<!-- DO NOT EDIT: this file is automatically generated using scw-doc-gen -->
# Documentation for `scw registry`
Container Registry API.
  
- [Image management commands](#image-management-commands)
  - [Delete an image](#delete-an-image)
  - [Get an image](#get-an-image)
  - [List images](#list-images)
  - [Update an image](#update-an-image)
- [Install a local Docker credential helper](#install-a-local-docker-credential-helper)
- [Login to a registry](#login-to-a-registry)
- [Logout of a registry](#logout-of-a-registry)
- [Namespace management commands](#namespace-management-commands)
  - [Create a namespace](#create-a-namespace)
  - [Delete a namespace](#delete-a-namespace)
  - [Get a namespace](#get-a-namespace)
  - [List namespaces](#list-namespaces)
  - [Update a namespace](#update-a-namespace)
- [Tag management commands](#tag-management-commands)
  - [Delete a tag](#delete-a-tag)
  - [Get a tag](#get-a-tag)
  - [List tags](#list-tags)

  
## Image management commands

An image represents a container image. A container image is a file that includes all the requirements and instructions of a complete and executable version of an application. When running, it becomes one or multiple instances of that application.

The visibility of an image can be public - when anyone can pull it, private - when only users within your organization can pull it, or inherited from the namespace visibility - which is the default. The visibility of your image can be changed using the [update image endpoit](#path-images-update-an-image).


### Delete an image

Delete a given image. You must specify, in the endpoint, the `region` and `image_id` parameters of the image you want to delete.

**Usage:**

```
scw registry image delete <image-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| image-id | Required | UUID of the image |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams`, `pl-waw` | Region to target. If none is passed will use default region from the config |



### Get an image

Retrieve information about a given container image, specified by its `image_id` and region. Full details about the image, such as `name`, `namespace_id`, `status`, `visibility`, and `size` are returned in the response.

**Usage:**

```
scw registry image get <image-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| image-id | Required | UUID of the image |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams`, `pl-waw` | Region to target. If none is passed will use default region from the config |



### List images

List all images in a specified region. By default, the images listed are ordered by creation date in ascending order. This can be modified via the order_by field. You can also define additional parameters for your query, such as the `namespace_id` and `project_id` parameters.

**Usage:**

```
scw registry image list [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| order-by | One of: `created_at_asc`, `created_at_desc`, `name_asc`, `name_desc` | Criteria to use when ordering image listings. Possible values are `created_at_asc`, `created_at_desc`, `name_asc`, `name_desc`, `region`, `status_asc` and `status_desc`. The default value is `created_at_asc`. |
| namespace-id |  | Filter by the namespace ID |
| name |  | Filter by the image name (exact match) |
| project-id |  | Filter by Project ID |
| organization-id |  | Filter by Organization ID |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams`, `pl-waw`, `all` | Region to target. If none is passed will use default region from the config |



### Update an image

Update the parameters of a given image, specified by its `image_id` and `region`. You can update the `visibility` parameter.

**Usage:**

```
scw registry image update <image-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| image-id | Required | ID of the image to update |
| visibility | One of: `visibility_unknown`, `inherit`, `public`, `private` | Set to `public` to allow the image to be pulled without authentication. Else, set to  `private`. Set to `inherit` to keep the same visibility configuration as the namespace |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams`, `pl-waw` | Region to target. If none is passed will use default region from the config |



## Install a local Docker credential helper

This command will install the Docker credential helper for your account.

It will create a new script named docker-credential-scw. 
This script will be called each time Docker needs the credentials and will return the correct credentials.
It avoid running docker login commands.


This command will install the Docker credential helper for your account.

It will create a new script named docker-credential-scw. 
This script will be called each time Docker needs the credentials and will return the correct credentials.
It avoid running docker login commands.


**Usage:**

```
scw registry install-docker-helper [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| path | Default: `/usr/local/bin` | Directory in which the Docker helper will be installed. This directory should be in your $PATH |



## Login to a registry

This command will run the correct command in order to log you in on the registry with the chosen program.
You will need to have the chosen binary installed on your system and in your PATH.

This command will run the correct command in order to log you in on the registry with the chosen program.
You will need to have the chosen binary installed on your system and in your PATH.

**Usage:**

```
scw registry login [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| program | Default: `docker`<br />One of: `docker`, `podman` | Program used to log in to the namespace |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams`, `pl-waw` | Region to target. If none is passed will use default region from the config |



## Logout of a registry

This command will run the correct command in order to log you out of the registry with the chosen program.
You will need to have the chosen binary installed on your system and in your PATH.

This command will run the correct command in order to log you out of the registry with the chosen program.
You will need to have the chosen binary installed on your system and in your PATH.

**Usage:**

```
scw registry logout [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| program | Default: `docker`<br />One of: `docker`, `podman` | Program used to log in to the namespace |
| region | Default: `fr-par` | Region to target. If none is passed will use default region from the config |



## Namespace management commands

A namespace is a collection of container images, each bearing the unique identifier of that namespace. A namespace can be either public or private, by default.

Each namespace must have a globally unique name within its region. This means no namespaces in the same region can bear the same name.

You can use namespace privacy policies to specify whether everyone has the right to pull an image from a namespace or not. When an image is in a public namespace, anyone is able to pull it. You can set your namespace to private if you want to restrict access.


### Create a namespace

Create a new Container Registry namespace. You must specify the namespace name and region in which you want it to be created. Optionally, you can specify the `project_id` and `is_public` in the request payload.

**Usage:**

```
scw registry namespace create [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| name | Required<br />Default: `<generated>` | Name of the namespace |
| description |  | Description of the namespace |
| project-id |  | Project ID to use. If none is passed the default project ID will be used |
| is-public |  | Defines whether or not namespace is public |
| organization-id |  | Organization ID to use. If none is passed the default organization ID will be used |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams`, `pl-waw` | Region to target. If none is passed will use default region from the config |



### Delete a namespace

Delete a given namespace. You must specify, in the endpoint, the `region` and `namespace_id` parameters of the namespace you want to delete.

**Usage:**

```
scw registry namespace delete <namespace-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| namespace-id | Required | UUID of the namespace |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams`, `pl-waw` | Region to target. If none is passed will use default region from the config |



### Get a namespace

Retrieve information about a given namespace, specified by its `namespace_id` and region. Full details about the namespace, such as `description`, `project_id`, `status`, `endpoint`, `is_public`, `size`, and `image_count` are returned in the response.

**Usage:**

```
scw registry namespace get <namespace-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| namespace-id | Required | UUID of the namespace |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams`, `pl-waw` | Region to target. If none is passed will use default region from the config |



### List namespaces

List all namespaces in a specified region. By default, the namespaces listed are ordered by creation date in ascending order. This can be modified via the order_by field. You can also define additional parameters for your query, such as the `instance_id` and `project_id` parameters.

**Usage:**

```
scw registry namespace list [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| order-by | One of: `created_at_asc`, `created_at_desc`, `description_asc`, `description_desc`, `name_asc`, `name_desc` | Criteria to use when ordering namespace listings. Possible values are `created_at_asc`, `created_at_desc`, `name_asc`, `name_desc`, `region`, `status_asc` and `status_desc`. The default value is `created_at_asc`. |
| project-id |  | Filter by Project ID |
| name |  | Filter by the namespace name (exact match) |
| organization-id |  | Filter by Organization ID |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams`, `pl-waw`, `all` | Region to target. If none is passed will use default region from the config |



### Update a namespace

Update the parameters of a given namespace, specified by its `namespace_id` and `region`. You can update the `description` and `is_public` parameters.

**Usage:**

```
scw registry namespace update <namespace-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| namespace-id | Required | ID of the namespace to update |
| description |  | Namespace description |
| is-public |  | Defines whether or not the namespace is public |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams`, `pl-waw` | Region to target. If none is passed will use default region from the config |



## Tag management commands

Tags allow you to organize your container images. This gives you the possibility of sorting and filtering your images in any organizational pattern of your choice, which in turn helps you arrange, control and monitor your cloud resources. You can assign as many tags as you want to each image.


### Delete a tag

Delete a given image tag. You must specify, in the endpoint, the `region` and `tag_id` parameters of the tag you want to delete.

**Usage:**

```
scw registry tag delete <tag-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| tag-id | Required | UUID of the tag |
| ~~force~~ | Deprecated | If two tags share the same digest the deletion will fail unless this parameter is set to true (deprecated) |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams`, `pl-waw` | Region to target. If none is passed will use default region from the config |



### Get a tag

Retrieve information about a given image tag, specified by its `tag_id` and region. Full details about the tag, such as `name`, `image_id`, `status`, and `digest` are returned in the response.

**Usage:**

```
scw registry tag get <tag-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| tag-id | Required | UUID of the tag |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams`, `pl-waw` | Region to target. If none is passed will use default region from the config |



### List tags

List all tags for a given image, specified by region. By default, the tags listed are ordered by creation date in ascending order. This can be modified via the order_by field. You can also define additional parameters for your query, such as the `name`.

**Usage:**

```
scw registry tag list [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| order-by | One of: `created_at_asc`, `created_at_desc`, `name_asc`, `name_desc` | Criteria to use when ordering tag listings. Possible values are `created_at_asc`, `created_at_desc`, `name_asc`, `name_desc`, `region`, `status_asc` and `status_desc`. The default value is `created_at_asc`. |
| image-id | Required | UUID of the image |
| name |  | Filter by the tag name (exact match) |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams`, `pl-waw`, `all` | Region to target. If none is passed will use default region from the config |



