<!-- DO NOT EDIT: this file is automatically generated using scw-doc-gen -->
# Documentation for `scw lb`
Load Balancer API.
  
- [Access Control List (ACL) management commands](#access-control-list-(acl)-management-commands)
  - [Create an ACL for a given frontend](#create-an-acl-for-a-given-frontend)
  - [Delete an ACL](#delete-an-acl)
  - [Get an ACL](#get-an-acl)
  - [List ACLs for a given frontend](#list-acls-for-a-given-frontend)
  - [Define all ACLs for a given frontend](#define-all-acls-for-a-given-frontend)
  - [Update an ACL](#update-an-acl)
- [Backend management commands](#backend-management-commands)
  - [Add a set of backend servers to a given backend](#add-a-set-of-backend-servers-to-a-given-backend)
  - [Create a backend for a given Load Balancer](#create-a-backend-for-a-given-load-balancer)
  - [Delete a backend of a given Load Balancer](#delete-a-backend-of-a-given-load-balancer)
  - [Get a backend of a given Load Balancer](#get-a-backend-of-a-given-load-balancer)
  - [List the backends of a given Load Balancer](#list-the-backends-of-a-given-load-balancer)
  - [List backend server statistics](#list-backend-server-statistics)
  - [Remove a set of servers for a given backend](#remove-a-set-of-servers-for-a-given-backend)
  - [Define all backend servers for a given backend](#define-all-backend-servers-for-a-given-backend)
  - [Update a backend of a given Load Balancer](#update-a-backend-of-a-given-load-balancer)
  - [Update a health check for a given backend](#update-a-health-check-for-a-given-backend)
- [TLS certificate management commands](#tls-certificate-management-commands)
  - [Create an SSL/TLS certificate](#create-an-ssltls-certificate)
  - [Delete an SSL/TLS certificate](#delete-an-ssltls-certificate)
  - [Get an SSL/TLS certificate](#get-an-ssltls-certificate)
  - [List all SSL/TLS certificates on a given Load Balancer](#list-all-ssltls-certificates-on-a-given-load-balancer)
  - [Update an SSL/TLS certificate](#update-an-ssltls-certificate)
- [Frontend management commands](#frontend-management-commands)
  - [Create a frontend in a given Load Balancer](#create-a-frontend-in-a-given-load-balancer)
  - [Delete a frontend](#delete-a-frontend)
  - [Get a frontend](#get-a-frontend)
  - [List frontends of a given Load Balancer](#list-frontends-of-a-given-load-balancer)
  - [Update a frontend](#update-a-frontend)
- [IP management commands](#ip-management-commands)
  - [Create an IP address](#create-an-ip-address)
  - [Delete an IP address](#delete-an-ip-address)
  - [Get an IP address](#get-an-ip-address)
  - [List IP addresses](#list-ip-addresses)
  - [Update an IP address](#update-an-ip-address)
- [Load balancer management commands](#load-balancer-management-commands)
  - [Create a Load Balancer](#create-a-load-balancer)
  - [Delete a Load Balancer](#delete-a-load-balancer)
  - [Get a Load Balancer](#get-a-load-balancer)
  - [Get usage statistics of a given Load Balancer](#get-usage-statistics-of-a-given-load-balancer)
  - [List Load Balancers](#list-load-balancers)
  - [Migrate a Load Balancer](#migrate-a-load-balancer)
  - [Update a Load Balancer](#update-a-load-balancer)
  - [Wait for a load balancer to reach a stable state](#wait-for-a-load-balancer-to-reach-a-stable-state)
- [Load balancer types management commands](#load-balancer-types-management-commands)
  - [List all Load Balancer offer types](#list-all-load-balancer-offer-types)
- [Private networks management commands](#private-networks-management-commands)
  - [Attach a Load Balancer to a Private Network](#attach-a-load-balancer-to-a-private-network)
  - [Detach Load Balancer from Private Network](#detach-load-balancer-from-private-network)
  - [List Private Networks attached to a Load Balancer](#list-private-networks-attached-to-a-load-balancer)
- [Route rules management commands](#route-rules-management-commands)
  - [Create a route](#create-a-route)
  - [Delete a route](#delete-a-route)
  - [Get a route](#get-a-route)
  - [List all routes](#list-all-routes)
  - [Update a route](#update-a-route)
- [Subscriber management commands](#subscriber-management-commands)
  - [Create a subscriber](#create-a-subscriber)
  - [Delete a subscriber](#delete-a-subscriber)
  - [Get a subscriber](#get-a-subscriber)
  - [List all subscribers](#list-all-subscribers)
  - [Subscribe a subscriber to alerts for a given Load Balancer](#subscribe-a-subscriber-to-alerts-for-a-given-load-balancer)
  - [Unsubscribe a subscriber from alerts for a given Load Balancer](#unsubscribe-a-subscriber-from-alerts-for-a-given-load-balancer)
  - [Update a subscriber](#update-a-subscriber)

  
## Access Control List (ACL) management commands

Access Control List (ACL) management commands.


### Create an ACL for a given frontend

Create a new ACL for a given frontend. Each ACL must have a name, an action to perform (allow or deny), and a match rule (the action is carried out when the incoming traffic matches the rule).

**Usage:**

```
scw lb acl create [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| frontend-id | Required | Frontend ID to attach the ACL to |
| name | Required<br />Default: `<generated>` | ACL name |
| action.type | One of: `allow`, `deny`, `redirect` | Action to take when incoming traffic matches an ACL filter |
| action.redirect.type | One of: `location`, `scheme` | Redirect type |
| action.redirect.target |  | Redirect target. For a location redirect, you can use a URL e.g. `https://scaleway.com`. Using a scheme name (e.g. `https`, `http`, `ftp`, `git`) will replace the request's original scheme. This can be useful to implement HTTP to HTTPS redirects. Valid placeholders that can be used in a `location` redirect to preserve parts of the original request in the redirection URL are \{\{host\}\}, \{\{query\}\}, \{\{path\}\} and \{\{scheme\}\} |
| action.redirect.code |  | HTTP redirect code to use. Valid values are 301, 302, 303, 307 and 308. Default value is 302 |
| match.ip-subnet.{index} |  | List of IPs or CIDR v4/v6 addresses to filter for from the client side |
| match.http-filter | One of: `acl_http_filter_none`, `path_begin`, `path_end`, `regex`, `http_header_match` | Type of HTTP filter to match. Extracts the request's URL path, which starts at the first slash and ends before the question mark (without the host part). Defines where to filter for the http_filter_value. Only supported for HTTP backends |
| match.http-filter-value.{index} |  | List of values to filter for |
| match.http-filter-option |  | Name of the HTTP header to filter on if `http_header_match` was selected in `http_filter` |
| match.invert |  | Defines whether to invert the match condition. If set to `true`, the ACL carries out its action when the condition DOES NOT match |
| index | Required | Priority of this ACL (ACLs are applied in ascending order, 0 is the first ACL executed) |
| description |  | ACL description |
| zone | Default: `fr-par-1`<br />One of: `fr-par-1`, `fr-par-2`, `nl-ams-1`, `nl-ams-2`, `nl-ams-3`, `pl-waw-1`, `pl-waw-2` | Zone to target. If none is passed will use default zone from the config |



### Delete an ACL

Delete an ACL, specified by its ACL ID. Deleting an ACL is irreversible and cannot be undone.

**Usage:**

```
scw lb acl delete <acl-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| acl-id | Required | ACL ID |
| zone | Default: `fr-par-1`<br />One of: `fr-par-1`, `fr-par-2`, `nl-ams-1`, `nl-ams-2`, `nl-ams-3`, `pl-waw-1`, `pl-waw-2` | Zone to target. If none is passed will use default zone from the config |



### Get an ACL

Get information for a particular ACL, specified by its ACL ID. The response returns full details of the ACL, including its name, action, match rule and frontend.

**Usage:**

```
scw lb acl get <acl-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| acl-id | Required | ACL ID |
| zone | Default: `fr-par-1`<br />One of: `fr-par-1`, `fr-par-2`, `nl-ams-1`, `nl-ams-2`, `nl-ams-3`, `pl-waw-1`, `pl-waw-2` | Zone to target. If none is passed will use default zone from the config |



### List ACLs for a given frontend

List the ACLs for a given frontend, specified by its frontend ID. The response is an array of ACL objects, each one representing an ACL that denies or allows traffic based on certain conditions.

**Usage:**

```
scw lb acl list [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| frontend-id | Required | Frontend ID (ACLs attached to this frontend will be returned in the response) |
| order-by | One of: `created_at_asc`, `created_at_desc`, `name_asc`, `name_desc` | Sort order of ACLs in the response |
| name |  | ACL name to filter for |
| zone | Default: `fr-par-1`<br />One of: `fr-par-1`, `fr-par-2`, `nl-ams-1`, `nl-ams-2`, `nl-ams-3`, `pl-waw-1`, `pl-waw-2`, `all` | Zone to target. If none is passed will use default zone from the config |



### Define all ACLs for a given frontend

For a given frontend specified by its frontend ID, define and add the complete set of ACLS for that frontend. Any existing ACLs on this frontend will be removed.

**Usage:**

```
scw lb acl set [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| acls.{index}.name | Required | ACL name |
| acls.{index}.action.type | One of: `allow`, `deny`, `redirect` | Action to take when incoming traffic matches an ACL filter |
| acls.{index}.action.redirect.type | One of: `location`, `scheme` | Redirect type |
| acls.{index}.action.redirect.target |  | Redirect target. For a location redirect, you can use a URL e.g. `https://scaleway.com`. Using a scheme name (e.g. `https`, `http`, `ftp`, `git`) will replace the request's original scheme. This can be useful to implement HTTP to HTTPS redirects. Valid placeholders that can be used in a `location` redirect to preserve parts of the original request in the redirection URL are \{\{host\}\}, \{\{query\}\}, \{\{path\}\} and \{\{scheme\}\} |
| acls.{index}.action.redirect.code |  | HTTP redirect code to use. Valid values are 301, 302, 303, 307 and 308. Default value is 302 |
| acls.{index}.match.ip-subnet.{index} |  | List of IPs or CIDR v4/v6 addresses to filter for from the client side |
| acls.{index}.match.http-filter | One of: `acl_http_filter_none`, `path_begin`, `path_end`, `regex`, `http_header_match` | Type of HTTP filter to match. Extracts the request's URL path, which starts at the first slash and ends before the question mark (without the host part). Defines where to filter for the http_filter_value. Only supported for HTTP backends |
| acls.{index}.match.http-filter-value.{index} |  | List of values to filter for |
| acls.{index}.match.http-filter-option |  | Name of the HTTP header to filter on if `http_header_match` was selected in `http_filter` |
| acls.{index}.match.invert |  | Defines whether to invert the match condition. If set to `true`, the ACL carries out its action when the condition DOES NOT match |
| acls.{index}.index | Required | Priority of this ACL (ACLs are applied in ascending order, 0 is the first ACL executed) |
| acls.{index}.description |  | ACL description |
| frontend-id | Required | Frontend ID |
| zone | Default: `fr-par-1`<br />One of: `fr-par-1`, `fr-par-2`, `nl-ams-1`, `nl-ams-2`, `nl-ams-3`, `pl-waw-1`, `pl-waw-2` | Zone to target. If none is passed will use default zone from the config |



### Update an ACL

Update a particular ACL, specified by its ACL ID. You can update details including its name, action and match rule.

**Usage:**

```
scw lb acl update <acl-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| acl-id | Required | ACL ID |
| name | Required | ACL name |
| action.type | One of: `allow`, `deny`, `redirect` | Action to take when incoming traffic matches an ACL filter |
| action.redirect.type | One of: `location`, `scheme` | Redirect type |
| action.redirect.target |  | Redirect target. For a location redirect, you can use a URL e.g. `https://scaleway.com`. Using a scheme name (e.g. `https`, `http`, `ftp`, `git`) will replace the request's original scheme. This can be useful to implement HTTP to HTTPS redirects. Valid placeholders that can be used in a `location` redirect to preserve parts of the original request in the redirection URL are \{\{host\}\}, \{\{query\}\}, \{\{path\}\} and \{\{scheme\}\} |
| action.redirect.code |  | HTTP redirect code to use. Valid values are 301, 302, 303, 307 and 308. Default value is 302 |
| match.ip-subnet.{index} |  | List of IPs or CIDR v4/v6 addresses to filter for from the client side |
| match.http-filter | One of: `acl_http_filter_none`, `path_begin`, `path_end`, `regex`, `http_header_match` | Type of HTTP filter to match. Extracts the request's URL path, which starts at the first slash and ends before the question mark (without the host part). Defines where to filter for the http_filter_value. Only supported for HTTP backends |
| match.http-filter-value.{index} |  | List of values to filter for |
| match.http-filter-option |  | Name of the HTTP header to filter on if `http_header_match` was selected in `http_filter` |
| match.invert |  | Defines whether to invert the match condition. If set to `true`, the ACL carries out its action when the condition DOES NOT match |
| index | Required | Priority of this ACL (ACLs are applied in ascending order, 0 is the first ACL executed) |
| description |  | ACL description |
| zone | Default: `fr-par-1`<br />One of: `fr-par-1`, `fr-par-2`, `nl-ams-1`, `nl-ams-2`, `nl-ams-3`, `pl-waw-1`, `pl-waw-2` | Zone to target. If none is passed will use default zone from the config |



## Backend management commands

Backend management commands.


### Add a set of backend servers to a given backend

For a given backend specified by its backend ID, add a set of backend servers (identified by their IP addresses) it should forward traffic to. These will be appended to any existing set of backend servers for this backend.

**Usage:**

```
scw lb backend add-servers <backend-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| backend-id | Required | Backend ID |
| instance-server-id.{index} |  | UIID of the instance server. |
| instance-server-tag.{index} |  | Tag of the instance server. |
| use-instance-server-public-ip |  | Use public IP address of the instance instead of the private one |
| baremetal-server-id.{index} |  | UIID of the baremetal server. |
| baremetal-server-tag.{index} |  | Tag of the baremetal server. |
| server-ip.{index} | Required | List of IP addresses to add to backend servers |
| zone | Default: `fr-par-1`<br />One of: `fr-par-1`, `fr-par-2`, `nl-ams-1`, `nl-ams-2`, `nl-ams-3`, `pl-waw-1`, `pl-waw-2` | Zone to target. If none is passed will use default zone from the config |



### Create a backend for a given Load Balancer

Create a new backend for a given Load Balancer, specifying its full configuration including protocol, port and forwarding algorithm.

**Usage:**

```
scw lb backend create [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| name | Required<br />Default: `<generated>` | Name for the backend |
| forward-protocol | Required<br />One of: `tcp`, `http` | Protocol to be used by the backend when forwarding traffic to backend servers |
| forward-port | Required | Port to be used by the backend when forwarding traffic to backend servers |
| forward-port-algorithm | Required<br />Default: `roundrobin`<br />One of: `roundrobin`, `leastconn`, `first` | Load balancing algorithm to be used when determining which backend server to forward new traffic to |
| sticky-sessions | Required<br />Default: `none`<br />One of: `none`, `cookie`, `table` | Defines whether to activate sticky sessions (binding a particular session to a particular backend server) and the method to use if so. None disables sticky sessions. Cookie-based uses an HTTP cookie TO stick a session to a backend server. Table-based uses the source (client) IP address to stick a session to a backend server |
| sticky-sessions-cookie-name |  | Cookie name for cookie-based sticky sessions |
| lb-id | Required | Load Balancer ID |
| health-check.port |  | Port to use for the backend server health check |
| health-check.check-delay | Default: `3s` | Time to wait between two consecutive health checks |
| health-check.check-timeout | Default: `1s` | Maximum time a backend server has to reply to the health check |
| health-check.check-max-retries |  | Number of consecutive unsuccessful health checks after which the server will be considered dead |
| health-check.mysql-config.user |  | MySQL user to use for the health check |
| health-check.pgsql-config.user |  | PostgreSQL user to use for the health check |
| health-check.http-config.uri |  | HTTP URI used for the health check |
| health-check.http-config.method |  | HTTP method used for the health check |
| health-check.http-config.code |  | HTTP response code expected for a successful health check |
| health-check.http-config.host-header |  | HTTP host header used for the health check |
| health-check.https-config.uri |  | HTTP URI used for the health check |
| health-check.https-config.method |  | HTTP method used for the health check |
| health-check.https-config.code |  | HTTP response code expected for a successful health check |
| health-check.https-config.host-header |  | HTTP host header used for the health check |
| health-check.https-config.sni |  | SNI used for SSL health checks |
| health-check.check-send-proxy |  | Defines whether proxy protocol should be activated for the health check |
| health-check.transient-check-delay.seconds |  |  |
| health-check.transient-check-delay.nanos |  |  |
| instance-server-id.{index} |  | UIID of the instance server. |
| instance-server-tag.{index} |  | Tag of the instance server. |
| use-instance-server-public-ip |  | Use public IP address of the instance instead of the private one |
| baremetal-server-id.{index} |  | UIID of the baremetal server. |
| baremetal-server-tag.{index} |  | Tag of the baremetal server. |
| server-ip.{index} | Required | List of backend server IP addresses (IPv4 or IPv6) the backend should forward traffic to |
| ~~send-proxy-v2~~ | Deprecated | Deprecated in favor of proxy_protocol field |
| timeout-server | Default: `5m` | Maximum allowed time for a backend server to process a request |
| timeout-connect | Default: `5s` | Maximum allowed time for establishing a connection to a backend server |
| timeout-tunnel | Default: `15m` | Maximum allowed tunnel inactivity time after Websocket is established (takes precedence over client and server timeout) |
| on-marked-down-action | One of: `on_marked_down_action_none`, `shutdown_sessions` | Action to take when a backend server is marked as down |
| proxy-protocol | One of: `proxy_protocol_unknown`, `proxy_protocol_none`, `proxy_protocol_v1`, `proxy_protocol_v2`, `proxy_protocol_v2_ssl`, `proxy_protocol_v2_ssl_cn` | Protocol to use between the Load Balancer and backend servers. Allows the backend servers to be informed of the client's real IP address. The PROXY protocol must be supported by the backend servers' software |
| failover-host |  | Scaleway S3 bucket website to be served as failover if all backend servers are down, e.g. failover-website.s3-website.fr-par.scw.cloud |
| ssl-bridging |  | Defines whether to enable SSL bridging between the Load Balancer and backend servers |
| ignore-ssl-server-verify |  | Defines whether the server certificate verification should be ignored |
| redispatch-attempt-count |  | Whether to use another backend server on each attempt |
| max-retries |  | Number of retries when a backend server connection failed |
| max-connections |  | Maximum number of connections allowed per backend server |
| timeout-queue.seconds |  |  |
| timeout-queue.nanos |  |  |
| zone | Default: `fr-par-1`<br />One of: `fr-par-1`, `fr-par-2`, `nl-ams-1`, `nl-ams-2`, `nl-ams-3`, `pl-waw-1`, `pl-waw-2` | Zone to target. If none is passed will use default zone from the config |



### Delete a backend of a given Load Balancer

Delete a backend of a given Load Balancer, specified by its backend ID. This action is irreversible and cannot be undone.

**Usage:**

```
scw lb backend delete <backend-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| backend-id | Required | ID of the backend to delete |
| zone | Default: `fr-par-1`<br />One of: `fr-par-1`, `fr-par-2`, `nl-ams-1`, `nl-ams-2`, `nl-ams-3`, `pl-waw-1`, `pl-waw-2` | Zone to target. If none is passed will use default zone from the config |



### Get a backend of a given Load Balancer

Get the full details of a given backend, specified by its backend ID. The response contains the backend's full configuration parameters including protocol, port and forwarding algorithm.

**Usage:**

```
scw lb backend get <backend-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| backend-id | Required | Backend ID |
| zone | Default: `fr-par-1`<br />One of: `fr-par-1`, `fr-par-2`, `nl-ams-1`, `nl-ams-2`, `nl-ams-3`, `pl-waw-1`, `pl-waw-2` | Zone to target. If none is passed will use default zone from the config |



### List the backends of a given Load Balancer

List all the backends of a Load Balancer, specified by its Load Balancer ID. By default, results are returned in ascending order by the creation date of each backend. The response is an array of backend objects, containing full details of each one including their configuration parameters such as protocol, port and forwarding algorithm.

**Usage:**

```
scw lb backend list [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| lb-id | Required | Load Balancer ID |
| name |  | Name of the backend to filter for |
| order-by | One of: `created_at_asc`, `created_at_desc`, `name_asc`, `name_desc` | Sort order of backends in the response |
| zone | Default: `fr-par-1`<br />One of: `fr-par-1`, `fr-par-2`, `nl-ams-1`, `nl-ams-2`, `nl-ams-3`, `pl-waw-1`, `pl-waw-2`, `all` | Zone to target. If none is passed will use default zone from the config |



### List backend server statistics

List information about your backend servers, including their state and the result of their last health check.

**Usage:**

```
scw lb backend list-statistics <lb-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| lb-id | Required | Load Balancer ID |
| backend-id |  | ID of the backend |
| zone | Default: `fr-par-1`<br />One of: `fr-par-1`, `fr-par-2`, `nl-ams-1`, `nl-ams-2`, `nl-ams-3`, `pl-waw-1`, `pl-waw-2`, `all` | Zone to target. If none is passed will use default zone from the config |



### Remove a set of servers for a given backend

For a given backend specified by its backend ID, remove the specified backend servers (identified by their IP addresses) so that it no longer forwards traffic to them.

**Usage:**

```
scw lb backend remove-servers <backend-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| backend-id | Required | Backend ID |
| instance-server-id.{index} |  | UIID of the instance server. |
| instance-server-tag.{index} |  | Tag of the instance server. |
| use-instance-server-public-ip |  | Use public IP address of the instance instead of the private one |
| baremetal-server-id.{index} |  | UIID of the baremetal server. |
| baremetal-server-tag.{index} |  | Tag of the baremetal server. |
| server-ip.{index} | Required | List of IP addresses to remove from backend servers |
| zone | Default: `fr-par-1`<br />One of: `fr-par-1`, `fr-par-2`, `nl-ams-1`, `nl-ams-2`, `nl-ams-3`, `pl-waw-1`, `pl-waw-2` | Zone to target. If none is passed will use default zone from the config |



### Define all backend servers for a given backend

For a given backend specified by its backend ID, define the set of backend servers (identified by their IP addresses) that it should forward traffic to. Any existing backend servers configured for this backend will be removed.

**Usage:**

```
scw lb backend set-servers <backend-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| backend-id | Required | Backend ID |
| instance-server-id.{index} |  | UIID of the instance server. |
| instance-server-tag.{index} |  | Tag of the instance server. |
| use-instance-server-public-ip |  | Use public IP address of the instance instead of the private one |
| baremetal-server-id.{index} |  | UIID of the baremetal server. |
| baremetal-server-tag.{index} |  | Tag of the baremetal server. |
| server-ip.{index} | Required | List of IP addresses for backend servers. Any other existing backend servers will be removed |
| zone | Default: `fr-par-1`<br />One of: `fr-par-1`, `fr-par-2`, `nl-ams-1`, `nl-ams-2`, `nl-ams-3`, `pl-waw-1`, `pl-waw-2` | Zone to target. If none is passed will use default zone from the config |



### Update a backend of a given Load Balancer

Update a backend of a given Load Balancer, specified by its backend ID. Note that the request type is PUT and not PATCH. You must set all parameters.

**Usage:**

```
scw lb backend update <backend-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| backend-id | Required | Backend ID |
| name | Required | Backend name |
| forward-protocol | Required<br />One of: `tcp`, `http` | Protocol to be used by the backend when forwarding traffic to backend servers |
| forward-port | Required | Port to be used by the backend when forwarding traffic to backend servers |
| forward-port-algorithm | Required<br />One of: `roundrobin`, `leastconn`, `first` | Load balancing algorithm to be used when determining which backend server to forward new traffic to |
| sticky-sessions | Required<br />One of: `none`, `cookie`, `table` | Defines whether to activate sticky sessions (binding a particular session to a particular backend server) and the method to use if so. None disables sticky sessions. Cookie-based uses an HTTP cookie to stick a session to a backend server. Table-based uses the source (client) IP address to stick a session to a backend server |
| sticky-sessions-cookie-name |  | Cookie name for cookie-based sticky sessions |
| ~~send-proxy-v2~~ | Deprecated | Deprecated in favor of proxy_protocol field |
| timeout-server | Default: `5m` | Maximum allowed time for a backend server to process a request |
| timeout-connect | Default: `5s` | Maximum allowed time for establishing a connection to a backend server |
| timeout-tunnel | Default: `15m` | Maximum allowed tunnel inactivity time after Websocket is established (takes precedence over client and server timeout) |
| on-marked-down-action | One of: `on_marked_down_action_none`, `shutdown_sessions` | Action to take when a backend server is marked as down |
| proxy-protocol | One of: `proxy_protocol_unknown`, `proxy_protocol_none`, `proxy_protocol_v1`, `proxy_protocol_v2`, `proxy_protocol_v2_ssl`, `proxy_protocol_v2_ssl_cn` | Protocol to use between the Load Balancer and backend servers. Allows the backend servers to be informed of the client's real IP address. The PROXY protocol must be supported by the backend servers' software |
| failover-host |  | Scaleway S3 bucket website to be served as failover if all backend servers are down, e.g. failover-website.s3-website.fr-par.scw.cloud |
| ssl-bridging |  | Defines whether to enable SSL bridging between the Load Balancer and backend servers |
| ignore-ssl-server-verify |  | Defines whether the server certificate verification should be ignored |
| redispatch-attempt-count |  | Whether to use another backend server on each attempt |
| max-retries |  | Number of retries when a backend server connection failed |
| max-connections |  | Maximum number of connections allowed per backend server |
| timeout-queue.seconds |  |  |
| timeout-queue.nanos |  |  |
| zone | Default: `fr-par-1`<br />One of: `fr-par-1`, `fr-par-2`, `nl-ams-1`, `nl-ams-2`, `nl-ams-3`, `pl-waw-1`, `pl-waw-2` | Zone to target. If none is passed will use default zone from the config |



### Update a health check for a given backend

Update the configuration of the health check performed by a given backend to verify the health of its backend servers, identified by its backend ID. Note that the request type is PUT and not PATCH. You must set all parameters.

**Usage:**

```
scw lb backend update-healthcheck [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| port | Required | Port to use for the backend server health check |
| check-delay | Required | Time to wait between two consecutive health checks |
| check-timeout | Required | Maximum time a backend server has to reply to the health check |
| check-max-retries | Required | Number of consecutive unsuccessful health checks after which the server will be considered dead |
| backend-id | Required | Backend ID |
| check-send-proxy |  | Defines whether proxy protocol should be activated for the health check |
| mysql-config.user |  | MySQL user to use for the health check |
| pgsql-config.user |  | PostgreSQL user to use for the health check |
| http-config.uri |  | HTTP URI used for the health check |
| http-config.method |  | HTTP method used for the health check |
| http-config.code |  | HTTP response code expected for a successful health check |
| http-config.host-header |  | HTTP host header used for the health check |
| https-config.uri |  | HTTP URI used for the health check |
| https-config.method |  | HTTP method used for the health check |
| https-config.code |  | HTTP response code expected for a successful health check |
| https-config.host-header |  | HTTP host header used for the health check |
| https-config.sni |  | SNI used for SSL health checks |
| transient-check-delay.seconds |  |  |
| transient-check-delay.nanos |  |  |
| zone | Default: `fr-par-1`<br />One of: `fr-par-1`, `fr-par-2`, `nl-ams-1`, `nl-ams-2`, `nl-ams-3`, `pl-waw-1`, `pl-waw-2` | Zone to target. If none is passed will use default zone from the config |



## TLS certificate management commands

TLS certificate management commands.


### Create an SSL/TLS certificate

Generate a new SSL/TLS certificate for a given Load Balancer. You can choose to create a Let's Encrypt certificate, or import a custom certificate.

**Usage:**

```
scw lb certificate create [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| lb-id | Required | Load Balancer ID |
| name | Required<br />Default: `<generated>` | Name for the certificate |
| letsencrypt-common-name |  | Main domain name of certificate (this domain must exist and resolve to your Load Balancer IP address) |
| letsencrypt-alternative-name.{index} |  | Alternative domain names (all domain names must exist and resolve to your Load Balancer IP address) |
| custom-certificate-chain |  | Full PEM-formatted certificate, consisting of the entire certificate chain including public key, private key, and (optionally) Certificate Authorities |
| zone | Default: `fr-par-1`<br />One of: `fr-par-1`, `fr-par-2`, `nl-ams-1`, `nl-ams-2`, `nl-ams-3`, `pl-waw-1`, `pl-waw-2` | Zone to target. If none is passed will use default zone from the config |



### Delete an SSL/TLS certificate

Delete an SSL/TLS certificate, specified by its certificate ID. Deleting a certificate is irreversible and cannot be undone.

**Usage:**

```
scw lb certificate delete <certificate-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| certificate-id | Required | Certificate ID |
| zone | Default: `fr-par-1`<br />One of: `fr-par-1`, `fr-par-2`, `nl-ams-1`, `nl-ams-2`, `nl-ams-3`, `pl-waw-1`, `pl-waw-2` | Zone to target. If none is passed will use default zone from the config |



### Get an SSL/TLS certificate

Get information for a particular SSL/TLS certificate, specified by its certificate ID. The response returns full details of the certificate, including its type, main domain name, and alternative domain names.

**Usage:**

```
scw lb certificate get <certificate-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| certificate-id | Required | Certificate ID |
| zone | Default: `fr-par-1`<br />One of: `fr-par-1`, `fr-par-2`, `nl-ams-1`, `nl-ams-2`, `nl-ams-3`, `pl-waw-1`, `pl-waw-2` | Zone to target. If none is passed will use default zone from the config |



### List all SSL/TLS certificates on a given Load Balancer

List all the SSL/TLS certificates on a given Load Balancer. The response is an array of certificate objects, which are by default listed in ascending order of creation date.

**Usage:**

```
scw lb certificate list [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| lb-id | Required | Load Balancer ID |
| order-by | One of: `created_at_asc`, `created_at_desc`, `name_asc`, `name_desc` | Sort order of certificates in the response |
| name |  | Certificate name to filter for, only certificates of this name will be returned |
| zone | Default: `fr-par-1`<br />One of: `fr-par-1`, `fr-par-2`, `nl-ams-1`, `nl-ams-2`, `nl-ams-3`, `pl-waw-1`, `pl-waw-2`, `all` | Zone to target. If none is passed will use default zone from the config |



### Update an SSL/TLS certificate

Update the name of a particular SSL/TLS certificate, specified by its certificate ID.

**Usage:**

```
scw lb certificate update <certificate-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| certificate-id | Required | Certificate ID |
| name | Required | Certificate name |
| zone | Default: `fr-par-1`<br />One of: `fr-par-1`, `fr-par-2`, `nl-ams-1`, `nl-ams-2`, `nl-ams-3`, `pl-waw-1`, `pl-waw-2` | Zone to target. If none is passed will use default zone from the config |



## Frontend management commands

Frontend management commands.


### Create a frontend in a given Load Balancer

Create a new frontend for a given Load Balancer, specifying its configuration including the port it should listen on and the backend to attach it to.

**Usage:**

```
scw lb frontend create [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| name | Required<br />Default: `<generated>` | Name for the frontend |
| inbound-port | Required | Port the frontend should listen on |
| lb-id | Required | Load Balancer ID (ID of the Load Balancer to attach the frontend to) |
| backend-id | Required | Backend ID (ID of the backend the frontend should pass traffic to) |
| timeout-client | Default: `5m` | Maximum allowed inactivity time on the client side |
| ~~certificate-id~~ | Deprecated | Certificate ID, deprecated in favor of certificate_ids array |
| certificate-ids.{index} |  | List of SSL/TLS certificate IDs to bind to the frontend |
| enable-http3 |  | Defines whether to enable HTTP/3 protocol on the frontend |
| zone | Default: `fr-par-1`<br />One of: `fr-par-1`, `fr-par-2`, `nl-ams-1`, `nl-ams-2`, `nl-ams-3`, `pl-waw-1`, `pl-waw-2` | Zone to target. If none is passed will use default zone from the config |



### Delete a frontend

Delete a given frontend, specified by its frontend ID. This action is irreversible and cannot be undone.

**Usage:**

```
scw lb frontend delete <frontend-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| frontend-id | Required | ID of the frontend to delete |
| zone | Default: `fr-par-1`<br />One of: `fr-par-1`, `fr-par-2`, `nl-ams-1`, `nl-ams-2`, `nl-ams-3`, `pl-waw-1`, `pl-waw-2` | Zone to target. If none is passed will use default zone from the config |



### Get a frontend

Get the full details of a given frontend, specified by its frontend ID. The response contains the frontend's full configuration parameters including the backend it is attached to, the port it listens on, and any certificates it has.

**Usage:**

```
scw lb frontend get <frontend-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| frontend-id | Required | Frontend ID |
| zone | Default: `fr-par-1`<br />One of: `fr-par-1`, `fr-par-2`, `nl-ams-1`, `nl-ams-2`, `nl-ams-3`, `pl-waw-1`, `pl-waw-2` | Zone to target. If none is passed will use default zone from the config |



### List frontends of a given Load Balancer

List all the frontends of a Load Balancer, specified by its Load Balancer ID. By default, results are returned in ascending order by the creation date of each frontend. The response is an array of frontend objects, containing full details of each one including the port they listen on and the backend they are attached to.

**Usage:**

```
scw lb frontend list [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| lb-id | Required | Load Balancer ID |
| name |  | Name of the frontend to filter for |
| order-by | One of: `created_at_asc`, `created_at_desc`, `name_asc`, `name_desc` | Sort order of frontends in the response |
| zone | Default: `fr-par-1`<br />One of: `fr-par-1`, `fr-par-2`, `nl-ams-1`, `nl-ams-2`, `nl-ams-3`, `pl-waw-1`, `pl-waw-2`, `all` | Zone to target. If none is passed will use default zone from the config |



### Update a frontend

Update a given frontend, specified by its frontend ID. You can update configuration parameters including its name and the port it listens on. Note that the request type is PUT and not PATCH. You must set all parameters.

**Usage:**

```
scw lb frontend update <frontend-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| frontend-id | Required | Frontend ID |
| name | Required | Frontend name |
| inbound-port | Required | Port the frontend should listen on |
| backend-id | Required | Backend ID (ID of the backend the frontend should pass traffic to) |
| timeout-client | Default: `5m` | Maximum allowed inactivity time on the client side |
| ~~certificate-id~~ | Deprecated | Certificate ID, deprecated in favor of certificate_ids array |
| certificate-ids.{index} |  | List of SSL/TLS certificate IDs to bind to the frontend |
| enable-http3 |  | Defines whether to enable HTTP/3 protocol on the frontend |
| zone | Default: `fr-par-1`<br />One of: `fr-par-1`, `fr-par-2`, `nl-ams-1`, `nl-ams-2`, `nl-ams-3`, `pl-waw-1`, `pl-waw-2` | Zone to target. If none is passed will use default zone from the config |



## IP management commands

IP management commands.


### Create an IP address

Create a new Load Balancer flexible IP address, in the specified Scaleway Project. This can be attached to new Load Balancers created in the future.

**Usage:**

```
scw lb ip create [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| project-id |  | Project ID to use. If none is passed the default project ID will be used |
| reverse |  | Reverse DNS (domain name) for the IP address |
| organization-id |  | Organization ID to use. If none is passed the default organization ID will be used |
| zone | Default: `fr-par-1`<br />One of: `fr-par-1`, `fr-par-2`, `nl-ams-1`, `nl-ams-2`, `nl-ams-3`, `pl-waw-1`, `pl-waw-2` | Zone to target. If none is passed will use default zone from the config |



### Delete an IP address

Delete a Load Balancer flexible IP address. This action is irreversible, and cannot be undone.

**Usage:**

```
scw lb ip delete <ip-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| ip-id | Required | IP address ID |
| zone | Default: `fr-par-1`<br />One of: `fr-par-1`, `fr-par-2`, `nl-ams-1`, `nl-ams-2`, `nl-ams-3`, `pl-waw-1`, `pl-waw-2` | Zone to target. If none is passed will use default zone from the config |



### Get an IP address

Retrieve the full details of a Load Balancer flexible IP address.

**Usage:**

```
scw lb ip get <ip-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| ip-id | Required | IP address ID |
| zone | Default: `fr-par-1`<br />One of: `fr-par-1`, `fr-par-2`, `nl-ams-1`, `nl-ams-2`, `nl-ams-3`, `pl-waw-1`, `pl-waw-2` | Zone to target. If none is passed will use default zone from the config |



### List IP addresses

List the Load Balancer flexible IP addresses held in the account (filtered by Organization ID or Project ID). It is also possible to search for a specific IP address.

**Usage:**

```
scw lb ip list [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| ip-address |  | IP address to filter for |
| project-id |  | Project ID to filter for, only Load Balancer IP addresses from this Project will be returned |
| organization-id |  | Organization ID to filter for, only Load Balancer IP addresses from this Organization will be returned |
| zone | Default: `fr-par-1`<br />One of: `fr-par-1`, `fr-par-2`, `nl-ams-1`, `nl-ams-2`, `nl-ams-3`, `pl-waw-1`, `pl-waw-2`, `all` | Zone to target. If none is passed will use default zone from the config |



### Update an IP address

Update the reverse DNS of a Load Balancer flexible IP address.

**Usage:**

```
scw lb ip update <ip-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| ip-id | Required | IP address ID |
| reverse |  | Reverse DNS (domain name) for the IP address |
| zone | Default: `fr-par-1`<br />One of: `fr-par-1`, `fr-par-2`, `nl-ams-1`, `nl-ams-2`, `nl-ams-3`, `pl-waw-1`, `pl-waw-2` | Zone to target. If none is passed will use default zone from the config |



## Load balancer management commands

Load balancer management commands.


### Create a Load Balancer

Create a new Load Balancer. Note that the Load Balancer will be created without frontends or backends; these must be created separately via the dedicated endpoints.

**Usage:**

```
scw lb lb create [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| project-id |  | Project ID to use. If none is passed the default project ID will be used |
| name | Required<br />Default: `<generated>` | Name for the Load Balancer |
| description |  | Description for the Load Balancer |
| ~~ip-id~~ | Deprecated | ID of an existing flexible IP address to attach to the Load Balancer |
| assign-flexible-ip |  | Defines whether to automatically assign a flexible public IP to lb. Default value is `false` (do not assign). |
| tags.{index} |  | List of tags for the Load Balancer |
| type | Default: `LB-S`<br />One of: `LB-S`, `LB-GP-M`, `LB-GP-L` | Load Balancer commercial offer type. Use the Load Balancer types endpoint to retrieve a list of available offer types |
| ssl-compatibility-level | One of: `ssl_compatibility_level_unknown`, `ssl_compatibility_level_intermediate`, `ssl_compatibility_level_modern`, `ssl_compatibility_level_old` | Determines the minimal SSL version which needs to be supported on the client side, in an SSL/TLS offloading context. Intermediate is suitable for general-purpose servers with a variety of clients, recommended for almost all systems. Modern is suitable for services with clients that support TLS 1.3 and do not need backward compatibility. Old is compatible with a small number of very old clients and should be used only as a last resort |
| organization-id |  | Organization ID to use. If none is passed the default organization ID will be used |
| zone | Default: `fr-par-1`<br />One of: `fr-par-1`, `fr-par-2`, `nl-ams-1`, `nl-ams-2`, `nl-ams-3`, `pl-waw-1`, `pl-waw-2` | Zone to target. If none is passed will use default zone from the config |



### Delete a Load Balancer

Delete an existing Load Balancer, specified by its Load Balancer ID. Deleting a Load Balancer is permanent, and cannot be undone. The Load Balancer's flexible IP address can either be deleted with the Load Balancer, or kept in your account for future use.

**Usage:**

```
scw lb lb delete <lb-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| lb-id | Required | ID of the Load Balancer to delete |
| release-ip |  | Defines whether the Load Balancer's flexible IP should be deleted. Set to true to release the flexible IP, or false to keep it available in your account for future Load Balancers |
| zone | Default: `fr-par-1`<br />One of: `fr-par-1`, `fr-par-2`, `nl-ams-1`, `nl-ams-2`, `nl-ams-3`, `pl-waw-1`, `pl-waw-2` | Zone to target. If none is passed will use default zone from the config |



### Get a Load Balancer

Retrieve information about an existing Load Balancer, specified by its Load Balancer ID. Its full details, including name, status and IP address, are returned in the response object.

**Usage:**

```
scw lb lb get <lb-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| lb-id | Required | Load Balancer ID |
| zone | Default: `fr-par-1`<br />One of: `fr-par-1`, `fr-par-2`, `nl-ams-1`, `nl-ams-2`, `nl-ams-3`, `pl-waw-1`, `pl-waw-2` | Zone to target. If none is passed will use default zone from the config |



### Get usage statistics of a given Load Balancer

Get usage statistics of a given Load Balancer.

**Usage:**

```
scw lb lb get-stats <lb-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| lb-id | Required | Load Balancer ID |
| backend-id |  | ID of the backend |
| zone | Default: `fr-par-1`<br />One of: `fr-par-1`, `fr-par-2`, `nl-ams-1`, `nl-ams-2`, `nl-ams-3`, `pl-waw-1`, `pl-waw-2` | Zone to target. If none is passed will use default zone from the config |



### List Load Balancers

List all Load Balancers in the specified zone, for a Scaleway Organization or Scaleway Project. By default, the Load Balancers returned in the list are ordered by creation date in ascending order, though this can be modified via the `order_by` field.

**Usage:**

```
scw lb lb list [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| name |  | Load Balancer name to filter for |
| order-by | One of: `created_at_asc`, `created_at_desc`, `name_asc`, `name_desc` | Sort order of Load Balancers in the response |
| project-id |  | Project ID to filter for, only Load Balancers from this Project will be returned |
| organization-id |  | Organization ID to filter for, only Load Balancers from this Organization will be returned |
| zone | Default: `fr-par-1`<br />One of: `fr-par-1`, `fr-par-2`, `nl-ams-1`, `nl-ams-2`, `nl-ams-3`, `pl-waw-1`, `pl-waw-2`, `all` | Zone to target. If none is passed will use default zone from the config |



### Migrate a Load Balancer

Migrate an existing Load Balancer from one commercial type to another. Allows you to scale your Load Balancer up or down in terms of bandwidth or multi-cloud provision.

**Usage:**

```
scw lb lb migrate <lb-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| lb-id | Required | Load Balancer ID |
| type | Required<br />One of: `LB-S`, `LB-GP-M`, `LB-GP-L` | Load Balancer type to migrate to (use the List all Load Balancer offer types endpoint to get a list of available offer types) |
| zone | Default: `fr-par-1`<br />One of: `fr-par-1`, `fr-par-2`, `nl-ams-1`, `nl-ams-2`, `nl-ams-3`, `pl-waw-1`, `pl-waw-2` | Zone to target. If none is passed will use default zone from the config |



### Update a Load Balancer

Update the parameters of an existing Load Balancer, specified by its Load Balancer ID. Note that the request type is PUT and not PATCH. You must set all parameters.

**Usage:**

```
scw lb lb update <lb-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| lb-id | Required | Load Balancer ID |
| name | Required | Load Balancer name |
| description | Required | Load Balancer description |
| tags.{index} |  | List of tags for the Load Balancer |
| ssl-compatibility-level | One of: `ssl_compatibility_level_unknown`, `ssl_compatibility_level_intermediate`, `ssl_compatibility_level_modern`, `ssl_compatibility_level_old` | Determines the minimal SSL version which needs to be supported on the client side, in an SSL/TLS offloading context. Intermediate is suitable for general-purpose servers with a variety of clients, recommended for almost all systems. Modern is suitable for services with clients that support TLS 1.3 and don't need backward compatibility. Old is compatible with a small number of very old clients and should be used only as a last resort |
| zone | Default: `fr-par-1`<br />One of: `fr-par-1`, `fr-par-2`, `nl-ams-1`, `nl-ams-2`, `nl-ams-3`, `pl-waw-1`, `pl-waw-2` | Zone to target. If none is passed will use default zone from the config |



### Wait for a load balancer to reach a stable state

Wait for a load balancer to reach a stable state. This is similar to using --wait flag.

**Usage:**

```
scw lb lb wait <lb-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| lb-id | Required | ID of the load balancer you want to wait for. |
| zone | Default: `fr-par-1`<br />One of: `fr-par-1`, `fr-par-2`, `pl-waw-1`, `nl-ams-1` | Zone to target. If none is passed will use default zone from the config |
| timeout | Default: `10m0s` | Timeout of the wait |


**Examples:**


Wait for a load balancer to reach a stable state
```
scw lb lb wait 11111111-1111-1111-1111-111111111111
```




## Load balancer types management commands

Load balancer types management commands.


### List all Load Balancer offer types

List all the different commercial Load Balancer types. The response includes an array of offer types, each with a name, description, and information about its stock availability.

**Usage:**

```
scw lb lb-types list [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| zone | Default: `fr-par-1`<br />One of: `fr-par-1`, `fr-par-2`, `nl-ams-1`, `nl-ams-2`, `nl-ams-3`, `pl-waw-1`, `pl-waw-2`, `all` | Zone to target. If none is passed will use default zone from the config |



## Private networks management commands

Private networks management commands.


### Attach a Load Balancer to a Private Network

Attach a specified Load Balancer to a specified Private Network, defining a static or DHCP configuration for the Load Balancer on the network.

**Usage:**

```
scw lb private-network attach <lb-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| lb-id | Required | Load Balancer ID |
| private-network-id | Required | Private Network ID |
| static-config.ip-address.{index} |  | Array of a local IP address for the Load Balancer on this Private Network |
| zone | Default: `fr-par-1`<br />One of: `fr-par-1`, `fr-par-2`, `nl-ams-1`, `nl-ams-2`, `nl-ams-3`, `pl-waw-1`, `pl-waw-2` | Zone to target. If none is passed will use default zone from the config |



### Detach Load Balancer from Private Network

Detach a specified Load Balancer from a specified Private Network.

**Usage:**

```
scw lb private-network detach <lb-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| lb-id | Required | Load balancer ID |
| private-network-id | Required | Set your instance private network id |
| zone | Default: `fr-par-1`<br />One of: `fr-par-1`, `fr-par-2`, `nl-ams-1`, `nl-ams-2`, `nl-ams-3`, `pl-waw-1`, `pl-waw-2` | Zone to target. If none is passed will use default zone from the config |



### List Private Networks attached to a Load Balancer

List the Private Networks attached to a given Load Balancer, specified by its Load Balancer ID. The response is an array of Private Network objects, giving information including the status, configuration, name and creation date of each Private Network.

**Usage:**

```
scw lb private-network list <lb-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| order-by | One of: `created_at_asc`, `created_at_desc` | Sort order of Private Network objects in the response |
| lb-id | Required | Load Balancer ID |
| zone | Default: `fr-par-1`<br />One of: `fr-par-1`, `fr-par-2`, `nl-ams-1`, `nl-ams-2`, `nl-ams-3`, `pl-waw-1`, `pl-waw-2`, `all` | Zone to target. If none is passed will use default zone from the config |



## Route rules management commands

Route rules management commands.


### Create a route

Create a new route on a given frontend. To configure a route, specify the backend to direct to if a certain condition is matched (based on the value of the SNI field or HTTP Host header).

**Usage:**

```
scw lb route create [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| frontend-id |  | ID of the source frontend to create the route on |
| backend-id |  | ID of the target backend for the route |
| match.sni |  | Server Name Indication (SNI) value to match |
| match.host-header |  | HTTP host header to match |
| zone | Default: `fr-par-1`<br />One of: `fr-par-1`, `fr-par-2`, `nl-ams-1`, `nl-ams-2`, `nl-ams-3`, `pl-waw-1`, `pl-waw-2` | Zone to target. If none is passed will use default zone from the config |



### Delete a route

Delete an existing route, specified by its route ID. Deleting a route is permanent, and cannot be undone.

**Usage:**

```
scw lb route delete <route-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| route-id | Required | Route ID |
| zone | Default: `fr-par-1`<br />One of: `fr-par-1`, `fr-par-2`, `nl-ams-1`, `nl-ams-2`, `nl-ams-3`, `pl-waw-1`, `pl-waw-2` | Zone to target. If none is passed will use default zone from the config |



### Get a route

Retrieve information about an existing route, specified by its route ID. Its full details, origin frontend, target backend and match condition, are returned in the response object.

**Usage:**

```
scw lb route get <route-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| route-id | Required | Route ID |
| zone | Default: `fr-par-1`<br />One of: `fr-par-1`, `fr-par-2`, `nl-ams-1`, `nl-ams-2`, `nl-ams-3`, `pl-waw-1`, `pl-waw-2` | Zone to target. If none is passed will use default zone from the config |



### List all routes

List all routes for a given frontend. The response is an array of routes, each one  with a specified backend to direct to if a certain condition is matched (based on the value of the SNI field or HTTP Host header).

**Usage:**

```
scw lb route list [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| order-by | One of: `created_at_asc`, `created_at_desc` | Sort order of routes in the response |
| frontend-id |  | Frontend ID to filter for, only Routes from this Frontend will be returned |
| zone | Default: `fr-par-1`<br />One of: `fr-par-1`, `fr-par-2`, `nl-ams-1`, `nl-ams-2`, `nl-ams-3`, `pl-waw-1`, `pl-waw-2`, `all` | Zone to target. If none is passed will use default zone from the config |



### Update a route

Update the configuration of an existing route, specified by its route ID.

**Usage:**

```
scw lb route update <route-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| route-id | Required | Route ID |
| backend-id |  | ID of the target backend for the route |
| match.sni |  | Server Name Indication (SNI) value to match |
| match.host-header |  | HTTP host header to match |
| zone | Default: `fr-par-1`<br />One of: `fr-par-1`, `fr-par-2`, `nl-ams-1`, `nl-ams-2`, `nl-ams-3`, `pl-waw-1`, `pl-waw-2` | Zone to target. If none is passed will use default zone from the config |



## Subscriber management commands

Subscriber management commands.


### Create a subscriber

Create a new subscriber, either with an email configuration or a webhook configuration, for a specified Scaleway Project.

**Usage:**

```
scw lb subscriber create [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| name | Required | Subscriber name |
| email-config.email |  | Email address to send alerts to |
| webhook-config.uri |  | URI to receive POST requests |
| project-id |  | Project ID to use. If none is passed the default project ID will be used |
| organization-id |  | Organization ID to use. If none is passed the default organization ID will be used |
| zone | Default: `fr-par-1`<br />One of: `fr-par-1`, `fr-par-2`, `nl-ams-1`, `nl-ams-2`, `nl-ams-3`, `pl-waw-1`, `pl-waw-2` | Zone to target. If none is passed will use default zone from the config |



### Delete a subscriber

Delete an existing subscriber, specified by its subscriber ID. Deleting a subscriber is permanent, and cannot be undone.

**Usage:**

```
scw lb subscriber delete <subscriber-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| subscriber-id | Required | Subscriber ID |
| zone | Default: `fr-par-1`<br />One of: `fr-par-1`, `fr-par-2`, `nl-ams-1`, `nl-ams-2`, `nl-ams-3`, `pl-waw-1`, `pl-waw-2` | Zone to target. If none is passed will use default zone from the config |



### Get a subscriber

Retrieve information about an existing subscriber, specified by its subscriber ID. Its full details, including name and email/webhook configuration, are returned in the response object.

**Usage:**

```
scw lb subscriber get <subscriber-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| subscriber-id | Required | Subscriber ID |
| zone | Default: `fr-par-1`<br />One of: `fr-par-1`, `fr-par-2`, `nl-ams-1`, `nl-ams-2`, `nl-ams-3`, `pl-waw-1`, `pl-waw-2` | Zone to target. If none is passed will use default zone from the config |



### List all subscribers

List all subscribers to Load Balancer alerts. By default, returns all subscribers to Load Balancer alerts for the Organization associated with the authentication token used for the request.

**Usage:**

```
scw lb subscriber list [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| order-by | One of: `created_at_asc`, `created_at_desc`, `name_asc`, `name_desc` | Sort order of subscribers in the response |
| name | Required | Subscriber name to search for |
| project-id |  | Filter subscribers by Project ID |
| organization-id |  | Filter subscribers by Organization ID |
| zone | Default: `fr-par-1`<br />One of: `fr-par-1`, `fr-par-2`, `nl-ams-1`, `nl-ams-2`, `nl-ams-3`, `pl-waw-1`, `pl-waw-2`, `all` | Zone to target. If none is passed will use default zone from the config |



### Subscribe a subscriber to alerts for a given Load Balancer

Subscribe an existing subscriber to alerts for a given Load Balancer.

**Usage:**

```
scw lb subscriber subscribe [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| lb-id | Required | Load Balancer ID |
| subscriber-id | Required | Subscriber ID |
| zone | Default: `fr-par-1`<br />One of: `fr-par-1`, `fr-par-2`, `nl-ams-1`, `nl-ams-2`, `nl-ams-3`, `pl-waw-1`, `pl-waw-2` | Zone to target. If none is passed will use default zone from the config |



### Unsubscribe a subscriber from alerts for a given Load Balancer

Unsubscribe a subscriber from alerts for a given Load Balancer. The subscriber is not deleted, and can be resubscribed in the future if necessary.

**Usage:**

```
scw lb subscriber unsubscribe [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| lb-id | Required | Load Balancer ID |
| zone | Default: `fr-par-1`<br />One of: `fr-par-1`, `fr-par-2`, `nl-ams-1`, `nl-ams-2`, `nl-ams-3`, `pl-waw-1`, `pl-waw-2` | Zone to target. If none is passed will use default zone from the config |



### Update a subscriber

Update the parameters of a given subscriber (e.g. name, webhook configuration, email configuration), specified by its subscriber ID.

**Usage:**

```
scw lb subscriber update <subscriber-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| subscriber-id | Required | Subscriber ID |
| name | Required | Subscriber name |
| email-config.email |  | Email address to send alerts to |
| webhook-config.uri |  | URI to receive POST requests |
| zone | Default: `fr-par-1`<br />One of: `fr-par-1`, `fr-par-2`, `nl-ams-1`, `nl-ams-2`, `nl-ams-3`, `pl-waw-1`, `pl-waw-2` | Zone to target. If none is passed will use default zone from the config |



