<!-- DO NOT EDIT: this file is automatically generated using scw-doc-gen -->
# Documentation for `scw registry`
Container registry API
  
- [Image management commands](#image-management-commands)
  - [Delete an image](#delete-an-image)
  - [Get a image](#get-a-image)
  - [List all your images](#list-all-your-images)
  - [Update an existing image](#update-an-existing-image)
- [Install a local Docker credential helper](#install-a-local-docker-credential-helper)
- [Login to a registry](#login-to-a-registry)
- [Logout of a registry](#logout-of-a-registry)
- [Namespace management commands](#namespace-management-commands)
  - [Create a new namespace](#create-a-new-namespace)
  - [Delete an existing namespace](#delete-an-existing-namespace)
  - [Get a namespace](#get-a-namespace)
  - [List all your namespaces](#list-all-your-namespaces)
  - [Update an existing namespace](#update-an-existing-namespace)
- [Tag management commands](#tag-management-commands)
  - [Delete a tag](#delete-a-tag)
  - [Get a tag](#get-a-tag)
  - [List all your tags](#list-all-your-tags)

  
## Image management commands

An image represents a container image.

The visibility of an image can be public (everyone can pull it), private (only your organization can pull it) or inherit from the namespace visibility (default)
It can be changed with an update on the image via the registry API.



### Delete an image

Delete the image associated with the given id.

**Usage:**

```
scw registry image delete <image-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| image-id | Required | The unique ID of the Image |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams` | Region to target. If none is passed will use default region from the config |



### Get a image

Get the image associated with the given id.

**Usage:**

```
scw registry image get <image-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| image-id | Required | The unique ID of the Image |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams` | Region to target. If none is passed will use default region from the config |



### List all your images

List all your images.

**Usage:**

```
scw registry image list [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| order-by | One of: `created_at_asc`, `created_at_desc`, `name_asc`, `name_desc` | Field by which to order the display of Images |
| namespace-id |  | Filter by the Namespace ID |
| name |  | Filter by the Image name (exact match) |
| organization-id |  | Filter by Organization ID |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams` | Region to target. If none is passed will use default region from the config |



### Update an existing image

Update the image associated with the given id.

**Usage:**

```
scw registry image update <image-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| image-id | Required | Image ID to update |
| visibility | One of: `visibility_unknown`, `inherit`, `public`, `private` | A `public` image is pullable from internet without authentication, opposed to a `private` image. `inherit` will use the namespace `is_public` parameter |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams` | Region to target. If none is passed will use default region from the config |



## Install a local Docker credential helper

This command will install the Docker credential helper for your account.

It will create a new script named docker-credential-scw. 
This script will be called each time Docker needs the credentials and will return the correct credentials.
It avoid running docker login commands.


This command will install the Docker credential helper for your account.

It will create a new script named docker-credential-scw. 
This script will be called each time Docker needs the credentials and will return the correct credentials.
It avoid running docker login commands.


**Usage:**

```
scw registry install-docker-helper [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| path | Default: `/usr/local/bin` | Directory in which the Docker helper will be installed. This directory should be in your $PATH |



## Login to a registry

This command will run the correct command in order to log you in on the registry with the chosen program.
You will need to have the chosen binary installed on your system and in your PATH.

This command will run the correct command in order to log you in on the registry with the chosen program.
You will need to have the chosen binary installed on your system and in your PATH.

**Usage:**

```
scw registry login [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| program | Default: `docker`<br />One of: `docker`, `podman` | Program used to log in to the namespace |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams` | Region to target. If none is passed will use default region from the config |



## Logout of a registry

This command will run the correct command in order to log you out of the registry with the chosen program.
You will need to have the chosen binary installed on your system and in your PATH.

This command will run the correct command in order to log you out of the registry with the chosen program.
You will need to have the chosen binary installed on your system and in your PATH.

**Usage:**

```
scw registry logout [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| program | Default: `docker`<br />One of: `docker`, `podman` | Program used to log in to the namespace |
| region | Default: `fr-par` | Region to target. If none is passed will use default region from the config |



## Namespace management commands

A namespace is for images what a folder is for files

To use our services, the first step is to create a namespace.

A namespace is for images what a folder is for files. Every push or pull must mention the namespace :
```docker pull rg.nl-ams.scw.cloud/<namespace_name>/<image_name>:<tag_name>```

Note that a namespace name is unique on a region. Thus, if another client already has created "test", you can't have it as a namespace

A namespace can be either public or private (default), which determines who can pull images.



### Create a new namespace

Create a new namespace.

**Usage:**

```
scw registry namespace create [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| name | Required | Define a namespace name |
| description |  | Define a description |
| is-public |  | Define the default visibility policy |
| organization-id |  | Organization ID to use. If none is passed will use default organization ID from the config |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams` | Region to target. If none is passed will use default region from the config |



### Delete an existing namespace

Delete the namespace associated with the given id.

**Usage:**

```
scw registry namespace delete <namespace-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| namespace-id | Required | The unique ID of the Namespace |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams` | Region to target. If none is passed will use default region from the config |



### Get a namespace

Get the namespace associated with the given id.

**Usage:**

```
scw registry namespace get <namespace-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| namespace-id | Required | The unique ID of the Namespace |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams` | Region to target. If none is passed will use default region from the config |



### List all your namespaces

List all your namespaces.

**Usage:**

```
scw registry namespace list [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| order-by | One of: `created_at_asc`, `created_at_desc`, `description_asc`, `description_desc`, `name_asc`, `name_desc` | Field by which to order the display of Images |
| name |  | Filter by the namespace name (exact match) |
| organization-id |  | Filter by the namespace owner |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams` | Region to target. If none is passed will use default region from the config |



### Update an existing namespace

Update the namespace associated with the given id.

**Usage:**

```
scw registry namespace update <namespace-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| namespace-id | Required | Namespace ID to update |
| description |  | Define a description |
| is-public |  | Define the default visibility policy |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams` | Region to target. If none is passed will use default region from the config |



## Tag management commands

A tag represents a container tag of an image.



### Delete a tag

Delete the tag associated with the given id.

**Usage:**

```
scw registry tag delete <tag-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| tag-id | Required | The unique ID of the tag |
| force |  | If two tags share the same digest the deletion will fail unless this parameter is set to true |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams` | Region to target. If none is passed will use default region from the config |



### Get a tag

Get the tag associated with the given id.

**Usage:**

```
scw registry tag get <tag-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| tag-id | Required | The unique ID of the Tag |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams` | Region to target. If none is passed will use default region from the config |



### List all your tags

List all your tags.

**Usage:**

```
scw registry tag list <image-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| order-by | One of: `created_at_asc`, `created_at_desc`, `name_asc`, `name_desc` | Field by which to order the display of Images |
| image-id | Required | The unique ID of the image |
| name |  | Filter by the tag name (exact match) |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams` | Region to target. If none is passed will use default region from the config |



