package mp4

import (
	"bytes"
	"io/ioutil"
	"testing"

	"github.com/Eyevinn/mp4ff/bits"
)

func TestDecodEncodeFileSRW(t *testing.T) {
	testFiles := []string{
		"1.m4s",
		"prog_8s.mp4",
	}
	for _, testFile := range testFiles {
		raw, err := ioutil.ReadFile("testdata/" + testFile)
		if err != nil {
			t.Error(err)
		}
		rawOut := make([]byte, len(raw))
		t.Run(testFile, func(t *testing.T) {
			sr := bits.NewFixedSliceReader(raw)
			f, err := DecodeFileSR(sr)
			if err != nil {
				t.Error(err)
			}
			sw := bits.NewFixedSliceWriterFromSlice(rawOut)
			f.FragEncMode = EncModeBoxTree
			err = f.EncodeSW(sw)
			if err != nil {
				t.Error(err)
			}
			if !bytes.Equal(raw, sw.Bytes()) {
				t.Errorf("%s: generated bytes differ from input", testFile)
			}
		})
	}
}

func BenchmarkDecodeFileSR(b *testing.B) {
	testFiles := []string{
		"1.m4s",
		"prog_8s.mp4",
	}
	for _, testFile := range testFiles {
		raw, _ := ioutil.ReadFile("testdata/" + testFile)
		b.Run(testFile, func(b *testing.B) {
			for i := 0; i < b.N; i++ {
				sr := bits.NewFixedSliceReader(raw)
				_, _ = DecodeFileSR(sr)
			}
		})
	}
}

func BenchmarkEncodeFileSW(b *testing.B) {
	testFiles := []string{
		"1.m4s",
		"prog_8s.mp4",
	}
	for _, testFile := range testFiles {
		raw, _ := ioutil.ReadFile("testdata/" + testFile)
		inBuf := bytes.NewBuffer(raw)
		decFile, _ := DecodeFile(inBuf)
		rawOut := make([]byte, len(raw))
		b.Run(testFile, func(b *testing.B) {
			for i := 0; i < b.N; i++ {
				sw := bits.NewFixedSliceWriterFromSlice(rawOut)
				_ = decFile.EncodeSW(sw)
			}
		})
	}
}
