/*
 * Subset of Influx API covered by Influx CLI
 *
 * No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)
 *
 * API version: 2.0.0
 */

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package api

import (
	_context "context"
	_fmt "fmt"
	_io "io"
	_nethttp "net/http"
	_neturl "net/url"
	"reflect"
	"strings"
)

// Linger please
var (
	_ _context.Context
)

type StacksApi interface {

	/*
	 * CreateStack Create a new stack
	 * @param ctx _context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
	 * @return ApiCreateStackRequest
	 */
	CreateStack(ctx _context.Context) ApiCreateStackRequest

	/*
	 * CreateStackExecute executes the request
	 * @return Stack
	 */
	CreateStackExecute(r ApiCreateStackRequest) (Stack, error)

	/*
	 * DeleteStack Delete a stack and associated resources
	 * @param ctx _context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
	 * @param stackId The identifier of the stack.
	 * @return ApiDeleteStackRequest
	 */
	DeleteStack(ctx _context.Context, stackId string) ApiDeleteStackRequest

	/*
	 * DeleteStackExecute executes the request
	 */
	DeleteStackExecute(r ApiDeleteStackRequest) error

	/*
	 * ListStacks List all installed InfluxDB templates
	 * @param ctx _context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
	 * @return ApiListStacksRequest
	 */
	ListStacks(ctx _context.Context) ApiListStacksRequest

	/*
	 * ListStacksExecute executes the request
	 * @return Stacks
	 */
	ListStacksExecute(r ApiListStacksRequest) (Stacks, error)

	/*
	 * ReadStack Retrieve a stack
	 * @param ctx _context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
	 * @param stackId The identifier of the stack.
	 * @return ApiReadStackRequest
	 */
	ReadStack(ctx _context.Context, stackId string) ApiReadStackRequest

	/*
	 * ReadStackExecute executes the request
	 * @return Stack
	 */
	ReadStackExecute(r ApiReadStackRequest) (Stack, error)

	/*
	 * UpdateStack Update an InfluxDB Stack
	 * @param ctx _context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
	 * @param stackId The identifier of the stack.
	 * @return ApiUpdateStackRequest
	 */
	UpdateStack(ctx _context.Context, stackId string) ApiUpdateStackRequest

	/*
	 * UpdateStackExecute executes the request
	 * @return Stack
	 */
	UpdateStackExecute(r ApiUpdateStackRequest) (Stack, error)

	// Sets additional descriptive text in the error message if any request in
	// this API fails, indicating that it is intended to be used only on OSS
	// servers.
	OnlyOSS() StacksApi

	// Sets additional descriptive text in the error message if any request in
	// this API fails, indicating that it is intended to be used only on cloud
	// servers.
	OnlyCloud() StacksApi
}

// StacksApiService StacksApi service
type StacksApiService service

func (a *StacksApiService) OnlyOSS() StacksApi {
	a.isOnlyOSS = true
	return a
}

func (a *StacksApiService) OnlyCloud() StacksApi {
	a.isOnlyCloud = true
	return a
}

type ApiCreateStackRequest struct {
	ctx              _context.Context
	ApiService       StacksApi
	stackPostRequest *StackPostRequest
}

func (r ApiCreateStackRequest) StackPostRequest(stackPostRequest StackPostRequest) ApiCreateStackRequest {
	r.stackPostRequest = &stackPostRequest
	return r
}
func (r ApiCreateStackRequest) GetStackPostRequest() *StackPostRequest {
	return r.stackPostRequest
}

func (r ApiCreateStackRequest) Execute() (Stack, error) {
	return r.ApiService.CreateStackExecute(r)
}

/*
 * CreateStack Create a new stack
 * @param ctx _context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 * @return ApiCreateStackRequest
 */
func (a *StacksApiService) CreateStack(ctx _context.Context) ApiCreateStackRequest {
	return ApiCreateStackRequest{
		ApiService: a,
		ctx:        ctx,
	}
}

/*
 * Execute executes the request
 * @return Stack
 */
func (a *StacksApiService) CreateStackExecute(r ApiCreateStackRequest) (Stack, error) {
	var (
		localVarHTTPMethod   = _nethttp.MethodPost
		localVarPostBody     interface{}
		localVarFormFileName string
		localVarFileName     string
		localVarFileBytes    []byte
		localVarReturnValue  Stack
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "StacksApiService.CreateStack")
	if err != nil {
		return localVarReturnValue, GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/stacks"

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := _neturl.Values{}
	localVarFormParams := _neturl.Values{}
	if r.stackPostRequest == nil {
		return localVarReturnValue, reportError("stackPostRequest is required and must be specified")
	}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	// body params
	localVarPostBody = r.stackPostRequest
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFormFileName, localVarFileName, localVarFileBytes)
	if err != nil {
		return localVarReturnValue, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, err
	}

	var errorPrefix string
	if a.isOnlyOSS {
		errorPrefix = "InfluxDB OSS-only command failed: "
	} else if a.isOnlyCloud {
		errorPrefix = "InfluxDB Cloud-only command failed: "
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		body, err := GunzipIfNeeded(localVarHTTPResponse)
		if err != nil {
			body.Close()
			return localVarReturnValue, _fmt.Errorf("%s%w", errorPrefix, err)
		}
		localVarBody, err := _io.ReadAll(body)
		body.Close()
		if err != nil {
			return localVarReturnValue, _fmt.Errorf("%s%w", errorPrefix, err)
		}
		newErr := GenericOpenAPIError{
			body:  localVarBody,
			error: _fmt.Sprintf("%s%s", errorPrefix, localVarHTTPResponse.Status),
		}
		var v Error
		err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
		if err != nil {
			newErr.error = _fmt.Sprintf("%s: %s", newErr.Error(), err.Error())
			return localVarReturnValue, newErr
		}
		v.SetMessage(_fmt.Sprintf("%s: %s", newErr.Error(), v.GetMessage()))
		newErr.model = &v
		return localVarReturnValue, newErr
	}

	body, err := GunzipIfNeeded(localVarHTTPResponse)
	if err != nil {
		body.Close()
		return localVarReturnValue, _fmt.Errorf("%s%w", errorPrefix, err)
	}
	localVarBody, err := _io.ReadAll(body)
	body.Close()
	if err != nil {
		return localVarReturnValue, _fmt.Errorf("%s%w", errorPrefix, err)
	}
	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := GenericOpenAPIError{
			body:  localVarBody,
			error: _fmt.Sprintf("%s%s", errorPrefix, err.Error()),
		}
		return localVarReturnValue, newErr
	}

	return localVarReturnValue, nil
}

type ApiDeleteStackRequest struct {
	ctx        _context.Context
	ApiService StacksApi
	stackId    string
	orgID      *string
}

func (r ApiDeleteStackRequest) StackId(stackId string) ApiDeleteStackRequest {
	r.stackId = stackId
	return r
}
func (r ApiDeleteStackRequest) GetStackId() string {
	return r.stackId
}

func (r ApiDeleteStackRequest) OrgID(orgID string) ApiDeleteStackRequest {
	r.orgID = &orgID
	return r
}
func (r ApiDeleteStackRequest) GetOrgID() *string {
	return r.orgID
}

func (r ApiDeleteStackRequest) Execute() error {
	return r.ApiService.DeleteStackExecute(r)
}

/*
 * DeleteStack Delete a stack and associated resources
 * @param ctx _context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 * @param stackId The identifier of the stack.
 * @return ApiDeleteStackRequest
 */
func (a *StacksApiService) DeleteStack(ctx _context.Context, stackId string) ApiDeleteStackRequest {
	return ApiDeleteStackRequest{
		ApiService: a,
		ctx:        ctx,
		stackId:    stackId,
	}
}

/*
 * Execute executes the request
 */
func (a *StacksApiService) DeleteStackExecute(r ApiDeleteStackRequest) error {
	var (
		localVarHTTPMethod   = _nethttp.MethodDelete
		localVarPostBody     interface{}
		localVarFormFileName string
		localVarFileName     string
		localVarFileBytes    []byte
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "StacksApiService.DeleteStack")
	if err != nil {
		return GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/stacks/{stack_id}"
	localVarPath = strings.Replace(localVarPath, "{"+"stack_id"+"}", _neturl.PathEscape(parameterToString(r.stackId, "")), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := _neturl.Values{}
	localVarFormParams := _neturl.Values{}
	if r.orgID == nil {
		return reportError("orgID is required and must be specified")
	}

	localVarQueryParams.Add("orgID", parameterToString(*r.orgID, ""))
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFormFileName, localVarFileName, localVarFileBytes)
	if err != nil {
		return err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return err
	}

	var errorPrefix string
	if a.isOnlyOSS {
		errorPrefix = "InfluxDB OSS-only command failed: "
	} else if a.isOnlyCloud {
		errorPrefix = "InfluxDB Cloud-only command failed: "
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		body, err := GunzipIfNeeded(localVarHTTPResponse)
		if err != nil {
			body.Close()
			return _fmt.Errorf("%s%w", errorPrefix, err)
		}
		localVarBody, err := _io.ReadAll(body)
		body.Close()
		if err != nil {
			return _fmt.Errorf("%s%w", errorPrefix, err)
		}
		newErr := GenericOpenAPIError{
			body:  localVarBody,
			error: _fmt.Sprintf("%s%s", errorPrefix, localVarHTTPResponse.Status),
		}
		var v Error
		err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
		if err != nil {
			newErr.error = _fmt.Sprintf("%s: %s", newErr.Error(), err.Error())
			return newErr
		}
		v.SetMessage(_fmt.Sprintf("%s: %s", newErr.Error(), v.GetMessage()))
		newErr.model = &v
		return newErr
	}

	return nil
}

type ApiListStacksRequest struct {
	ctx        _context.Context
	ApiService StacksApi
	orgID      *string
	name       *[]string
	stackID    *[]string
}

func (r ApiListStacksRequest) OrgID(orgID string) ApiListStacksRequest {
	r.orgID = &orgID
	return r
}
func (r ApiListStacksRequest) GetOrgID() *string {
	return r.orgID
}

func (r ApiListStacksRequest) Name(name []string) ApiListStacksRequest {
	r.name = &name
	return r
}
func (r ApiListStacksRequest) GetName() *[]string {
	return r.name
}

func (r ApiListStacksRequest) StackID(stackID []string) ApiListStacksRequest {
	r.stackID = &stackID
	return r
}
func (r ApiListStacksRequest) GetStackID() *[]string {
	return r.stackID
}

func (r ApiListStacksRequest) Execute() (Stacks, error) {
	return r.ApiService.ListStacksExecute(r)
}

/*
 * ListStacks List all installed InfluxDB templates
 * @param ctx _context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 * @return ApiListStacksRequest
 */
func (a *StacksApiService) ListStacks(ctx _context.Context) ApiListStacksRequest {
	return ApiListStacksRequest{
		ApiService: a,
		ctx:        ctx,
	}
}

/*
 * Execute executes the request
 * @return Stacks
 */
func (a *StacksApiService) ListStacksExecute(r ApiListStacksRequest) (Stacks, error) {
	var (
		localVarHTTPMethod   = _nethttp.MethodGet
		localVarPostBody     interface{}
		localVarFormFileName string
		localVarFileName     string
		localVarFileBytes    []byte
		localVarReturnValue  Stacks
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "StacksApiService.ListStacks")
	if err != nil {
		return localVarReturnValue, GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/stacks"

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := _neturl.Values{}
	localVarFormParams := _neturl.Values{}
	if r.orgID == nil {
		return localVarReturnValue, reportError("orgID is required and must be specified")
	}

	localVarQueryParams.Add("orgID", parameterToString(*r.orgID, ""))
	if r.name != nil {
		t := *r.name
		if reflect.TypeOf(t).Kind() == reflect.Slice {
			s := reflect.ValueOf(t)
			for i := 0; i < s.Len(); i++ {
				localVarQueryParams.Add("name", parameterToString(s.Index(i), "multi"))
			}
		} else {
			localVarQueryParams.Add("name", parameterToString(t, "multi"))
		}
	}
	if r.stackID != nil {
		t := *r.stackID
		if reflect.TypeOf(t).Kind() == reflect.Slice {
			s := reflect.ValueOf(t)
			for i := 0; i < s.Len(); i++ {
				localVarQueryParams.Add("stackID", parameterToString(s.Index(i), "multi"))
			}
		} else {
			localVarQueryParams.Add("stackID", parameterToString(t, "multi"))
		}
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFormFileName, localVarFileName, localVarFileBytes)
	if err != nil {
		return localVarReturnValue, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, err
	}

	var errorPrefix string
	if a.isOnlyOSS {
		errorPrefix = "InfluxDB OSS-only command failed: "
	} else if a.isOnlyCloud {
		errorPrefix = "InfluxDB Cloud-only command failed: "
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		body, err := GunzipIfNeeded(localVarHTTPResponse)
		if err != nil {
			body.Close()
			return localVarReturnValue, _fmt.Errorf("%s%w", errorPrefix, err)
		}
		localVarBody, err := _io.ReadAll(body)
		body.Close()
		if err != nil {
			return localVarReturnValue, _fmt.Errorf("%s%w", errorPrefix, err)
		}
		newErr := GenericOpenAPIError{
			body:  localVarBody,
			error: _fmt.Sprintf("%s%s", errorPrefix, localVarHTTPResponse.Status),
		}
		var v Error
		err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
		if err != nil {
			newErr.error = _fmt.Sprintf("%s: %s", newErr.Error(), err.Error())
			return localVarReturnValue, newErr
		}
		v.SetMessage(_fmt.Sprintf("%s: %s", newErr.Error(), v.GetMessage()))
		newErr.model = &v
		return localVarReturnValue, newErr
	}

	body, err := GunzipIfNeeded(localVarHTTPResponse)
	if err != nil {
		body.Close()
		return localVarReturnValue, _fmt.Errorf("%s%w", errorPrefix, err)
	}
	localVarBody, err := _io.ReadAll(body)
	body.Close()
	if err != nil {
		return localVarReturnValue, _fmt.Errorf("%s%w", errorPrefix, err)
	}
	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := GenericOpenAPIError{
			body:  localVarBody,
			error: _fmt.Sprintf("%s%s", errorPrefix, err.Error()),
		}
		return localVarReturnValue, newErr
	}

	return localVarReturnValue, nil
}

type ApiReadStackRequest struct {
	ctx        _context.Context
	ApiService StacksApi
	stackId    string
}

func (r ApiReadStackRequest) StackId(stackId string) ApiReadStackRequest {
	r.stackId = stackId
	return r
}
func (r ApiReadStackRequest) GetStackId() string {
	return r.stackId
}

func (r ApiReadStackRequest) Execute() (Stack, error) {
	return r.ApiService.ReadStackExecute(r)
}

/*
 * ReadStack Retrieve a stack
 * @param ctx _context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 * @param stackId The identifier of the stack.
 * @return ApiReadStackRequest
 */
func (a *StacksApiService) ReadStack(ctx _context.Context, stackId string) ApiReadStackRequest {
	return ApiReadStackRequest{
		ApiService: a,
		ctx:        ctx,
		stackId:    stackId,
	}
}

/*
 * Execute executes the request
 * @return Stack
 */
func (a *StacksApiService) ReadStackExecute(r ApiReadStackRequest) (Stack, error) {
	var (
		localVarHTTPMethod   = _nethttp.MethodGet
		localVarPostBody     interface{}
		localVarFormFileName string
		localVarFileName     string
		localVarFileBytes    []byte
		localVarReturnValue  Stack
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "StacksApiService.ReadStack")
	if err != nil {
		return localVarReturnValue, GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/stacks/{stack_id}"
	localVarPath = strings.Replace(localVarPath, "{"+"stack_id"+"}", _neturl.PathEscape(parameterToString(r.stackId, "")), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := _neturl.Values{}
	localVarFormParams := _neturl.Values{}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFormFileName, localVarFileName, localVarFileBytes)
	if err != nil {
		return localVarReturnValue, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, err
	}

	var errorPrefix string
	if a.isOnlyOSS {
		errorPrefix = "InfluxDB OSS-only command failed: "
	} else if a.isOnlyCloud {
		errorPrefix = "InfluxDB Cloud-only command failed: "
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		body, err := GunzipIfNeeded(localVarHTTPResponse)
		if err != nil {
			body.Close()
			return localVarReturnValue, _fmt.Errorf("%s%w", errorPrefix, err)
		}
		localVarBody, err := _io.ReadAll(body)
		body.Close()
		if err != nil {
			return localVarReturnValue, _fmt.Errorf("%s%w", errorPrefix, err)
		}
		newErr := GenericOpenAPIError{
			body:  localVarBody,
			error: _fmt.Sprintf("%s%s", errorPrefix, localVarHTTPResponse.Status),
		}
		var v Error
		err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
		if err != nil {
			newErr.error = _fmt.Sprintf("%s: %s", newErr.Error(), err.Error())
			return localVarReturnValue, newErr
		}
		v.SetMessage(_fmt.Sprintf("%s: %s", newErr.Error(), v.GetMessage()))
		newErr.model = &v
		return localVarReturnValue, newErr
	}

	body, err := GunzipIfNeeded(localVarHTTPResponse)
	if err != nil {
		body.Close()
		return localVarReturnValue, _fmt.Errorf("%s%w", errorPrefix, err)
	}
	localVarBody, err := _io.ReadAll(body)
	body.Close()
	if err != nil {
		return localVarReturnValue, _fmt.Errorf("%s%w", errorPrefix, err)
	}
	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := GenericOpenAPIError{
			body:  localVarBody,
			error: _fmt.Sprintf("%s%s", errorPrefix, err.Error()),
		}
		return localVarReturnValue, newErr
	}

	return localVarReturnValue, nil
}

type ApiUpdateStackRequest struct {
	ctx               _context.Context
	ApiService        StacksApi
	stackId           string
	stackPatchRequest *StackPatchRequest
}

func (r ApiUpdateStackRequest) StackId(stackId string) ApiUpdateStackRequest {
	r.stackId = stackId
	return r
}
func (r ApiUpdateStackRequest) GetStackId() string {
	return r.stackId
}

func (r ApiUpdateStackRequest) StackPatchRequest(stackPatchRequest StackPatchRequest) ApiUpdateStackRequest {
	r.stackPatchRequest = &stackPatchRequest
	return r
}
func (r ApiUpdateStackRequest) GetStackPatchRequest() *StackPatchRequest {
	return r.stackPatchRequest
}

func (r ApiUpdateStackRequest) Execute() (Stack, error) {
	return r.ApiService.UpdateStackExecute(r)
}

/*
 * UpdateStack Update an InfluxDB Stack
 * @param ctx _context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 * @param stackId The identifier of the stack.
 * @return ApiUpdateStackRequest
 */
func (a *StacksApiService) UpdateStack(ctx _context.Context, stackId string) ApiUpdateStackRequest {
	return ApiUpdateStackRequest{
		ApiService: a,
		ctx:        ctx,
		stackId:    stackId,
	}
}

/*
 * Execute executes the request
 * @return Stack
 */
func (a *StacksApiService) UpdateStackExecute(r ApiUpdateStackRequest) (Stack, error) {
	var (
		localVarHTTPMethod   = _nethttp.MethodPatch
		localVarPostBody     interface{}
		localVarFormFileName string
		localVarFileName     string
		localVarFileBytes    []byte
		localVarReturnValue  Stack
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "StacksApiService.UpdateStack")
	if err != nil {
		return localVarReturnValue, GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/stacks/{stack_id}"
	localVarPath = strings.Replace(localVarPath, "{"+"stack_id"+"}", _neturl.PathEscape(parameterToString(r.stackId, "")), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := _neturl.Values{}
	localVarFormParams := _neturl.Values{}
	if r.stackPatchRequest == nil {
		return localVarReturnValue, reportError("stackPatchRequest is required and must be specified")
	}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	// body params
	localVarPostBody = r.stackPatchRequest
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFormFileName, localVarFileName, localVarFileBytes)
	if err != nil {
		return localVarReturnValue, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, err
	}

	var errorPrefix string
	if a.isOnlyOSS {
		errorPrefix = "InfluxDB OSS-only command failed: "
	} else if a.isOnlyCloud {
		errorPrefix = "InfluxDB Cloud-only command failed: "
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		body, err := GunzipIfNeeded(localVarHTTPResponse)
		if err != nil {
			body.Close()
			return localVarReturnValue, _fmt.Errorf("%s%w", errorPrefix, err)
		}
		localVarBody, err := _io.ReadAll(body)
		body.Close()
		if err != nil {
			return localVarReturnValue, _fmt.Errorf("%s%w", errorPrefix, err)
		}
		newErr := GenericOpenAPIError{
			body:  localVarBody,
			error: _fmt.Sprintf("%s%s", errorPrefix, localVarHTTPResponse.Status),
		}
		var v Error
		err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
		if err != nil {
			newErr.error = _fmt.Sprintf("%s: %s", newErr.Error(), err.Error())
			return localVarReturnValue, newErr
		}
		v.SetMessage(_fmt.Sprintf("%s: %s", newErr.Error(), v.GetMessage()))
		newErr.model = &v
		return localVarReturnValue, newErr
	}

	body, err := GunzipIfNeeded(localVarHTTPResponse)
	if err != nil {
		body.Close()
		return localVarReturnValue, _fmt.Errorf("%s%w", errorPrefix, err)
	}
	localVarBody, err := _io.ReadAll(body)
	body.Close()
	if err != nil {
		return localVarReturnValue, _fmt.Errorf("%s%w", errorPrefix, err)
	}
	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := GenericOpenAPIError{
			body:  localVarBody,
			error: _fmt.Sprintf("%s%s", errorPrefix, err.Error()),
		}
		return localVarReturnValue, newErr
	}

	return localVarReturnValue, nil
}
