package aws_test

import (
	"testing"

	"github.com/cloudskiff/driftctl/test/acceptance"
)

func TestAcc_AwsNATGateway(t *testing.T) {
	acceptance.Run(t, acceptance.AccTestCase{
		Path: "./testdata/acc/aws_nat_gateway",
		// We filter on aws_eip_association too to test the middleware behavior
		Args: []string{"scan", "--filter", "Type=='aws_nat_gateway' || Type=='aws_eip_association'"},
		Checks: []acceptance.AccCheck{
			{
				Env: map[string]string{
					"AWS_REGION": "us-east-1",
				},
				Check: func(result *acceptance.ScanResult, stdout string, err error) {
					if err != nil {
						t.Fatal(err)
					}
					result.AssertInfrastructureIsInSync()
					result.Equal(1, result.Summary().TotalManaged)
				},
			},
		},
	})
}
