Share your applications, videos, and blog posts with fellow Copilots!

## Blog posts

| Title      | Description                          |
| ----------- | ------------------------------------ |
| [**Deploying a Containerized Web App with AWS Copilot**](https://towardsdatascience.com/deploying-a-containerized-web-app-with-aws-copilot-db5c90467fbd) by <a href="https://twitter.com/edkruegerdata">@edkruegerdata</a> and <a href="https://www.linkedin.com/in/dylan-rossi/">Dylan Rossi</a> | Edward and Dylan start from the basics, including IAM account creation and AWS CLI installation. (Note: you'll also need to install AWS Copilot.) They demonstrate using Postman to test the deployed app. |
| [**Pilot your containers like a boss with AWS Copilot!**](https://blog.flolight.dev/pilot-your-containers-like-a-boss-with-aws-copilot) by <a href="https://twitter.com/FlolightC">@FlolightC</a> | Florian simplifies getting started with AWS Copilot by demoing deployment of a [sample app](https://github.com/aws-samples/amazon-ecs-cli-sample-app) from start to finish, including links to both required and optional resources. |
| [**Use AWS Copilot CLI to deploy containers on an existing infrastructure - Tutorial**](https://dannys.cloud/aws-copilot-cli-deploy-containers-existing-infrastructure-tutorial) by <a href="https://twitter.com/dannysteenman">@dannysteenman</a> | Danny explains how to use your existing VPC and subnets with AWS Copilot to quickly set up a working container environment. Follow along as he deploys a Django app with an RDS Postgres database and Elasticache Redis cluster. | 
| [**Automatically deploying your container application with AWS Copilot**](https://aws.amazon.com/blogs/containers/automatically-deploying-your-container-application-with-aws-copilot/) by <a href="https://twitter.com/nathankpeck">@nathankpeck</a> | Nathan shows how to set up a release pipeline with the CLI that builds, pushes, and deploys an application. Finally, he sets up integration tests for validation before releasing to production. |
| [**Deploying containers with the AWS Copilot CLI**](https://maartenbruntink.nl/blog/2020/08/16/deploying-containers-with-the-aws-copilot-cli-part-1/) by <a href="https://twitter.com/maartenbruntink">@maartenbruntink</a> | Maarten shows how to use the AWS Copilot CLI to deploy the [sample Docker voting app](https://github.com/dockersamples/example-voting-app), which showcases how to set up your own Redis and Postgres servers. In the [second part](https://maartenbruntink.nl/blog/2020/08/16/deploying-containers-with-the-aws-copilot-cli-part-2), he automates the release process. |
| [**AWS Copilot: an application-first CLI for containers on AWS**](https://aws.amazon.com/blogs/containers/aws-copilot-an-application-first-cli-for-containers-on-aws/) by <a href="https://twitter.com/efekarakus">@efekarakus</a> | Efe walks through the design tenets of the CLI: why they were chosen, how they map to Copilot features, and the vision for how the CLI will evolve in the future.  |
| [**Introducing AWS Copilot**](https://aws.amazon.com/blogs/containers/introducing-aws-copilot/) by <a href="https://twitter.com/nathankpeck">@nathankpeck</a> | Nathan explains how with the AWS Copilot CLI you can go from idea to implementation much faster, with the confidence that the infrastructure you have deployed has production-ready configuration. |



## Videos

| Title      | Description                          |
| ----------- | ------------------------------------ |
| [**Using Jenkins and AWS Copilot CLI to Deploy to AWS App Runner**](https://www.youtube.com/watch?v=ajgQ4WfgKA8) by <a href="https://twitter.com/DarinPope">@DarinPope</a> | Darin, a developer advocate for CloudBees, uses AWS Copilot and a Jenkinsfile to deploy to AWS AppRunner. | 
| [**Deploy a Web App with AWS CoPilot**](https://www.youtube.com/watch?v=OLiO5LLl6Ng&list=PLoxFga2t8Vw0tB6QRMZiADnAvmuTUZcc6) by <a href="https://twitter.com/edkruegerdata">@edkruegerdata</a> | This three-part series includes "Creating an Administrator User Group in AWS," "Create an IAM Account on AWS," and "Deploying the Web App." |
| [**Container Day: Amazon ECS Edition-- Demo: deploy a modern application on AWS Fargate with ECS Copilot**](https://www.youtube.com/watch?v=k01AdJC-dcA&t=14236s) by <a href="https://twitter.com/efekarakus">@efekarakus</a> and <a href="https://twitter.com/realadamjkeller">@realadamjkeller</a> | Efe goes beyond the basics, demoing how to grow [an application](https://github.com/efekarakus/day2-with-copilot); he highlights the `alias` field, secrets and environment variables, addons, and more. |
| [**Copilot– What AWS ECS and Fargate Container Management Should Have Been**](https://www.youtube.com/watch?v=YCCFK2RRm7U) by <a href="https://twitter.com/vfarcic">@vfarcic</a> | Viktor lauds Copilot for its simplicity and ease of use in this clear, step-by-step demo. |
| [**AWS Copilot CLI v1.8.0 Release Highlights**](https://www.youtube.com/watch?v=Oyr-n59mVjI) by <a href="https://twitter.com/realadamjkeller">@realadamjkeller</a> | Adam walks through the features that shipped with version 1.8.0 of the AWS Copilot CLI, including `alias`, the `svc status` update, and container dependency. |
| [**DevBeardOps with !Cobus & !Darko: Playing with Containers**](https://www.pscp.tv/w/1ypJdgQoLDqGW) by <a href="https://twitter.com/cobusbernard">@cobusbernard</a> and <a href="https://twitter.com/darkosubotica">@darkosubotica</a> | Learn alongside Cobus and Darko as they experiment with AWS Copilot, from installation to pipeline setup. |
| [**Containers from the Couch series**](https://www.youtube.com/c/ContainersfromtheCouch/search?query=copilot) by <a href="https://twitter.com/realadamjkeller">@realadamjkeller</a>, <a href="https://twitter.com/brentContained">@brentContained</a>, and guests | Join Adam and Brent to learn about many of the existing features of AWS Copilot with fun demos. Watch as they [set up](https://www.youtube.com/watch?v=Ay8iUFWzF4U) a three-tier application [with autoscaling](https://www.youtube.com/watch?v=TE-E_ZtMiv0); [create a continuous delivery pipeline with integration tests](https://www.youtube.com/watch?v=SpTI9be5whk); show how easy it is to ['exec' with Copilot](https://www.youtube.com/watch?v=NyiMoyx_xj4); and highlight [ephemeral storage](https://www.youtube.com/watch?v=lGmLhQjagVs) and [scheduled job](https://www.youtube.com/watch?v=veffvwZ6hG8) features. |
| [**AWS Copilot and another 6 ways to easily deploy apps to AWS**](https://www.youtube.com/watch?v=0lxcfJ20TwA) by <a href="https://twitter.com/Fodoj">Kirill Shirinkin</a> | Kirill Shirinkin explores ways to easily deploy a new product on AWS - including a new favorite one, AWS Copilot. |
| [**AWS re:Invent 2020: AWS Copilot: Simplifying container development**](https://youtu.be/EqW--TKQ_PQ) by <a href="https://twitter.com/efekarakus">@efekarakus</a> | Learn about the motivation behind AWS Copilot, get an overview of the existing commands and a demo of how to deploy a three-tier application. |
| [**How to Deploy a .NET Application to Amazon Elastic Container Service (ECS) with AWS Copilot**](https://youtu.be/nWaw8Rp8JgQ) by <a href="https://twitter.com/ignacioafuentes">@ignacioafuentes</a> | Get a demo on how to build and deploy a .NET application on Amazon ECS and AWS Fargate. |
| [**AWS What's Next**](https://www.youtube.com/watch?v=vmTJgVDERZU) by <a href="https://twitter.com/nathankpeck">@nathankpeck</a> and <a href="https://twitter.com/efekarakus">@efekarakus</a> | Nathan and Efe discuss what makes AWS Copilot unique compared to other infrastructure provisioning tools and then demo an overview of the existing commands. |



## Code samples

| Repository      | Description                          | Key features |
| ----------- | ------------------------------------ | ------------ |
[**github.com/efekarakus/day2-with-copilot**](https://github.com/efekarakus/day2-with-copilot) | A REST API coffeeshop application that goes beyond the basics, demoed in the ["Container Day" video](./guides.en.md#videos), above. | `alias`, secrets, DynamoDB, Redis |
[**github.com/bvtujo/copilot-wordpress**](https://github.com/bvtujo/copilot-wordpress) | A WordPress installation launched by AWS Copilot with step-by-step instructions and options for customization. | [EFS](../docs/developing/storage.en.md#managed-efs), MySQL RDS cluster, autoscaling |
[**#2378**](https://github.com/aws/copilot-cli/discussions/2378) | Show-and-tell with sample templates for launching isolated tasks in private subnets. | VPC Endpoints, [custom environments](../docs/developing/custom-environment-resources.en.md) |
[**github.com/copilot-example-voting-app**](https://github.com/copilot-example-voting-app), [**#1745**](https://github.com/aws/copilot-cli/discussions/1745) | A voting application distributed over three ECS services created with AWS Copilot. | Amazon Aurora PostgreSQL database, service discovery, autoscaling |
[**#1925**](https://github.com/aws/copilot-cli/discussions/1925) | Show-and-tell explaining how you can do continuous deployments from branches with AWS Copilot pipelines. | Branch-based deploys, AWS CodePipeline |


## Workshops
| Title      | Description                          |
| ----------- | ------------------------------------ |
[**ECS Workshop**](https://ecsworkshop.com/microservices/) | In this workshop, we deploy a three-tier microservices application using the AWS Copilot CLI. (Optional accompanying video [here](https://www.youtube.com/watch?v=o8o9Ea9o0aI).) |
