// Code generated by capnpc-go. DO NOT EDIT.

package tunnelrpc

import (
	context "golang.org/x/net/context"
	strconv "strconv"
	capnp "zombiezen.com/go/capnproto2"
	text "zombiezen.com/go/capnproto2/encoding/text"
	schemas "zombiezen.com/go/capnproto2/schemas"
	server "zombiezen.com/go/capnproto2/server"
)

type Authentication struct{ capnp.Struct }

// Authentication_TypeID is the unique identifier for the type Authentication.
const Authentication_TypeID = 0xc082ef6e0d42ed1d

func NewAuthentication(s *capnp.Segment) (Authentication, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 3})
	return Authentication{st}, err
}

func NewRootAuthentication(s *capnp.Segment) (Authentication, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 3})
	return Authentication{st}, err
}

func ReadRootAuthentication(msg *capnp.Message) (Authentication, error) {
	root, err := msg.RootPtr()
	return Authentication{root.Struct()}, err
}

func (s Authentication) String() string {
	str, _ := text.Marshal(0xc082ef6e0d42ed1d, s.Struct)
	return str
}

func (s Authentication) Key() (string, error) {
	p, err := s.Struct.Ptr(0)
	return p.Text(), err
}

func (s Authentication) HasKey() bool {
	p, err := s.Struct.Ptr(0)
	return p.IsValid() || err != nil
}

func (s Authentication) KeyBytes() ([]byte, error) {
	p, err := s.Struct.Ptr(0)
	return p.TextBytes(), err
}

func (s Authentication) SetKey(v string) error {
	return s.Struct.SetText(0, v)
}

func (s Authentication) Email() (string, error) {
	p, err := s.Struct.Ptr(1)
	return p.Text(), err
}

func (s Authentication) HasEmail() bool {
	p, err := s.Struct.Ptr(1)
	return p.IsValid() || err != nil
}

func (s Authentication) EmailBytes() ([]byte, error) {
	p, err := s.Struct.Ptr(1)
	return p.TextBytes(), err
}

func (s Authentication) SetEmail(v string) error {
	return s.Struct.SetText(1, v)
}

func (s Authentication) OriginCAKey() (string, error) {
	p, err := s.Struct.Ptr(2)
	return p.Text(), err
}

func (s Authentication) HasOriginCAKey() bool {
	p, err := s.Struct.Ptr(2)
	return p.IsValid() || err != nil
}

func (s Authentication) OriginCAKeyBytes() ([]byte, error) {
	p, err := s.Struct.Ptr(2)
	return p.TextBytes(), err
}

func (s Authentication) SetOriginCAKey(v string) error {
	return s.Struct.SetText(2, v)
}

// Authentication_List is a list of Authentication.
type Authentication_List struct{ capnp.List }

// NewAuthentication creates a new list of Authentication.
func NewAuthentication_List(s *capnp.Segment, sz int32) (Authentication_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 0, PointerCount: 3}, sz)
	return Authentication_List{l}, err
}

func (s Authentication_List) At(i int) Authentication { return Authentication{s.List.Struct(i)} }

func (s Authentication_List) Set(i int, v Authentication) error { return s.List.SetStruct(i, v.Struct) }

func (s Authentication_List) String() string {
	str, _ := text.MarshalList(0xc082ef6e0d42ed1d, s.List)
	return str
}

// Authentication_Promise is a wrapper for a Authentication promised by a client call.
type Authentication_Promise struct{ *capnp.Pipeline }

func (p Authentication_Promise) Struct() (Authentication, error) {
	s, err := p.Pipeline.Struct()
	return Authentication{s}, err
}

type TunnelRegistration struct{ capnp.Struct }

// TunnelRegistration_TypeID is the unique identifier for the type TunnelRegistration.
const TunnelRegistration_TypeID = 0xf41a0f001ad49e46

func NewTunnelRegistration(s *capnp.Segment) (TunnelRegistration, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 8, PointerCount: 6})
	return TunnelRegistration{st}, err
}

func NewRootTunnelRegistration(s *capnp.Segment) (TunnelRegistration, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 8, PointerCount: 6})
	return TunnelRegistration{st}, err
}

func ReadRootTunnelRegistration(msg *capnp.Message) (TunnelRegistration, error) {
	root, err := msg.RootPtr()
	return TunnelRegistration{root.Struct()}, err
}

func (s TunnelRegistration) String() string {
	str, _ := text.Marshal(0xf41a0f001ad49e46, s.Struct)
	return str
}

func (s TunnelRegistration) Err() (string, error) {
	p, err := s.Struct.Ptr(0)
	return p.Text(), err
}

func (s TunnelRegistration) HasErr() bool {
	p, err := s.Struct.Ptr(0)
	return p.IsValid() || err != nil
}

func (s TunnelRegistration) ErrBytes() ([]byte, error) {
	p, err := s.Struct.Ptr(0)
	return p.TextBytes(), err
}

func (s TunnelRegistration) SetErr(v string) error {
	return s.Struct.SetText(0, v)
}

func (s TunnelRegistration) Url() (string, error) {
	p, err := s.Struct.Ptr(1)
	return p.Text(), err
}

func (s TunnelRegistration) HasUrl() bool {
	p, err := s.Struct.Ptr(1)
	return p.IsValid() || err != nil
}

func (s TunnelRegistration) UrlBytes() ([]byte, error) {
	p, err := s.Struct.Ptr(1)
	return p.TextBytes(), err
}

func (s TunnelRegistration) SetUrl(v string) error {
	return s.Struct.SetText(1, v)
}

func (s TunnelRegistration) LogLines() (capnp.TextList, error) {
	p, err := s.Struct.Ptr(2)
	return capnp.TextList{List: p.List()}, err
}

func (s TunnelRegistration) HasLogLines() bool {
	p, err := s.Struct.Ptr(2)
	return p.IsValid() || err != nil
}

func (s TunnelRegistration) SetLogLines(v capnp.TextList) error {
	return s.Struct.SetPtr(2, v.List.ToPtr())
}

// NewLogLines sets the logLines field to a newly
// allocated capnp.TextList, preferring placement in s's segment.
func (s TunnelRegistration) NewLogLines(n int32) (capnp.TextList, error) {
	l, err := capnp.NewTextList(s.Struct.Segment(), n)
	if err != nil {
		return capnp.TextList{}, err
	}
	err = s.Struct.SetPtr(2, l.List.ToPtr())
	return l, err
}

func (s TunnelRegistration) PermanentFailure() bool {
	return s.Struct.Bit(0)
}

func (s TunnelRegistration) SetPermanentFailure(v bool) {
	s.Struct.SetBit(0, v)
}

func (s TunnelRegistration) TunnelID() (string, error) {
	p, err := s.Struct.Ptr(3)
	return p.Text(), err
}

func (s TunnelRegistration) HasTunnelID() bool {
	p, err := s.Struct.Ptr(3)
	return p.IsValid() || err != nil
}

func (s TunnelRegistration) TunnelIDBytes() ([]byte, error) {
	p, err := s.Struct.Ptr(3)
	return p.TextBytes(), err
}

func (s TunnelRegistration) SetTunnelID(v string) error {
	return s.Struct.SetText(3, v)
}

func (s TunnelRegistration) RetryAfterSeconds() uint16 {
	return s.Struct.Uint16(2)
}

func (s TunnelRegistration) SetRetryAfterSeconds(v uint16) {
	s.Struct.SetUint16(2, v)
}

func (s TunnelRegistration) EventDigest() ([]byte, error) {
	p, err := s.Struct.Ptr(4)
	return []byte(p.Data()), err
}

func (s TunnelRegistration) HasEventDigest() bool {
	p, err := s.Struct.Ptr(4)
	return p.IsValid() || err != nil
}

func (s TunnelRegistration) SetEventDigest(v []byte) error {
	return s.Struct.SetData(4, v)
}

func (s TunnelRegistration) ConnDigest() ([]byte, error) {
	p, err := s.Struct.Ptr(5)
	return []byte(p.Data()), err
}

func (s TunnelRegistration) HasConnDigest() bool {
	p, err := s.Struct.Ptr(5)
	return p.IsValid() || err != nil
}

func (s TunnelRegistration) SetConnDigest(v []byte) error {
	return s.Struct.SetData(5, v)
}

// TunnelRegistration_List is a list of TunnelRegistration.
type TunnelRegistration_List struct{ capnp.List }

// NewTunnelRegistration creates a new list of TunnelRegistration.
func NewTunnelRegistration_List(s *capnp.Segment, sz int32) (TunnelRegistration_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 8, PointerCount: 6}, sz)
	return TunnelRegistration_List{l}, err
}

func (s TunnelRegistration_List) At(i int) TunnelRegistration {
	return TunnelRegistration{s.List.Struct(i)}
}

func (s TunnelRegistration_List) Set(i int, v TunnelRegistration) error {
	return s.List.SetStruct(i, v.Struct)
}

func (s TunnelRegistration_List) String() string {
	str, _ := text.MarshalList(0xf41a0f001ad49e46, s.List)
	return str
}

// TunnelRegistration_Promise is a wrapper for a TunnelRegistration promised by a client call.
type TunnelRegistration_Promise struct{ *capnp.Pipeline }

func (p TunnelRegistration_Promise) Struct() (TunnelRegistration, error) {
	s, err := p.Pipeline.Struct()
	return TunnelRegistration{s}, err
}

type RegistrationOptions struct{ capnp.Struct }

// RegistrationOptions_TypeID is the unique identifier for the type RegistrationOptions.
const RegistrationOptions_TypeID = 0xc793e50592935b4a

func NewRegistrationOptions(s *capnp.Segment) (RegistrationOptions, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 16, PointerCount: 8})
	return RegistrationOptions{st}, err
}

func NewRootRegistrationOptions(s *capnp.Segment) (RegistrationOptions, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 16, PointerCount: 8})
	return RegistrationOptions{st}, err
}

func ReadRootRegistrationOptions(msg *capnp.Message) (RegistrationOptions, error) {
	root, err := msg.RootPtr()
	return RegistrationOptions{root.Struct()}, err
}

func (s RegistrationOptions) String() string {
	str, _ := text.Marshal(0xc793e50592935b4a, s.Struct)
	return str
}

func (s RegistrationOptions) ClientId() (string, error) {
	p, err := s.Struct.Ptr(0)
	return p.Text(), err
}

func (s RegistrationOptions) HasClientId() bool {
	p, err := s.Struct.Ptr(0)
	return p.IsValid() || err != nil
}

func (s RegistrationOptions) ClientIdBytes() ([]byte, error) {
	p, err := s.Struct.Ptr(0)
	return p.TextBytes(), err
}

func (s RegistrationOptions) SetClientId(v string) error {
	return s.Struct.SetText(0, v)
}

func (s RegistrationOptions) Version() (string, error) {
	p, err := s.Struct.Ptr(1)
	return p.Text(), err
}

func (s RegistrationOptions) HasVersion() bool {
	p, err := s.Struct.Ptr(1)
	return p.IsValid() || err != nil
}

func (s RegistrationOptions) VersionBytes() ([]byte, error) {
	p, err := s.Struct.Ptr(1)
	return p.TextBytes(), err
}

func (s RegistrationOptions) SetVersion(v string) error {
	return s.Struct.SetText(1, v)
}

func (s RegistrationOptions) Os() (string, error) {
	p, err := s.Struct.Ptr(2)
	return p.Text(), err
}

func (s RegistrationOptions) HasOs() bool {
	p, err := s.Struct.Ptr(2)
	return p.IsValid() || err != nil
}

func (s RegistrationOptions) OsBytes() ([]byte, error) {
	p, err := s.Struct.Ptr(2)
	return p.TextBytes(), err
}

func (s RegistrationOptions) SetOs(v string) error {
	return s.Struct.SetText(2, v)
}

func (s RegistrationOptions) ExistingTunnelPolicy() ExistingTunnelPolicy {
	return ExistingTunnelPolicy(s.Struct.Uint16(0))
}

func (s RegistrationOptions) SetExistingTunnelPolicy(v ExistingTunnelPolicy) {
	s.Struct.SetUint16(0, uint16(v))
}

func (s RegistrationOptions) PoolName() (string, error) {
	p, err := s.Struct.Ptr(3)
	return p.Text(), err
}

func (s RegistrationOptions) HasPoolName() bool {
	p, err := s.Struct.Ptr(3)
	return p.IsValid() || err != nil
}

func (s RegistrationOptions) PoolNameBytes() ([]byte, error) {
	p, err := s.Struct.Ptr(3)
	return p.TextBytes(), err
}

func (s RegistrationOptions) SetPoolName(v string) error {
	return s.Struct.SetText(3, v)
}

func (s RegistrationOptions) Tags() (Tag_List, error) {
	p, err := s.Struct.Ptr(4)
	return Tag_List{List: p.List()}, err
}

func (s RegistrationOptions) HasTags() bool {
	p, err := s.Struct.Ptr(4)
	return p.IsValid() || err != nil
}

func (s RegistrationOptions) SetTags(v Tag_List) error {
	return s.Struct.SetPtr(4, v.List.ToPtr())
}

// NewTags sets the tags field to a newly
// allocated Tag_List, preferring placement in s's segment.
func (s RegistrationOptions) NewTags(n int32) (Tag_List, error) {
	l, err := NewTag_List(s.Struct.Segment(), n)
	if err != nil {
		return Tag_List{}, err
	}
	err = s.Struct.SetPtr(4, l.List.ToPtr())
	return l, err
}

func (s RegistrationOptions) ConnectionId() uint8 {
	return s.Struct.Uint8(2)
}

func (s RegistrationOptions) SetConnectionId(v uint8) {
	s.Struct.SetUint8(2, v)
}

func (s RegistrationOptions) OriginLocalIp() (string, error) {
	p, err := s.Struct.Ptr(5)
	return p.Text(), err
}

func (s RegistrationOptions) HasOriginLocalIp() bool {
	p, err := s.Struct.Ptr(5)
	return p.IsValid() || err != nil
}

func (s RegistrationOptions) OriginLocalIpBytes() ([]byte, error) {
	p, err := s.Struct.Ptr(5)
	return p.TextBytes(), err
}

func (s RegistrationOptions) SetOriginLocalIp(v string) error {
	return s.Struct.SetText(5, v)
}

func (s RegistrationOptions) IsAutoupdated() bool {
	return s.Struct.Bit(24)
}

func (s RegistrationOptions) SetIsAutoupdated(v bool) {
	s.Struct.SetBit(24, v)
}

func (s RegistrationOptions) RunFromTerminal() bool {
	return s.Struct.Bit(25)
}

func (s RegistrationOptions) SetRunFromTerminal(v bool) {
	s.Struct.SetBit(25, v)
}

func (s RegistrationOptions) CompressionQuality() uint64 {
	return s.Struct.Uint64(8)
}

func (s RegistrationOptions) SetCompressionQuality(v uint64) {
	s.Struct.SetUint64(8, v)
}

func (s RegistrationOptions) Uuid() (string, error) {
	p, err := s.Struct.Ptr(6)
	return p.Text(), err
}

func (s RegistrationOptions) HasUuid() bool {
	p, err := s.Struct.Ptr(6)
	return p.IsValid() || err != nil
}

func (s RegistrationOptions) UuidBytes() ([]byte, error) {
	p, err := s.Struct.Ptr(6)
	return p.TextBytes(), err
}

func (s RegistrationOptions) SetUuid(v string) error {
	return s.Struct.SetText(6, v)
}

func (s RegistrationOptions) NumPreviousAttempts() uint8 {
	return s.Struct.Uint8(4)
}

func (s RegistrationOptions) SetNumPreviousAttempts(v uint8) {
	s.Struct.SetUint8(4, v)
}

func (s RegistrationOptions) Features() (capnp.TextList, error) {
	p, err := s.Struct.Ptr(7)
	return capnp.TextList{List: p.List()}, err
}

func (s RegistrationOptions) HasFeatures() bool {
	p, err := s.Struct.Ptr(7)
	return p.IsValid() || err != nil
}

func (s RegistrationOptions) SetFeatures(v capnp.TextList) error {
	return s.Struct.SetPtr(7, v.List.ToPtr())
}

// NewFeatures sets the features field to a newly
// allocated capnp.TextList, preferring placement in s's segment.
func (s RegistrationOptions) NewFeatures(n int32) (capnp.TextList, error) {
	l, err := capnp.NewTextList(s.Struct.Segment(), n)
	if err != nil {
		return capnp.TextList{}, err
	}
	err = s.Struct.SetPtr(7, l.List.ToPtr())
	return l, err
}

// RegistrationOptions_List is a list of RegistrationOptions.
type RegistrationOptions_List struct{ capnp.List }

// NewRegistrationOptions creates a new list of RegistrationOptions.
func NewRegistrationOptions_List(s *capnp.Segment, sz int32) (RegistrationOptions_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 16, PointerCount: 8}, sz)
	return RegistrationOptions_List{l}, err
}

func (s RegistrationOptions_List) At(i int) RegistrationOptions {
	return RegistrationOptions{s.List.Struct(i)}
}

func (s RegistrationOptions_List) Set(i int, v RegistrationOptions) error {
	return s.List.SetStruct(i, v.Struct)
}

func (s RegistrationOptions_List) String() string {
	str, _ := text.MarshalList(0xc793e50592935b4a, s.List)
	return str
}

// RegistrationOptions_Promise is a wrapper for a RegistrationOptions promised by a client call.
type RegistrationOptions_Promise struct{ *capnp.Pipeline }

func (p RegistrationOptions_Promise) Struct() (RegistrationOptions, error) {
	s, err := p.Pipeline.Struct()
	return RegistrationOptions{s}, err
}

type Tag struct{ capnp.Struct }

// Tag_TypeID is the unique identifier for the type Tag.
const Tag_TypeID = 0xcbd96442ae3bb01a

func NewTag(s *capnp.Segment) (Tag, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 2})
	return Tag{st}, err
}

func NewRootTag(s *capnp.Segment) (Tag, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 2})
	return Tag{st}, err
}

func ReadRootTag(msg *capnp.Message) (Tag, error) {
	root, err := msg.RootPtr()
	return Tag{root.Struct()}, err
}

func (s Tag) String() string {
	str, _ := text.Marshal(0xcbd96442ae3bb01a, s.Struct)
	return str
}

func (s Tag) Name() (string, error) {
	p, err := s.Struct.Ptr(0)
	return p.Text(), err
}

func (s Tag) HasName() bool {
	p, err := s.Struct.Ptr(0)
	return p.IsValid() || err != nil
}

func (s Tag) NameBytes() ([]byte, error) {
	p, err := s.Struct.Ptr(0)
	return p.TextBytes(), err
}

func (s Tag) SetName(v string) error {
	return s.Struct.SetText(0, v)
}

func (s Tag) Value() (string, error) {
	p, err := s.Struct.Ptr(1)
	return p.Text(), err
}

func (s Tag) HasValue() bool {
	p, err := s.Struct.Ptr(1)
	return p.IsValid() || err != nil
}

func (s Tag) ValueBytes() ([]byte, error) {
	p, err := s.Struct.Ptr(1)
	return p.TextBytes(), err
}

func (s Tag) SetValue(v string) error {
	return s.Struct.SetText(1, v)
}

// Tag_List is a list of Tag.
type Tag_List struct{ capnp.List }

// NewTag creates a new list of Tag.
func NewTag_List(s *capnp.Segment, sz int32) (Tag_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 0, PointerCount: 2}, sz)
	return Tag_List{l}, err
}

func (s Tag_List) At(i int) Tag { return Tag{s.List.Struct(i)} }

func (s Tag_List) Set(i int, v Tag) error { return s.List.SetStruct(i, v.Struct) }

func (s Tag_List) String() string {
	str, _ := text.MarshalList(0xcbd96442ae3bb01a, s.List)
	return str
}

// Tag_Promise is a wrapper for a Tag promised by a client call.
type Tag_Promise struct{ *capnp.Pipeline }

func (p Tag_Promise) Struct() (Tag, error) {
	s, err := p.Pipeline.Struct()
	return Tag{s}, err
}

type ExistingTunnelPolicy uint16

// ExistingTunnelPolicy_TypeID is the unique identifier for the type ExistingTunnelPolicy.
const ExistingTunnelPolicy_TypeID = 0x84cb9536a2cf6d3c

// Values of ExistingTunnelPolicy.
const (
	ExistingTunnelPolicy_ignore     ExistingTunnelPolicy = 0
	ExistingTunnelPolicy_disconnect ExistingTunnelPolicy = 1
	ExistingTunnelPolicy_balance    ExistingTunnelPolicy = 2
)

// String returns the enum's constant name.
func (c ExistingTunnelPolicy) String() string {
	switch c {
	case ExistingTunnelPolicy_ignore:
		return "ignore"
	case ExistingTunnelPolicy_disconnect:
		return "disconnect"
	case ExistingTunnelPolicy_balance:
		return "balance"

	default:
		return ""
	}
}

// ExistingTunnelPolicyFromString returns the enum value with a name,
// or the zero value if there's no such value.
func ExistingTunnelPolicyFromString(c string) ExistingTunnelPolicy {
	switch c {
	case "ignore":
		return ExistingTunnelPolicy_ignore
	case "disconnect":
		return ExistingTunnelPolicy_disconnect
	case "balance":
		return ExistingTunnelPolicy_balance

	default:
		return 0
	}
}

type ExistingTunnelPolicy_List struct{ capnp.List }

func NewExistingTunnelPolicy_List(s *capnp.Segment, sz int32) (ExistingTunnelPolicy_List, error) {
	l, err := capnp.NewUInt16List(s, sz)
	return ExistingTunnelPolicy_List{l.List}, err
}

func (l ExistingTunnelPolicy_List) At(i int) ExistingTunnelPolicy {
	ul := capnp.UInt16List{List: l.List}
	return ExistingTunnelPolicy(ul.At(i))
}

func (l ExistingTunnelPolicy_List) Set(i int, v ExistingTunnelPolicy) {
	ul := capnp.UInt16List{List: l.List}
	ul.Set(i, uint16(v))
}

type ServerInfo struct{ capnp.Struct }

// ServerInfo_TypeID is the unique identifier for the type ServerInfo.
const ServerInfo_TypeID = 0xf2c68e2547ec3866

func NewServerInfo(s *capnp.Segment) (ServerInfo, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 1})
	return ServerInfo{st}, err
}

func NewRootServerInfo(s *capnp.Segment) (ServerInfo, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 1})
	return ServerInfo{st}, err
}

func ReadRootServerInfo(msg *capnp.Message) (ServerInfo, error) {
	root, err := msg.RootPtr()
	return ServerInfo{root.Struct()}, err
}

func (s ServerInfo) String() string {
	str, _ := text.Marshal(0xf2c68e2547ec3866, s.Struct)
	return str
}

func (s ServerInfo) LocationName() (string, error) {
	p, err := s.Struct.Ptr(0)
	return p.Text(), err
}

func (s ServerInfo) HasLocationName() bool {
	p, err := s.Struct.Ptr(0)
	return p.IsValid() || err != nil
}

func (s ServerInfo) LocationNameBytes() ([]byte, error) {
	p, err := s.Struct.Ptr(0)
	return p.TextBytes(), err
}

func (s ServerInfo) SetLocationName(v string) error {
	return s.Struct.SetText(0, v)
}

// ServerInfo_List is a list of ServerInfo.
type ServerInfo_List struct{ capnp.List }

// NewServerInfo creates a new list of ServerInfo.
func NewServerInfo_List(s *capnp.Segment, sz int32) (ServerInfo_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 0, PointerCount: 1}, sz)
	return ServerInfo_List{l}, err
}

func (s ServerInfo_List) At(i int) ServerInfo { return ServerInfo{s.List.Struct(i)} }

func (s ServerInfo_List) Set(i int, v ServerInfo) error { return s.List.SetStruct(i, v.Struct) }

func (s ServerInfo_List) String() string {
	str, _ := text.MarshalList(0xf2c68e2547ec3866, s.List)
	return str
}

// ServerInfo_Promise is a wrapper for a ServerInfo promised by a client call.
type ServerInfo_Promise struct{ *capnp.Pipeline }

func (p ServerInfo_Promise) Struct() (ServerInfo, error) {
	s, err := p.Pipeline.Struct()
	return ServerInfo{s}, err
}

type AuthenticateResponse struct{ capnp.Struct }

// AuthenticateResponse_TypeID is the unique identifier for the type AuthenticateResponse.
const AuthenticateResponse_TypeID = 0x82c325a07ad22a65

func NewAuthenticateResponse(s *capnp.Segment) (AuthenticateResponse, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 8, PointerCount: 3})
	return AuthenticateResponse{st}, err
}

func NewRootAuthenticateResponse(s *capnp.Segment) (AuthenticateResponse, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 8, PointerCount: 3})
	return AuthenticateResponse{st}, err
}

func ReadRootAuthenticateResponse(msg *capnp.Message) (AuthenticateResponse, error) {
	root, err := msg.RootPtr()
	return AuthenticateResponse{root.Struct()}, err
}

func (s AuthenticateResponse) String() string {
	str, _ := text.Marshal(0x82c325a07ad22a65, s.Struct)
	return str
}

func (s AuthenticateResponse) PermanentErr() (string, error) {
	p, err := s.Struct.Ptr(0)
	return p.Text(), err
}

func (s AuthenticateResponse) HasPermanentErr() bool {
	p, err := s.Struct.Ptr(0)
	return p.IsValid() || err != nil
}

func (s AuthenticateResponse) PermanentErrBytes() ([]byte, error) {
	p, err := s.Struct.Ptr(0)
	return p.TextBytes(), err
}

func (s AuthenticateResponse) SetPermanentErr(v string) error {
	return s.Struct.SetText(0, v)
}

func (s AuthenticateResponse) RetryableErr() (string, error) {
	p, err := s.Struct.Ptr(1)
	return p.Text(), err
}

func (s AuthenticateResponse) HasRetryableErr() bool {
	p, err := s.Struct.Ptr(1)
	return p.IsValid() || err != nil
}

func (s AuthenticateResponse) RetryableErrBytes() ([]byte, error) {
	p, err := s.Struct.Ptr(1)
	return p.TextBytes(), err
}

func (s AuthenticateResponse) SetRetryableErr(v string) error {
	return s.Struct.SetText(1, v)
}

func (s AuthenticateResponse) Jwt() ([]byte, error) {
	p, err := s.Struct.Ptr(2)
	return []byte(p.Data()), err
}

func (s AuthenticateResponse) HasJwt() bool {
	p, err := s.Struct.Ptr(2)
	return p.IsValid() || err != nil
}

func (s AuthenticateResponse) SetJwt(v []byte) error {
	return s.Struct.SetData(2, v)
}

func (s AuthenticateResponse) HoursUntilRefresh() uint8 {
	return s.Struct.Uint8(0)
}

func (s AuthenticateResponse) SetHoursUntilRefresh(v uint8) {
	s.Struct.SetUint8(0, v)
}

// AuthenticateResponse_List is a list of AuthenticateResponse.
type AuthenticateResponse_List struct{ capnp.List }

// NewAuthenticateResponse creates a new list of AuthenticateResponse.
func NewAuthenticateResponse_List(s *capnp.Segment, sz int32) (AuthenticateResponse_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 8, PointerCount: 3}, sz)
	return AuthenticateResponse_List{l}, err
}

func (s AuthenticateResponse_List) At(i int) AuthenticateResponse {
	return AuthenticateResponse{s.List.Struct(i)}
}

func (s AuthenticateResponse_List) Set(i int, v AuthenticateResponse) error {
	return s.List.SetStruct(i, v.Struct)
}

func (s AuthenticateResponse_List) String() string {
	str, _ := text.MarshalList(0x82c325a07ad22a65, s.List)
	return str
}

// AuthenticateResponse_Promise is a wrapper for a AuthenticateResponse promised by a client call.
type AuthenticateResponse_Promise struct{ *capnp.Pipeline }

func (p AuthenticateResponse_Promise) Struct() (AuthenticateResponse, error) {
	s, err := p.Pipeline.Struct()
	return AuthenticateResponse{s}, err
}

type ClientInfo struct{ capnp.Struct }

// ClientInfo_TypeID is the unique identifier for the type ClientInfo.
const ClientInfo_TypeID = 0x83ced0145b2f114b

func NewClientInfo(s *capnp.Segment) (ClientInfo, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 4})
	return ClientInfo{st}, err
}

func NewRootClientInfo(s *capnp.Segment) (ClientInfo, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 4})
	return ClientInfo{st}, err
}

func ReadRootClientInfo(msg *capnp.Message) (ClientInfo, error) {
	root, err := msg.RootPtr()
	return ClientInfo{root.Struct()}, err
}

func (s ClientInfo) String() string {
	str, _ := text.Marshal(0x83ced0145b2f114b, s.Struct)
	return str
}

func (s ClientInfo) ClientId() ([]byte, error) {
	p, err := s.Struct.Ptr(0)
	return []byte(p.Data()), err
}

func (s ClientInfo) HasClientId() bool {
	p, err := s.Struct.Ptr(0)
	return p.IsValid() || err != nil
}

func (s ClientInfo) SetClientId(v []byte) error {
	return s.Struct.SetData(0, v)
}

func (s ClientInfo) Features() (capnp.TextList, error) {
	p, err := s.Struct.Ptr(1)
	return capnp.TextList{List: p.List()}, err
}

func (s ClientInfo) HasFeatures() bool {
	p, err := s.Struct.Ptr(1)
	return p.IsValid() || err != nil
}

func (s ClientInfo) SetFeatures(v capnp.TextList) error {
	return s.Struct.SetPtr(1, v.List.ToPtr())
}

// NewFeatures sets the features field to a newly
// allocated capnp.TextList, preferring placement in s's segment.
func (s ClientInfo) NewFeatures(n int32) (capnp.TextList, error) {
	l, err := capnp.NewTextList(s.Struct.Segment(), n)
	if err != nil {
		return capnp.TextList{}, err
	}
	err = s.Struct.SetPtr(1, l.List.ToPtr())
	return l, err
}

func (s ClientInfo) Version() (string, error) {
	p, err := s.Struct.Ptr(2)
	return p.Text(), err
}

func (s ClientInfo) HasVersion() bool {
	p, err := s.Struct.Ptr(2)
	return p.IsValid() || err != nil
}

func (s ClientInfo) VersionBytes() ([]byte, error) {
	p, err := s.Struct.Ptr(2)
	return p.TextBytes(), err
}

func (s ClientInfo) SetVersion(v string) error {
	return s.Struct.SetText(2, v)
}

func (s ClientInfo) Arch() (string, error) {
	p, err := s.Struct.Ptr(3)
	return p.Text(), err
}

func (s ClientInfo) HasArch() bool {
	p, err := s.Struct.Ptr(3)
	return p.IsValid() || err != nil
}

func (s ClientInfo) ArchBytes() ([]byte, error) {
	p, err := s.Struct.Ptr(3)
	return p.TextBytes(), err
}

func (s ClientInfo) SetArch(v string) error {
	return s.Struct.SetText(3, v)
}

// ClientInfo_List is a list of ClientInfo.
type ClientInfo_List struct{ capnp.List }

// NewClientInfo creates a new list of ClientInfo.
func NewClientInfo_List(s *capnp.Segment, sz int32) (ClientInfo_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 0, PointerCount: 4}, sz)
	return ClientInfo_List{l}, err
}

func (s ClientInfo_List) At(i int) ClientInfo { return ClientInfo{s.List.Struct(i)} }

func (s ClientInfo_List) Set(i int, v ClientInfo) error { return s.List.SetStruct(i, v.Struct) }

func (s ClientInfo_List) String() string {
	str, _ := text.MarshalList(0x83ced0145b2f114b, s.List)
	return str
}

// ClientInfo_Promise is a wrapper for a ClientInfo promised by a client call.
type ClientInfo_Promise struct{ *capnp.Pipeline }

func (p ClientInfo_Promise) Struct() (ClientInfo, error) {
	s, err := p.Pipeline.Struct()
	return ClientInfo{s}, err
}

type ConnectionOptions struct{ capnp.Struct }

// ConnectionOptions_TypeID is the unique identifier for the type ConnectionOptions.
const ConnectionOptions_TypeID = 0xb4bf9861fe035d04

func NewConnectionOptions(s *capnp.Segment) (ConnectionOptions, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 8, PointerCount: 2})
	return ConnectionOptions{st}, err
}

func NewRootConnectionOptions(s *capnp.Segment) (ConnectionOptions, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 8, PointerCount: 2})
	return ConnectionOptions{st}, err
}

func ReadRootConnectionOptions(msg *capnp.Message) (ConnectionOptions, error) {
	root, err := msg.RootPtr()
	return ConnectionOptions{root.Struct()}, err
}

func (s ConnectionOptions) String() string {
	str, _ := text.Marshal(0xb4bf9861fe035d04, s.Struct)
	return str
}

func (s ConnectionOptions) Client() (ClientInfo, error) {
	p, err := s.Struct.Ptr(0)
	return ClientInfo{Struct: p.Struct()}, err
}

func (s ConnectionOptions) HasClient() bool {
	p, err := s.Struct.Ptr(0)
	return p.IsValid() || err != nil
}

func (s ConnectionOptions) SetClient(v ClientInfo) error {
	return s.Struct.SetPtr(0, v.Struct.ToPtr())
}

// NewClient sets the client field to a newly
// allocated ClientInfo struct, preferring placement in s's segment.
func (s ConnectionOptions) NewClient() (ClientInfo, error) {
	ss, err := NewClientInfo(s.Struct.Segment())
	if err != nil {
		return ClientInfo{}, err
	}
	err = s.Struct.SetPtr(0, ss.Struct.ToPtr())
	return ss, err
}

func (s ConnectionOptions) OriginLocalIp() ([]byte, error) {
	p, err := s.Struct.Ptr(1)
	return []byte(p.Data()), err
}

func (s ConnectionOptions) HasOriginLocalIp() bool {
	p, err := s.Struct.Ptr(1)
	return p.IsValid() || err != nil
}

func (s ConnectionOptions) SetOriginLocalIp(v []byte) error {
	return s.Struct.SetData(1, v)
}

func (s ConnectionOptions) ReplaceExisting() bool {
	return s.Struct.Bit(0)
}

func (s ConnectionOptions) SetReplaceExisting(v bool) {
	s.Struct.SetBit(0, v)
}

func (s ConnectionOptions) CompressionQuality() uint8 {
	return s.Struct.Uint8(1)
}

func (s ConnectionOptions) SetCompressionQuality(v uint8) {
	s.Struct.SetUint8(1, v)
}

func (s ConnectionOptions) NumPreviousAttempts() uint8 {
	return s.Struct.Uint8(2)
}

func (s ConnectionOptions) SetNumPreviousAttempts(v uint8) {
	s.Struct.SetUint8(2, v)
}

// ConnectionOptions_List is a list of ConnectionOptions.
type ConnectionOptions_List struct{ capnp.List }

// NewConnectionOptions creates a new list of ConnectionOptions.
func NewConnectionOptions_List(s *capnp.Segment, sz int32) (ConnectionOptions_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 8, PointerCount: 2}, sz)
	return ConnectionOptions_List{l}, err
}

func (s ConnectionOptions_List) At(i int) ConnectionOptions {
	return ConnectionOptions{s.List.Struct(i)}
}

func (s ConnectionOptions_List) Set(i int, v ConnectionOptions) error {
	return s.List.SetStruct(i, v.Struct)
}

func (s ConnectionOptions_List) String() string {
	str, _ := text.MarshalList(0xb4bf9861fe035d04, s.List)
	return str
}

// ConnectionOptions_Promise is a wrapper for a ConnectionOptions promised by a client call.
type ConnectionOptions_Promise struct{ *capnp.Pipeline }

func (p ConnectionOptions_Promise) Struct() (ConnectionOptions, error) {
	s, err := p.Pipeline.Struct()
	return ConnectionOptions{s}, err
}

func (p ConnectionOptions_Promise) Client() ClientInfo_Promise {
	return ClientInfo_Promise{Pipeline: p.Pipeline.GetPipeline(0)}
}

type ConnectionResponse struct{ capnp.Struct }
type ConnectionResponse_result ConnectionResponse
type ConnectionResponse_result_Which uint16

const (
	ConnectionResponse_result_Which_error             ConnectionResponse_result_Which = 0
	ConnectionResponse_result_Which_connectionDetails ConnectionResponse_result_Which = 1
)

func (w ConnectionResponse_result_Which) String() string {
	const s = "errorconnectionDetails"
	switch w {
	case ConnectionResponse_result_Which_error:
		return s[0:5]
	case ConnectionResponse_result_Which_connectionDetails:
		return s[5:22]

	}
	return "ConnectionResponse_result_Which(" + strconv.FormatUint(uint64(w), 10) + ")"
}

// ConnectionResponse_TypeID is the unique identifier for the type ConnectionResponse.
const ConnectionResponse_TypeID = 0xdbaa9d03d52b62dc

func NewConnectionResponse(s *capnp.Segment) (ConnectionResponse, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 8, PointerCount: 1})
	return ConnectionResponse{st}, err
}

func NewRootConnectionResponse(s *capnp.Segment) (ConnectionResponse, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 8, PointerCount: 1})
	return ConnectionResponse{st}, err
}

func ReadRootConnectionResponse(msg *capnp.Message) (ConnectionResponse, error) {
	root, err := msg.RootPtr()
	return ConnectionResponse{root.Struct()}, err
}

func (s ConnectionResponse) String() string {
	str, _ := text.Marshal(0xdbaa9d03d52b62dc, s.Struct)
	return str
}

func (s ConnectionResponse) Result() ConnectionResponse_result { return ConnectionResponse_result(s) }

func (s ConnectionResponse_result) Which() ConnectionResponse_result_Which {
	return ConnectionResponse_result_Which(s.Struct.Uint16(0))
}
func (s ConnectionResponse_result) Error() (ConnectionError, error) {
	if s.Struct.Uint16(0) != 0 {
		panic("Which() != error")
	}
	p, err := s.Struct.Ptr(0)
	return ConnectionError{Struct: p.Struct()}, err
}

func (s ConnectionResponse_result) HasError() bool {
	if s.Struct.Uint16(0) != 0 {
		return false
	}
	p, err := s.Struct.Ptr(0)
	return p.IsValid() || err != nil
}

func (s ConnectionResponse_result) SetError(v ConnectionError) error {
	s.Struct.SetUint16(0, 0)
	return s.Struct.SetPtr(0, v.Struct.ToPtr())
}

// NewError sets the error field to a newly
// allocated ConnectionError struct, preferring placement in s's segment.
func (s ConnectionResponse_result) NewError() (ConnectionError, error) {
	s.Struct.SetUint16(0, 0)
	ss, err := NewConnectionError(s.Struct.Segment())
	if err != nil {
		return ConnectionError{}, err
	}
	err = s.Struct.SetPtr(0, ss.Struct.ToPtr())
	return ss, err
}

func (s ConnectionResponse_result) ConnectionDetails() (ConnectionDetails, error) {
	if s.Struct.Uint16(0) != 1 {
		panic("Which() != connectionDetails")
	}
	p, err := s.Struct.Ptr(0)
	return ConnectionDetails{Struct: p.Struct()}, err
}

func (s ConnectionResponse_result) HasConnectionDetails() bool {
	if s.Struct.Uint16(0) != 1 {
		return false
	}
	p, err := s.Struct.Ptr(0)
	return p.IsValid() || err != nil
}

func (s ConnectionResponse_result) SetConnectionDetails(v ConnectionDetails) error {
	s.Struct.SetUint16(0, 1)
	return s.Struct.SetPtr(0, v.Struct.ToPtr())
}

// NewConnectionDetails sets the connectionDetails field to a newly
// allocated ConnectionDetails struct, preferring placement in s's segment.
func (s ConnectionResponse_result) NewConnectionDetails() (ConnectionDetails, error) {
	s.Struct.SetUint16(0, 1)
	ss, err := NewConnectionDetails(s.Struct.Segment())
	if err != nil {
		return ConnectionDetails{}, err
	}
	err = s.Struct.SetPtr(0, ss.Struct.ToPtr())
	return ss, err
}

// ConnectionResponse_List is a list of ConnectionResponse.
type ConnectionResponse_List struct{ capnp.List }

// NewConnectionResponse creates a new list of ConnectionResponse.
func NewConnectionResponse_List(s *capnp.Segment, sz int32) (ConnectionResponse_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 8, PointerCount: 1}, sz)
	return ConnectionResponse_List{l}, err
}

func (s ConnectionResponse_List) At(i int) ConnectionResponse {
	return ConnectionResponse{s.List.Struct(i)}
}

func (s ConnectionResponse_List) Set(i int, v ConnectionResponse) error {
	return s.List.SetStruct(i, v.Struct)
}

func (s ConnectionResponse_List) String() string {
	str, _ := text.MarshalList(0xdbaa9d03d52b62dc, s.List)
	return str
}

// ConnectionResponse_Promise is a wrapper for a ConnectionResponse promised by a client call.
type ConnectionResponse_Promise struct{ *capnp.Pipeline }

func (p ConnectionResponse_Promise) Struct() (ConnectionResponse, error) {
	s, err := p.Pipeline.Struct()
	return ConnectionResponse{s}, err
}

func (p ConnectionResponse_Promise) Result() ConnectionResponse_result_Promise {
	return ConnectionResponse_result_Promise{p.Pipeline}
}

// ConnectionResponse_result_Promise is a wrapper for a ConnectionResponse_result promised by a client call.
type ConnectionResponse_result_Promise struct{ *capnp.Pipeline }

func (p ConnectionResponse_result_Promise) Struct() (ConnectionResponse_result, error) {
	s, err := p.Pipeline.Struct()
	return ConnectionResponse_result{s}, err
}

func (p ConnectionResponse_result_Promise) Error() ConnectionError_Promise {
	return ConnectionError_Promise{Pipeline: p.Pipeline.GetPipeline(0)}
}

func (p ConnectionResponse_result_Promise) ConnectionDetails() ConnectionDetails_Promise {
	return ConnectionDetails_Promise{Pipeline: p.Pipeline.GetPipeline(0)}
}

type ConnectionError struct{ capnp.Struct }

// ConnectionError_TypeID is the unique identifier for the type ConnectionError.
const ConnectionError_TypeID = 0xf5f383d2785edb86

func NewConnectionError(s *capnp.Segment) (ConnectionError, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 16, PointerCount: 1})
	return ConnectionError{st}, err
}

func NewRootConnectionError(s *capnp.Segment) (ConnectionError, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 16, PointerCount: 1})
	return ConnectionError{st}, err
}

func ReadRootConnectionError(msg *capnp.Message) (ConnectionError, error) {
	root, err := msg.RootPtr()
	return ConnectionError{root.Struct()}, err
}

func (s ConnectionError) String() string {
	str, _ := text.Marshal(0xf5f383d2785edb86, s.Struct)
	return str
}

func (s ConnectionError) Cause() (string, error) {
	p, err := s.Struct.Ptr(0)
	return p.Text(), err
}

func (s ConnectionError) HasCause() bool {
	p, err := s.Struct.Ptr(0)
	return p.IsValid() || err != nil
}

func (s ConnectionError) CauseBytes() ([]byte, error) {
	p, err := s.Struct.Ptr(0)
	return p.TextBytes(), err
}

func (s ConnectionError) SetCause(v string) error {
	return s.Struct.SetText(0, v)
}

func (s ConnectionError) RetryAfter() int64 {
	return int64(s.Struct.Uint64(0))
}

func (s ConnectionError) SetRetryAfter(v int64) {
	s.Struct.SetUint64(0, uint64(v))
}

func (s ConnectionError) ShouldRetry() bool {
	return s.Struct.Bit(64)
}

func (s ConnectionError) SetShouldRetry(v bool) {
	s.Struct.SetBit(64, v)
}

// ConnectionError_List is a list of ConnectionError.
type ConnectionError_List struct{ capnp.List }

// NewConnectionError creates a new list of ConnectionError.
func NewConnectionError_List(s *capnp.Segment, sz int32) (ConnectionError_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 16, PointerCount: 1}, sz)
	return ConnectionError_List{l}, err
}

func (s ConnectionError_List) At(i int) ConnectionError { return ConnectionError{s.List.Struct(i)} }

func (s ConnectionError_List) Set(i int, v ConnectionError) error {
	return s.List.SetStruct(i, v.Struct)
}

func (s ConnectionError_List) String() string {
	str, _ := text.MarshalList(0xf5f383d2785edb86, s.List)
	return str
}

// ConnectionError_Promise is a wrapper for a ConnectionError promised by a client call.
type ConnectionError_Promise struct{ *capnp.Pipeline }

func (p ConnectionError_Promise) Struct() (ConnectionError, error) {
	s, err := p.Pipeline.Struct()
	return ConnectionError{s}, err
}

type ConnectionDetails struct{ capnp.Struct }

// ConnectionDetails_TypeID is the unique identifier for the type ConnectionDetails.
const ConnectionDetails_TypeID = 0xb5f39f082b9ac18a

func NewConnectionDetails(s *capnp.Segment) (ConnectionDetails, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 2})
	return ConnectionDetails{st}, err
}

func NewRootConnectionDetails(s *capnp.Segment) (ConnectionDetails, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 2})
	return ConnectionDetails{st}, err
}

func ReadRootConnectionDetails(msg *capnp.Message) (ConnectionDetails, error) {
	root, err := msg.RootPtr()
	return ConnectionDetails{root.Struct()}, err
}

func (s ConnectionDetails) String() string {
	str, _ := text.Marshal(0xb5f39f082b9ac18a, s.Struct)
	return str
}

func (s ConnectionDetails) Uuid() ([]byte, error) {
	p, err := s.Struct.Ptr(0)
	return []byte(p.Data()), err
}

func (s ConnectionDetails) HasUuid() bool {
	p, err := s.Struct.Ptr(0)
	return p.IsValid() || err != nil
}

func (s ConnectionDetails) SetUuid(v []byte) error {
	return s.Struct.SetData(0, v)
}

func (s ConnectionDetails) LocationName() (string, error) {
	p, err := s.Struct.Ptr(1)
	return p.Text(), err
}

func (s ConnectionDetails) HasLocationName() bool {
	p, err := s.Struct.Ptr(1)
	return p.IsValid() || err != nil
}

func (s ConnectionDetails) LocationNameBytes() ([]byte, error) {
	p, err := s.Struct.Ptr(1)
	return p.TextBytes(), err
}

func (s ConnectionDetails) SetLocationName(v string) error {
	return s.Struct.SetText(1, v)
}

// ConnectionDetails_List is a list of ConnectionDetails.
type ConnectionDetails_List struct{ capnp.List }

// NewConnectionDetails creates a new list of ConnectionDetails.
func NewConnectionDetails_List(s *capnp.Segment, sz int32) (ConnectionDetails_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 0, PointerCount: 2}, sz)
	return ConnectionDetails_List{l}, err
}

func (s ConnectionDetails_List) At(i int) ConnectionDetails {
	return ConnectionDetails{s.List.Struct(i)}
}

func (s ConnectionDetails_List) Set(i int, v ConnectionDetails) error {
	return s.List.SetStruct(i, v.Struct)
}

func (s ConnectionDetails_List) String() string {
	str, _ := text.MarshalList(0xb5f39f082b9ac18a, s.List)
	return str
}

// ConnectionDetails_Promise is a wrapper for a ConnectionDetails promised by a client call.
type ConnectionDetails_Promise struct{ *capnp.Pipeline }

func (p ConnectionDetails_Promise) Struct() (ConnectionDetails, error) {
	s, err := p.Pipeline.Struct()
	return ConnectionDetails{s}, err
}

type TunnelAuth struct{ capnp.Struct }

// TunnelAuth_TypeID is the unique identifier for the type TunnelAuth.
const TunnelAuth_TypeID = 0x9496331ab9cd463f

func NewTunnelAuth(s *capnp.Segment) (TunnelAuth, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 2})
	return TunnelAuth{st}, err
}

func NewRootTunnelAuth(s *capnp.Segment) (TunnelAuth, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 2})
	return TunnelAuth{st}, err
}

func ReadRootTunnelAuth(msg *capnp.Message) (TunnelAuth, error) {
	root, err := msg.RootPtr()
	return TunnelAuth{root.Struct()}, err
}

func (s TunnelAuth) String() string {
	str, _ := text.Marshal(0x9496331ab9cd463f, s.Struct)
	return str
}

func (s TunnelAuth) AccountTag() (string, error) {
	p, err := s.Struct.Ptr(0)
	return p.Text(), err
}

func (s TunnelAuth) HasAccountTag() bool {
	p, err := s.Struct.Ptr(0)
	return p.IsValid() || err != nil
}

func (s TunnelAuth) AccountTagBytes() ([]byte, error) {
	p, err := s.Struct.Ptr(0)
	return p.TextBytes(), err
}

func (s TunnelAuth) SetAccountTag(v string) error {
	return s.Struct.SetText(0, v)
}

func (s TunnelAuth) TunnelSecret() ([]byte, error) {
	p, err := s.Struct.Ptr(1)
	return []byte(p.Data()), err
}

func (s TunnelAuth) HasTunnelSecret() bool {
	p, err := s.Struct.Ptr(1)
	return p.IsValid() || err != nil
}

func (s TunnelAuth) SetTunnelSecret(v []byte) error {
	return s.Struct.SetData(1, v)
}

// TunnelAuth_List is a list of TunnelAuth.
type TunnelAuth_List struct{ capnp.List }

// NewTunnelAuth creates a new list of TunnelAuth.
func NewTunnelAuth_List(s *capnp.Segment, sz int32) (TunnelAuth_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 0, PointerCount: 2}, sz)
	return TunnelAuth_List{l}, err
}

func (s TunnelAuth_List) At(i int) TunnelAuth { return TunnelAuth{s.List.Struct(i)} }

func (s TunnelAuth_List) Set(i int, v TunnelAuth) error { return s.List.SetStruct(i, v.Struct) }

func (s TunnelAuth_List) String() string {
	str, _ := text.MarshalList(0x9496331ab9cd463f, s.List)
	return str
}

// TunnelAuth_Promise is a wrapper for a TunnelAuth promised by a client call.
type TunnelAuth_Promise struct{ *capnp.Pipeline }

func (p TunnelAuth_Promise) Struct() (TunnelAuth, error) {
	s, err := p.Pipeline.Struct()
	return TunnelAuth{s}, err
}

type RegistrationServer struct{ Client capnp.Client }

// RegistrationServer_TypeID is the unique identifier for the type RegistrationServer.
const RegistrationServer_TypeID = 0xf71695ec7fe85497

func (c RegistrationServer) RegisterConnection(ctx context.Context, params func(RegistrationServer_registerConnection_Params) error, opts ...capnp.CallOption) RegistrationServer_registerConnection_Results_Promise {
	if c.Client == nil {
		return RegistrationServer_registerConnection_Results_Promise{Pipeline: capnp.NewPipeline(capnp.ErrorAnswer(capnp.ErrNullClient))}
	}
	call := &capnp.Call{
		Ctx: ctx,
		Method: capnp.Method{
			InterfaceID:   0xf71695ec7fe85497,
			MethodID:      0,
			InterfaceName: "tunnelrpc/tunnelrpc.capnp:RegistrationServer",
			MethodName:    "registerConnection",
		},
		Options: capnp.NewCallOptions(opts),
	}
	if params != nil {
		call.ParamsSize = capnp.ObjectSize{DataSize: 8, PointerCount: 3}
		call.ParamsFunc = func(s capnp.Struct) error { return params(RegistrationServer_registerConnection_Params{Struct: s}) }
	}
	return RegistrationServer_registerConnection_Results_Promise{Pipeline: capnp.NewPipeline(c.Client.Call(call))}
}
func (c RegistrationServer) UnregisterConnection(ctx context.Context, params func(RegistrationServer_unregisterConnection_Params) error, opts ...capnp.CallOption) RegistrationServer_unregisterConnection_Results_Promise {
	if c.Client == nil {
		return RegistrationServer_unregisterConnection_Results_Promise{Pipeline: capnp.NewPipeline(capnp.ErrorAnswer(capnp.ErrNullClient))}
	}
	call := &capnp.Call{
		Ctx: ctx,
		Method: capnp.Method{
			InterfaceID:   0xf71695ec7fe85497,
			MethodID:      1,
			InterfaceName: "tunnelrpc/tunnelrpc.capnp:RegistrationServer",
			MethodName:    "unregisterConnection",
		},
		Options: capnp.NewCallOptions(opts),
	}
	if params != nil {
		call.ParamsSize = capnp.ObjectSize{DataSize: 0, PointerCount: 0}
		call.ParamsFunc = func(s capnp.Struct) error { return params(RegistrationServer_unregisterConnection_Params{Struct: s}) }
	}
	return RegistrationServer_unregisterConnection_Results_Promise{Pipeline: capnp.NewPipeline(c.Client.Call(call))}
}

type RegistrationServer_Server interface {
	RegisterConnection(RegistrationServer_registerConnection) error

	UnregisterConnection(RegistrationServer_unregisterConnection) error
}

func RegistrationServer_ServerToClient(s RegistrationServer_Server) RegistrationServer {
	c, _ := s.(server.Closer)
	return RegistrationServer{Client: server.New(RegistrationServer_Methods(nil, s), c)}
}

func RegistrationServer_Methods(methods []server.Method, s RegistrationServer_Server) []server.Method {
	if cap(methods) == 0 {
		methods = make([]server.Method, 0, 2)
	}

	methods = append(methods, server.Method{
		Method: capnp.Method{
			InterfaceID:   0xf71695ec7fe85497,
			MethodID:      0,
			InterfaceName: "tunnelrpc/tunnelrpc.capnp:RegistrationServer",
			MethodName:    "registerConnection",
		},
		Impl: func(c context.Context, opts capnp.CallOptions, p, r capnp.Struct) error {
			call := RegistrationServer_registerConnection{c, opts, RegistrationServer_registerConnection_Params{Struct: p}, RegistrationServer_registerConnection_Results{Struct: r}}
			return s.RegisterConnection(call)
		},
		ResultsSize: capnp.ObjectSize{DataSize: 0, PointerCount: 1},
	})

	methods = append(methods, server.Method{
		Method: capnp.Method{
			InterfaceID:   0xf71695ec7fe85497,
			MethodID:      1,
			InterfaceName: "tunnelrpc/tunnelrpc.capnp:RegistrationServer",
			MethodName:    "unregisterConnection",
		},
		Impl: func(c context.Context, opts capnp.CallOptions, p, r capnp.Struct) error {
			call := RegistrationServer_unregisterConnection{c, opts, RegistrationServer_unregisterConnection_Params{Struct: p}, RegistrationServer_unregisterConnection_Results{Struct: r}}
			return s.UnregisterConnection(call)
		},
		ResultsSize: capnp.ObjectSize{DataSize: 0, PointerCount: 0},
	})

	return methods
}

// RegistrationServer_registerConnection holds the arguments for a server call to RegistrationServer.registerConnection.
type RegistrationServer_registerConnection struct {
	Ctx     context.Context
	Options capnp.CallOptions
	Params  RegistrationServer_registerConnection_Params
	Results RegistrationServer_registerConnection_Results
}

// RegistrationServer_unregisterConnection holds the arguments for a server call to RegistrationServer.unregisterConnection.
type RegistrationServer_unregisterConnection struct {
	Ctx     context.Context
	Options capnp.CallOptions
	Params  RegistrationServer_unregisterConnection_Params
	Results RegistrationServer_unregisterConnection_Results
}

type RegistrationServer_registerConnection_Params struct{ capnp.Struct }

// RegistrationServer_registerConnection_Params_TypeID is the unique identifier for the type RegistrationServer_registerConnection_Params.
const RegistrationServer_registerConnection_Params_TypeID = 0xe6646dec8feaa6ee

func NewRegistrationServer_registerConnection_Params(s *capnp.Segment) (RegistrationServer_registerConnection_Params, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 8, PointerCount: 3})
	return RegistrationServer_registerConnection_Params{st}, err
}

func NewRootRegistrationServer_registerConnection_Params(s *capnp.Segment) (RegistrationServer_registerConnection_Params, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 8, PointerCount: 3})
	return RegistrationServer_registerConnection_Params{st}, err
}

func ReadRootRegistrationServer_registerConnection_Params(msg *capnp.Message) (RegistrationServer_registerConnection_Params, error) {
	root, err := msg.RootPtr()
	return RegistrationServer_registerConnection_Params{root.Struct()}, err
}

func (s RegistrationServer_registerConnection_Params) String() string {
	str, _ := text.Marshal(0xe6646dec8feaa6ee, s.Struct)
	return str
}

func (s RegistrationServer_registerConnection_Params) Auth() (TunnelAuth, error) {
	p, err := s.Struct.Ptr(0)
	return TunnelAuth{Struct: p.Struct()}, err
}

func (s RegistrationServer_registerConnection_Params) HasAuth() bool {
	p, err := s.Struct.Ptr(0)
	return p.IsValid() || err != nil
}

func (s RegistrationServer_registerConnection_Params) SetAuth(v TunnelAuth) error {
	return s.Struct.SetPtr(0, v.Struct.ToPtr())
}

// NewAuth sets the auth field to a newly
// allocated TunnelAuth struct, preferring placement in s's segment.
func (s RegistrationServer_registerConnection_Params) NewAuth() (TunnelAuth, error) {
	ss, err := NewTunnelAuth(s.Struct.Segment())
	if err != nil {
		return TunnelAuth{}, err
	}
	err = s.Struct.SetPtr(0, ss.Struct.ToPtr())
	return ss, err
}

func (s RegistrationServer_registerConnection_Params) TunnelId() ([]byte, error) {
	p, err := s.Struct.Ptr(1)
	return []byte(p.Data()), err
}

func (s RegistrationServer_registerConnection_Params) HasTunnelId() bool {
	p, err := s.Struct.Ptr(1)
	return p.IsValid() || err != nil
}

func (s RegistrationServer_registerConnection_Params) SetTunnelId(v []byte) error {
	return s.Struct.SetData(1, v)
}

func (s RegistrationServer_registerConnection_Params) ConnIndex() uint8 {
	return s.Struct.Uint8(0)
}

func (s RegistrationServer_registerConnection_Params) SetConnIndex(v uint8) {
	s.Struct.SetUint8(0, v)
}

func (s RegistrationServer_registerConnection_Params) Options() (ConnectionOptions, error) {
	p, err := s.Struct.Ptr(2)
	return ConnectionOptions{Struct: p.Struct()}, err
}

func (s RegistrationServer_registerConnection_Params) HasOptions() bool {
	p, err := s.Struct.Ptr(2)
	return p.IsValid() || err != nil
}

func (s RegistrationServer_registerConnection_Params) SetOptions(v ConnectionOptions) error {
	return s.Struct.SetPtr(2, v.Struct.ToPtr())
}

// NewOptions sets the options field to a newly
// allocated ConnectionOptions struct, preferring placement in s's segment.
func (s RegistrationServer_registerConnection_Params) NewOptions() (ConnectionOptions, error) {
	ss, err := NewConnectionOptions(s.Struct.Segment())
	if err != nil {
		return ConnectionOptions{}, err
	}
	err = s.Struct.SetPtr(2, ss.Struct.ToPtr())
	return ss, err
}

// RegistrationServer_registerConnection_Params_List is a list of RegistrationServer_registerConnection_Params.
type RegistrationServer_registerConnection_Params_List struct{ capnp.List }

// NewRegistrationServer_registerConnection_Params creates a new list of RegistrationServer_registerConnection_Params.
func NewRegistrationServer_registerConnection_Params_List(s *capnp.Segment, sz int32) (RegistrationServer_registerConnection_Params_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 8, PointerCount: 3}, sz)
	return RegistrationServer_registerConnection_Params_List{l}, err
}

func (s RegistrationServer_registerConnection_Params_List) At(i int) RegistrationServer_registerConnection_Params {
	return RegistrationServer_registerConnection_Params{s.List.Struct(i)}
}

func (s RegistrationServer_registerConnection_Params_List) Set(i int, v RegistrationServer_registerConnection_Params) error {
	return s.List.SetStruct(i, v.Struct)
}

func (s RegistrationServer_registerConnection_Params_List) String() string {
	str, _ := text.MarshalList(0xe6646dec8feaa6ee, s.List)
	return str
}

// RegistrationServer_registerConnection_Params_Promise is a wrapper for a RegistrationServer_registerConnection_Params promised by a client call.
type RegistrationServer_registerConnection_Params_Promise struct{ *capnp.Pipeline }

func (p RegistrationServer_registerConnection_Params_Promise) Struct() (RegistrationServer_registerConnection_Params, error) {
	s, err := p.Pipeline.Struct()
	return RegistrationServer_registerConnection_Params{s}, err
}

func (p RegistrationServer_registerConnection_Params_Promise) Auth() TunnelAuth_Promise {
	return TunnelAuth_Promise{Pipeline: p.Pipeline.GetPipeline(0)}
}

func (p RegistrationServer_registerConnection_Params_Promise) Options() ConnectionOptions_Promise {
	return ConnectionOptions_Promise{Pipeline: p.Pipeline.GetPipeline(2)}
}

type RegistrationServer_registerConnection_Results struct{ capnp.Struct }

// RegistrationServer_registerConnection_Results_TypeID is the unique identifier for the type RegistrationServer_registerConnection_Results.
const RegistrationServer_registerConnection_Results_TypeID = 0xea50d822450d1f17

func NewRegistrationServer_registerConnection_Results(s *capnp.Segment) (RegistrationServer_registerConnection_Results, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 1})
	return RegistrationServer_registerConnection_Results{st}, err
}

func NewRootRegistrationServer_registerConnection_Results(s *capnp.Segment) (RegistrationServer_registerConnection_Results, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 1})
	return RegistrationServer_registerConnection_Results{st}, err
}

func ReadRootRegistrationServer_registerConnection_Results(msg *capnp.Message) (RegistrationServer_registerConnection_Results, error) {
	root, err := msg.RootPtr()
	return RegistrationServer_registerConnection_Results{root.Struct()}, err
}

func (s RegistrationServer_registerConnection_Results) String() string {
	str, _ := text.Marshal(0xea50d822450d1f17, s.Struct)
	return str
}

func (s RegistrationServer_registerConnection_Results) Result() (ConnectionResponse, error) {
	p, err := s.Struct.Ptr(0)
	return ConnectionResponse{Struct: p.Struct()}, err
}

func (s RegistrationServer_registerConnection_Results) HasResult() bool {
	p, err := s.Struct.Ptr(0)
	return p.IsValid() || err != nil
}

func (s RegistrationServer_registerConnection_Results) SetResult(v ConnectionResponse) error {
	return s.Struct.SetPtr(0, v.Struct.ToPtr())
}

// NewResult sets the result field to a newly
// allocated ConnectionResponse struct, preferring placement in s's segment.
func (s RegistrationServer_registerConnection_Results) NewResult() (ConnectionResponse, error) {
	ss, err := NewConnectionResponse(s.Struct.Segment())
	if err != nil {
		return ConnectionResponse{}, err
	}
	err = s.Struct.SetPtr(0, ss.Struct.ToPtr())
	return ss, err
}

// RegistrationServer_registerConnection_Results_List is a list of RegistrationServer_registerConnection_Results.
type RegistrationServer_registerConnection_Results_List struct{ capnp.List }

// NewRegistrationServer_registerConnection_Results creates a new list of RegistrationServer_registerConnection_Results.
func NewRegistrationServer_registerConnection_Results_List(s *capnp.Segment, sz int32) (RegistrationServer_registerConnection_Results_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 0, PointerCount: 1}, sz)
	return RegistrationServer_registerConnection_Results_List{l}, err
}

func (s RegistrationServer_registerConnection_Results_List) At(i int) RegistrationServer_registerConnection_Results {
	return RegistrationServer_registerConnection_Results{s.List.Struct(i)}
}

func (s RegistrationServer_registerConnection_Results_List) Set(i int, v RegistrationServer_registerConnection_Results) error {
	return s.List.SetStruct(i, v.Struct)
}

func (s RegistrationServer_registerConnection_Results_List) String() string {
	str, _ := text.MarshalList(0xea50d822450d1f17, s.List)
	return str
}

// RegistrationServer_registerConnection_Results_Promise is a wrapper for a RegistrationServer_registerConnection_Results promised by a client call.
type RegistrationServer_registerConnection_Results_Promise struct{ *capnp.Pipeline }

func (p RegistrationServer_registerConnection_Results_Promise) Struct() (RegistrationServer_registerConnection_Results, error) {
	s, err := p.Pipeline.Struct()
	return RegistrationServer_registerConnection_Results{s}, err
}

func (p RegistrationServer_registerConnection_Results_Promise) Result() ConnectionResponse_Promise {
	return ConnectionResponse_Promise{Pipeline: p.Pipeline.GetPipeline(0)}
}

type RegistrationServer_unregisterConnection_Params struct{ capnp.Struct }

// RegistrationServer_unregisterConnection_Params_TypeID is the unique identifier for the type RegistrationServer_unregisterConnection_Params.
const RegistrationServer_unregisterConnection_Params_TypeID = 0xf9cb7f4431a307d0

func NewRegistrationServer_unregisterConnection_Params(s *capnp.Segment) (RegistrationServer_unregisterConnection_Params, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 0})
	return RegistrationServer_unregisterConnection_Params{st}, err
}

func NewRootRegistrationServer_unregisterConnection_Params(s *capnp.Segment) (RegistrationServer_unregisterConnection_Params, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 0})
	return RegistrationServer_unregisterConnection_Params{st}, err
}

func ReadRootRegistrationServer_unregisterConnection_Params(msg *capnp.Message) (RegistrationServer_unregisterConnection_Params, error) {
	root, err := msg.RootPtr()
	return RegistrationServer_unregisterConnection_Params{root.Struct()}, err
}

func (s RegistrationServer_unregisterConnection_Params) String() string {
	str, _ := text.Marshal(0xf9cb7f4431a307d0, s.Struct)
	return str
}

// RegistrationServer_unregisterConnection_Params_List is a list of RegistrationServer_unregisterConnection_Params.
type RegistrationServer_unregisterConnection_Params_List struct{ capnp.List }

// NewRegistrationServer_unregisterConnection_Params creates a new list of RegistrationServer_unregisterConnection_Params.
func NewRegistrationServer_unregisterConnection_Params_List(s *capnp.Segment, sz int32) (RegistrationServer_unregisterConnection_Params_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 0, PointerCount: 0}, sz)
	return RegistrationServer_unregisterConnection_Params_List{l}, err
}

func (s RegistrationServer_unregisterConnection_Params_List) At(i int) RegistrationServer_unregisterConnection_Params {
	return RegistrationServer_unregisterConnection_Params{s.List.Struct(i)}
}

func (s RegistrationServer_unregisterConnection_Params_List) Set(i int, v RegistrationServer_unregisterConnection_Params) error {
	return s.List.SetStruct(i, v.Struct)
}

func (s RegistrationServer_unregisterConnection_Params_List) String() string {
	str, _ := text.MarshalList(0xf9cb7f4431a307d0, s.List)
	return str
}

// RegistrationServer_unregisterConnection_Params_Promise is a wrapper for a RegistrationServer_unregisterConnection_Params promised by a client call.
type RegistrationServer_unregisterConnection_Params_Promise struct{ *capnp.Pipeline }

func (p RegistrationServer_unregisterConnection_Params_Promise) Struct() (RegistrationServer_unregisterConnection_Params, error) {
	s, err := p.Pipeline.Struct()
	return RegistrationServer_unregisterConnection_Params{s}, err
}

type RegistrationServer_unregisterConnection_Results struct{ capnp.Struct }

// RegistrationServer_unregisterConnection_Results_TypeID is the unique identifier for the type RegistrationServer_unregisterConnection_Results.
const RegistrationServer_unregisterConnection_Results_TypeID = 0xb046e578094b1ead

func NewRegistrationServer_unregisterConnection_Results(s *capnp.Segment) (RegistrationServer_unregisterConnection_Results, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 0})
	return RegistrationServer_unregisterConnection_Results{st}, err
}

func NewRootRegistrationServer_unregisterConnection_Results(s *capnp.Segment) (RegistrationServer_unregisterConnection_Results, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 0})
	return RegistrationServer_unregisterConnection_Results{st}, err
}

func ReadRootRegistrationServer_unregisterConnection_Results(msg *capnp.Message) (RegistrationServer_unregisterConnection_Results, error) {
	root, err := msg.RootPtr()
	return RegistrationServer_unregisterConnection_Results{root.Struct()}, err
}

func (s RegistrationServer_unregisterConnection_Results) String() string {
	str, _ := text.Marshal(0xb046e578094b1ead, s.Struct)
	return str
}

// RegistrationServer_unregisterConnection_Results_List is a list of RegistrationServer_unregisterConnection_Results.
type RegistrationServer_unregisterConnection_Results_List struct{ capnp.List }

// NewRegistrationServer_unregisterConnection_Results creates a new list of RegistrationServer_unregisterConnection_Results.
func NewRegistrationServer_unregisterConnection_Results_List(s *capnp.Segment, sz int32) (RegistrationServer_unregisterConnection_Results_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 0, PointerCount: 0}, sz)
	return RegistrationServer_unregisterConnection_Results_List{l}, err
}

func (s RegistrationServer_unregisterConnection_Results_List) At(i int) RegistrationServer_unregisterConnection_Results {
	return RegistrationServer_unregisterConnection_Results{s.List.Struct(i)}
}

func (s RegistrationServer_unregisterConnection_Results_List) Set(i int, v RegistrationServer_unregisterConnection_Results) error {
	return s.List.SetStruct(i, v.Struct)
}

func (s RegistrationServer_unregisterConnection_Results_List) String() string {
	str, _ := text.MarshalList(0xb046e578094b1ead, s.List)
	return str
}

// RegistrationServer_unregisterConnection_Results_Promise is a wrapper for a RegistrationServer_unregisterConnection_Results promised by a client call.
type RegistrationServer_unregisterConnection_Results_Promise struct{ *capnp.Pipeline }

func (p RegistrationServer_unregisterConnection_Results_Promise) Struct() (RegistrationServer_unregisterConnection_Results, error) {
	s, err := p.Pipeline.Struct()
	return RegistrationServer_unregisterConnection_Results{s}, err
}

type TunnelServer struct{ Client capnp.Client }

// TunnelServer_TypeID is the unique identifier for the type TunnelServer.
const TunnelServer_TypeID = 0xea58385c65416035

func (c TunnelServer) RegisterTunnel(ctx context.Context, params func(TunnelServer_registerTunnel_Params) error, opts ...capnp.CallOption) TunnelServer_registerTunnel_Results_Promise {
	if c.Client == nil {
		return TunnelServer_registerTunnel_Results_Promise{Pipeline: capnp.NewPipeline(capnp.ErrorAnswer(capnp.ErrNullClient))}
	}
	call := &capnp.Call{
		Ctx: ctx,
		Method: capnp.Method{
			InterfaceID:   0xea58385c65416035,
			MethodID:      0,
			InterfaceName: "tunnelrpc/tunnelrpc.capnp:TunnelServer",
			MethodName:    "registerTunnel",
		},
		Options: capnp.NewCallOptions(opts),
	}
	if params != nil {
		call.ParamsSize = capnp.ObjectSize{DataSize: 0, PointerCount: 3}
		call.ParamsFunc = func(s capnp.Struct) error { return params(TunnelServer_registerTunnel_Params{Struct: s}) }
	}
	return TunnelServer_registerTunnel_Results_Promise{Pipeline: capnp.NewPipeline(c.Client.Call(call))}
}
func (c TunnelServer) GetServerInfo(ctx context.Context, params func(TunnelServer_getServerInfo_Params) error, opts ...capnp.CallOption) TunnelServer_getServerInfo_Results_Promise {
	if c.Client == nil {
		return TunnelServer_getServerInfo_Results_Promise{Pipeline: capnp.NewPipeline(capnp.ErrorAnswer(capnp.ErrNullClient))}
	}
	call := &capnp.Call{
		Ctx: ctx,
		Method: capnp.Method{
			InterfaceID:   0xea58385c65416035,
			MethodID:      1,
			InterfaceName: "tunnelrpc/tunnelrpc.capnp:TunnelServer",
			MethodName:    "getServerInfo",
		},
		Options: capnp.NewCallOptions(opts),
	}
	if params != nil {
		call.ParamsSize = capnp.ObjectSize{DataSize: 0, PointerCount: 0}
		call.ParamsFunc = func(s capnp.Struct) error { return params(TunnelServer_getServerInfo_Params{Struct: s}) }
	}
	return TunnelServer_getServerInfo_Results_Promise{Pipeline: capnp.NewPipeline(c.Client.Call(call))}
}
func (c TunnelServer) UnregisterTunnel(ctx context.Context, params func(TunnelServer_unregisterTunnel_Params) error, opts ...capnp.CallOption) TunnelServer_unregisterTunnel_Results_Promise {
	if c.Client == nil {
		return TunnelServer_unregisterTunnel_Results_Promise{Pipeline: capnp.NewPipeline(capnp.ErrorAnswer(capnp.ErrNullClient))}
	}
	call := &capnp.Call{
		Ctx: ctx,
		Method: capnp.Method{
			InterfaceID:   0xea58385c65416035,
			MethodID:      2,
			InterfaceName: "tunnelrpc/tunnelrpc.capnp:TunnelServer",
			MethodName:    "unregisterTunnel",
		},
		Options: capnp.NewCallOptions(opts),
	}
	if params != nil {
		call.ParamsSize = capnp.ObjectSize{DataSize: 8, PointerCount: 0}
		call.ParamsFunc = func(s capnp.Struct) error { return params(TunnelServer_unregisterTunnel_Params{Struct: s}) }
	}
	return TunnelServer_unregisterTunnel_Results_Promise{Pipeline: capnp.NewPipeline(c.Client.Call(call))}
}
func (c TunnelServer) ObsoleteDeclarativeTunnelConnect(ctx context.Context, params func(TunnelServer_obsoleteDeclarativeTunnelConnect_Params) error, opts ...capnp.CallOption) TunnelServer_obsoleteDeclarativeTunnelConnect_Results_Promise {
	if c.Client == nil {
		return TunnelServer_obsoleteDeclarativeTunnelConnect_Results_Promise{Pipeline: capnp.NewPipeline(capnp.ErrorAnswer(capnp.ErrNullClient))}
	}
	call := &capnp.Call{
		Ctx: ctx,
		Method: capnp.Method{
			InterfaceID:   0xea58385c65416035,
			MethodID:      3,
			InterfaceName: "tunnelrpc/tunnelrpc.capnp:TunnelServer",
			MethodName:    "obsoleteDeclarativeTunnelConnect",
		},
		Options: capnp.NewCallOptions(opts),
	}
	if params != nil {
		call.ParamsSize = capnp.ObjectSize{DataSize: 0, PointerCount: 0}
		call.ParamsFunc = func(s capnp.Struct) error {
			return params(TunnelServer_obsoleteDeclarativeTunnelConnect_Params{Struct: s})
		}
	}
	return TunnelServer_obsoleteDeclarativeTunnelConnect_Results_Promise{Pipeline: capnp.NewPipeline(c.Client.Call(call))}
}
func (c TunnelServer) Authenticate(ctx context.Context, params func(TunnelServer_authenticate_Params) error, opts ...capnp.CallOption) TunnelServer_authenticate_Results_Promise {
	if c.Client == nil {
		return TunnelServer_authenticate_Results_Promise{Pipeline: capnp.NewPipeline(capnp.ErrorAnswer(capnp.ErrNullClient))}
	}
	call := &capnp.Call{
		Ctx: ctx,
		Method: capnp.Method{
			InterfaceID:   0xea58385c65416035,
			MethodID:      4,
			InterfaceName: "tunnelrpc/tunnelrpc.capnp:TunnelServer",
			MethodName:    "authenticate",
		},
		Options: capnp.NewCallOptions(opts),
	}
	if params != nil {
		call.ParamsSize = capnp.ObjectSize{DataSize: 0, PointerCount: 3}
		call.ParamsFunc = func(s capnp.Struct) error { return params(TunnelServer_authenticate_Params{Struct: s}) }
	}
	return TunnelServer_authenticate_Results_Promise{Pipeline: capnp.NewPipeline(c.Client.Call(call))}
}
func (c TunnelServer) ReconnectTunnel(ctx context.Context, params func(TunnelServer_reconnectTunnel_Params) error, opts ...capnp.CallOption) TunnelServer_reconnectTunnel_Results_Promise {
	if c.Client == nil {
		return TunnelServer_reconnectTunnel_Results_Promise{Pipeline: capnp.NewPipeline(capnp.ErrorAnswer(capnp.ErrNullClient))}
	}
	call := &capnp.Call{
		Ctx: ctx,
		Method: capnp.Method{
			InterfaceID:   0xea58385c65416035,
			MethodID:      5,
			InterfaceName: "tunnelrpc/tunnelrpc.capnp:TunnelServer",
			MethodName:    "reconnectTunnel",
		},
		Options: capnp.NewCallOptions(opts),
	}
	if params != nil {
		call.ParamsSize = capnp.ObjectSize{DataSize: 0, PointerCount: 5}
		call.ParamsFunc = func(s capnp.Struct) error { return params(TunnelServer_reconnectTunnel_Params{Struct: s}) }
	}
	return TunnelServer_reconnectTunnel_Results_Promise{Pipeline: capnp.NewPipeline(c.Client.Call(call))}
}
func (c TunnelServer) RegisterConnection(ctx context.Context, params func(RegistrationServer_registerConnection_Params) error, opts ...capnp.CallOption) RegistrationServer_registerConnection_Results_Promise {
	if c.Client == nil {
		return RegistrationServer_registerConnection_Results_Promise{Pipeline: capnp.NewPipeline(capnp.ErrorAnswer(capnp.ErrNullClient))}
	}
	call := &capnp.Call{
		Ctx: ctx,
		Method: capnp.Method{
			InterfaceID:   0xf71695ec7fe85497,
			MethodID:      0,
			InterfaceName: "tunnelrpc/tunnelrpc.capnp:RegistrationServer",
			MethodName:    "registerConnection",
		},
		Options: capnp.NewCallOptions(opts),
	}
	if params != nil {
		call.ParamsSize = capnp.ObjectSize{DataSize: 8, PointerCount: 3}
		call.ParamsFunc = func(s capnp.Struct) error { return params(RegistrationServer_registerConnection_Params{Struct: s}) }
	}
	return RegistrationServer_registerConnection_Results_Promise{Pipeline: capnp.NewPipeline(c.Client.Call(call))}
}
func (c TunnelServer) UnregisterConnection(ctx context.Context, params func(RegistrationServer_unregisterConnection_Params) error, opts ...capnp.CallOption) RegistrationServer_unregisterConnection_Results_Promise {
	if c.Client == nil {
		return RegistrationServer_unregisterConnection_Results_Promise{Pipeline: capnp.NewPipeline(capnp.ErrorAnswer(capnp.ErrNullClient))}
	}
	call := &capnp.Call{
		Ctx: ctx,
		Method: capnp.Method{
			InterfaceID:   0xf71695ec7fe85497,
			MethodID:      1,
			InterfaceName: "tunnelrpc/tunnelrpc.capnp:RegistrationServer",
			MethodName:    "unregisterConnection",
		},
		Options: capnp.NewCallOptions(opts),
	}
	if params != nil {
		call.ParamsSize = capnp.ObjectSize{DataSize: 0, PointerCount: 0}
		call.ParamsFunc = func(s capnp.Struct) error { return params(RegistrationServer_unregisterConnection_Params{Struct: s}) }
	}
	return RegistrationServer_unregisterConnection_Results_Promise{Pipeline: capnp.NewPipeline(c.Client.Call(call))}
}

type TunnelServer_Server interface {
	RegisterTunnel(TunnelServer_registerTunnel) error

	GetServerInfo(TunnelServer_getServerInfo) error

	UnregisterTunnel(TunnelServer_unregisterTunnel) error

	ObsoleteDeclarativeTunnelConnect(TunnelServer_obsoleteDeclarativeTunnelConnect) error

	Authenticate(TunnelServer_authenticate) error

	ReconnectTunnel(TunnelServer_reconnectTunnel) error

	RegisterConnection(RegistrationServer_registerConnection) error

	UnregisterConnection(RegistrationServer_unregisterConnection) error
}

func TunnelServer_ServerToClient(s TunnelServer_Server) TunnelServer {
	c, _ := s.(server.Closer)
	return TunnelServer{Client: server.New(TunnelServer_Methods(nil, s), c)}
}

func TunnelServer_Methods(methods []server.Method, s TunnelServer_Server) []server.Method {
	if cap(methods) == 0 {
		methods = make([]server.Method, 0, 8)
	}

	methods = append(methods, server.Method{
		Method: capnp.Method{
			InterfaceID:   0xea58385c65416035,
			MethodID:      0,
			InterfaceName: "tunnelrpc/tunnelrpc.capnp:TunnelServer",
			MethodName:    "registerTunnel",
		},
		Impl: func(c context.Context, opts capnp.CallOptions, p, r capnp.Struct) error {
			call := TunnelServer_registerTunnel{c, opts, TunnelServer_registerTunnel_Params{Struct: p}, TunnelServer_registerTunnel_Results{Struct: r}}
			return s.RegisterTunnel(call)
		},
		ResultsSize: capnp.ObjectSize{DataSize: 0, PointerCount: 1},
	})

	methods = append(methods, server.Method{
		Method: capnp.Method{
			InterfaceID:   0xea58385c65416035,
			MethodID:      1,
			InterfaceName: "tunnelrpc/tunnelrpc.capnp:TunnelServer",
			MethodName:    "getServerInfo",
		},
		Impl: func(c context.Context, opts capnp.CallOptions, p, r capnp.Struct) error {
			call := TunnelServer_getServerInfo{c, opts, TunnelServer_getServerInfo_Params{Struct: p}, TunnelServer_getServerInfo_Results{Struct: r}}
			return s.GetServerInfo(call)
		},
		ResultsSize: capnp.ObjectSize{DataSize: 0, PointerCount: 1},
	})

	methods = append(methods, server.Method{
		Method: capnp.Method{
			InterfaceID:   0xea58385c65416035,
			MethodID:      2,
			InterfaceName: "tunnelrpc/tunnelrpc.capnp:TunnelServer",
			MethodName:    "unregisterTunnel",
		},
		Impl: func(c context.Context, opts capnp.CallOptions, p, r capnp.Struct) error {
			call := TunnelServer_unregisterTunnel{c, opts, TunnelServer_unregisterTunnel_Params{Struct: p}, TunnelServer_unregisterTunnel_Results{Struct: r}}
			return s.UnregisterTunnel(call)
		},
		ResultsSize: capnp.ObjectSize{DataSize: 0, PointerCount: 0},
	})

	methods = append(methods, server.Method{
		Method: capnp.Method{
			InterfaceID:   0xea58385c65416035,
			MethodID:      3,
			InterfaceName: "tunnelrpc/tunnelrpc.capnp:TunnelServer",
			MethodName:    "obsoleteDeclarativeTunnelConnect",
		},
		Impl: func(c context.Context, opts capnp.CallOptions, p, r capnp.Struct) error {
			call := TunnelServer_obsoleteDeclarativeTunnelConnect{c, opts, TunnelServer_obsoleteDeclarativeTunnelConnect_Params{Struct: p}, TunnelServer_obsoleteDeclarativeTunnelConnect_Results{Struct: r}}
			return s.ObsoleteDeclarativeTunnelConnect(call)
		},
		ResultsSize: capnp.ObjectSize{DataSize: 0, PointerCount: 0},
	})

	methods = append(methods, server.Method{
		Method: capnp.Method{
			InterfaceID:   0xea58385c65416035,
			MethodID:      4,
			InterfaceName: "tunnelrpc/tunnelrpc.capnp:TunnelServer",
			MethodName:    "authenticate",
		},
		Impl: func(c context.Context, opts capnp.CallOptions, p, r capnp.Struct) error {
			call := TunnelServer_authenticate{c, opts, TunnelServer_authenticate_Params{Struct: p}, TunnelServer_authenticate_Results{Struct: r}}
			return s.Authenticate(call)
		},
		ResultsSize: capnp.ObjectSize{DataSize: 0, PointerCount: 1},
	})

	methods = append(methods, server.Method{
		Method: capnp.Method{
			InterfaceID:   0xea58385c65416035,
			MethodID:      5,
			InterfaceName: "tunnelrpc/tunnelrpc.capnp:TunnelServer",
			MethodName:    "reconnectTunnel",
		},
		Impl: func(c context.Context, opts capnp.CallOptions, p, r capnp.Struct) error {
			call := TunnelServer_reconnectTunnel{c, opts, TunnelServer_reconnectTunnel_Params{Struct: p}, TunnelServer_reconnectTunnel_Results{Struct: r}}
			return s.ReconnectTunnel(call)
		},
		ResultsSize: capnp.ObjectSize{DataSize: 0, PointerCount: 1},
	})

	methods = append(methods, server.Method{
		Method: capnp.Method{
			InterfaceID:   0xf71695ec7fe85497,
			MethodID:      0,
			InterfaceName: "tunnelrpc/tunnelrpc.capnp:RegistrationServer",
			MethodName:    "registerConnection",
		},
		Impl: func(c context.Context, opts capnp.CallOptions, p, r capnp.Struct) error {
			call := RegistrationServer_registerConnection{c, opts, RegistrationServer_registerConnection_Params{Struct: p}, RegistrationServer_registerConnection_Results{Struct: r}}
			return s.RegisterConnection(call)
		},
		ResultsSize: capnp.ObjectSize{DataSize: 0, PointerCount: 1},
	})

	methods = append(methods, server.Method{
		Method: capnp.Method{
			InterfaceID:   0xf71695ec7fe85497,
			MethodID:      1,
			InterfaceName: "tunnelrpc/tunnelrpc.capnp:RegistrationServer",
			MethodName:    "unregisterConnection",
		},
		Impl: func(c context.Context, opts capnp.CallOptions, p, r capnp.Struct) error {
			call := RegistrationServer_unregisterConnection{c, opts, RegistrationServer_unregisterConnection_Params{Struct: p}, RegistrationServer_unregisterConnection_Results{Struct: r}}
			return s.UnregisterConnection(call)
		},
		ResultsSize: capnp.ObjectSize{DataSize: 0, PointerCount: 0},
	})

	return methods
}

// TunnelServer_registerTunnel holds the arguments for a server call to TunnelServer.registerTunnel.
type TunnelServer_registerTunnel struct {
	Ctx     context.Context
	Options capnp.CallOptions
	Params  TunnelServer_registerTunnel_Params
	Results TunnelServer_registerTunnel_Results
}

// TunnelServer_getServerInfo holds the arguments for a server call to TunnelServer.getServerInfo.
type TunnelServer_getServerInfo struct {
	Ctx     context.Context
	Options capnp.CallOptions
	Params  TunnelServer_getServerInfo_Params
	Results TunnelServer_getServerInfo_Results
}

// TunnelServer_unregisterTunnel holds the arguments for a server call to TunnelServer.unregisterTunnel.
type TunnelServer_unregisterTunnel struct {
	Ctx     context.Context
	Options capnp.CallOptions
	Params  TunnelServer_unregisterTunnel_Params
	Results TunnelServer_unregisterTunnel_Results
}

// TunnelServer_obsoleteDeclarativeTunnelConnect holds the arguments for a server call to TunnelServer.obsoleteDeclarativeTunnelConnect.
type TunnelServer_obsoleteDeclarativeTunnelConnect struct {
	Ctx     context.Context
	Options capnp.CallOptions
	Params  TunnelServer_obsoleteDeclarativeTunnelConnect_Params
	Results TunnelServer_obsoleteDeclarativeTunnelConnect_Results
}

// TunnelServer_authenticate holds the arguments for a server call to TunnelServer.authenticate.
type TunnelServer_authenticate struct {
	Ctx     context.Context
	Options capnp.CallOptions
	Params  TunnelServer_authenticate_Params
	Results TunnelServer_authenticate_Results
}

// TunnelServer_reconnectTunnel holds the arguments for a server call to TunnelServer.reconnectTunnel.
type TunnelServer_reconnectTunnel struct {
	Ctx     context.Context
	Options capnp.CallOptions
	Params  TunnelServer_reconnectTunnel_Params
	Results TunnelServer_reconnectTunnel_Results
}

type TunnelServer_registerTunnel_Params struct{ capnp.Struct }

// TunnelServer_registerTunnel_Params_TypeID is the unique identifier for the type TunnelServer_registerTunnel_Params.
const TunnelServer_registerTunnel_Params_TypeID = 0xb70431c0dc014915

func NewTunnelServer_registerTunnel_Params(s *capnp.Segment) (TunnelServer_registerTunnel_Params, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 3})
	return TunnelServer_registerTunnel_Params{st}, err
}

func NewRootTunnelServer_registerTunnel_Params(s *capnp.Segment) (TunnelServer_registerTunnel_Params, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 3})
	return TunnelServer_registerTunnel_Params{st}, err
}

func ReadRootTunnelServer_registerTunnel_Params(msg *capnp.Message) (TunnelServer_registerTunnel_Params, error) {
	root, err := msg.RootPtr()
	return TunnelServer_registerTunnel_Params{root.Struct()}, err
}

func (s TunnelServer_registerTunnel_Params) String() string {
	str, _ := text.Marshal(0xb70431c0dc014915, s.Struct)
	return str
}

func (s TunnelServer_registerTunnel_Params) OriginCert() ([]byte, error) {
	p, err := s.Struct.Ptr(0)
	return []byte(p.Data()), err
}

func (s TunnelServer_registerTunnel_Params) HasOriginCert() bool {
	p, err := s.Struct.Ptr(0)
	return p.IsValid() || err != nil
}

func (s TunnelServer_registerTunnel_Params) SetOriginCert(v []byte) error {
	return s.Struct.SetData(0, v)
}

func (s TunnelServer_registerTunnel_Params) Hostname() (string, error) {
	p, err := s.Struct.Ptr(1)
	return p.Text(), err
}

func (s TunnelServer_registerTunnel_Params) HasHostname() bool {
	p, err := s.Struct.Ptr(1)
	return p.IsValid() || err != nil
}

func (s TunnelServer_registerTunnel_Params) HostnameBytes() ([]byte, error) {
	p, err := s.Struct.Ptr(1)
	return p.TextBytes(), err
}

func (s TunnelServer_registerTunnel_Params) SetHostname(v string) error {
	return s.Struct.SetText(1, v)
}

func (s TunnelServer_registerTunnel_Params) Options() (RegistrationOptions, error) {
	p, err := s.Struct.Ptr(2)
	return RegistrationOptions{Struct: p.Struct()}, err
}

func (s TunnelServer_registerTunnel_Params) HasOptions() bool {
	p, err := s.Struct.Ptr(2)
	return p.IsValid() || err != nil
}

func (s TunnelServer_registerTunnel_Params) SetOptions(v RegistrationOptions) error {
	return s.Struct.SetPtr(2, v.Struct.ToPtr())
}

// NewOptions sets the options field to a newly
// allocated RegistrationOptions struct, preferring placement in s's segment.
func (s TunnelServer_registerTunnel_Params) NewOptions() (RegistrationOptions, error) {
	ss, err := NewRegistrationOptions(s.Struct.Segment())
	if err != nil {
		return RegistrationOptions{}, err
	}
	err = s.Struct.SetPtr(2, ss.Struct.ToPtr())
	return ss, err
}

// TunnelServer_registerTunnel_Params_List is a list of TunnelServer_registerTunnel_Params.
type TunnelServer_registerTunnel_Params_List struct{ capnp.List }

// NewTunnelServer_registerTunnel_Params creates a new list of TunnelServer_registerTunnel_Params.
func NewTunnelServer_registerTunnel_Params_List(s *capnp.Segment, sz int32) (TunnelServer_registerTunnel_Params_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 0, PointerCount: 3}, sz)
	return TunnelServer_registerTunnel_Params_List{l}, err
}

func (s TunnelServer_registerTunnel_Params_List) At(i int) TunnelServer_registerTunnel_Params {
	return TunnelServer_registerTunnel_Params{s.List.Struct(i)}
}

func (s TunnelServer_registerTunnel_Params_List) Set(i int, v TunnelServer_registerTunnel_Params) error {
	return s.List.SetStruct(i, v.Struct)
}

func (s TunnelServer_registerTunnel_Params_List) String() string {
	str, _ := text.MarshalList(0xb70431c0dc014915, s.List)
	return str
}

// TunnelServer_registerTunnel_Params_Promise is a wrapper for a TunnelServer_registerTunnel_Params promised by a client call.
type TunnelServer_registerTunnel_Params_Promise struct{ *capnp.Pipeline }

func (p TunnelServer_registerTunnel_Params_Promise) Struct() (TunnelServer_registerTunnel_Params, error) {
	s, err := p.Pipeline.Struct()
	return TunnelServer_registerTunnel_Params{s}, err
}

func (p TunnelServer_registerTunnel_Params_Promise) Options() RegistrationOptions_Promise {
	return RegistrationOptions_Promise{Pipeline: p.Pipeline.GetPipeline(2)}
}

type TunnelServer_registerTunnel_Results struct{ capnp.Struct }

// TunnelServer_registerTunnel_Results_TypeID is the unique identifier for the type TunnelServer_registerTunnel_Results.
const TunnelServer_registerTunnel_Results_TypeID = 0xf2c122394f447e8e

func NewTunnelServer_registerTunnel_Results(s *capnp.Segment) (TunnelServer_registerTunnel_Results, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 1})
	return TunnelServer_registerTunnel_Results{st}, err
}

func NewRootTunnelServer_registerTunnel_Results(s *capnp.Segment) (TunnelServer_registerTunnel_Results, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 1})
	return TunnelServer_registerTunnel_Results{st}, err
}

func ReadRootTunnelServer_registerTunnel_Results(msg *capnp.Message) (TunnelServer_registerTunnel_Results, error) {
	root, err := msg.RootPtr()
	return TunnelServer_registerTunnel_Results{root.Struct()}, err
}

func (s TunnelServer_registerTunnel_Results) String() string {
	str, _ := text.Marshal(0xf2c122394f447e8e, s.Struct)
	return str
}

func (s TunnelServer_registerTunnel_Results) Result() (TunnelRegistration, error) {
	p, err := s.Struct.Ptr(0)
	return TunnelRegistration{Struct: p.Struct()}, err
}

func (s TunnelServer_registerTunnel_Results) HasResult() bool {
	p, err := s.Struct.Ptr(0)
	return p.IsValid() || err != nil
}

func (s TunnelServer_registerTunnel_Results) SetResult(v TunnelRegistration) error {
	return s.Struct.SetPtr(0, v.Struct.ToPtr())
}

// NewResult sets the result field to a newly
// allocated TunnelRegistration struct, preferring placement in s's segment.
func (s TunnelServer_registerTunnel_Results) NewResult() (TunnelRegistration, error) {
	ss, err := NewTunnelRegistration(s.Struct.Segment())
	if err != nil {
		return TunnelRegistration{}, err
	}
	err = s.Struct.SetPtr(0, ss.Struct.ToPtr())
	return ss, err
}

// TunnelServer_registerTunnel_Results_List is a list of TunnelServer_registerTunnel_Results.
type TunnelServer_registerTunnel_Results_List struct{ capnp.List }

// NewTunnelServer_registerTunnel_Results creates a new list of TunnelServer_registerTunnel_Results.
func NewTunnelServer_registerTunnel_Results_List(s *capnp.Segment, sz int32) (TunnelServer_registerTunnel_Results_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 0, PointerCount: 1}, sz)
	return TunnelServer_registerTunnel_Results_List{l}, err
}

func (s TunnelServer_registerTunnel_Results_List) At(i int) TunnelServer_registerTunnel_Results {
	return TunnelServer_registerTunnel_Results{s.List.Struct(i)}
}

func (s TunnelServer_registerTunnel_Results_List) Set(i int, v TunnelServer_registerTunnel_Results) error {
	return s.List.SetStruct(i, v.Struct)
}

func (s TunnelServer_registerTunnel_Results_List) String() string {
	str, _ := text.MarshalList(0xf2c122394f447e8e, s.List)
	return str
}

// TunnelServer_registerTunnel_Results_Promise is a wrapper for a TunnelServer_registerTunnel_Results promised by a client call.
type TunnelServer_registerTunnel_Results_Promise struct{ *capnp.Pipeline }

func (p TunnelServer_registerTunnel_Results_Promise) Struct() (TunnelServer_registerTunnel_Results, error) {
	s, err := p.Pipeline.Struct()
	return TunnelServer_registerTunnel_Results{s}, err
}

func (p TunnelServer_registerTunnel_Results_Promise) Result() TunnelRegistration_Promise {
	return TunnelRegistration_Promise{Pipeline: p.Pipeline.GetPipeline(0)}
}

type TunnelServer_getServerInfo_Params struct{ capnp.Struct }

// TunnelServer_getServerInfo_Params_TypeID is the unique identifier for the type TunnelServer_getServerInfo_Params.
const TunnelServer_getServerInfo_Params_TypeID = 0xdc3ed6801961e502

func NewTunnelServer_getServerInfo_Params(s *capnp.Segment) (TunnelServer_getServerInfo_Params, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 0})
	return TunnelServer_getServerInfo_Params{st}, err
}

func NewRootTunnelServer_getServerInfo_Params(s *capnp.Segment) (TunnelServer_getServerInfo_Params, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 0})
	return TunnelServer_getServerInfo_Params{st}, err
}

func ReadRootTunnelServer_getServerInfo_Params(msg *capnp.Message) (TunnelServer_getServerInfo_Params, error) {
	root, err := msg.RootPtr()
	return TunnelServer_getServerInfo_Params{root.Struct()}, err
}

func (s TunnelServer_getServerInfo_Params) String() string {
	str, _ := text.Marshal(0xdc3ed6801961e502, s.Struct)
	return str
}

// TunnelServer_getServerInfo_Params_List is a list of TunnelServer_getServerInfo_Params.
type TunnelServer_getServerInfo_Params_List struct{ capnp.List }

// NewTunnelServer_getServerInfo_Params creates a new list of TunnelServer_getServerInfo_Params.
func NewTunnelServer_getServerInfo_Params_List(s *capnp.Segment, sz int32) (TunnelServer_getServerInfo_Params_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 0, PointerCount: 0}, sz)
	return TunnelServer_getServerInfo_Params_List{l}, err
}

func (s TunnelServer_getServerInfo_Params_List) At(i int) TunnelServer_getServerInfo_Params {
	return TunnelServer_getServerInfo_Params{s.List.Struct(i)}
}

func (s TunnelServer_getServerInfo_Params_List) Set(i int, v TunnelServer_getServerInfo_Params) error {
	return s.List.SetStruct(i, v.Struct)
}

func (s TunnelServer_getServerInfo_Params_List) String() string {
	str, _ := text.MarshalList(0xdc3ed6801961e502, s.List)
	return str
}

// TunnelServer_getServerInfo_Params_Promise is a wrapper for a TunnelServer_getServerInfo_Params promised by a client call.
type TunnelServer_getServerInfo_Params_Promise struct{ *capnp.Pipeline }

func (p TunnelServer_getServerInfo_Params_Promise) Struct() (TunnelServer_getServerInfo_Params, error) {
	s, err := p.Pipeline.Struct()
	return TunnelServer_getServerInfo_Params{s}, err
}

type TunnelServer_getServerInfo_Results struct{ capnp.Struct }

// TunnelServer_getServerInfo_Results_TypeID is the unique identifier for the type TunnelServer_getServerInfo_Results.
const TunnelServer_getServerInfo_Results_TypeID = 0xe3e37d096a5b564e

func NewTunnelServer_getServerInfo_Results(s *capnp.Segment) (TunnelServer_getServerInfo_Results, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 1})
	return TunnelServer_getServerInfo_Results{st}, err
}

func NewRootTunnelServer_getServerInfo_Results(s *capnp.Segment) (TunnelServer_getServerInfo_Results, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 1})
	return TunnelServer_getServerInfo_Results{st}, err
}

func ReadRootTunnelServer_getServerInfo_Results(msg *capnp.Message) (TunnelServer_getServerInfo_Results, error) {
	root, err := msg.RootPtr()
	return TunnelServer_getServerInfo_Results{root.Struct()}, err
}

func (s TunnelServer_getServerInfo_Results) String() string {
	str, _ := text.Marshal(0xe3e37d096a5b564e, s.Struct)
	return str
}

func (s TunnelServer_getServerInfo_Results) Result() (ServerInfo, error) {
	p, err := s.Struct.Ptr(0)
	return ServerInfo{Struct: p.Struct()}, err
}

func (s TunnelServer_getServerInfo_Results) HasResult() bool {
	p, err := s.Struct.Ptr(0)
	return p.IsValid() || err != nil
}

func (s TunnelServer_getServerInfo_Results) SetResult(v ServerInfo) error {
	return s.Struct.SetPtr(0, v.Struct.ToPtr())
}

// NewResult sets the result field to a newly
// allocated ServerInfo struct, preferring placement in s's segment.
func (s TunnelServer_getServerInfo_Results) NewResult() (ServerInfo, error) {
	ss, err := NewServerInfo(s.Struct.Segment())
	if err != nil {
		return ServerInfo{}, err
	}
	err = s.Struct.SetPtr(0, ss.Struct.ToPtr())
	return ss, err
}

// TunnelServer_getServerInfo_Results_List is a list of TunnelServer_getServerInfo_Results.
type TunnelServer_getServerInfo_Results_List struct{ capnp.List }

// NewTunnelServer_getServerInfo_Results creates a new list of TunnelServer_getServerInfo_Results.
func NewTunnelServer_getServerInfo_Results_List(s *capnp.Segment, sz int32) (TunnelServer_getServerInfo_Results_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 0, PointerCount: 1}, sz)
	return TunnelServer_getServerInfo_Results_List{l}, err
}

func (s TunnelServer_getServerInfo_Results_List) At(i int) TunnelServer_getServerInfo_Results {
	return TunnelServer_getServerInfo_Results{s.List.Struct(i)}
}

func (s TunnelServer_getServerInfo_Results_List) Set(i int, v TunnelServer_getServerInfo_Results) error {
	return s.List.SetStruct(i, v.Struct)
}

func (s TunnelServer_getServerInfo_Results_List) String() string {
	str, _ := text.MarshalList(0xe3e37d096a5b564e, s.List)
	return str
}

// TunnelServer_getServerInfo_Results_Promise is a wrapper for a TunnelServer_getServerInfo_Results promised by a client call.
type TunnelServer_getServerInfo_Results_Promise struct{ *capnp.Pipeline }

func (p TunnelServer_getServerInfo_Results_Promise) Struct() (TunnelServer_getServerInfo_Results, error) {
	s, err := p.Pipeline.Struct()
	return TunnelServer_getServerInfo_Results{s}, err
}

func (p TunnelServer_getServerInfo_Results_Promise) Result() ServerInfo_Promise {
	return ServerInfo_Promise{Pipeline: p.Pipeline.GetPipeline(0)}
}

type TunnelServer_unregisterTunnel_Params struct{ capnp.Struct }

// TunnelServer_unregisterTunnel_Params_TypeID is the unique identifier for the type TunnelServer_unregisterTunnel_Params.
const TunnelServer_unregisterTunnel_Params_TypeID = 0x9b87b390babc2ccf

func NewTunnelServer_unregisterTunnel_Params(s *capnp.Segment) (TunnelServer_unregisterTunnel_Params, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 8, PointerCount: 0})
	return TunnelServer_unregisterTunnel_Params{st}, err
}

func NewRootTunnelServer_unregisterTunnel_Params(s *capnp.Segment) (TunnelServer_unregisterTunnel_Params, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 8, PointerCount: 0})
	return TunnelServer_unregisterTunnel_Params{st}, err
}

func ReadRootTunnelServer_unregisterTunnel_Params(msg *capnp.Message) (TunnelServer_unregisterTunnel_Params, error) {
	root, err := msg.RootPtr()
	return TunnelServer_unregisterTunnel_Params{root.Struct()}, err
}

func (s TunnelServer_unregisterTunnel_Params) String() string {
	str, _ := text.Marshal(0x9b87b390babc2ccf, s.Struct)
	return str
}

func (s TunnelServer_unregisterTunnel_Params) GracePeriodNanoSec() int64 {
	return int64(s.Struct.Uint64(0))
}

func (s TunnelServer_unregisterTunnel_Params) SetGracePeriodNanoSec(v int64) {
	s.Struct.SetUint64(0, uint64(v))
}

// TunnelServer_unregisterTunnel_Params_List is a list of TunnelServer_unregisterTunnel_Params.
type TunnelServer_unregisterTunnel_Params_List struct{ capnp.List }

// NewTunnelServer_unregisterTunnel_Params creates a new list of TunnelServer_unregisterTunnel_Params.
func NewTunnelServer_unregisterTunnel_Params_List(s *capnp.Segment, sz int32) (TunnelServer_unregisterTunnel_Params_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 8, PointerCount: 0}, sz)
	return TunnelServer_unregisterTunnel_Params_List{l}, err
}

func (s TunnelServer_unregisterTunnel_Params_List) At(i int) TunnelServer_unregisterTunnel_Params {
	return TunnelServer_unregisterTunnel_Params{s.List.Struct(i)}
}

func (s TunnelServer_unregisterTunnel_Params_List) Set(i int, v TunnelServer_unregisterTunnel_Params) error {
	return s.List.SetStruct(i, v.Struct)
}

func (s TunnelServer_unregisterTunnel_Params_List) String() string {
	str, _ := text.MarshalList(0x9b87b390babc2ccf, s.List)
	return str
}

// TunnelServer_unregisterTunnel_Params_Promise is a wrapper for a TunnelServer_unregisterTunnel_Params promised by a client call.
type TunnelServer_unregisterTunnel_Params_Promise struct{ *capnp.Pipeline }

func (p TunnelServer_unregisterTunnel_Params_Promise) Struct() (TunnelServer_unregisterTunnel_Params, error) {
	s, err := p.Pipeline.Struct()
	return TunnelServer_unregisterTunnel_Params{s}, err
}

type TunnelServer_unregisterTunnel_Results struct{ capnp.Struct }

// TunnelServer_unregisterTunnel_Results_TypeID is the unique identifier for the type TunnelServer_unregisterTunnel_Results.
const TunnelServer_unregisterTunnel_Results_TypeID = 0xa29a916d4ebdd894

func NewTunnelServer_unregisterTunnel_Results(s *capnp.Segment) (TunnelServer_unregisterTunnel_Results, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 0})
	return TunnelServer_unregisterTunnel_Results{st}, err
}

func NewRootTunnelServer_unregisterTunnel_Results(s *capnp.Segment) (TunnelServer_unregisterTunnel_Results, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 0})
	return TunnelServer_unregisterTunnel_Results{st}, err
}

func ReadRootTunnelServer_unregisterTunnel_Results(msg *capnp.Message) (TunnelServer_unregisterTunnel_Results, error) {
	root, err := msg.RootPtr()
	return TunnelServer_unregisterTunnel_Results{root.Struct()}, err
}

func (s TunnelServer_unregisterTunnel_Results) String() string {
	str, _ := text.Marshal(0xa29a916d4ebdd894, s.Struct)
	return str
}

// TunnelServer_unregisterTunnel_Results_List is a list of TunnelServer_unregisterTunnel_Results.
type TunnelServer_unregisterTunnel_Results_List struct{ capnp.List }

// NewTunnelServer_unregisterTunnel_Results creates a new list of TunnelServer_unregisterTunnel_Results.
func NewTunnelServer_unregisterTunnel_Results_List(s *capnp.Segment, sz int32) (TunnelServer_unregisterTunnel_Results_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 0, PointerCount: 0}, sz)
	return TunnelServer_unregisterTunnel_Results_List{l}, err
}

func (s TunnelServer_unregisterTunnel_Results_List) At(i int) TunnelServer_unregisterTunnel_Results {
	return TunnelServer_unregisterTunnel_Results{s.List.Struct(i)}
}

func (s TunnelServer_unregisterTunnel_Results_List) Set(i int, v TunnelServer_unregisterTunnel_Results) error {
	return s.List.SetStruct(i, v.Struct)
}

func (s TunnelServer_unregisterTunnel_Results_List) String() string {
	str, _ := text.MarshalList(0xa29a916d4ebdd894, s.List)
	return str
}

// TunnelServer_unregisterTunnel_Results_Promise is a wrapper for a TunnelServer_unregisterTunnel_Results promised by a client call.
type TunnelServer_unregisterTunnel_Results_Promise struct{ *capnp.Pipeline }

func (p TunnelServer_unregisterTunnel_Results_Promise) Struct() (TunnelServer_unregisterTunnel_Results, error) {
	s, err := p.Pipeline.Struct()
	return TunnelServer_unregisterTunnel_Results{s}, err
}

type TunnelServer_obsoleteDeclarativeTunnelConnect_Params struct{ capnp.Struct }

// TunnelServer_obsoleteDeclarativeTunnelConnect_Params_TypeID is the unique identifier for the type TunnelServer_obsoleteDeclarativeTunnelConnect_Params.
const TunnelServer_obsoleteDeclarativeTunnelConnect_Params_TypeID = 0xa766b24d4fe5da35

func NewTunnelServer_obsoleteDeclarativeTunnelConnect_Params(s *capnp.Segment) (TunnelServer_obsoleteDeclarativeTunnelConnect_Params, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 0})
	return TunnelServer_obsoleteDeclarativeTunnelConnect_Params{st}, err
}

func NewRootTunnelServer_obsoleteDeclarativeTunnelConnect_Params(s *capnp.Segment) (TunnelServer_obsoleteDeclarativeTunnelConnect_Params, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 0})
	return TunnelServer_obsoleteDeclarativeTunnelConnect_Params{st}, err
}

func ReadRootTunnelServer_obsoleteDeclarativeTunnelConnect_Params(msg *capnp.Message) (TunnelServer_obsoleteDeclarativeTunnelConnect_Params, error) {
	root, err := msg.RootPtr()
	return TunnelServer_obsoleteDeclarativeTunnelConnect_Params{root.Struct()}, err
}

func (s TunnelServer_obsoleteDeclarativeTunnelConnect_Params) String() string {
	str, _ := text.Marshal(0xa766b24d4fe5da35, s.Struct)
	return str
}

// TunnelServer_obsoleteDeclarativeTunnelConnect_Params_List is a list of TunnelServer_obsoleteDeclarativeTunnelConnect_Params.
type TunnelServer_obsoleteDeclarativeTunnelConnect_Params_List struct{ capnp.List }

// NewTunnelServer_obsoleteDeclarativeTunnelConnect_Params creates a new list of TunnelServer_obsoleteDeclarativeTunnelConnect_Params.
func NewTunnelServer_obsoleteDeclarativeTunnelConnect_Params_List(s *capnp.Segment, sz int32) (TunnelServer_obsoleteDeclarativeTunnelConnect_Params_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 0, PointerCount: 0}, sz)
	return TunnelServer_obsoleteDeclarativeTunnelConnect_Params_List{l}, err
}

func (s TunnelServer_obsoleteDeclarativeTunnelConnect_Params_List) At(i int) TunnelServer_obsoleteDeclarativeTunnelConnect_Params {
	return TunnelServer_obsoleteDeclarativeTunnelConnect_Params{s.List.Struct(i)}
}

func (s TunnelServer_obsoleteDeclarativeTunnelConnect_Params_List) Set(i int, v TunnelServer_obsoleteDeclarativeTunnelConnect_Params) error {
	return s.List.SetStruct(i, v.Struct)
}

func (s TunnelServer_obsoleteDeclarativeTunnelConnect_Params_List) String() string {
	str, _ := text.MarshalList(0xa766b24d4fe5da35, s.List)
	return str
}

// TunnelServer_obsoleteDeclarativeTunnelConnect_Params_Promise is a wrapper for a TunnelServer_obsoleteDeclarativeTunnelConnect_Params promised by a client call.
type TunnelServer_obsoleteDeclarativeTunnelConnect_Params_Promise struct{ *capnp.Pipeline }

func (p TunnelServer_obsoleteDeclarativeTunnelConnect_Params_Promise) Struct() (TunnelServer_obsoleteDeclarativeTunnelConnect_Params, error) {
	s, err := p.Pipeline.Struct()
	return TunnelServer_obsoleteDeclarativeTunnelConnect_Params{s}, err
}

type TunnelServer_obsoleteDeclarativeTunnelConnect_Results struct{ capnp.Struct }

// TunnelServer_obsoleteDeclarativeTunnelConnect_Results_TypeID is the unique identifier for the type TunnelServer_obsoleteDeclarativeTunnelConnect_Results.
const TunnelServer_obsoleteDeclarativeTunnelConnect_Results_TypeID = 0xfeac5c8f4899ef7c

func NewTunnelServer_obsoleteDeclarativeTunnelConnect_Results(s *capnp.Segment) (TunnelServer_obsoleteDeclarativeTunnelConnect_Results, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 0})
	return TunnelServer_obsoleteDeclarativeTunnelConnect_Results{st}, err
}

func NewRootTunnelServer_obsoleteDeclarativeTunnelConnect_Results(s *capnp.Segment) (TunnelServer_obsoleteDeclarativeTunnelConnect_Results, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 0})
	return TunnelServer_obsoleteDeclarativeTunnelConnect_Results{st}, err
}

func ReadRootTunnelServer_obsoleteDeclarativeTunnelConnect_Results(msg *capnp.Message) (TunnelServer_obsoleteDeclarativeTunnelConnect_Results, error) {
	root, err := msg.RootPtr()
	return TunnelServer_obsoleteDeclarativeTunnelConnect_Results{root.Struct()}, err
}

func (s TunnelServer_obsoleteDeclarativeTunnelConnect_Results) String() string {
	str, _ := text.Marshal(0xfeac5c8f4899ef7c, s.Struct)
	return str
}

// TunnelServer_obsoleteDeclarativeTunnelConnect_Results_List is a list of TunnelServer_obsoleteDeclarativeTunnelConnect_Results.
type TunnelServer_obsoleteDeclarativeTunnelConnect_Results_List struct{ capnp.List }

// NewTunnelServer_obsoleteDeclarativeTunnelConnect_Results creates a new list of TunnelServer_obsoleteDeclarativeTunnelConnect_Results.
func NewTunnelServer_obsoleteDeclarativeTunnelConnect_Results_List(s *capnp.Segment, sz int32) (TunnelServer_obsoleteDeclarativeTunnelConnect_Results_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 0, PointerCount: 0}, sz)
	return TunnelServer_obsoleteDeclarativeTunnelConnect_Results_List{l}, err
}

func (s TunnelServer_obsoleteDeclarativeTunnelConnect_Results_List) At(i int) TunnelServer_obsoleteDeclarativeTunnelConnect_Results {
	return TunnelServer_obsoleteDeclarativeTunnelConnect_Results{s.List.Struct(i)}
}

func (s TunnelServer_obsoleteDeclarativeTunnelConnect_Results_List) Set(i int, v TunnelServer_obsoleteDeclarativeTunnelConnect_Results) error {
	return s.List.SetStruct(i, v.Struct)
}

func (s TunnelServer_obsoleteDeclarativeTunnelConnect_Results_List) String() string {
	str, _ := text.MarshalList(0xfeac5c8f4899ef7c, s.List)
	return str
}

// TunnelServer_obsoleteDeclarativeTunnelConnect_Results_Promise is a wrapper for a TunnelServer_obsoleteDeclarativeTunnelConnect_Results promised by a client call.
type TunnelServer_obsoleteDeclarativeTunnelConnect_Results_Promise struct{ *capnp.Pipeline }

func (p TunnelServer_obsoleteDeclarativeTunnelConnect_Results_Promise) Struct() (TunnelServer_obsoleteDeclarativeTunnelConnect_Results, error) {
	s, err := p.Pipeline.Struct()
	return TunnelServer_obsoleteDeclarativeTunnelConnect_Results{s}, err
}

type TunnelServer_authenticate_Params struct{ capnp.Struct }

// TunnelServer_authenticate_Params_TypeID is the unique identifier for the type TunnelServer_authenticate_Params.
const TunnelServer_authenticate_Params_TypeID = 0x85c8cea1ab1894f3

func NewTunnelServer_authenticate_Params(s *capnp.Segment) (TunnelServer_authenticate_Params, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 3})
	return TunnelServer_authenticate_Params{st}, err
}

func NewRootTunnelServer_authenticate_Params(s *capnp.Segment) (TunnelServer_authenticate_Params, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 3})
	return TunnelServer_authenticate_Params{st}, err
}

func ReadRootTunnelServer_authenticate_Params(msg *capnp.Message) (TunnelServer_authenticate_Params, error) {
	root, err := msg.RootPtr()
	return TunnelServer_authenticate_Params{root.Struct()}, err
}

func (s TunnelServer_authenticate_Params) String() string {
	str, _ := text.Marshal(0x85c8cea1ab1894f3, s.Struct)
	return str
}

func (s TunnelServer_authenticate_Params) OriginCert() ([]byte, error) {
	p, err := s.Struct.Ptr(0)
	return []byte(p.Data()), err
}

func (s TunnelServer_authenticate_Params) HasOriginCert() bool {
	p, err := s.Struct.Ptr(0)
	return p.IsValid() || err != nil
}

func (s TunnelServer_authenticate_Params) SetOriginCert(v []byte) error {
	return s.Struct.SetData(0, v)
}

func (s TunnelServer_authenticate_Params) Hostname() (string, error) {
	p, err := s.Struct.Ptr(1)
	return p.Text(), err
}

func (s TunnelServer_authenticate_Params) HasHostname() bool {
	p, err := s.Struct.Ptr(1)
	return p.IsValid() || err != nil
}

func (s TunnelServer_authenticate_Params) HostnameBytes() ([]byte, error) {
	p, err := s.Struct.Ptr(1)
	return p.TextBytes(), err
}

func (s TunnelServer_authenticate_Params) SetHostname(v string) error {
	return s.Struct.SetText(1, v)
}

func (s TunnelServer_authenticate_Params) Options() (RegistrationOptions, error) {
	p, err := s.Struct.Ptr(2)
	return RegistrationOptions{Struct: p.Struct()}, err
}

func (s TunnelServer_authenticate_Params) HasOptions() bool {
	p, err := s.Struct.Ptr(2)
	return p.IsValid() || err != nil
}

func (s TunnelServer_authenticate_Params) SetOptions(v RegistrationOptions) error {
	return s.Struct.SetPtr(2, v.Struct.ToPtr())
}

// NewOptions sets the options field to a newly
// allocated RegistrationOptions struct, preferring placement in s's segment.
func (s TunnelServer_authenticate_Params) NewOptions() (RegistrationOptions, error) {
	ss, err := NewRegistrationOptions(s.Struct.Segment())
	if err != nil {
		return RegistrationOptions{}, err
	}
	err = s.Struct.SetPtr(2, ss.Struct.ToPtr())
	return ss, err
}

// TunnelServer_authenticate_Params_List is a list of TunnelServer_authenticate_Params.
type TunnelServer_authenticate_Params_List struct{ capnp.List }

// NewTunnelServer_authenticate_Params creates a new list of TunnelServer_authenticate_Params.
func NewTunnelServer_authenticate_Params_List(s *capnp.Segment, sz int32) (TunnelServer_authenticate_Params_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 0, PointerCount: 3}, sz)
	return TunnelServer_authenticate_Params_List{l}, err
}

func (s TunnelServer_authenticate_Params_List) At(i int) TunnelServer_authenticate_Params {
	return TunnelServer_authenticate_Params{s.List.Struct(i)}
}

func (s TunnelServer_authenticate_Params_List) Set(i int, v TunnelServer_authenticate_Params) error {
	return s.List.SetStruct(i, v.Struct)
}

func (s TunnelServer_authenticate_Params_List) String() string {
	str, _ := text.MarshalList(0x85c8cea1ab1894f3, s.List)
	return str
}

// TunnelServer_authenticate_Params_Promise is a wrapper for a TunnelServer_authenticate_Params promised by a client call.
type TunnelServer_authenticate_Params_Promise struct{ *capnp.Pipeline }

func (p TunnelServer_authenticate_Params_Promise) Struct() (TunnelServer_authenticate_Params, error) {
	s, err := p.Pipeline.Struct()
	return TunnelServer_authenticate_Params{s}, err
}

func (p TunnelServer_authenticate_Params_Promise) Options() RegistrationOptions_Promise {
	return RegistrationOptions_Promise{Pipeline: p.Pipeline.GetPipeline(2)}
}

type TunnelServer_authenticate_Results struct{ capnp.Struct }

// TunnelServer_authenticate_Results_TypeID is the unique identifier for the type TunnelServer_authenticate_Results.
const TunnelServer_authenticate_Results_TypeID = 0xfc5edf80e39c0796

func NewTunnelServer_authenticate_Results(s *capnp.Segment) (TunnelServer_authenticate_Results, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 1})
	return TunnelServer_authenticate_Results{st}, err
}

func NewRootTunnelServer_authenticate_Results(s *capnp.Segment) (TunnelServer_authenticate_Results, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 1})
	return TunnelServer_authenticate_Results{st}, err
}

func ReadRootTunnelServer_authenticate_Results(msg *capnp.Message) (TunnelServer_authenticate_Results, error) {
	root, err := msg.RootPtr()
	return TunnelServer_authenticate_Results{root.Struct()}, err
}

func (s TunnelServer_authenticate_Results) String() string {
	str, _ := text.Marshal(0xfc5edf80e39c0796, s.Struct)
	return str
}

func (s TunnelServer_authenticate_Results) Result() (AuthenticateResponse, error) {
	p, err := s.Struct.Ptr(0)
	return AuthenticateResponse{Struct: p.Struct()}, err
}

func (s TunnelServer_authenticate_Results) HasResult() bool {
	p, err := s.Struct.Ptr(0)
	return p.IsValid() || err != nil
}

func (s TunnelServer_authenticate_Results) SetResult(v AuthenticateResponse) error {
	return s.Struct.SetPtr(0, v.Struct.ToPtr())
}

// NewResult sets the result field to a newly
// allocated AuthenticateResponse struct, preferring placement in s's segment.
func (s TunnelServer_authenticate_Results) NewResult() (AuthenticateResponse, error) {
	ss, err := NewAuthenticateResponse(s.Struct.Segment())
	if err != nil {
		return AuthenticateResponse{}, err
	}
	err = s.Struct.SetPtr(0, ss.Struct.ToPtr())
	return ss, err
}

// TunnelServer_authenticate_Results_List is a list of TunnelServer_authenticate_Results.
type TunnelServer_authenticate_Results_List struct{ capnp.List }

// NewTunnelServer_authenticate_Results creates a new list of TunnelServer_authenticate_Results.
func NewTunnelServer_authenticate_Results_List(s *capnp.Segment, sz int32) (TunnelServer_authenticate_Results_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 0, PointerCount: 1}, sz)
	return TunnelServer_authenticate_Results_List{l}, err
}

func (s TunnelServer_authenticate_Results_List) At(i int) TunnelServer_authenticate_Results {
	return TunnelServer_authenticate_Results{s.List.Struct(i)}
}

func (s TunnelServer_authenticate_Results_List) Set(i int, v TunnelServer_authenticate_Results) error {
	return s.List.SetStruct(i, v.Struct)
}

func (s TunnelServer_authenticate_Results_List) String() string {
	str, _ := text.MarshalList(0xfc5edf80e39c0796, s.List)
	return str
}

// TunnelServer_authenticate_Results_Promise is a wrapper for a TunnelServer_authenticate_Results promised by a client call.
type TunnelServer_authenticate_Results_Promise struct{ *capnp.Pipeline }

func (p TunnelServer_authenticate_Results_Promise) Struct() (TunnelServer_authenticate_Results, error) {
	s, err := p.Pipeline.Struct()
	return TunnelServer_authenticate_Results{s}, err
}

func (p TunnelServer_authenticate_Results_Promise) Result() AuthenticateResponse_Promise {
	return AuthenticateResponse_Promise{Pipeline: p.Pipeline.GetPipeline(0)}
}

type TunnelServer_reconnectTunnel_Params struct{ capnp.Struct }

// TunnelServer_reconnectTunnel_Params_TypeID is the unique identifier for the type TunnelServer_reconnectTunnel_Params.
const TunnelServer_reconnectTunnel_Params_TypeID = 0xa353a3556df74984

func NewTunnelServer_reconnectTunnel_Params(s *capnp.Segment) (TunnelServer_reconnectTunnel_Params, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 5})
	return TunnelServer_reconnectTunnel_Params{st}, err
}

func NewRootTunnelServer_reconnectTunnel_Params(s *capnp.Segment) (TunnelServer_reconnectTunnel_Params, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 5})
	return TunnelServer_reconnectTunnel_Params{st}, err
}

func ReadRootTunnelServer_reconnectTunnel_Params(msg *capnp.Message) (TunnelServer_reconnectTunnel_Params, error) {
	root, err := msg.RootPtr()
	return TunnelServer_reconnectTunnel_Params{root.Struct()}, err
}

func (s TunnelServer_reconnectTunnel_Params) String() string {
	str, _ := text.Marshal(0xa353a3556df74984, s.Struct)
	return str
}

func (s TunnelServer_reconnectTunnel_Params) Jwt() ([]byte, error) {
	p, err := s.Struct.Ptr(0)
	return []byte(p.Data()), err
}

func (s TunnelServer_reconnectTunnel_Params) HasJwt() bool {
	p, err := s.Struct.Ptr(0)
	return p.IsValid() || err != nil
}

func (s TunnelServer_reconnectTunnel_Params) SetJwt(v []byte) error {
	return s.Struct.SetData(0, v)
}

func (s TunnelServer_reconnectTunnel_Params) EventDigest() ([]byte, error) {
	p, err := s.Struct.Ptr(1)
	return []byte(p.Data()), err
}

func (s TunnelServer_reconnectTunnel_Params) HasEventDigest() bool {
	p, err := s.Struct.Ptr(1)
	return p.IsValid() || err != nil
}

func (s TunnelServer_reconnectTunnel_Params) SetEventDigest(v []byte) error {
	return s.Struct.SetData(1, v)
}

func (s TunnelServer_reconnectTunnel_Params) ConnDigest() ([]byte, error) {
	p, err := s.Struct.Ptr(2)
	return []byte(p.Data()), err
}

func (s TunnelServer_reconnectTunnel_Params) HasConnDigest() bool {
	p, err := s.Struct.Ptr(2)
	return p.IsValid() || err != nil
}

func (s TunnelServer_reconnectTunnel_Params) SetConnDigest(v []byte) error {
	return s.Struct.SetData(2, v)
}

func (s TunnelServer_reconnectTunnel_Params) Hostname() (string, error) {
	p, err := s.Struct.Ptr(3)
	return p.Text(), err
}

func (s TunnelServer_reconnectTunnel_Params) HasHostname() bool {
	p, err := s.Struct.Ptr(3)
	return p.IsValid() || err != nil
}

func (s TunnelServer_reconnectTunnel_Params) HostnameBytes() ([]byte, error) {
	p, err := s.Struct.Ptr(3)
	return p.TextBytes(), err
}

func (s TunnelServer_reconnectTunnel_Params) SetHostname(v string) error {
	return s.Struct.SetText(3, v)
}

func (s TunnelServer_reconnectTunnel_Params) Options() (RegistrationOptions, error) {
	p, err := s.Struct.Ptr(4)
	return RegistrationOptions{Struct: p.Struct()}, err
}

func (s TunnelServer_reconnectTunnel_Params) HasOptions() bool {
	p, err := s.Struct.Ptr(4)
	return p.IsValid() || err != nil
}

func (s TunnelServer_reconnectTunnel_Params) SetOptions(v RegistrationOptions) error {
	return s.Struct.SetPtr(4, v.Struct.ToPtr())
}

// NewOptions sets the options field to a newly
// allocated RegistrationOptions struct, preferring placement in s's segment.
func (s TunnelServer_reconnectTunnel_Params) NewOptions() (RegistrationOptions, error) {
	ss, err := NewRegistrationOptions(s.Struct.Segment())
	if err != nil {
		return RegistrationOptions{}, err
	}
	err = s.Struct.SetPtr(4, ss.Struct.ToPtr())
	return ss, err
}

// TunnelServer_reconnectTunnel_Params_List is a list of TunnelServer_reconnectTunnel_Params.
type TunnelServer_reconnectTunnel_Params_List struct{ capnp.List }

// NewTunnelServer_reconnectTunnel_Params creates a new list of TunnelServer_reconnectTunnel_Params.
func NewTunnelServer_reconnectTunnel_Params_List(s *capnp.Segment, sz int32) (TunnelServer_reconnectTunnel_Params_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 0, PointerCount: 5}, sz)
	return TunnelServer_reconnectTunnel_Params_List{l}, err
}

func (s TunnelServer_reconnectTunnel_Params_List) At(i int) TunnelServer_reconnectTunnel_Params {
	return TunnelServer_reconnectTunnel_Params{s.List.Struct(i)}
}

func (s TunnelServer_reconnectTunnel_Params_List) Set(i int, v TunnelServer_reconnectTunnel_Params) error {
	return s.List.SetStruct(i, v.Struct)
}

func (s TunnelServer_reconnectTunnel_Params_List) String() string {
	str, _ := text.MarshalList(0xa353a3556df74984, s.List)
	return str
}

// TunnelServer_reconnectTunnel_Params_Promise is a wrapper for a TunnelServer_reconnectTunnel_Params promised by a client call.
type TunnelServer_reconnectTunnel_Params_Promise struct{ *capnp.Pipeline }

func (p TunnelServer_reconnectTunnel_Params_Promise) Struct() (TunnelServer_reconnectTunnel_Params, error) {
	s, err := p.Pipeline.Struct()
	return TunnelServer_reconnectTunnel_Params{s}, err
}

func (p TunnelServer_reconnectTunnel_Params_Promise) Options() RegistrationOptions_Promise {
	return RegistrationOptions_Promise{Pipeline: p.Pipeline.GetPipeline(4)}
}

type TunnelServer_reconnectTunnel_Results struct{ capnp.Struct }

// TunnelServer_reconnectTunnel_Results_TypeID is the unique identifier for the type TunnelServer_reconnectTunnel_Results.
const TunnelServer_reconnectTunnel_Results_TypeID = 0xd4d18de97bb12de3

func NewTunnelServer_reconnectTunnel_Results(s *capnp.Segment) (TunnelServer_reconnectTunnel_Results, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 1})
	return TunnelServer_reconnectTunnel_Results{st}, err
}

func NewRootTunnelServer_reconnectTunnel_Results(s *capnp.Segment) (TunnelServer_reconnectTunnel_Results, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 1})
	return TunnelServer_reconnectTunnel_Results{st}, err
}

func ReadRootTunnelServer_reconnectTunnel_Results(msg *capnp.Message) (TunnelServer_reconnectTunnel_Results, error) {
	root, err := msg.RootPtr()
	return TunnelServer_reconnectTunnel_Results{root.Struct()}, err
}

func (s TunnelServer_reconnectTunnel_Results) String() string {
	str, _ := text.Marshal(0xd4d18de97bb12de3, s.Struct)
	return str
}

func (s TunnelServer_reconnectTunnel_Results) Result() (TunnelRegistration, error) {
	p, err := s.Struct.Ptr(0)
	return TunnelRegistration{Struct: p.Struct()}, err
}

func (s TunnelServer_reconnectTunnel_Results) HasResult() bool {
	p, err := s.Struct.Ptr(0)
	return p.IsValid() || err != nil
}

func (s TunnelServer_reconnectTunnel_Results) SetResult(v TunnelRegistration) error {
	return s.Struct.SetPtr(0, v.Struct.ToPtr())
}

// NewResult sets the result field to a newly
// allocated TunnelRegistration struct, preferring placement in s's segment.
func (s TunnelServer_reconnectTunnel_Results) NewResult() (TunnelRegistration, error) {
	ss, err := NewTunnelRegistration(s.Struct.Segment())
	if err != nil {
		return TunnelRegistration{}, err
	}
	err = s.Struct.SetPtr(0, ss.Struct.ToPtr())
	return ss, err
}

// TunnelServer_reconnectTunnel_Results_List is a list of TunnelServer_reconnectTunnel_Results.
type TunnelServer_reconnectTunnel_Results_List struct{ capnp.List }

// NewTunnelServer_reconnectTunnel_Results creates a new list of TunnelServer_reconnectTunnel_Results.
func NewTunnelServer_reconnectTunnel_Results_List(s *capnp.Segment, sz int32) (TunnelServer_reconnectTunnel_Results_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 0, PointerCount: 1}, sz)
	return TunnelServer_reconnectTunnel_Results_List{l}, err
}

func (s TunnelServer_reconnectTunnel_Results_List) At(i int) TunnelServer_reconnectTunnel_Results {
	return TunnelServer_reconnectTunnel_Results{s.List.Struct(i)}
}

func (s TunnelServer_reconnectTunnel_Results_List) Set(i int, v TunnelServer_reconnectTunnel_Results) error {
	return s.List.SetStruct(i, v.Struct)
}

func (s TunnelServer_reconnectTunnel_Results_List) String() string {
	str, _ := text.MarshalList(0xd4d18de97bb12de3, s.List)
	return str
}

// TunnelServer_reconnectTunnel_Results_Promise is a wrapper for a TunnelServer_reconnectTunnel_Results promised by a client call.
type TunnelServer_reconnectTunnel_Results_Promise struct{ *capnp.Pipeline }

func (p TunnelServer_reconnectTunnel_Results_Promise) Struct() (TunnelServer_reconnectTunnel_Results, error) {
	s, err := p.Pipeline.Struct()
	return TunnelServer_reconnectTunnel_Results{s}, err
}

func (p TunnelServer_reconnectTunnel_Results_Promise) Result() TunnelRegistration_Promise {
	return TunnelRegistration_Promise{Pipeline: p.Pipeline.GetPipeline(0)}
}

type RegisterUdpSessionResponse struct{ capnp.Struct }

// RegisterUdpSessionResponse_TypeID is the unique identifier for the type RegisterUdpSessionResponse.
const RegisterUdpSessionResponse_TypeID = 0xab6d5210c1f26687

func NewRegisterUdpSessionResponse(s *capnp.Segment) (RegisterUdpSessionResponse, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 1})
	return RegisterUdpSessionResponse{st}, err
}

func NewRootRegisterUdpSessionResponse(s *capnp.Segment) (RegisterUdpSessionResponse, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 1})
	return RegisterUdpSessionResponse{st}, err
}

func ReadRootRegisterUdpSessionResponse(msg *capnp.Message) (RegisterUdpSessionResponse, error) {
	root, err := msg.RootPtr()
	return RegisterUdpSessionResponse{root.Struct()}, err
}

func (s RegisterUdpSessionResponse) String() string {
	str, _ := text.Marshal(0xab6d5210c1f26687, s.Struct)
	return str
}

func (s RegisterUdpSessionResponse) Err() (string, error) {
	p, err := s.Struct.Ptr(0)
	return p.Text(), err
}

func (s RegisterUdpSessionResponse) HasErr() bool {
	p, err := s.Struct.Ptr(0)
	return p.IsValid() || err != nil
}

func (s RegisterUdpSessionResponse) ErrBytes() ([]byte, error) {
	p, err := s.Struct.Ptr(0)
	return p.TextBytes(), err
}

func (s RegisterUdpSessionResponse) SetErr(v string) error {
	return s.Struct.SetText(0, v)
}

// RegisterUdpSessionResponse_List is a list of RegisterUdpSessionResponse.
type RegisterUdpSessionResponse_List struct{ capnp.List }

// NewRegisterUdpSessionResponse creates a new list of RegisterUdpSessionResponse.
func NewRegisterUdpSessionResponse_List(s *capnp.Segment, sz int32) (RegisterUdpSessionResponse_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 0, PointerCount: 1}, sz)
	return RegisterUdpSessionResponse_List{l}, err
}

func (s RegisterUdpSessionResponse_List) At(i int) RegisterUdpSessionResponse {
	return RegisterUdpSessionResponse{s.List.Struct(i)}
}

func (s RegisterUdpSessionResponse_List) Set(i int, v RegisterUdpSessionResponse) error {
	return s.List.SetStruct(i, v.Struct)
}

func (s RegisterUdpSessionResponse_List) String() string {
	str, _ := text.MarshalList(0xab6d5210c1f26687, s.List)
	return str
}

// RegisterUdpSessionResponse_Promise is a wrapper for a RegisterUdpSessionResponse promised by a client call.
type RegisterUdpSessionResponse_Promise struct{ *capnp.Pipeline }

func (p RegisterUdpSessionResponse_Promise) Struct() (RegisterUdpSessionResponse, error) {
	s, err := p.Pipeline.Struct()
	return RegisterUdpSessionResponse{s}, err
}

type SessionManager struct{ Client capnp.Client }

// SessionManager_TypeID is the unique identifier for the type SessionManager.
const SessionManager_TypeID = 0x839445a59fb01686

func (c SessionManager) RegisterUdpSession(ctx context.Context, params func(SessionManager_registerUdpSession_Params) error, opts ...capnp.CallOption) SessionManager_registerUdpSession_Results_Promise {
	if c.Client == nil {
		return SessionManager_registerUdpSession_Results_Promise{Pipeline: capnp.NewPipeline(capnp.ErrorAnswer(capnp.ErrNullClient))}
	}
	call := &capnp.Call{
		Ctx: ctx,
		Method: capnp.Method{
			InterfaceID:   0x839445a59fb01686,
			MethodID:      0,
			InterfaceName: "tunnelrpc/tunnelrpc.capnp:SessionManager",
			MethodName:    "registerUdpSession",
		},
		Options: capnp.NewCallOptions(opts),
	}
	if params != nil {
		call.ParamsSize = capnp.ObjectSize{DataSize: 16, PointerCount: 2}
		call.ParamsFunc = func(s capnp.Struct) error { return params(SessionManager_registerUdpSession_Params{Struct: s}) }
	}
	return SessionManager_registerUdpSession_Results_Promise{Pipeline: capnp.NewPipeline(c.Client.Call(call))}
}
func (c SessionManager) UnregisterUdpSession(ctx context.Context, params func(SessionManager_unregisterUdpSession_Params) error, opts ...capnp.CallOption) SessionManager_unregisterUdpSession_Results_Promise {
	if c.Client == nil {
		return SessionManager_unregisterUdpSession_Results_Promise{Pipeline: capnp.NewPipeline(capnp.ErrorAnswer(capnp.ErrNullClient))}
	}
	call := &capnp.Call{
		Ctx: ctx,
		Method: capnp.Method{
			InterfaceID:   0x839445a59fb01686,
			MethodID:      1,
			InterfaceName: "tunnelrpc/tunnelrpc.capnp:SessionManager",
			MethodName:    "unregisterUdpSession",
		},
		Options: capnp.NewCallOptions(opts),
	}
	if params != nil {
		call.ParamsSize = capnp.ObjectSize{DataSize: 0, PointerCount: 2}
		call.ParamsFunc = func(s capnp.Struct) error { return params(SessionManager_unregisterUdpSession_Params{Struct: s}) }
	}
	return SessionManager_unregisterUdpSession_Results_Promise{Pipeline: capnp.NewPipeline(c.Client.Call(call))}
}

type SessionManager_Server interface {
	RegisterUdpSession(SessionManager_registerUdpSession) error

	UnregisterUdpSession(SessionManager_unregisterUdpSession) error
}

func SessionManager_ServerToClient(s SessionManager_Server) SessionManager {
	c, _ := s.(server.Closer)
	return SessionManager{Client: server.New(SessionManager_Methods(nil, s), c)}
}

func SessionManager_Methods(methods []server.Method, s SessionManager_Server) []server.Method {
	if cap(methods) == 0 {
		methods = make([]server.Method, 0, 2)
	}

	methods = append(methods, server.Method{
		Method: capnp.Method{
			InterfaceID:   0x839445a59fb01686,
			MethodID:      0,
			InterfaceName: "tunnelrpc/tunnelrpc.capnp:SessionManager",
			MethodName:    "registerUdpSession",
		},
		Impl: func(c context.Context, opts capnp.CallOptions, p, r capnp.Struct) error {
			call := SessionManager_registerUdpSession{c, opts, SessionManager_registerUdpSession_Params{Struct: p}, SessionManager_registerUdpSession_Results{Struct: r}}
			return s.RegisterUdpSession(call)
		},
		ResultsSize: capnp.ObjectSize{DataSize: 0, PointerCount: 1},
	})

	methods = append(methods, server.Method{
		Method: capnp.Method{
			InterfaceID:   0x839445a59fb01686,
			MethodID:      1,
			InterfaceName: "tunnelrpc/tunnelrpc.capnp:SessionManager",
			MethodName:    "unregisterUdpSession",
		},
		Impl: func(c context.Context, opts capnp.CallOptions, p, r capnp.Struct) error {
			call := SessionManager_unregisterUdpSession{c, opts, SessionManager_unregisterUdpSession_Params{Struct: p}, SessionManager_unregisterUdpSession_Results{Struct: r}}
			return s.UnregisterUdpSession(call)
		},
		ResultsSize: capnp.ObjectSize{DataSize: 0, PointerCount: 0},
	})

	return methods
}

// SessionManager_registerUdpSession holds the arguments for a server call to SessionManager.registerUdpSession.
type SessionManager_registerUdpSession struct {
	Ctx     context.Context
	Options capnp.CallOptions
	Params  SessionManager_registerUdpSession_Params
	Results SessionManager_registerUdpSession_Results
}

// SessionManager_unregisterUdpSession holds the arguments for a server call to SessionManager.unregisterUdpSession.
type SessionManager_unregisterUdpSession struct {
	Ctx     context.Context
	Options capnp.CallOptions
	Params  SessionManager_unregisterUdpSession_Params
	Results SessionManager_unregisterUdpSession_Results
}

type SessionManager_registerUdpSession_Params struct{ capnp.Struct }

// SessionManager_registerUdpSession_Params_TypeID is the unique identifier for the type SessionManager_registerUdpSession_Params.
const SessionManager_registerUdpSession_Params_TypeID = 0x904e297b87fbecea

func NewSessionManager_registerUdpSession_Params(s *capnp.Segment) (SessionManager_registerUdpSession_Params, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 16, PointerCount: 2})
	return SessionManager_registerUdpSession_Params{st}, err
}

func NewRootSessionManager_registerUdpSession_Params(s *capnp.Segment) (SessionManager_registerUdpSession_Params, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 16, PointerCount: 2})
	return SessionManager_registerUdpSession_Params{st}, err
}

func ReadRootSessionManager_registerUdpSession_Params(msg *capnp.Message) (SessionManager_registerUdpSession_Params, error) {
	root, err := msg.RootPtr()
	return SessionManager_registerUdpSession_Params{root.Struct()}, err
}

func (s SessionManager_registerUdpSession_Params) String() string {
	str, _ := text.Marshal(0x904e297b87fbecea, s.Struct)
	return str
}

func (s SessionManager_registerUdpSession_Params) SessionId() ([]byte, error) {
	p, err := s.Struct.Ptr(0)
	return []byte(p.Data()), err
}

func (s SessionManager_registerUdpSession_Params) HasSessionId() bool {
	p, err := s.Struct.Ptr(0)
	return p.IsValid() || err != nil
}

func (s SessionManager_registerUdpSession_Params) SetSessionId(v []byte) error {
	return s.Struct.SetData(0, v)
}

func (s SessionManager_registerUdpSession_Params) DstIp() ([]byte, error) {
	p, err := s.Struct.Ptr(1)
	return []byte(p.Data()), err
}

func (s SessionManager_registerUdpSession_Params) HasDstIp() bool {
	p, err := s.Struct.Ptr(1)
	return p.IsValid() || err != nil
}

func (s SessionManager_registerUdpSession_Params) SetDstIp(v []byte) error {
	return s.Struct.SetData(1, v)
}

func (s SessionManager_registerUdpSession_Params) DstPort() uint16 {
	return s.Struct.Uint16(0)
}

func (s SessionManager_registerUdpSession_Params) SetDstPort(v uint16) {
	s.Struct.SetUint16(0, v)
}

func (s SessionManager_registerUdpSession_Params) CloseAfterIdleHint() int64 {
	return int64(s.Struct.Uint64(8))
}

func (s SessionManager_registerUdpSession_Params) SetCloseAfterIdleHint(v int64) {
	s.Struct.SetUint64(8, uint64(v))
}

// SessionManager_registerUdpSession_Params_List is a list of SessionManager_registerUdpSession_Params.
type SessionManager_registerUdpSession_Params_List struct{ capnp.List }

// NewSessionManager_registerUdpSession_Params creates a new list of SessionManager_registerUdpSession_Params.
func NewSessionManager_registerUdpSession_Params_List(s *capnp.Segment, sz int32) (SessionManager_registerUdpSession_Params_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 16, PointerCount: 2}, sz)
	return SessionManager_registerUdpSession_Params_List{l}, err
}

func (s SessionManager_registerUdpSession_Params_List) At(i int) SessionManager_registerUdpSession_Params {
	return SessionManager_registerUdpSession_Params{s.List.Struct(i)}
}

func (s SessionManager_registerUdpSession_Params_List) Set(i int, v SessionManager_registerUdpSession_Params) error {
	return s.List.SetStruct(i, v.Struct)
}

func (s SessionManager_registerUdpSession_Params_List) String() string {
	str, _ := text.MarshalList(0x904e297b87fbecea, s.List)
	return str
}

// SessionManager_registerUdpSession_Params_Promise is a wrapper for a SessionManager_registerUdpSession_Params promised by a client call.
type SessionManager_registerUdpSession_Params_Promise struct{ *capnp.Pipeline }

func (p SessionManager_registerUdpSession_Params_Promise) Struct() (SessionManager_registerUdpSession_Params, error) {
	s, err := p.Pipeline.Struct()
	return SessionManager_registerUdpSession_Params{s}, err
}

type SessionManager_registerUdpSession_Results struct{ capnp.Struct }

// SessionManager_registerUdpSession_Results_TypeID is the unique identifier for the type SessionManager_registerUdpSession_Results.
const SessionManager_registerUdpSession_Results_TypeID = 0x8635c6b4f45bf5cd

func NewSessionManager_registerUdpSession_Results(s *capnp.Segment) (SessionManager_registerUdpSession_Results, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 1})
	return SessionManager_registerUdpSession_Results{st}, err
}

func NewRootSessionManager_registerUdpSession_Results(s *capnp.Segment) (SessionManager_registerUdpSession_Results, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 1})
	return SessionManager_registerUdpSession_Results{st}, err
}

func ReadRootSessionManager_registerUdpSession_Results(msg *capnp.Message) (SessionManager_registerUdpSession_Results, error) {
	root, err := msg.RootPtr()
	return SessionManager_registerUdpSession_Results{root.Struct()}, err
}

func (s SessionManager_registerUdpSession_Results) String() string {
	str, _ := text.Marshal(0x8635c6b4f45bf5cd, s.Struct)
	return str
}

func (s SessionManager_registerUdpSession_Results) Result() (RegisterUdpSessionResponse, error) {
	p, err := s.Struct.Ptr(0)
	return RegisterUdpSessionResponse{Struct: p.Struct()}, err
}

func (s SessionManager_registerUdpSession_Results) HasResult() bool {
	p, err := s.Struct.Ptr(0)
	return p.IsValid() || err != nil
}

func (s SessionManager_registerUdpSession_Results) SetResult(v RegisterUdpSessionResponse) error {
	return s.Struct.SetPtr(0, v.Struct.ToPtr())
}

// NewResult sets the result field to a newly
// allocated RegisterUdpSessionResponse struct, preferring placement in s's segment.
func (s SessionManager_registerUdpSession_Results) NewResult() (RegisterUdpSessionResponse, error) {
	ss, err := NewRegisterUdpSessionResponse(s.Struct.Segment())
	if err != nil {
		return RegisterUdpSessionResponse{}, err
	}
	err = s.Struct.SetPtr(0, ss.Struct.ToPtr())
	return ss, err
}

// SessionManager_registerUdpSession_Results_List is a list of SessionManager_registerUdpSession_Results.
type SessionManager_registerUdpSession_Results_List struct{ capnp.List }

// NewSessionManager_registerUdpSession_Results creates a new list of SessionManager_registerUdpSession_Results.
func NewSessionManager_registerUdpSession_Results_List(s *capnp.Segment, sz int32) (SessionManager_registerUdpSession_Results_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 0, PointerCount: 1}, sz)
	return SessionManager_registerUdpSession_Results_List{l}, err
}

func (s SessionManager_registerUdpSession_Results_List) At(i int) SessionManager_registerUdpSession_Results {
	return SessionManager_registerUdpSession_Results{s.List.Struct(i)}
}

func (s SessionManager_registerUdpSession_Results_List) Set(i int, v SessionManager_registerUdpSession_Results) error {
	return s.List.SetStruct(i, v.Struct)
}

func (s SessionManager_registerUdpSession_Results_List) String() string {
	str, _ := text.MarshalList(0x8635c6b4f45bf5cd, s.List)
	return str
}

// SessionManager_registerUdpSession_Results_Promise is a wrapper for a SessionManager_registerUdpSession_Results promised by a client call.
type SessionManager_registerUdpSession_Results_Promise struct{ *capnp.Pipeline }

func (p SessionManager_registerUdpSession_Results_Promise) Struct() (SessionManager_registerUdpSession_Results, error) {
	s, err := p.Pipeline.Struct()
	return SessionManager_registerUdpSession_Results{s}, err
}

func (p SessionManager_registerUdpSession_Results_Promise) Result() RegisterUdpSessionResponse_Promise {
	return RegisterUdpSessionResponse_Promise{Pipeline: p.Pipeline.GetPipeline(0)}
}

type SessionManager_unregisterUdpSession_Params struct{ capnp.Struct }

// SessionManager_unregisterUdpSession_Params_TypeID is the unique identifier for the type SessionManager_unregisterUdpSession_Params.
const SessionManager_unregisterUdpSession_Params_TypeID = 0x96b74375ce9b0ef6

func NewSessionManager_unregisterUdpSession_Params(s *capnp.Segment) (SessionManager_unregisterUdpSession_Params, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 2})
	return SessionManager_unregisterUdpSession_Params{st}, err
}

func NewRootSessionManager_unregisterUdpSession_Params(s *capnp.Segment) (SessionManager_unregisterUdpSession_Params, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 2})
	return SessionManager_unregisterUdpSession_Params{st}, err
}

func ReadRootSessionManager_unregisterUdpSession_Params(msg *capnp.Message) (SessionManager_unregisterUdpSession_Params, error) {
	root, err := msg.RootPtr()
	return SessionManager_unregisterUdpSession_Params{root.Struct()}, err
}

func (s SessionManager_unregisterUdpSession_Params) String() string {
	str, _ := text.Marshal(0x96b74375ce9b0ef6, s.Struct)
	return str
}

func (s SessionManager_unregisterUdpSession_Params) SessionId() ([]byte, error) {
	p, err := s.Struct.Ptr(0)
	return []byte(p.Data()), err
}

func (s SessionManager_unregisterUdpSession_Params) HasSessionId() bool {
	p, err := s.Struct.Ptr(0)
	return p.IsValid() || err != nil
}

func (s SessionManager_unregisterUdpSession_Params) SetSessionId(v []byte) error {
	return s.Struct.SetData(0, v)
}

func (s SessionManager_unregisterUdpSession_Params) Message() (string, error) {
	p, err := s.Struct.Ptr(1)
	return p.Text(), err
}

func (s SessionManager_unregisterUdpSession_Params) HasMessage() bool {
	p, err := s.Struct.Ptr(1)
	return p.IsValid() || err != nil
}

func (s SessionManager_unregisterUdpSession_Params) MessageBytes() ([]byte, error) {
	p, err := s.Struct.Ptr(1)
	return p.TextBytes(), err
}

func (s SessionManager_unregisterUdpSession_Params) SetMessage(v string) error {
	return s.Struct.SetText(1, v)
}

// SessionManager_unregisterUdpSession_Params_List is a list of SessionManager_unregisterUdpSession_Params.
type SessionManager_unregisterUdpSession_Params_List struct{ capnp.List }

// NewSessionManager_unregisterUdpSession_Params creates a new list of SessionManager_unregisterUdpSession_Params.
func NewSessionManager_unregisterUdpSession_Params_List(s *capnp.Segment, sz int32) (SessionManager_unregisterUdpSession_Params_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 0, PointerCount: 2}, sz)
	return SessionManager_unregisterUdpSession_Params_List{l}, err
}

func (s SessionManager_unregisterUdpSession_Params_List) At(i int) SessionManager_unregisterUdpSession_Params {
	return SessionManager_unregisterUdpSession_Params{s.List.Struct(i)}
}

func (s SessionManager_unregisterUdpSession_Params_List) Set(i int, v SessionManager_unregisterUdpSession_Params) error {
	return s.List.SetStruct(i, v.Struct)
}

func (s SessionManager_unregisterUdpSession_Params_List) String() string {
	str, _ := text.MarshalList(0x96b74375ce9b0ef6, s.List)
	return str
}

// SessionManager_unregisterUdpSession_Params_Promise is a wrapper for a SessionManager_unregisterUdpSession_Params promised by a client call.
type SessionManager_unregisterUdpSession_Params_Promise struct{ *capnp.Pipeline }

func (p SessionManager_unregisterUdpSession_Params_Promise) Struct() (SessionManager_unregisterUdpSession_Params, error) {
	s, err := p.Pipeline.Struct()
	return SessionManager_unregisterUdpSession_Params{s}, err
}

type SessionManager_unregisterUdpSession_Results struct{ capnp.Struct }

// SessionManager_unregisterUdpSession_Results_TypeID is the unique identifier for the type SessionManager_unregisterUdpSession_Results.
const SessionManager_unregisterUdpSession_Results_TypeID = 0xf24ec4ab5891b676

func NewSessionManager_unregisterUdpSession_Results(s *capnp.Segment) (SessionManager_unregisterUdpSession_Results, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 0})
	return SessionManager_unregisterUdpSession_Results{st}, err
}

func NewRootSessionManager_unregisterUdpSession_Results(s *capnp.Segment) (SessionManager_unregisterUdpSession_Results, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 0})
	return SessionManager_unregisterUdpSession_Results{st}, err
}

func ReadRootSessionManager_unregisterUdpSession_Results(msg *capnp.Message) (SessionManager_unregisterUdpSession_Results, error) {
	root, err := msg.RootPtr()
	return SessionManager_unregisterUdpSession_Results{root.Struct()}, err
}

func (s SessionManager_unregisterUdpSession_Results) String() string {
	str, _ := text.Marshal(0xf24ec4ab5891b676, s.Struct)
	return str
}

// SessionManager_unregisterUdpSession_Results_List is a list of SessionManager_unregisterUdpSession_Results.
type SessionManager_unregisterUdpSession_Results_List struct{ capnp.List }

// NewSessionManager_unregisterUdpSession_Results creates a new list of SessionManager_unregisterUdpSession_Results.
func NewSessionManager_unregisterUdpSession_Results_List(s *capnp.Segment, sz int32) (SessionManager_unregisterUdpSession_Results_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 0, PointerCount: 0}, sz)
	return SessionManager_unregisterUdpSession_Results_List{l}, err
}

func (s SessionManager_unregisterUdpSession_Results_List) At(i int) SessionManager_unregisterUdpSession_Results {
	return SessionManager_unregisterUdpSession_Results{s.List.Struct(i)}
}

func (s SessionManager_unregisterUdpSession_Results_List) Set(i int, v SessionManager_unregisterUdpSession_Results) error {
	return s.List.SetStruct(i, v.Struct)
}

func (s SessionManager_unregisterUdpSession_Results_List) String() string {
	str, _ := text.MarshalList(0xf24ec4ab5891b676, s.List)
	return str
}

// SessionManager_unregisterUdpSession_Results_Promise is a wrapper for a SessionManager_unregisterUdpSession_Results promised by a client call.
type SessionManager_unregisterUdpSession_Results_Promise struct{ *capnp.Pipeline }

func (p SessionManager_unregisterUdpSession_Results_Promise) Struct() (SessionManager_unregisterUdpSession_Results, error) {
	s, err := p.Pipeline.Struct()
	return SessionManager_unregisterUdpSession_Results{s}, err
}

const schema_db8274f9144abc7e = "x\xda\xccY}p\x14e\x9a\x7f\x9e\xee\x99t\x02\x19" +
	"f\xbaz 0%\x97\x93\xc2\xf2\x88\x82\x06\xce+\x8e" +
	"\xb3.\x09\x06\xceD>\xd23p\xe5\x09Zvf\xde" +
	"\x84\xc9\xcdt\x0f\xdd=\x91 \xc8\x87 b\xf9\x05\x82" +
	"\"\xca\xc9ayW\xa0\xde\xc1\xa9\xe7\xb2%\xb5\xb2+" +
	"*\xa5\xa8X\xb0\x85\x8a\xb5\x8b\xc8\xeeJ\xc1\xba\"\xac" +
	"\xe5\xaeko=\xdd\xd3\x1f\x99\x84$\xc8\xfe\xb1\xffM" +
	"\x9e~\xde\xf7}>~\xcf\xef}\xde'\xd7wT6" +
	"r\xf5\xe1\x9a\x08\x80\xbc%\\a\xb1\xba\x0f\x97n\xbf" +
	"\xeag\xabAN Z\xf7\xbc\xd6\x1a\xff\xd6\\\xfd\x09" +
	"\x84y\x01`\xca\xe2\x8a\xa5(\xad\xad\x10\x00\xa4U\x15" +
	"\xbf\x06\xb4\xee\x1b\xb5\xfb\x99\xe7fl\xba\x17\xc4\x04\xef" +
	"+\x03NaB+J=\x02i\x16\x85u\xd2Q\xfa" +
	"e\xdd\"^\xb7 \xfe\xc1{\xa4\x1d\xdc:D[\xef" +
	"\x13\xeaP:d/8(\xd0\xd67\xe6\xdf\xdf\xf1\x0f" +
	"\x9b\xdfY\x03b\x82\xeb\xb5\xf5+\x95KQ:XI" +
	"\x9a\x07*\xe7\x02Z_o\x1a\xfd\xfc\x7f\xbe\xf7\xf6Z" +
	"\x10\xafF(Y\xfai\xe5\xc7\x08(}U\xf9\xbf\x80" +
	"\xd6\xa1\x0b\x0b\xce\xbf\xfc\xe6\x0d\xf7\x818\x81\x14\x90\x14" +
	"6T\x8d\xe3\x00\xa5\x9dU\x0d\x80\xd6\xe93\x7f\\w" +
	"\xf7\x849\x8f\x82<\x019\x800G\x1a\x07\xab\x12\xa4" +
	"q\xa2\x8a\xaci\x98yhob\xca\xe3\x9b\xcaL\xb7" +
	"\x15\xf7\x0f\xabC\xe9\xf002\xe8\xd0\xb0\xbb\x00\xad\xdf" +
	"\x8fx\xea\xbd\xe2M\xaf>^:\xcfV\xaa\x1f^G" +
	"\xbb\xb5\x0c'\x85q\xddW\xdd\xf9\xd3\x03/=\x01\xf2" +
	"DD\xebx\xfb5G\xf9m\xbb>\x81\xf9(\xd0\xf1" +
	"Sv\x0e\xdfA\xc6\xef\xb5u\xdf\xbf\xf6\xb5\x1f?\xfa" +
	"\xd2\xba\xa7@\xbe\x1a\x11\xc0\x0e\xd6\xd8\xea?\x90B}" +
	"5\x19\xbf\xe9\xd8\xbe9\xf9\x0d[w8\xee\xdb\xdf\xff" +
	"\xad\x9a\xe3 d\xadi\xf9&?\xff\xd9\xd4\xb3\xa5\xc0" +
	"\x84\xe9\xd3\xec\xeas\x088E\xa9\xaeE@\xeb\x86\x8f" +
	"O\xcd\x9d\xfd\x7f\x1d\xff\x1dX\xbb<\xb2\x94\xd6\xae\xeb" +
	"8\xb7?\x96\xcc?_\xe6\xb0\x1d\xbb\x9e\xc8.\x946" +
	"D\xc8\xe1\x87\"d\xc2\x8b\x7fsK\xd5\x92S3w" +
	"\x838\xd1\xdd\xe6\xc5H\x92\xb6\x09\xdd\xce\x7f\xafl\xf9" +
	"\xc9\xcb\xe5p\xb2c\xb23\xd2\x8e\xd2>\xdag\xca\xde" +
	"\x88m\xcf\x03\xfb\xb7^S\xf9\xcc\xd7\xaf\xf4\x17\xe6\x13" +
	"#\xdaQ\xba0\x82N\xfdj\x04Efd\x0b\x1e\x7f" +
	"\xbd>\xf4j0\xefr\xf44E\x86E)\xefc\xcf" +
	"N\x8f\xa8_\xae~\xbdl7[1\x1ckEiL" +
	"\x8cv\x1b\x19#\xe5\xd6\x05\x8fm\x0c\x9fz\xec-\xb2" +
	"4\x00\xb80\x01m\xca\x9e\x98\x8e\xd2\x81\x98\x9d\xedX" +
	"\x0d\x0fh%v\xff\xd3\xffL\xcf|\xf4N?\x96J" +
	"M\xf1s\xd2\xec8\xfdj\x89\x93\xa1''\xee\xb9\xfb" +
	"\x8b\x87\x0e\x1f)\x19j\xc7\xf0\xb9\xb8\x9d\xc2\xbdq\x8a" +
	"\x9f\x87\x80\xb2(\xd9\x9a\x1f\xc5\xbbP:ko\xf7\x85" +
	"\xad\xcd\x9dR\xc6\xac\xfc\xf9?\x1f\x0f$\xedl\xfc3" +
	"\x84\x905\xe7_\x17tU-?y2x\xd0\x89\xb8" +
	"\x1d\x91\x0b\xf6\xd2\xdf\xfe\xd7\xe9G\xce\xe43\xbf\xb2\x81" +
	"\xe7\xc6l\xe4\xc8i\x04\xcd\x89#\x09\xe85\xb5\x91\x19" +
	"\xe3\x8e\xb5\x9dvR\xe9lQ5j:)\\9\x8a" +
	"\xb6\xb8\xe1\xce&\xb6p\xea\xad\xa7\xfb\x94|\xd3\xa8i" +
	"(\xc9\xa3l\x90\x8dZ\x87\x12\xab\xa9\x01\xb0\xba\xff\x7f" +
	"\xc3\xad\xcf\xbf1\xe7\x9cS\x0b\xb6\xb1\xf3k&\x134" +
	"\x1e\xbe\xa7y\xee?\x8e\xdb\x7f.h\xec\xec\x1aB\xa7" +
	"\xa4\xd4\xd0I\x1dS\xcf\xfc\xcbU\x0f\xbfy\xae?\x08" +
	"\xae\xaa\xa9CiC\x8d\x0dAR\xfer\xe6\x7f\x1cI" +
	"D\x13\xe7\xcb\x02Xa'\xaf\xa6\x0b\xa5\x035v\xf2" +
	"j\xde\"\x98\xdd\xf7\xc9\x1dK>\xbc\xf7\xeb\x0b\xe5\xb9" +
	"\xb6\xb7~eL\x12\xa5\x83cl~\x19C\xc8xb" +
	"\xdeoV\x9c\xd9<\xea\x9b\xbe$\x97\xe8B\xa9'a" +
	"\x93\\b\x9dt\x94~Y\x1f\x08\xcf\xd67\xafx\xe7" +
	"\xdb@-\xecK\xb4\x92\xc3\x8f\x0bO\x9f\\\xf9\x8b;" +
	"\xbe\x0b:\xbc7\xf1\x199|(A\x0e/\xfb\xf2\xc9" +
	"\x9b\x1fY\xf8\xc2\xf7\xc1\xc4&V\xd3R\xb3\xa8\xaa," +
	"\xa7\x17B\xe9\xeb\xdc\x9f\xe9Ii\xa5\xa0\x16\xa65\x15" +
	"\xcdEL5\xb3i\xc5dI\xd6`\x144\xd5`m" +
	"\x88r\x8c\x0f\x01\x84\x10@T\xba\x00\xe4;y\x94s" +
	"\x1c\x8a\x88qJ\xbd\x98%\xe1\"\x1ee\x93C\x91\xe3" +
	"\xe2\xc4<\xe2\xe2q\x00r\x8eGy\x09\x87\xc8\xc7\x91" +
	"\x07\x10\x8b\x1b\x01\xe4%<\xcak8\xb4\x0aL\xcf+" +
	"*S!j\xce\xd0u\xac\x06\x0e\xab\x01-\x9d\x99z" +
	"\x8f\xd2\x9e\x83(\x0b\x88\x85\xae\xbbL\x8c\x00\x87\x11@" +
	"k\x91V\xd4\x8d\xf9\xaa\x89\xd9\\\x92u\xe8\xcc\xc0E" +
	"X\x01\x1cV\x00\x0e\xe4^\x8a\x19FVSg+\xaa" +
	"\xd2\xc9t\x00\xf2\xac\x92\x0f\x03x\xa4\x8d.\xbd\x8b\xf5" +
	"[\x81\x13'\x0a\xe830\xba\xf0\x13\xaf\xdc\x05\x9c8" +
	"V\xb0t\xd6\x995L\xa6\xe3\xfcL\xc1\xde\x9b\xd7\xd4" +
	"F\xb4\x8a\xaa\xf3\x01\x99\xee|\x88\xd2\xa9\x8d\xd8\x86\xbe" +
	"u|_\xebn\xcae\x99jF[\xd4\x0e\xad,\xe4" +
	"\xad\xfd\x85\xbc\xb5\x14\xf25\x81\x90\xaf\x9a\x0e /\xe3" +
	"Q\xbe\x9fC\x91/\xc5|m\x1d\x80\xbc\x92G\xf9A" +
	"\x0e\xad\xb4}HK\x06\x00\xbchv0\xc5,\xea\xcc" +
	" \xd9\x08\xc06\x1e\xed\xa0\x8f\x00\\\xd1\xcdt\xb2\xdd" +
	"MBT\xd1\xd3\x8b\xbcD\x0d\x10\xe9\x19K\xb2\x86\x99" +
	"U;\xe7\xd9\xf2\x866-\x97M\xf7\x90W\xd5\xb6\x9d" +
	"c\xa7\x01 \x8a#o\x03@N\x14\xa7\x034d;" +
	"UMgV&k\xa45Ue\xc0\xa7\xcd\x15\xedJ" +
	"NQ\xd3\xcc;\xa8\xa2\xefA\xce\x01)\xa6w3}" +
	"\x92\x12\x80\xef\xf86EW\xf8\xbc!W{q\x9cq" +
	"\x1b\x80\xdc\xcc\xa3\xdc\x16\x88\xe3l\x8a\xe3,\x1e\xe5[" +
	"\x03q\x9cOql\xe3Q^\xc8\xa1\xa5\xe9\xd9\xce\xac" +
	"z\x13\x03^\x0f\"\xd00U%\xcf(f\xa5x\xac" +
	"\xd0\x0afVS\x0d\x8c\xf9\xfc\x0f\x88\xb1@\xa4\x84\xc1" +
	"09\xc9\x85\x94\x8b(M\x1d\x9fdFQ\xc8\x99\x86" +
	"\x1c\xf2<\x89L\x03\x90+y\x94\xe3\x1c6\xe8\xcc(" +
	"\xe6L\x8c\xf9\xd7\xec_\xe2T7|\x01\x18&\xfb\x83" +
	"\xe1d\x009\xc3\xa3\\\xe0\x10K\xd1\xcbO\x0f\xb0\x01" +
	"\x8f\x0e\x0a\x17o\x05\x90M\x1e\xe5\x95\x1cZ\x86sH" +
	"\x0b`\xc6\x8dhm\xc60[\x0a\xee_+2\x86\xd9" +
	"\xa6\xe9&\x0a\xc0\xa1\x00\x84[\xcd`M\x1dTS-" +
	"\x99\x1c\xbb9\xcb\xab&\x86\x81\xc30\x0cXT\x0e>" +
	"\xa2DlN\xb5\xbb\xdeL 0\xfc\x1d\x8f\xf2\xdf\x07" +
	"\xbc\xa9'\x1e\xbb\x9eG\xf9F\x0e-%\x9d\xd6\x8a\xaa" +
	"9\x0fx\xa5\xb3\x0c\xf3)\x06\xd1\xb4\xce|8\x0c=" +
	"\xd4.9\x94\x05;\xaa+y#h^\xb2?\xf3(" +
	"\xb0\xd7\xf2(O\xed?\x86+\xf2\xcc0\x94N\xd6\xa7" +
	"B\xc3\xfd\xb0\x0dUY\x9a\x00\x9bd\x0e\xcfO\xd2\x99" +
	"!\x14s&YQmY\x8e\x19\x94\xde\xf1<\xca\xd7" +
	"s\x18\xc1\xef-\xc7\x8e\x89\x1b\xfd0\xd52]\xd7t" +
	"\x8c\xf9\xf7`\x09}\xe9\xd2\x01\xa8\xa9\xcd\xccT\xb29" +
	"\xa4\xca\xf0\x9a\xb22\x8c\x0eV\xda~\xd8\x1c\xf1\xf8\x06" +
	"\x02h\xbeWQ\x10\xc2b<\xcaWphu\xeaJ" +
	"\x9a\xb51\x1d\xb3Zf\x8e\xa2j)\x9e\xa5\xfb\xe0e" +
	"\xc4\xa5\x1e\x9a\xb4K\xcd\x00o\xd5\xc0\xebuV\x0aB" +
	"iy[\xadcs\xdc\xb3y\xf98\xff>\xf4\xd2\xbc" +
	"\xaa\xdd'l\x8f\x92\xd6\x13^\xef\xe7Q\xde\x14\xa0\xf6" +
	"\x0dD^\x8f\xf2(?\xcd\xa1\x18\x0a\xc51\x04 >" +
	"I(\xd9\xc4\xa3\xbc\x9d\xeb}k\xb2n\xa6\x9a\xcd\xd9" +
	"N\x10\x98\xe1K\xc9\xc4\xe6l'\x03\xde\xb8\\z\xab" +
	"\x1c$\x1eZ\xbb\xa1\xe5\x98\xc9\x9aY:\xa7\xe8\x8a\x99" +
	"\xedf\xce\xf7\x12\x18\xdd\xa4\x0e\x84\xdbd\x9f\xea!\xfc" +
	"F\xddF%\x00\x87q>G\x0a,\xd0_\x0c`\xad" +
	"\xb39Y\xa6\xa9}0\xe0WL\x09\x07h\x0ct\x05" +
	"\xfa\xeas\x0bfV\xd0T\x83\xec\x0b\xa4~Z\x7f\xa9" +
	"\xd7\xfd\xd4\xbbt\xba~u0\xf3%:\xdd\xb0\xd5O" +
	"\xb2\x18\xe2\x9c\xcco\xdb\x01 o\xe7Q~\x81\xc3\x06" +
	"\xe7\xa6\xc7\x98\xffR.e\xcb\xb9\xcffiP\x9bV" +
	"r>\xe5Z:+\xe4\x944\x9b\x81\xa5\xbb\x1b\x10\x81" +
	"C\xb4!\x92/\xe8\xcc00\xab\xa9rQ\xc9ey" +
	"\xb3\xc7\xeb\xb7\xd4b\xbeMg\xddY\xd4\x8aF\x93i" +
	"\xb2\xbcP0\x8d\xa1tc~\x80\x88\x1f\x84l\xce(" +
	"c\xe8:\x9f{\xbc\x00M\xec\xf2)0Z,f=" +
	"\xee\xb3rZ\xda\xce\x1bD\xe7(\xf9\xbe\x14X1h" +
	"\xad\xf6\xaat\x97\x91\xff\x9a\xba\x87\x81\x1bvr\xdd\xee" +
	"h\x03&S\x094\xf2(\xcf\x0a\x98\xdc29\xe0\x87" +
	"k\xf2\xecv\xdf\x0f\xe1\xdfY\x8fkU-\xcb\x13s" +
	"\xbb\xc1,9\xd3\x04\xc2-\xbe\xce@\xf6\x05\x0bjn" +
	"\xa1\xd6\xf6\x90l\x9c\xea\xda(\xf5`+@j\x09\xf2" +
	"\x98Z\x83\xbe\x99\xd2*\x9c\x0e\x90ZF\xf2\xfb\xd1\xb7" +
	"TZ\x8b\x09\x80\xd4J\x92?\x88\xde\xc3BZ\x8f\xbb" +
	"\x00R\x0f\x92x\x0b\xa9\x87x\xbb$\xa4\xcd\xf6\xf6\x9b" +
	"H\xbe\x9d\xe4\xe1P\x1c\xc3\x00\xd26\xac\x03Hm!" +
	"\xf9\xcb$\xaf\xe0\xe2X\x01 \xed\xc1.\x80\xd4n\x92" +
	"\xbfFr!\x1c\xa7\xb7\x95\xb4\x17u\x80\xd4\x8fH\xfe" +
	"\x06\xc9+G\xc7\xb1\x12@\xdao\xcb_'\xf9\xbb$" +
	"\xaf\x1a\x13\xc7*\x00\xe9 \xae\x06H\xbdM\xf2#$" +
	"\x1f\x86q\x1c\x06 \x1d\xc6\xad\x00\xa9#$\xff%\xc9" +
	"\x87W\xc4q8\x80\xf4\xa9m\xcf1\x92\x7fN\xf2\xea" +
	"P\x1c\xab\x01\xa4\x13\xb8\x03 \xf59\xc9\x7fG\xf2\x88" +
	"\x10\xc7\x08\x80t\xd6\xf6\xeb\x0c\xc9+\xb9\xb2\xbe\xdeE" +
	"TY\xf3\xcek\x86\x972V\xaaqt\xe0\xde\xa6E" +
	"\xa9A\xc7\xa8?)\x03\xc4(\xa0U\xd0\xb4\xdc\x9c\xde" +
	"H\x8d\x9aJ\xa7\xe1>\x14b\xfe\xf0\x02\x90\x84\xde\xbd" +
	"\x0fQMm\xc9xDP\xce:\xae%Y\xa3\xa9h" +
	"j\xc5\x02\xd4f\x14\x93e<\xce\xd1\x8b\xeaL]\xcb" +
	"\xcfC\xa6\xe7\xb3\xaa\x92\x1b\x84\x8d\xaa\x80\xc3*(Q" +
	"\x82\xbb\xf7\xc0\xd4t\xf1g\x8f\x87h\xae\x1c\xd1\xb5\x85" +
	"i\xf3\x94\xce\xa1\xf0\xd4d\xbf\x7f\x8b\xaa\x01B\xaa\xed" +
	"Vr\xc5\x1fBO\xbd[\x89d\x83\xd3\x8a\x0c\xf6(" +
	"pg\x19\x83SI\xef\x86\xb0\xf7\x85\x8a\x811#\x9d" +
	"\xc3\x95\xf6\x1f\xb2\xf9\x9d\xcct~\xd1\xeb\x96\xde\x16B" +
	"\xf0\x9a\xbf\xb4\xd5IfD\x87\xe2\xba?\xf3\x19\xfc=" +
	"\xd4\xcf\xc5\xdf\xcf\xb5\xef\xf6\x9c\x817\x11\xe5~!\x8f" +
	"\xf2\xa2@\xeeYk?o\xa2\xa4?\x0c\x11y\xae4" +
	"\x0d\xa1\x8b\xa2\xc0\xa3\xbc\x8c\xc3(=^1\xe6\x0f\x87" +
	"{\x19\xdd\xfb\xc1NPhQ3\x0cp\x89\x8b\xe6\xc0" +
	"\xf5\xe1\x8dI\x07\xef\xce\x86\xe6\xb6\xdb\xf5\x0e\x1apo" +
	"\xf4Xv\xf2E\xdfe\x0d\xce\xa1\x84\xb3\xd1\xf6\x1c\xc6" +
	"\x1d\xc3\xa2;\xd0\x13\xf7,\x05N\xdc)\xa0?\xaaD" +
	"w2)n\xd3\x81\x137\x0b\xc8y\x83mt\x07\xd8" +
	"\xe2\xfa\x07\x80\x13\xd7\x0a\xc8{sitGb\xf5=" +
	"\xc3\x108q\xb9\x80!o\xde\x8f\xee@M\\\xdc\x05" +
	"\x9c\x98\x150\xec\x8d\xbc\xd1\x9d\xb9\x8a\xb7\xaf\x06N\x9c" +
	"\xef\x0f~\xa0\xc1\xf1\xa3\x11-\x17\xa3Pk\xa3\xb4\xf7" +
	"\x18\xc8\xd1\x02hD\xcb\xed\x81\xf9\x8b5\xc1\xb6\x96;" +
	"\xc9\x80hZ1Y#5gN\xfdc\x89\x00\xa0\x11" +
	"\xe5\x10\x06\xe6\x89\x00\x97\xfb\x08M\xb2Z;\xcf?\xb4" +
	"er\xd7\xff@J\xe2\xfb\xb3\x9a\xce\xf1&b\x81}" +
	"\xa9\x0b\xac\xe6Q\x1e\xcd\x0d\xda\xf8\x85.\xe6\x85\x0b\xfe" +
	"(-\xa6\xfd\xff\xd6\xdb\xff05N\xef\xf2(\x1f\x0b" +
	"\x94\xf5Q\x12~\xc0\xa3|<\xd08}D\xb5~\x8c" +
	"G\xf9\xbc?\xe4\xfc\xea\x01\x00\xf9<\x8f\xc9@#\"" +
	"\xfe\x89\x14\xbf\xa3\xeb\xdanC\xd0iC\xc2\xb8\x11 " +
	"UI\xd7x\xdcnCBN\x1b\"b;@*F" +
	"\xf2+\x82m\xc8\x18\xbc\x0d 5\x9a\xe4\xe3\xb1\xf7\xbb" +
	"F(\xea~\xa3\x96\xd3:ge\xd5~\xef6w\xea" +
	"\x8a\xe6L%\x9b+\xea\x0c\xfc\xab\xb5D6\xcd\x81\xdb" +
	"\xde\x19\xc7:\x93\x97\x14\x810\x83\x867\x95\xb9\x84\x17" +
	"\xe5\x90n\x9e\x19\xba\xae\xa1^\xd6\xc4N\xf6\x9bX\xaf" +
	"\x87\xa5^\xfcf\x1e\xe5y\x94\x8aF'\x15r\xbb\xdf" +
	"v\xd7\xa6\x95\xa2\xc1\xfa\xf8\x00<\xd3\xbd)\x80\xb1H" +
	"+\xe62I\x06\x82\xa9\xf7\x94\x85`\xd0f6\xc5\xa2" +
	".s9\x13d\xf7\xbf!\xe8\xfe\xd3#0Av\xc7" +
	"\xf8\xe8\xfeo\xab\xef\x04\xd9\x8dA\x9f\x09\xb2\xf3\xc1\xc6" +
	"h\xef\x09\xf2e<_\x9dk,\xc0\x18\x974X\x1d" +
	"\xf2<\xd2\xfb\xf7oY\xa5W]\xee\x98\xc0\xbd\x90\xfe" +
	"\x1c\x00\x00\xff\xff\xa1\x1ap\xe9"

func init() {
	schemas.Register(schema_db8274f9144abc7e,
		0x82c325a07ad22a65,
		0x839445a59fb01686,
		0x83ced0145b2f114b,
		0x84cb9536a2cf6d3c,
		0x85c8cea1ab1894f3,
		0x8635c6b4f45bf5cd,
		0x904e297b87fbecea,
		0x9496331ab9cd463f,
		0x96b74375ce9b0ef6,
		0x97b3c5c260257622,
		0x9b87b390babc2ccf,
		0xa29a916d4ebdd894,
		0xa353a3556df74984,
		0xa766b24d4fe5da35,
		0xab6d5210c1f26687,
		0xb046e578094b1ead,
		0xb4bf9861fe035d04,
		0xb5f39f082b9ac18a,
		0xb70431c0dc014915,
		0xc082ef6e0d42ed1d,
		0xc793e50592935b4a,
		0xcbd96442ae3bb01a,
		0xd4d18de97bb12de3,
		0xdbaa9d03d52b62dc,
		0xdc3ed6801961e502,
		0xe3e37d096a5b564e,
		0xe6646dec8feaa6ee,
		0xea50d822450d1f17,
		0xea58385c65416035,
		0xf24ec4ab5891b676,
		0xf2c122394f447e8e,
		0xf2c68e2547ec3866,
		0xf41a0f001ad49e46,
		0xf5f383d2785edb86,
		0xf71695ec7fe85497,
		0xf9cb7f4431a307d0,
		0xfc5edf80e39c0796,
		0xfeac5c8f4899ef7c)
}
