// @flow
import Icon from './icon'
import * as React from 'react'
import * as Styles from '../styles'
import type {Props} from './avatar.render'

class AvatarRender extends React.PureComponent<Props> {
  render() {
    const avatarSizeClasName = `avatar-${this.props.isTeam ? 'team' : 'user'}-size-${this.props.size}`

    return (
      <div className={`avatar ${avatarSizeClasName}`} onClick={this.props.onClick} style={this.props.style}>
        {!this.props.skipBackground && <div className={'avatar-background ' + avatarSizeClasName} />}
        {!!this.props.url && (
          <div
            className={'avatar-user-image ' + avatarSizeClasName}
            style={{
              backgroundImage: this.props.url,
              opacity:
                this.props.opacity === undefined || this.props.opacity === 1 ? undefined : this.props.opacity,
            }}
          />
        )}
        {(!!this.props.borderColor || this.props.isTeam) && (
          <div
            style={{
              boxShadow: `0px 0px 0px ${this.props.isTeam ? 1 : 2}px ${this.props.borderColor ||
                Styles.globalColors.black_10} ${this.props.isTeam ? 'inset' : ''}`,
            }}
            className={(this.props.isTeam ? 'avatar-border-team ' : 'avatar-border ') + avatarSizeClasName}
          />
        )}
        {this.props.followIconType && (
          <Icon type={this.props.followIconType} style={this.props.followIconStyle} />
        )}
        {this.props.editable && (
          <Icon
            type="iconfont-edit"
            style={{
              bottom: this.props.isTeam ? -2 : 0,
              position: 'absolute',
              right: this.props.isTeam ? -18 : 0,
            }}
          />
        )}
        {this.props.children}
      </div>
    )
  }
}

export default AvatarRender
