// Auto-generated by avdl-compiler v1.3.25 (https://github.com/keybase/node-avdl-compiler)
//   Input file: avdl/keybase1/notify_team.avdl

package keybase1

import (
	"github.com/keybase/go-framed-msgpack-rpc/rpc"
	context "golang.org/x/net/context"
)

type TeamChangeSet struct {
	MembershipChanged bool `codec:"membershipChanged" json:"membershipChanged"`
	KeyRotated        bool `codec:"keyRotated" json:"keyRotated"`
	Renamed           bool `codec:"renamed" json:"renamed"`
	Misc              bool `codec:"misc" json:"misc"`
}

func (o TeamChangeSet) DeepCopy() TeamChangeSet {
	return TeamChangeSet{
		MembershipChanged: o.MembershipChanged,
		KeyRotated:        o.KeyRotated,
		Renamed:           o.Renamed,
		Misc:              o.Misc,
	}
}

type TeamChangedByIDArg struct {
	TeamID       TeamID        `codec:"teamID" json:"teamID"`
	LatestSeqno  Seqno         `codec:"latestSeqno" json:"latestSeqno"`
	ImplicitTeam bool          `codec:"implicitTeam" json:"implicitTeam"`
	Changes      TeamChangeSet `codec:"changes" json:"changes"`
}

type TeamChangedByNameArg struct {
	TeamName     string        `codec:"teamName" json:"teamName"`
	LatestSeqno  Seqno         `codec:"latestSeqno" json:"latestSeqno"`
	ImplicitTeam bool          `codec:"implicitTeam" json:"implicitTeam"`
	Changes      TeamChangeSet `codec:"changes" json:"changes"`
}

type TeamDeletedArg struct {
	TeamID TeamID `codec:"teamID" json:"teamID"`
}

type TeamAbandonedArg struct {
	TeamID TeamID `codec:"teamID" json:"teamID"`
}

type TeamExitArg struct {
	TeamID TeamID `codec:"teamID" json:"teamID"`
}

type NewlyAddedToTeamArg struct {
	TeamID TeamID `codec:"teamID" json:"teamID"`
}

type AvatarUpdatedArg struct {
	Name    string         `codec:"name" json:"name"`
	Formats []AvatarFormat `codec:"formats" json:"formats"`
}

type NotifyTeamInterface interface {
	TeamChangedByID(context.Context, TeamChangedByIDArg) error
	TeamChangedByName(context.Context, TeamChangedByNameArg) error
	TeamDeleted(context.Context, TeamID) error
	TeamAbandoned(context.Context, TeamID) error
	TeamExit(context.Context, TeamID) error
	NewlyAddedToTeam(context.Context, TeamID) error
	AvatarUpdated(context.Context, AvatarUpdatedArg) error
}

func NotifyTeamProtocol(i NotifyTeamInterface) rpc.Protocol {
	return rpc.Protocol{
		Name: "keybase.1.NotifyTeam",
		Methods: map[string]rpc.ServeHandlerDescription{
			"teamChangedByID": {
				MakeArg: func() interface{} {
					var ret [1]TeamChangedByIDArg
					return &ret
				},
				Handler: func(ctx context.Context, args interface{}) (ret interface{}, err error) {
					typedArgs, ok := args.(*[1]TeamChangedByIDArg)
					if !ok {
						err = rpc.NewTypeError((*[1]TeamChangedByIDArg)(nil), args)
						return
					}
					err = i.TeamChangedByID(ctx, typedArgs[0])
					return
				},
				MethodType: rpc.MethodNotify,
			},
			"teamChangedByName": {
				MakeArg: func() interface{} {
					var ret [1]TeamChangedByNameArg
					return &ret
				},
				Handler: func(ctx context.Context, args interface{}) (ret interface{}, err error) {
					typedArgs, ok := args.(*[1]TeamChangedByNameArg)
					if !ok {
						err = rpc.NewTypeError((*[1]TeamChangedByNameArg)(nil), args)
						return
					}
					err = i.TeamChangedByName(ctx, typedArgs[0])
					return
				},
				MethodType: rpc.MethodNotify,
			},
			"teamDeleted": {
				MakeArg: func() interface{} {
					var ret [1]TeamDeletedArg
					return &ret
				},
				Handler: func(ctx context.Context, args interface{}) (ret interface{}, err error) {
					typedArgs, ok := args.(*[1]TeamDeletedArg)
					if !ok {
						err = rpc.NewTypeError((*[1]TeamDeletedArg)(nil), args)
						return
					}
					err = i.TeamDeleted(ctx, typedArgs[0].TeamID)
					return
				},
				MethodType: rpc.MethodNotify,
			},
			"teamAbandoned": {
				MakeArg: func() interface{} {
					var ret [1]TeamAbandonedArg
					return &ret
				},
				Handler: func(ctx context.Context, args interface{}) (ret interface{}, err error) {
					typedArgs, ok := args.(*[1]TeamAbandonedArg)
					if !ok {
						err = rpc.NewTypeError((*[1]TeamAbandonedArg)(nil), args)
						return
					}
					err = i.TeamAbandoned(ctx, typedArgs[0].TeamID)
					return
				},
				MethodType: rpc.MethodNotify,
			},
			"teamExit": {
				MakeArg: func() interface{} {
					var ret [1]TeamExitArg
					return &ret
				},
				Handler: func(ctx context.Context, args interface{}) (ret interface{}, err error) {
					typedArgs, ok := args.(*[1]TeamExitArg)
					if !ok {
						err = rpc.NewTypeError((*[1]TeamExitArg)(nil), args)
						return
					}
					err = i.TeamExit(ctx, typedArgs[0].TeamID)
					return
				},
				MethodType: rpc.MethodNotify,
			},
			"newlyAddedToTeam": {
				MakeArg: func() interface{} {
					var ret [1]NewlyAddedToTeamArg
					return &ret
				},
				Handler: func(ctx context.Context, args interface{}) (ret interface{}, err error) {
					typedArgs, ok := args.(*[1]NewlyAddedToTeamArg)
					if !ok {
						err = rpc.NewTypeError((*[1]NewlyAddedToTeamArg)(nil), args)
						return
					}
					err = i.NewlyAddedToTeam(ctx, typedArgs[0].TeamID)
					return
				},
				MethodType: rpc.MethodNotify,
			},
			"avatarUpdated": {
				MakeArg: func() interface{} {
					var ret [1]AvatarUpdatedArg
					return &ret
				},
				Handler: func(ctx context.Context, args interface{}) (ret interface{}, err error) {
					typedArgs, ok := args.(*[1]AvatarUpdatedArg)
					if !ok {
						err = rpc.NewTypeError((*[1]AvatarUpdatedArg)(nil), args)
						return
					}
					err = i.AvatarUpdated(ctx, typedArgs[0])
					return
				},
				MethodType: rpc.MethodNotify,
			},
		},
	}
}

type NotifyTeamClient struct {
	Cli rpc.GenericClient
}

func (c NotifyTeamClient) TeamChangedByID(ctx context.Context, __arg TeamChangedByIDArg) (err error) {
	err = c.Cli.Notify(ctx, "keybase.1.NotifyTeam.teamChangedByID", []interface{}{__arg})
	return
}

func (c NotifyTeamClient) TeamChangedByName(ctx context.Context, __arg TeamChangedByNameArg) (err error) {
	err = c.Cli.Notify(ctx, "keybase.1.NotifyTeam.teamChangedByName", []interface{}{__arg})
	return
}

func (c NotifyTeamClient) TeamDeleted(ctx context.Context, teamID TeamID) (err error) {
	__arg := TeamDeletedArg{TeamID: teamID}
	err = c.Cli.Notify(ctx, "keybase.1.NotifyTeam.teamDeleted", []interface{}{__arg})
	return
}

func (c NotifyTeamClient) TeamAbandoned(ctx context.Context, teamID TeamID) (err error) {
	__arg := TeamAbandonedArg{TeamID: teamID}
	err = c.Cli.Notify(ctx, "keybase.1.NotifyTeam.teamAbandoned", []interface{}{__arg})
	return
}

func (c NotifyTeamClient) TeamExit(ctx context.Context, teamID TeamID) (err error) {
	__arg := TeamExitArg{TeamID: teamID}
	err = c.Cli.Notify(ctx, "keybase.1.NotifyTeam.teamExit", []interface{}{__arg})
	return
}

func (c NotifyTeamClient) NewlyAddedToTeam(ctx context.Context, teamID TeamID) (err error) {
	__arg := NewlyAddedToTeamArg{TeamID: teamID}
	err = c.Cli.Notify(ctx, "keybase.1.NotifyTeam.newlyAddedToTeam", []interface{}{__arg})
	return
}

func (c NotifyTeamClient) AvatarUpdated(ctx context.Context, __arg AvatarUpdatedArg) (err error) {
	err = c.Cli.Notify(ctx, "keybase.1.NotifyTeam.avatarUpdated", []interface{}{__arg})
	return
}
