---
stage: Create
group: Code Review
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://about.gitlab.com/handbook/product/ux/technical-writing/#assignments
---

<!--
This documentation is auto generated by a script.
Please do not edit this file directly, check cmd/gen-docs/docs.go.
-->

# `glab completion`

Generate shell completion scripts

## Synopsis

The output of this command will be computer code and is meant to be saved 
to a file or immediately evaluated by an interactive shell.

For example, for bash you could add this to your `~/.bash_profile`:

```plaintext
eval "$(glab completion -s bash)"
```

Generate a `_glab` completion script and put it somewhere in your `$fpath`:

```plaintext
glab completion -s zsh > /usr/local/share/zsh/site-functions/_glab
```

Ensure that the following is present in your `~/.zshrc`:

- `autoload -U compinit`
- `compinit -i`

Zsh version 5.7 or later is recommended.

When installing glab through a package manager, however, it's possible that
no additional shell configuration is necessary to gain completion support. 
For Homebrew, see <https://docs.brew.sh/Shell-Completion>

```plaintext
glab completion [flags]
```

## Options

```plaintext
      --no-desc        Do not include shell completion description
  -s, --shell string   Shell type: {bash|zsh|fish|powershell} (default "bash")
```

## Options inherited from parent commands

```plaintext
      --help   Show help for command
```
