// Code generated by goa v3.8.5, DO NOT EDIT.
//
// resource HTTP client types
//
// Command:
// $ goa gen github.com/tektoncd/hub/api/v1/design

package client

import (
	resourceviews "github.com/tektoncd/hub/api/v1/gen/resource/views"
	goa "goa.design/goa/v3/pkg"
)

// QueryResponseBody is the type of the "resource" service "Query" endpoint
// HTTP response body.
type QueryResponseBody struct {
	Data ResourceDataCollectionResponseBody `form:"data,omitempty" json:"data,omitempty" xml:"data,omitempty"`
}

// ListResponseBody is the type of the "resource" service "List" endpoint HTTP
// response body.
type ListResponseBody struct {
	Data ResourceDataCollectionResponseBody `form:"data,omitempty" json:"data,omitempty" xml:"data,omitempty"`
}

// VersionsByIDResponseBody is the type of the "resource" service
// "VersionsByID" endpoint HTTP response body.
type VersionsByIDResponseBody struct {
	Data *VersionsResponseBody `form:"data,omitempty" json:"data,omitempty" xml:"data,omitempty"`
}

// ByCatalogKindNameVersionResponseBody is the type of the "resource" service
// "ByCatalogKindNameVersion" endpoint HTTP response body.
type ByCatalogKindNameVersionResponseBody struct {
	Data *ResourceVersionDataResponseBody `form:"data,omitempty" json:"data,omitempty" xml:"data,omitempty"`
}

// ByCatalogKindNameVersionReadmeResponseBody is the type of the "resource"
// service "ByCatalogKindNameVersionReadme" endpoint HTTP response body.
type ByCatalogKindNameVersionReadmeResponseBody struct {
	Data *ResourceContentResponseBody `form:"data,omitempty" json:"data,omitempty" xml:"data,omitempty"`
}

// ByCatalogKindNameVersionYamlResponseBody is the type of the "resource"
// service "ByCatalogKindNameVersionYaml" endpoint HTTP response body.
type ByCatalogKindNameVersionYamlResponseBody struct {
	Data *ResourceContentResponseBody `form:"data,omitempty" json:"data,omitempty" xml:"data,omitempty"`
}

// ByVersionIDResponseBody is the type of the "resource" service "ByVersionId"
// endpoint HTTP response body.
type ByVersionIDResponseBody struct {
	Data *ResourceVersionDataResponseBody `form:"data,omitempty" json:"data,omitempty" xml:"data,omitempty"`
}

// ByCatalogKindNameResponseBody is the type of the "resource" service
// "ByCatalogKindName" endpoint HTTP response body.
type ByCatalogKindNameResponseBody struct {
	Data *ResourceDataResponseBody `form:"data,omitempty" json:"data,omitempty" xml:"data,omitempty"`
}

// ByIDResponseBody is the type of the "resource" service "ById" endpoint HTTP
// response body.
type ByIDResponseBody struct {
	Data *ResourceDataResponseBody `form:"data,omitempty" json:"data,omitempty" xml:"data,omitempty"`
}

// QueryInternalErrorResponseBody is the type of the "resource" service "Query"
// endpoint HTTP response body for the "internal-error" error.
type QueryInternalErrorResponseBody struct {
	// Name is the name of this class of errors.
	Name *string `form:"name,omitempty" json:"name,omitempty" xml:"name,omitempty"`
	// ID is a unique identifier for this particular occurrence of the problem.
	ID *string `form:"id,omitempty" json:"id,omitempty" xml:"id,omitempty"`
	// Message is a human-readable explanation specific to this occurrence of the
	// problem.
	Message *string `form:"message,omitempty" json:"message,omitempty" xml:"message,omitempty"`
	// Is the error temporary?
	Temporary *bool `form:"temporary,omitempty" json:"temporary,omitempty" xml:"temporary,omitempty"`
	// Is the error a timeout?
	Timeout *bool `form:"timeout,omitempty" json:"timeout,omitempty" xml:"timeout,omitempty"`
	// Is the error a server-side fault?
	Fault *bool `form:"fault,omitempty" json:"fault,omitempty" xml:"fault,omitempty"`
}

// QueryInvalidKindResponseBody is the type of the "resource" service "Query"
// endpoint HTTP response body for the "invalid-kind" error.
type QueryInvalidKindResponseBody struct {
	// Name is the name of this class of errors.
	Name *string `form:"name,omitempty" json:"name,omitempty" xml:"name,omitempty"`
	// ID is a unique identifier for this particular occurrence of the problem.
	ID *string `form:"id,omitempty" json:"id,omitempty" xml:"id,omitempty"`
	// Message is a human-readable explanation specific to this occurrence of the
	// problem.
	Message *string `form:"message,omitempty" json:"message,omitempty" xml:"message,omitempty"`
	// Is the error temporary?
	Temporary *bool `form:"temporary,omitempty" json:"temporary,omitempty" xml:"temporary,omitempty"`
	// Is the error a timeout?
	Timeout *bool `form:"timeout,omitempty" json:"timeout,omitempty" xml:"timeout,omitempty"`
	// Is the error a server-side fault?
	Fault *bool `form:"fault,omitempty" json:"fault,omitempty" xml:"fault,omitempty"`
}

// QueryNotFoundResponseBody is the type of the "resource" service "Query"
// endpoint HTTP response body for the "not-found" error.
type QueryNotFoundResponseBody struct {
	// Name is the name of this class of errors.
	Name *string `form:"name,omitempty" json:"name,omitempty" xml:"name,omitempty"`
	// ID is a unique identifier for this particular occurrence of the problem.
	ID *string `form:"id,omitempty" json:"id,omitempty" xml:"id,omitempty"`
	// Message is a human-readable explanation specific to this occurrence of the
	// problem.
	Message *string `form:"message,omitempty" json:"message,omitempty" xml:"message,omitempty"`
	// Is the error temporary?
	Temporary *bool `form:"temporary,omitempty" json:"temporary,omitempty" xml:"temporary,omitempty"`
	// Is the error a timeout?
	Timeout *bool `form:"timeout,omitempty" json:"timeout,omitempty" xml:"timeout,omitempty"`
	// Is the error a server-side fault?
	Fault *bool `form:"fault,omitempty" json:"fault,omitempty" xml:"fault,omitempty"`
}

// ListInternalErrorResponseBody is the type of the "resource" service "List"
// endpoint HTTP response body for the "internal-error" error.
type ListInternalErrorResponseBody struct {
	// Name is the name of this class of errors.
	Name *string `form:"name,omitempty" json:"name,omitempty" xml:"name,omitempty"`
	// ID is a unique identifier for this particular occurrence of the problem.
	ID *string `form:"id,omitempty" json:"id,omitempty" xml:"id,omitempty"`
	// Message is a human-readable explanation specific to this occurrence of the
	// problem.
	Message *string `form:"message,omitempty" json:"message,omitempty" xml:"message,omitempty"`
	// Is the error temporary?
	Temporary *bool `form:"temporary,omitempty" json:"temporary,omitempty" xml:"temporary,omitempty"`
	// Is the error a timeout?
	Timeout *bool `form:"timeout,omitempty" json:"timeout,omitempty" xml:"timeout,omitempty"`
	// Is the error a server-side fault?
	Fault *bool `form:"fault,omitempty" json:"fault,omitempty" xml:"fault,omitempty"`
}

// ListNotFoundResponseBody is the type of the "resource" service "List"
// endpoint HTTP response body for the "not-found" error.
type ListNotFoundResponseBody struct {
	// Name is the name of this class of errors.
	Name *string `form:"name,omitempty" json:"name,omitempty" xml:"name,omitempty"`
	// ID is a unique identifier for this particular occurrence of the problem.
	ID *string `form:"id,omitempty" json:"id,omitempty" xml:"id,omitempty"`
	// Message is a human-readable explanation specific to this occurrence of the
	// problem.
	Message *string `form:"message,omitempty" json:"message,omitempty" xml:"message,omitempty"`
	// Is the error temporary?
	Temporary *bool `form:"temporary,omitempty" json:"temporary,omitempty" xml:"temporary,omitempty"`
	// Is the error a timeout?
	Timeout *bool `form:"timeout,omitempty" json:"timeout,omitempty" xml:"timeout,omitempty"`
	// Is the error a server-side fault?
	Fault *bool `form:"fault,omitempty" json:"fault,omitempty" xml:"fault,omitempty"`
}

// VersionsByIDInternalErrorResponseBody is the type of the "resource" service
// "VersionsByID" endpoint HTTP response body for the "internal-error" error.
type VersionsByIDInternalErrorResponseBody struct {
	// Name is the name of this class of errors.
	Name *string `form:"name,omitempty" json:"name,omitempty" xml:"name,omitempty"`
	// ID is a unique identifier for this particular occurrence of the problem.
	ID *string `form:"id,omitempty" json:"id,omitempty" xml:"id,omitempty"`
	// Message is a human-readable explanation specific to this occurrence of the
	// problem.
	Message *string `form:"message,omitempty" json:"message,omitempty" xml:"message,omitempty"`
	// Is the error temporary?
	Temporary *bool `form:"temporary,omitempty" json:"temporary,omitempty" xml:"temporary,omitempty"`
	// Is the error a timeout?
	Timeout *bool `form:"timeout,omitempty" json:"timeout,omitempty" xml:"timeout,omitempty"`
	// Is the error a server-side fault?
	Fault *bool `form:"fault,omitempty" json:"fault,omitempty" xml:"fault,omitempty"`
}

// VersionsByIDNotFoundResponseBody is the type of the "resource" service
// "VersionsByID" endpoint HTTP response body for the "not-found" error.
type VersionsByIDNotFoundResponseBody struct {
	// Name is the name of this class of errors.
	Name *string `form:"name,omitempty" json:"name,omitempty" xml:"name,omitempty"`
	// ID is a unique identifier for this particular occurrence of the problem.
	ID *string `form:"id,omitempty" json:"id,omitempty" xml:"id,omitempty"`
	// Message is a human-readable explanation specific to this occurrence of the
	// problem.
	Message *string `form:"message,omitempty" json:"message,omitempty" xml:"message,omitempty"`
	// Is the error temporary?
	Temporary *bool `form:"temporary,omitempty" json:"temporary,omitempty" xml:"temporary,omitempty"`
	// Is the error a timeout?
	Timeout *bool `form:"timeout,omitempty" json:"timeout,omitempty" xml:"timeout,omitempty"`
	// Is the error a server-side fault?
	Fault *bool `form:"fault,omitempty" json:"fault,omitempty" xml:"fault,omitempty"`
}

// ByCatalogKindNameVersionInternalErrorResponseBody is the type of the
// "resource" service "ByCatalogKindNameVersion" endpoint HTTP response body
// for the "internal-error" error.
type ByCatalogKindNameVersionInternalErrorResponseBody struct {
	// Name is the name of this class of errors.
	Name *string `form:"name,omitempty" json:"name,omitempty" xml:"name,omitempty"`
	// ID is a unique identifier for this particular occurrence of the problem.
	ID *string `form:"id,omitempty" json:"id,omitempty" xml:"id,omitempty"`
	// Message is a human-readable explanation specific to this occurrence of the
	// problem.
	Message *string `form:"message,omitempty" json:"message,omitempty" xml:"message,omitempty"`
	// Is the error temporary?
	Temporary *bool `form:"temporary,omitempty" json:"temporary,omitempty" xml:"temporary,omitempty"`
	// Is the error a timeout?
	Timeout *bool `form:"timeout,omitempty" json:"timeout,omitempty" xml:"timeout,omitempty"`
	// Is the error a server-side fault?
	Fault *bool `form:"fault,omitempty" json:"fault,omitempty" xml:"fault,omitempty"`
}

// ByCatalogKindNameVersionNotFoundResponseBody is the type of the "resource"
// service "ByCatalogKindNameVersion" endpoint HTTP response body for the
// "not-found" error.
type ByCatalogKindNameVersionNotFoundResponseBody struct {
	// Name is the name of this class of errors.
	Name *string `form:"name,omitempty" json:"name,omitempty" xml:"name,omitempty"`
	// ID is a unique identifier for this particular occurrence of the problem.
	ID *string `form:"id,omitempty" json:"id,omitempty" xml:"id,omitempty"`
	// Message is a human-readable explanation specific to this occurrence of the
	// problem.
	Message *string `form:"message,omitempty" json:"message,omitempty" xml:"message,omitempty"`
	// Is the error temporary?
	Temporary *bool `form:"temporary,omitempty" json:"temporary,omitempty" xml:"temporary,omitempty"`
	// Is the error a timeout?
	Timeout *bool `form:"timeout,omitempty" json:"timeout,omitempty" xml:"timeout,omitempty"`
	// Is the error a server-side fault?
	Fault *bool `form:"fault,omitempty" json:"fault,omitempty" xml:"fault,omitempty"`
}

// ByCatalogKindNameVersionReadmeInternalErrorResponseBody is the type of the
// "resource" service "ByCatalogKindNameVersionReadme" endpoint HTTP response
// body for the "internal-error" error.
type ByCatalogKindNameVersionReadmeInternalErrorResponseBody struct {
	// Name is the name of this class of errors.
	Name *string `form:"name,omitempty" json:"name,omitempty" xml:"name,omitempty"`
	// ID is a unique identifier for this particular occurrence of the problem.
	ID *string `form:"id,omitempty" json:"id,omitempty" xml:"id,omitempty"`
	// Message is a human-readable explanation specific to this occurrence of the
	// problem.
	Message *string `form:"message,omitempty" json:"message,omitempty" xml:"message,omitempty"`
	// Is the error temporary?
	Temporary *bool `form:"temporary,omitempty" json:"temporary,omitempty" xml:"temporary,omitempty"`
	// Is the error a timeout?
	Timeout *bool `form:"timeout,omitempty" json:"timeout,omitempty" xml:"timeout,omitempty"`
	// Is the error a server-side fault?
	Fault *bool `form:"fault,omitempty" json:"fault,omitempty" xml:"fault,omitempty"`
}

// ByCatalogKindNameVersionReadmeNotFoundResponseBody is the type of the
// "resource" service "ByCatalogKindNameVersionReadme" endpoint HTTP response
// body for the "not-found" error.
type ByCatalogKindNameVersionReadmeNotFoundResponseBody struct {
	// Name is the name of this class of errors.
	Name *string `form:"name,omitempty" json:"name,omitempty" xml:"name,omitempty"`
	// ID is a unique identifier for this particular occurrence of the problem.
	ID *string `form:"id,omitempty" json:"id,omitempty" xml:"id,omitempty"`
	// Message is a human-readable explanation specific to this occurrence of the
	// problem.
	Message *string `form:"message,omitempty" json:"message,omitempty" xml:"message,omitempty"`
	// Is the error temporary?
	Temporary *bool `form:"temporary,omitempty" json:"temporary,omitempty" xml:"temporary,omitempty"`
	// Is the error a timeout?
	Timeout *bool `form:"timeout,omitempty" json:"timeout,omitempty" xml:"timeout,omitempty"`
	// Is the error a server-side fault?
	Fault *bool `form:"fault,omitempty" json:"fault,omitempty" xml:"fault,omitempty"`
}

// ByCatalogKindNameVersionYamlInternalErrorResponseBody is the type of the
// "resource" service "ByCatalogKindNameVersionYaml" endpoint HTTP response
// body for the "internal-error" error.
type ByCatalogKindNameVersionYamlInternalErrorResponseBody struct {
	// Name is the name of this class of errors.
	Name *string `form:"name,omitempty" json:"name,omitempty" xml:"name,omitempty"`
	// ID is a unique identifier for this particular occurrence of the problem.
	ID *string `form:"id,omitempty" json:"id,omitempty" xml:"id,omitempty"`
	// Message is a human-readable explanation specific to this occurrence of the
	// problem.
	Message *string `form:"message,omitempty" json:"message,omitempty" xml:"message,omitempty"`
	// Is the error temporary?
	Temporary *bool `form:"temporary,omitempty" json:"temporary,omitempty" xml:"temporary,omitempty"`
	// Is the error a timeout?
	Timeout *bool `form:"timeout,omitempty" json:"timeout,omitempty" xml:"timeout,omitempty"`
	// Is the error a server-side fault?
	Fault *bool `form:"fault,omitempty" json:"fault,omitempty" xml:"fault,omitempty"`
}

// ByCatalogKindNameVersionYamlNotFoundResponseBody is the type of the
// "resource" service "ByCatalogKindNameVersionYaml" endpoint HTTP response
// body for the "not-found" error.
type ByCatalogKindNameVersionYamlNotFoundResponseBody struct {
	// Name is the name of this class of errors.
	Name *string `form:"name,omitempty" json:"name,omitempty" xml:"name,omitempty"`
	// ID is a unique identifier for this particular occurrence of the problem.
	ID *string `form:"id,omitempty" json:"id,omitempty" xml:"id,omitempty"`
	// Message is a human-readable explanation specific to this occurrence of the
	// problem.
	Message *string `form:"message,omitempty" json:"message,omitempty" xml:"message,omitempty"`
	// Is the error temporary?
	Temporary *bool `form:"temporary,omitempty" json:"temporary,omitempty" xml:"temporary,omitempty"`
	// Is the error a timeout?
	Timeout *bool `form:"timeout,omitempty" json:"timeout,omitempty" xml:"timeout,omitempty"`
	// Is the error a server-side fault?
	Fault *bool `form:"fault,omitempty" json:"fault,omitempty" xml:"fault,omitempty"`
}

// ByVersionIDInternalErrorResponseBody is the type of the "resource" service
// "ByVersionId" endpoint HTTP response body for the "internal-error" error.
type ByVersionIDInternalErrorResponseBody struct {
	// Name is the name of this class of errors.
	Name *string `form:"name,omitempty" json:"name,omitempty" xml:"name,omitempty"`
	// ID is a unique identifier for this particular occurrence of the problem.
	ID *string `form:"id,omitempty" json:"id,omitempty" xml:"id,omitempty"`
	// Message is a human-readable explanation specific to this occurrence of the
	// problem.
	Message *string `form:"message,omitempty" json:"message,omitempty" xml:"message,omitempty"`
	// Is the error temporary?
	Temporary *bool `form:"temporary,omitempty" json:"temporary,omitempty" xml:"temporary,omitempty"`
	// Is the error a timeout?
	Timeout *bool `form:"timeout,omitempty" json:"timeout,omitempty" xml:"timeout,omitempty"`
	// Is the error a server-side fault?
	Fault *bool `form:"fault,omitempty" json:"fault,omitempty" xml:"fault,omitempty"`
}

// ByVersionIDNotFoundResponseBody is the type of the "resource" service
// "ByVersionId" endpoint HTTP response body for the "not-found" error.
type ByVersionIDNotFoundResponseBody struct {
	// Name is the name of this class of errors.
	Name *string `form:"name,omitempty" json:"name,omitempty" xml:"name,omitempty"`
	// ID is a unique identifier for this particular occurrence of the problem.
	ID *string `form:"id,omitempty" json:"id,omitempty" xml:"id,omitempty"`
	// Message is a human-readable explanation specific to this occurrence of the
	// problem.
	Message *string `form:"message,omitempty" json:"message,omitempty" xml:"message,omitempty"`
	// Is the error temporary?
	Temporary *bool `form:"temporary,omitempty" json:"temporary,omitempty" xml:"temporary,omitempty"`
	// Is the error a timeout?
	Timeout *bool `form:"timeout,omitempty" json:"timeout,omitempty" xml:"timeout,omitempty"`
	// Is the error a server-side fault?
	Fault *bool `form:"fault,omitempty" json:"fault,omitempty" xml:"fault,omitempty"`
}

// ByCatalogKindNameInternalErrorResponseBody is the type of the "resource"
// service "ByCatalogKindName" endpoint HTTP response body for the
// "internal-error" error.
type ByCatalogKindNameInternalErrorResponseBody struct {
	// Name is the name of this class of errors.
	Name *string `form:"name,omitempty" json:"name,omitempty" xml:"name,omitempty"`
	// ID is a unique identifier for this particular occurrence of the problem.
	ID *string `form:"id,omitempty" json:"id,omitempty" xml:"id,omitempty"`
	// Message is a human-readable explanation specific to this occurrence of the
	// problem.
	Message *string `form:"message,omitempty" json:"message,omitempty" xml:"message,omitempty"`
	// Is the error temporary?
	Temporary *bool `form:"temporary,omitempty" json:"temporary,omitempty" xml:"temporary,omitempty"`
	// Is the error a timeout?
	Timeout *bool `form:"timeout,omitempty" json:"timeout,omitempty" xml:"timeout,omitempty"`
	// Is the error a server-side fault?
	Fault *bool `form:"fault,omitempty" json:"fault,omitempty" xml:"fault,omitempty"`
}

// ByCatalogKindNameNotFoundResponseBody is the type of the "resource" service
// "ByCatalogKindName" endpoint HTTP response body for the "not-found" error.
type ByCatalogKindNameNotFoundResponseBody struct {
	// Name is the name of this class of errors.
	Name *string `form:"name,omitempty" json:"name,omitempty" xml:"name,omitempty"`
	// ID is a unique identifier for this particular occurrence of the problem.
	ID *string `form:"id,omitempty" json:"id,omitempty" xml:"id,omitempty"`
	// Message is a human-readable explanation specific to this occurrence of the
	// problem.
	Message *string `form:"message,omitempty" json:"message,omitempty" xml:"message,omitempty"`
	// Is the error temporary?
	Temporary *bool `form:"temporary,omitempty" json:"temporary,omitempty" xml:"temporary,omitempty"`
	// Is the error a timeout?
	Timeout *bool `form:"timeout,omitempty" json:"timeout,omitempty" xml:"timeout,omitempty"`
	// Is the error a server-side fault?
	Fault *bool `form:"fault,omitempty" json:"fault,omitempty" xml:"fault,omitempty"`
}

// ByIDInternalErrorResponseBody is the type of the "resource" service "ById"
// endpoint HTTP response body for the "internal-error" error.
type ByIDInternalErrorResponseBody struct {
	// Name is the name of this class of errors.
	Name *string `form:"name,omitempty" json:"name,omitempty" xml:"name,omitempty"`
	// ID is a unique identifier for this particular occurrence of the problem.
	ID *string `form:"id,omitempty" json:"id,omitempty" xml:"id,omitempty"`
	// Message is a human-readable explanation specific to this occurrence of the
	// problem.
	Message *string `form:"message,omitempty" json:"message,omitempty" xml:"message,omitempty"`
	// Is the error temporary?
	Temporary *bool `form:"temporary,omitempty" json:"temporary,omitempty" xml:"temporary,omitempty"`
	// Is the error a timeout?
	Timeout *bool `form:"timeout,omitempty" json:"timeout,omitempty" xml:"timeout,omitempty"`
	// Is the error a server-side fault?
	Fault *bool `form:"fault,omitempty" json:"fault,omitempty" xml:"fault,omitempty"`
}

// ByIDNotFoundResponseBody is the type of the "resource" service "ById"
// endpoint HTTP response body for the "not-found" error.
type ByIDNotFoundResponseBody struct {
	// Name is the name of this class of errors.
	Name *string `form:"name,omitempty" json:"name,omitempty" xml:"name,omitempty"`
	// ID is a unique identifier for this particular occurrence of the problem.
	ID *string `form:"id,omitempty" json:"id,omitempty" xml:"id,omitempty"`
	// Message is a human-readable explanation specific to this occurrence of the
	// problem.
	Message *string `form:"message,omitempty" json:"message,omitempty" xml:"message,omitempty"`
	// Is the error temporary?
	Temporary *bool `form:"temporary,omitempty" json:"temporary,omitempty" xml:"temporary,omitempty"`
	// Is the error a timeout?
	Timeout *bool `form:"timeout,omitempty" json:"timeout,omitempty" xml:"timeout,omitempty"`
	// Is the error a server-side fault?
	Fault *bool `form:"fault,omitempty" json:"fault,omitempty" xml:"fault,omitempty"`
}

// GetRawYamlByCatalogKindNameVersionInternalErrorResponseBody is the type of
// the "resource" service "GetRawYamlByCatalogKindNameVersion" endpoint HTTP
// response body for the "internal-error" error.
type GetRawYamlByCatalogKindNameVersionInternalErrorResponseBody struct {
	// Name is the name of this class of errors.
	Name *string `form:"name,omitempty" json:"name,omitempty" xml:"name,omitempty"`
	// ID is a unique identifier for this particular occurrence of the problem.
	ID *string `form:"id,omitempty" json:"id,omitempty" xml:"id,omitempty"`
	// Message is a human-readable explanation specific to this occurrence of the
	// problem.
	Message *string `form:"message,omitempty" json:"message,omitempty" xml:"message,omitempty"`
	// Is the error temporary?
	Temporary *bool `form:"temporary,omitempty" json:"temporary,omitempty" xml:"temporary,omitempty"`
	// Is the error a timeout?
	Timeout *bool `form:"timeout,omitempty" json:"timeout,omitempty" xml:"timeout,omitempty"`
	// Is the error a server-side fault?
	Fault *bool `form:"fault,omitempty" json:"fault,omitempty" xml:"fault,omitempty"`
}

// GetRawYamlByCatalogKindNameVersionNotFoundResponseBody is the type of the
// "resource" service "GetRawYamlByCatalogKindNameVersion" endpoint HTTP
// response body for the "not-found" error.
type GetRawYamlByCatalogKindNameVersionNotFoundResponseBody struct {
	// Name is the name of this class of errors.
	Name *string `form:"name,omitempty" json:"name,omitempty" xml:"name,omitempty"`
	// ID is a unique identifier for this particular occurrence of the problem.
	ID *string `form:"id,omitempty" json:"id,omitempty" xml:"id,omitempty"`
	// Message is a human-readable explanation specific to this occurrence of the
	// problem.
	Message *string `form:"message,omitempty" json:"message,omitempty" xml:"message,omitempty"`
	// Is the error temporary?
	Temporary *bool `form:"temporary,omitempty" json:"temporary,omitempty" xml:"temporary,omitempty"`
	// Is the error a timeout?
	Timeout *bool `form:"timeout,omitempty" json:"timeout,omitempty" xml:"timeout,omitempty"`
	// Is the error a server-side fault?
	Fault *bool `form:"fault,omitempty" json:"fault,omitempty" xml:"fault,omitempty"`
}

// ResourceDataCollectionResponseBody is used to define fields on response body
// types.
type ResourceDataCollectionResponseBody []*ResourceDataResponseBody

// ResourceDataResponseBody is used to define fields on response body types.
type ResourceDataResponseBody struct {
	// ID is the unique id of the resource
	ID *uint `form:"id,omitempty" json:"id,omitempty" xml:"id,omitempty"`
	// Name of resource
	Name *string `form:"name,omitempty" json:"name,omitempty" xml:"name,omitempty"`
	// Type of catalog to which resource belongs
	Catalog *CatalogResponseBody `form:"catalog,omitempty" json:"catalog,omitempty" xml:"catalog,omitempty"`
	// Categories related to resource
	Categories []*CategoryResponseBody `form:"categories,omitempty" json:"categories,omitempty" xml:"categories,omitempty"`
	// Kind of resource
	Kind *string `form:"kind,omitempty" json:"kind,omitempty" xml:"kind,omitempty"`
	// Url path of the resource in hub
	HubURLPath *string `form:"hubURLPath,omitempty" json:"hubURLPath,omitempty" xml:"hubURLPath,omitempty"`
	// Latest version of resource
	LatestVersion *ResourceVersionDataResponseBody `form:"latestVersion,omitempty" json:"latestVersion,omitempty" xml:"latestVersion,omitempty"`
	// Tags related to resource
	Tags []*TagResponseBody `form:"tags,omitempty" json:"tags,omitempty" xml:"tags,omitempty"`
	// Platforms related to resource
	Platforms []*PlatformResponseBody `form:"platforms,omitempty" json:"platforms,omitempty" xml:"platforms,omitempty"`
	// Rating of resource
	Rating *float64 `form:"rating,omitempty" json:"rating,omitempty" xml:"rating,omitempty"`
	// List of all versions of a resource
	Versions []*ResourceVersionDataResponseBody `form:"versions,omitempty" json:"versions,omitempty" xml:"versions,omitempty"`
}

// CatalogResponseBody is used to define fields on response body types.
type CatalogResponseBody struct {
	// ID is the unique id of the catalog
	ID *uint `form:"id,omitempty" json:"id,omitempty" xml:"id,omitempty"`
	// Name of catalog
	Name *string `form:"name,omitempty" json:"name,omitempty" xml:"name,omitempty"`
	// Type of catalog
	Type *string `form:"type,omitempty" json:"type,omitempty" xml:"type,omitempty"`
	// URL of catalog
	URL *string `form:"url,omitempty" json:"url,omitempty" xml:"url,omitempty"`
	// Provider of catalog
	Provider *string `form:"provider,omitempty" json:"provider,omitempty" xml:"provider,omitempty"`
}

// CategoryResponseBody is used to define fields on response body types.
type CategoryResponseBody struct {
	// ID is the unique id of the category
	ID *uint `form:"id,omitempty" json:"id,omitempty" xml:"id,omitempty"`
	// Name of category
	Name *string `form:"name,omitempty" json:"name,omitempty" xml:"name,omitempty"`
}

// ResourceVersionDataResponseBody is used to define fields on response body
// types.
type ResourceVersionDataResponseBody struct {
	// ID is the unique id of resource's version
	ID *uint `form:"id,omitempty" json:"id,omitempty" xml:"id,omitempty"`
	// Version of resource
	Version *string `form:"version,omitempty" json:"version,omitempty" xml:"version,omitempty"`
	// Display name of version
	DisplayName *string `form:"displayName,omitempty" json:"displayName,omitempty" xml:"displayName,omitempty"`
	// Deprecation status of a version
	Deprecated *bool `form:"deprecated,omitempty" json:"deprecated,omitempty" xml:"deprecated,omitempty"`
	// Description of version
	Description *string `form:"description,omitempty" json:"description,omitempty" xml:"description,omitempty"`
	// Minimum pipelines version the resource's version is compatible with
	MinPipelinesVersion *string `form:"minPipelinesVersion,omitempty" json:"minPipelinesVersion,omitempty" xml:"minPipelinesVersion,omitempty"`
	// Raw URL of resource's yaml file of the version
	RawURL *string `form:"rawURL,omitempty" json:"rawURL,omitempty" xml:"rawURL,omitempty"`
	// Web URL of resource's yaml file of the version
	WebURL *string `form:"webURL,omitempty" json:"webURL,omitempty" xml:"webURL,omitempty"`
	// Timestamp when version was last updated
	UpdatedAt *string `form:"updatedAt,omitempty" json:"updatedAt,omitempty" xml:"updatedAt,omitempty"`
	// Platforms related to resource version
	Platforms []*PlatformResponseBody `form:"platforms,omitempty" json:"platforms,omitempty" xml:"platforms,omitempty"`
	// Url path of the resource in hub
	HubURLPath *string `form:"hubURLPath,omitempty" json:"hubURLPath,omitempty" xml:"hubURLPath,omitempty"`
	// Resource to which the version belongs
	Resource *ResourceDataResponseBody `form:"resource,omitempty" json:"resource,omitempty" xml:"resource,omitempty"`
}

// PlatformResponseBody is used to define fields on response body types.
type PlatformResponseBody struct {
	// ID is the unique id of platform
	ID *uint `form:"id,omitempty" json:"id,omitempty" xml:"id,omitempty"`
	// Name of platform
	Name *string `form:"name,omitempty" json:"name,omitempty" xml:"name,omitempty"`
}

// TagResponseBody is used to define fields on response body types.
type TagResponseBody struct {
	// ID is the unique id of tag
	ID *uint `form:"id,omitempty" json:"id,omitempty" xml:"id,omitempty"`
	// Name of tag
	Name *string `form:"name,omitempty" json:"name,omitempty" xml:"name,omitempty"`
}

// VersionsResponseBody is used to define fields on response body types.
type VersionsResponseBody struct {
	// Latest Version of resource
	Latest *ResourceVersionDataResponseBody `form:"latest,omitempty" json:"latest,omitempty" xml:"latest,omitempty"`
	// List of all versions of resource
	Versions []*ResourceVersionDataResponseBody `form:"versions,omitempty" json:"versions,omitempty" xml:"versions,omitempty"`
}

// ResourceContentResponseBody is used to define fields on response body types.
type ResourceContentResponseBody struct {
	// Readme
	Readme *string `form:"readme,omitempty" json:"readme,omitempty" xml:"readme,omitempty"`
	// Yaml
	Yaml *string `form:"yaml,omitempty" json:"yaml,omitempty" xml:"yaml,omitempty"`
}

// NewQueryResourcesOK builds a "resource" service "Query" endpoint result from
// a HTTP "OK" response.
func NewQueryResourcesOK(body *QueryResponseBody) *resourceviews.ResourcesView {
	v := &resourceviews.ResourcesView{}
	v.Data = make([]*resourceviews.ResourceDataView, len(body.Data))
	for i, val := range body.Data {
		v.Data[i] = unmarshalResourceDataResponseBodyToResourceviewsResourceDataView(val)
	}

	return v
}

// NewQueryInternalError builds a resource service Query endpoint
// internal-error error.
func NewQueryInternalError(body *QueryInternalErrorResponseBody) *goa.ServiceError {
	v := &goa.ServiceError{
		Name:      *body.Name,
		ID:        *body.ID,
		Message:   *body.Message,
		Temporary: *body.Temporary,
		Timeout:   *body.Timeout,
		Fault:     *body.Fault,
	}

	return v
}

// NewQueryInvalidKind builds a resource service Query endpoint invalid-kind
// error.
func NewQueryInvalidKind(body *QueryInvalidKindResponseBody) *goa.ServiceError {
	v := &goa.ServiceError{
		Name:      *body.Name,
		ID:        *body.ID,
		Message:   *body.Message,
		Temporary: *body.Temporary,
		Timeout:   *body.Timeout,
		Fault:     *body.Fault,
	}

	return v
}

// NewQueryNotFound builds a resource service Query endpoint not-found error.
func NewQueryNotFound(body *QueryNotFoundResponseBody) *goa.ServiceError {
	v := &goa.ServiceError{
		Name:      *body.Name,
		ID:        *body.ID,
		Message:   *body.Message,
		Temporary: *body.Temporary,
		Timeout:   *body.Timeout,
		Fault:     *body.Fault,
	}

	return v
}

// NewListResourcesOK builds a "resource" service "List" endpoint result from a
// HTTP "OK" response.
func NewListResourcesOK(body *ListResponseBody) *resourceviews.ResourcesView {
	v := &resourceviews.ResourcesView{}
	v.Data = make([]*resourceviews.ResourceDataView, len(body.Data))
	for i, val := range body.Data {
		v.Data[i] = unmarshalResourceDataResponseBodyToResourceviewsResourceDataView(val)
	}

	return v
}

// NewListInternalError builds a resource service List endpoint internal-error
// error.
func NewListInternalError(body *ListInternalErrorResponseBody) *goa.ServiceError {
	v := &goa.ServiceError{
		Name:      *body.Name,
		ID:        *body.ID,
		Message:   *body.Message,
		Temporary: *body.Temporary,
		Timeout:   *body.Timeout,
		Fault:     *body.Fault,
	}

	return v
}

// NewListNotFound builds a resource service List endpoint not-found error.
func NewListNotFound(body *ListNotFoundResponseBody) *goa.ServiceError {
	v := &goa.ServiceError{
		Name:      *body.Name,
		ID:        *body.ID,
		Message:   *body.Message,
		Temporary: *body.Temporary,
		Timeout:   *body.Timeout,
		Fault:     *body.Fault,
	}

	return v
}

// NewVersionsByIDResourceVersionsOK builds a "resource" service "VersionsByID"
// endpoint result from a HTTP "OK" response.
func NewVersionsByIDResourceVersionsOK(body *VersionsByIDResponseBody) *resourceviews.ResourceVersionsView {
	v := &resourceviews.ResourceVersionsView{}
	v.Data = unmarshalVersionsResponseBodyToResourceviewsVersionsView(body.Data)

	return v
}

// NewVersionsByIDInternalError builds a resource service VersionsByID endpoint
// internal-error error.
func NewVersionsByIDInternalError(body *VersionsByIDInternalErrorResponseBody) *goa.ServiceError {
	v := &goa.ServiceError{
		Name:      *body.Name,
		ID:        *body.ID,
		Message:   *body.Message,
		Temporary: *body.Temporary,
		Timeout:   *body.Timeout,
		Fault:     *body.Fault,
	}

	return v
}

// NewVersionsByIDNotFound builds a resource service VersionsByID endpoint
// not-found error.
func NewVersionsByIDNotFound(body *VersionsByIDNotFoundResponseBody) *goa.ServiceError {
	v := &goa.ServiceError{
		Name:      *body.Name,
		ID:        *body.ID,
		Message:   *body.Message,
		Temporary: *body.Temporary,
		Timeout:   *body.Timeout,
		Fault:     *body.Fault,
	}

	return v
}

// NewByCatalogKindNameVersionResourceVersionOK builds a "resource" service
// "ByCatalogKindNameVersion" endpoint result from a HTTP "OK" response.
func NewByCatalogKindNameVersionResourceVersionOK(body *ByCatalogKindNameVersionResponseBody) *resourceviews.ResourceVersionView {
	v := &resourceviews.ResourceVersionView{}
	v.Data = unmarshalResourceVersionDataResponseBodyToResourceviewsResourceVersionDataView(body.Data)

	return v
}

// NewByCatalogKindNameVersionInternalError builds a resource service
// ByCatalogKindNameVersion endpoint internal-error error.
func NewByCatalogKindNameVersionInternalError(body *ByCatalogKindNameVersionInternalErrorResponseBody) *goa.ServiceError {
	v := &goa.ServiceError{
		Name:      *body.Name,
		ID:        *body.ID,
		Message:   *body.Message,
		Temporary: *body.Temporary,
		Timeout:   *body.Timeout,
		Fault:     *body.Fault,
	}

	return v
}

// NewByCatalogKindNameVersionNotFound builds a resource service
// ByCatalogKindNameVersion endpoint not-found error.
func NewByCatalogKindNameVersionNotFound(body *ByCatalogKindNameVersionNotFoundResponseBody) *goa.ServiceError {
	v := &goa.ServiceError{
		Name:      *body.Name,
		ID:        *body.ID,
		Message:   *body.Message,
		Temporary: *body.Temporary,
		Timeout:   *body.Timeout,
		Fault:     *body.Fault,
	}

	return v
}

// NewByCatalogKindNameVersionReadmeResourceVersionReadmeOK builds a "resource"
// service "ByCatalogKindNameVersionReadme" endpoint result from a HTTP "OK"
// response.
func NewByCatalogKindNameVersionReadmeResourceVersionReadmeOK(body *ByCatalogKindNameVersionReadmeResponseBody) *resourceviews.ResourceVersionReadmeView {
	v := &resourceviews.ResourceVersionReadmeView{}
	v.Data = unmarshalResourceContentResponseBodyToResourceviewsResourceContentView(body.Data)

	return v
}

// NewByCatalogKindNameVersionReadmeInternalError builds a resource service
// ByCatalogKindNameVersionReadme endpoint internal-error error.
func NewByCatalogKindNameVersionReadmeInternalError(body *ByCatalogKindNameVersionReadmeInternalErrorResponseBody) *goa.ServiceError {
	v := &goa.ServiceError{
		Name:      *body.Name,
		ID:        *body.ID,
		Message:   *body.Message,
		Temporary: *body.Temporary,
		Timeout:   *body.Timeout,
		Fault:     *body.Fault,
	}

	return v
}

// NewByCatalogKindNameVersionReadmeNotFound builds a resource service
// ByCatalogKindNameVersionReadme endpoint not-found error.
func NewByCatalogKindNameVersionReadmeNotFound(body *ByCatalogKindNameVersionReadmeNotFoundResponseBody) *goa.ServiceError {
	v := &goa.ServiceError{
		Name:      *body.Name,
		ID:        *body.ID,
		Message:   *body.Message,
		Temporary: *body.Temporary,
		Timeout:   *body.Timeout,
		Fault:     *body.Fault,
	}

	return v
}

// NewByCatalogKindNameVersionYamlResourceVersionYamlOK builds a "resource"
// service "ByCatalogKindNameVersionYaml" endpoint result from a HTTP "OK"
// response.
func NewByCatalogKindNameVersionYamlResourceVersionYamlOK(body *ByCatalogKindNameVersionYamlResponseBody) *resourceviews.ResourceVersionYamlView {
	v := &resourceviews.ResourceVersionYamlView{}
	v.Data = unmarshalResourceContentResponseBodyToResourceviewsResourceContentView(body.Data)

	return v
}

// NewByCatalogKindNameVersionYamlInternalError builds a resource service
// ByCatalogKindNameVersionYaml endpoint internal-error error.
func NewByCatalogKindNameVersionYamlInternalError(body *ByCatalogKindNameVersionYamlInternalErrorResponseBody) *goa.ServiceError {
	v := &goa.ServiceError{
		Name:      *body.Name,
		ID:        *body.ID,
		Message:   *body.Message,
		Temporary: *body.Temporary,
		Timeout:   *body.Timeout,
		Fault:     *body.Fault,
	}

	return v
}

// NewByCatalogKindNameVersionYamlNotFound builds a resource service
// ByCatalogKindNameVersionYaml endpoint not-found error.
func NewByCatalogKindNameVersionYamlNotFound(body *ByCatalogKindNameVersionYamlNotFoundResponseBody) *goa.ServiceError {
	v := &goa.ServiceError{
		Name:      *body.Name,
		ID:        *body.ID,
		Message:   *body.Message,
		Temporary: *body.Temporary,
		Timeout:   *body.Timeout,
		Fault:     *body.Fault,
	}

	return v
}

// NewByVersionIDResourceVersionOK builds a "resource" service "ByVersionId"
// endpoint result from a HTTP "OK" response.
func NewByVersionIDResourceVersionOK(body *ByVersionIDResponseBody) *resourceviews.ResourceVersionView {
	v := &resourceviews.ResourceVersionView{}
	v.Data = unmarshalResourceVersionDataResponseBodyToResourceviewsResourceVersionDataView(body.Data)

	return v
}

// NewByVersionIDInternalError builds a resource service ByVersionId endpoint
// internal-error error.
func NewByVersionIDInternalError(body *ByVersionIDInternalErrorResponseBody) *goa.ServiceError {
	v := &goa.ServiceError{
		Name:      *body.Name,
		ID:        *body.ID,
		Message:   *body.Message,
		Temporary: *body.Temporary,
		Timeout:   *body.Timeout,
		Fault:     *body.Fault,
	}

	return v
}

// NewByVersionIDNotFound builds a resource service ByVersionId endpoint
// not-found error.
func NewByVersionIDNotFound(body *ByVersionIDNotFoundResponseBody) *goa.ServiceError {
	v := &goa.ServiceError{
		Name:      *body.Name,
		ID:        *body.ID,
		Message:   *body.Message,
		Temporary: *body.Temporary,
		Timeout:   *body.Timeout,
		Fault:     *body.Fault,
	}

	return v
}

// NewByCatalogKindNameResourceOK builds a "resource" service
// "ByCatalogKindName" endpoint result from a HTTP "OK" response.
func NewByCatalogKindNameResourceOK(body *ByCatalogKindNameResponseBody) *resourceviews.ResourceView {
	v := &resourceviews.ResourceView{}
	v.Data = unmarshalResourceDataResponseBodyToResourceviewsResourceDataView(body.Data)

	return v
}

// NewByCatalogKindNameInternalError builds a resource service
// ByCatalogKindName endpoint internal-error error.
func NewByCatalogKindNameInternalError(body *ByCatalogKindNameInternalErrorResponseBody) *goa.ServiceError {
	v := &goa.ServiceError{
		Name:      *body.Name,
		ID:        *body.ID,
		Message:   *body.Message,
		Temporary: *body.Temporary,
		Timeout:   *body.Timeout,
		Fault:     *body.Fault,
	}

	return v
}

// NewByCatalogKindNameNotFound builds a resource service ByCatalogKindName
// endpoint not-found error.
func NewByCatalogKindNameNotFound(body *ByCatalogKindNameNotFoundResponseBody) *goa.ServiceError {
	v := &goa.ServiceError{
		Name:      *body.Name,
		ID:        *body.ID,
		Message:   *body.Message,
		Temporary: *body.Temporary,
		Timeout:   *body.Timeout,
		Fault:     *body.Fault,
	}

	return v
}

// NewByIDResourceOK builds a "resource" service "ById" endpoint result from a
// HTTP "OK" response.
func NewByIDResourceOK(body *ByIDResponseBody) *resourceviews.ResourceView {
	v := &resourceviews.ResourceView{}
	v.Data = unmarshalResourceDataResponseBodyToResourceviewsResourceDataView(body.Data)

	return v
}

// NewByIDInternalError builds a resource service ById endpoint internal-error
// error.
func NewByIDInternalError(body *ByIDInternalErrorResponseBody) *goa.ServiceError {
	v := &goa.ServiceError{
		Name:      *body.Name,
		ID:        *body.ID,
		Message:   *body.Message,
		Temporary: *body.Temporary,
		Timeout:   *body.Timeout,
		Fault:     *body.Fault,
	}

	return v
}

// NewByIDNotFound builds a resource service ById endpoint not-found error.
func NewByIDNotFound(body *ByIDNotFoundResponseBody) *goa.ServiceError {
	v := &goa.ServiceError{
		Name:      *body.Name,
		ID:        *body.ID,
		Message:   *body.Message,
		Temporary: *body.Temporary,
		Timeout:   *body.Timeout,
		Fault:     *body.Fault,
	}

	return v
}

// NewGetRawYamlByCatalogKindNameVersionInternalError builds a resource service
// GetRawYamlByCatalogKindNameVersion endpoint internal-error error.
func NewGetRawYamlByCatalogKindNameVersionInternalError(body *GetRawYamlByCatalogKindNameVersionInternalErrorResponseBody) *goa.ServiceError {
	v := &goa.ServiceError{
		Name:      *body.Name,
		ID:        *body.ID,
		Message:   *body.Message,
		Temporary: *body.Temporary,
		Timeout:   *body.Timeout,
		Fault:     *body.Fault,
	}

	return v
}

// NewGetRawYamlByCatalogKindNameVersionNotFound builds a resource service
// GetRawYamlByCatalogKindNameVersion endpoint not-found error.
func NewGetRawYamlByCatalogKindNameVersionNotFound(body *GetRawYamlByCatalogKindNameVersionNotFoundResponseBody) *goa.ServiceError {
	v := &goa.ServiceError{
		Name:      *body.Name,
		ID:        *body.ID,
		Message:   *body.Message,
		Temporary: *body.Temporary,
		Timeout:   *body.Timeout,
		Fault:     *body.Fault,
	}

	return v
}

// ValidateQueryInternalErrorResponseBody runs the validations defined on
// Query_internal-error_Response_Body
func ValidateQueryInternalErrorResponseBody(body *QueryInternalErrorResponseBody) (err error) {
	if body.Name == nil {
		err = goa.MergeErrors(err, goa.MissingFieldError("name", "body"))
	}
	if body.ID == nil {
		err = goa.MergeErrors(err, goa.MissingFieldError("id", "body"))
	}
	if body.Message == nil {
		err = goa.MergeErrors(err, goa.MissingFieldError("message", "body"))
	}
	if body.Temporary == nil {
		err = goa.MergeErrors(err, goa.MissingFieldError("temporary", "body"))
	}
	if body.Timeout == nil {
		err = goa.MergeErrors(err, goa.MissingFieldError("timeout", "body"))
	}
	if body.Fault == nil {
		err = goa.MergeErrors(err, goa.MissingFieldError("fault", "body"))
	}
	return
}

// ValidateQueryInvalidKindResponseBody runs the validations defined on
// Query_invalid-kind_Response_Body
func ValidateQueryInvalidKindResponseBody(body *QueryInvalidKindResponseBody) (err error) {
	if body.Name == nil {
		err = goa.MergeErrors(err, goa.MissingFieldError("name", "body"))
	}
	if body.ID == nil {
		err = goa.MergeErrors(err, goa.MissingFieldError("id", "body"))
	}
	if body.Message == nil {
		err = goa.MergeErrors(err, goa.MissingFieldError("message", "body"))
	}
	if body.Temporary == nil {
		err = goa.MergeErrors(err, goa.MissingFieldError("temporary", "body"))
	}
	if body.Timeout == nil {
		err = goa.MergeErrors(err, goa.MissingFieldError("timeout", "body"))
	}
	if body.Fault == nil {
		err = goa.MergeErrors(err, goa.MissingFieldError("fault", "body"))
	}
	return
}

// ValidateQueryNotFoundResponseBody runs the validations defined on
// Query_not-found_Response_Body
func ValidateQueryNotFoundResponseBody(body *QueryNotFoundResponseBody) (err error) {
	if body.Name == nil {
		err = goa.MergeErrors(err, goa.MissingFieldError("name", "body"))
	}
	if body.ID == nil {
		err = goa.MergeErrors(err, goa.MissingFieldError("id", "body"))
	}
	if body.Message == nil {
		err = goa.MergeErrors(err, goa.MissingFieldError("message", "body"))
	}
	if body.Temporary == nil {
		err = goa.MergeErrors(err, goa.MissingFieldError("temporary", "body"))
	}
	if body.Timeout == nil {
		err = goa.MergeErrors(err, goa.MissingFieldError("timeout", "body"))
	}
	if body.Fault == nil {
		err = goa.MergeErrors(err, goa.MissingFieldError("fault", "body"))
	}
	return
}

// ValidateListInternalErrorResponseBody runs the validations defined on
// List_internal-error_Response_Body
func ValidateListInternalErrorResponseBody(body *ListInternalErrorResponseBody) (err error) {
	if body.Name == nil {
		err = goa.MergeErrors(err, goa.MissingFieldError("name", "body"))
	}
	if body.ID == nil {
		err = goa.MergeErrors(err, goa.MissingFieldError("id", "body"))
	}
	if body.Message == nil {
		err = goa.MergeErrors(err, goa.MissingFieldError("message", "body"))
	}
	if body.Temporary == nil {
		err = goa.MergeErrors(err, goa.MissingFieldError("temporary", "body"))
	}
	if body.Timeout == nil {
		err = goa.MergeErrors(err, goa.MissingFieldError("timeout", "body"))
	}
	if body.Fault == nil {
		err = goa.MergeErrors(err, goa.MissingFieldError("fault", "body"))
	}
	return
}

// ValidateListNotFoundResponseBody runs the validations defined on
// List_not-found_Response_Body
func ValidateListNotFoundResponseBody(body *ListNotFoundResponseBody) (err error) {
	if body.Name == nil {
		err = goa.MergeErrors(err, goa.MissingFieldError("name", "body"))
	}
	if body.ID == nil {
		err = goa.MergeErrors(err, goa.MissingFieldError("id", "body"))
	}
	if body.Message == nil {
		err = goa.MergeErrors(err, goa.MissingFieldError("message", "body"))
	}
	if body.Temporary == nil {
		err = goa.MergeErrors(err, goa.MissingFieldError("temporary", "body"))
	}
	if body.Timeout == nil {
		err = goa.MergeErrors(err, goa.MissingFieldError("timeout", "body"))
	}
	if body.Fault == nil {
		err = goa.MergeErrors(err, goa.MissingFieldError("fault", "body"))
	}
	return
}

// ValidateVersionsByIDInternalErrorResponseBody runs the validations defined
// on VersionsByID_internal-error_Response_Body
func ValidateVersionsByIDInternalErrorResponseBody(body *VersionsByIDInternalErrorResponseBody) (err error) {
	if body.Name == nil {
		err = goa.MergeErrors(err, goa.MissingFieldError("name", "body"))
	}
	if body.ID == nil {
		err = goa.MergeErrors(err, goa.MissingFieldError("id", "body"))
	}
	if body.Message == nil {
		err = goa.MergeErrors(err, goa.MissingFieldError("message", "body"))
	}
	if body.Temporary == nil {
		err = goa.MergeErrors(err, goa.MissingFieldError("temporary", "body"))
	}
	if body.Timeout == nil {
		err = goa.MergeErrors(err, goa.MissingFieldError("timeout", "body"))
	}
	if body.Fault == nil {
		err = goa.MergeErrors(err, goa.MissingFieldError("fault", "body"))
	}
	return
}

// ValidateVersionsByIDNotFoundResponseBody runs the validations defined on
// VersionsByID_not-found_Response_Body
func ValidateVersionsByIDNotFoundResponseBody(body *VersionsByIDNotFoundResponseBody) (err error) {
	if body.Name == nil {
		err = goa.MergeErrors(err, goa.MissingFieldError("name", "body"))
	}
	if body.ID == nil {
		err = goa.MergeErrors(err, goa.MissingFieldError("id", "body"))
	}
	if body.Message == nil {
		err = goa.MergeErrors(err, goa.MissingFieldError("message", "body"))
	}
	if body.Temporary == nil {
		err = goa.MergeErrors(err, goa.MissingFieldError("temporary", "body"))
	}
	if body.Timeout == nil {
		err = goa.MergeErrors(err, goa.MissingFieldError("timeout", "body"))
	}
	if body.Fault == nil {
		err = goa.MergeErrors(err, goa.MissingFieldError("fault", "body"))
	}
	return
}

// ValidateByCatalogKindNameVersionInternalErrorResponseBody runs the
// validations defined on ByCatalogKindNameVersion_internal-error_Response_Body
func ValidateByCatalogKindNameVersionInternalErrorResponseBody(body *ByCatalogKindNameVersionInternalErrorResponseBody) (err error) {
	if body.Name == nil {
		err = goa.MergeErrors(err, goa.MissingFieldError("name", "body"))
	}
	if body.ID == nil {
		err = goa.MergeErrors(err, goa.MissingFieldError("id", "body"))
	}
	if body.Message == nil {
		err = goa.MergeErrors(err, goa.MissingFieldError("message", "body"))
	}
	if body.Temporary == nil {
		err = goa.MergeErrors(err, goa.MissingFieldError("temporary", "body"))
	}
	if body.Timeout == nil {
		err = goa.MergeErrors(err, goa.MissingFieldError("timeout", "body"))
	}
	if body.Fault == nil {
		err = goa.MergeErrors(err, goa.MissingFieldError("fault", "body"))
	}
	return
}

// ValidateByCatalogKindNameVersionNotFoundResponseBody runs the validations
// defined on ByCatalogKindNameVersion_not-found_Response_Body
func ValidateByCatalogKindNameVersionNotFoundResponseBody(body *ByCatalogKindNameVersionNotFoundResponseBody) (err error) {
	if body.Name == nil {
		err = goa.MergeErrors(err, goa.MissingFieldError("name", "body"))
	}
	if body.ID == nil {
		err = goa.MergeErrors(err, goa.MissingFieldError("id", "body"))
	}
	if body.Message == nil {
		err = goa.MergeErrors(err, goa.MissingFieldError("message", "body"))
	}
	if body.Temporary == nil {
		err = goa.MergeErrors(err, goa.MissingFieldError("temporary", "body"))
	}
	if body.Timeout == nil {
		err = goa.MergeErrors(err, goa.MissingFieldError("timeout", "body"))
	}
	if body.Fault == nil {
		err = goa.MergeErrors(err, goa.MissingFieldError("fault", "body"))
	}
	return
}

// ValidateByCatalogKindNameVersionReadmeInternalErrorResponseBody runs the
// validations defined on
// ByCatalogKindNameVersionReadme_internal-error_Response_Body
func ValidateByCatalogKindNameVersionReadmeInternalErrorResponseBody(body *ByCatalogKindNameVersionReadmeInternalErrorResponseBody) (err error) {
	if body.Name == nil {
		err = goa.MergeErrors(err, goa.MissingFieldError("name", "body"))
	}
	if body.ID == nil {
		err = goa.MergeErrors(err, goa.MissingFieldError("id", "body"))
	}
	if body.Message == nil {
		err = goa.MergeErrors(err, goa.MissingFieldError("message", "body"))
	}
	if body.Temporary == nil {
		err = goa.MergeErrors(err, goa.MissingFieldError("temporary", "body"))
	}
	if body.Timeout == nil {
		err = goa.MergeErrors(err, goa.MissingFieldError("timeout", "body"))
	}
	if body.Fault == nil {
		err = goa.MergeErrors(err, goa.MissingFieldError("fault", "body"))
	}
	return
}

// ValidateByCatalogKindNameVersionReadmeNotFoundResponseBody runs the
// validations defined on ByCatalogKindNameVersionReadme_not-found_Response_Body
func ValidateByCatalogKindNameVersionReadmeNotFoundResponseBody(body *ByCatalogKindNameVersionReadmeNotFoundResponseBody) (err error) {
	if body.Name == nil {
		err = goa.MergeErrors(err, goa.MissingFieldError("name", "body"))
	}
	if body.ID == nil {
		err = goa.MergeErrors(err, goa.MissingFieldError("id", "body"))
	}
	if body.Message == nil {
		err = goa.MergeErrors(err, goa.MissingFieldError("message", "body"))
	}
	if body.Temporary == nil {
		err = goa.MergeErrors(err, goa.MissingFieldError("temporary", "body"))
	}
	if body.Timeout == nil {
		err = goa.MergeErrors(err, goa.MissingFieldError("timeout", "body"))
	}
	if body.Fault == nil {
		err = goa.MergeErrors(err, goa.MissingFieldError("fault", "body"))
	}
	return
}

// ValidateByCatalogKindNameVersionYamlInternalErrorResponseBody runs the
// validations defined on
// ByCatalogKindNameVersionYaml_internal-error_Response_Body
func ValidateByCatalogKindNameVersionYamlInternalErrorResponseBody(body *ByCatalogKindNameVersionYamlInternalErrorResponseBody) (err error) {
	if body.Name == nil {
		err = goa.MergeErrors(err, goa.MissingFieldError("name", "body"))
	}
	if body.ID == nil {
		err = goa.MergeErrors(err, goa.MissingFieldError("id", "body"))
	}
	if body.Message == nil {
		err = goa.MergeErrors(err, goa.MissingFieldError("message", "body"))
	}
	if body.Temporary == nil {
		err = goa.MergeErrors(err, goa.MissingFieldError("temporary", "body"))
	}
	if body.Timeout == nil {
		err = goa.MergeErrors(err, goa.MissingFieldError("timeout", "body"))
	}
	if body.Fault == nil {
		err = goa.MergeErrors(err, goa.MissingFieldError("fault", "body"))
	}
	return
}

// ValidateByCatalogKindNameVersionYamlNotFoundResponseBody runs the
// validations defined on ByCatalogKindNameVersionYaml_not-found_Response_Body
func ValidateByCatalogKindNameVersionYamlNotFoundResponseBody(body *ByCatalogKindNameVersionYamlNotFoundResponseBody) (err error) {
	if body.Name == nil {
		err = goa.MergeErrors(err, goa.MissingFieldError("name", "body"))
	}
	if body.ID == nil {
		err = goa.MergeErrors(err, goa.MissingFieldError("id", "body"))
	}
	if body.Message == nil {
		err = goa.MergeErrors(err, goa.MissingFieldError("message", "body"))
	}
	if body.Temporary == nil {
		err = goa.MergeErrors(err, goa.MissingFieldError("temporary", "body"))
	}
	if body.Timeout == nil {
		err = goa.MergeErrors(err, goa.MissingFieldError("timeout", "body"))
	}
	if body.Fault == nil {
		err = goa.MergeErrors(err, goa.MissingFieldError("fault", "body"))
	}
	return
}

// ValidateByVersionIDInternalErrorResponseBody runs the validations defined on
// ByVersionId_internal-error_Response_Body
func ValidateByVersionIDInternalErrorResponseBody(body *ByVersionIDInternalErrorResponseBody) (err error) {
	if body.Name == nil {
		err = goa.MergeErrors(err, goa.MissingFieldError("name", "body"))
	}
	if body.ID == nil {
		err = goa.MergeErrors(err, goa.MissingFieldError("id", "body"))
	}
	if body.Message == nil {
		err = goa.MergeErrors(err, goa.MissingFieldError("message", "body"))
	}
	if body.Temporary == nil {
		err = goa.MergeErrors(err, goa.MissingFieldError("temporary", "body"))
	}
	if body.Timeout == nil {
		err = goa.MergeErrors(err, goa.MissingFieldError("timeout", "body"))
	}
	if body.Fault == nil {
		err = goa.MergeErrors(err, goa.MissingFieldError("fault", "body"))
	}
	return
}

// ValidateByVersionIDNotFoundResponseBody runs the validations defined on
// ByVersionId_not-found_Response_Body
func ValidateByVersionIDNotFoundResponseBody(body *ByVersionIDNotFoundResponseBody) (err error) {
	if body.Name == nil {
		err = goa.MergeErrors(err, goa.MissingFieldError("name", "body"))
	}
	if body.ID == nil {
		err = goa.MergeErrors(err, goa.MissingFieldError("id", "body"))
	}
	if body.Message == nil {
		err = goa.MergeErrors(err, goa.MissingFieldError("message", "body"))
	}
	if body.Temporary == nil {
		err = goa.MergeErrors(err, goa.MissingFieldError("temporary", "body"))
	}
	if body.Timeout == nil {
		err = goa.MergeErrors(err, goa.MissingFieldError("timeout", "body"))
	}
	if body.Fault == nil {
		err = goa.MergeErrors(err, goa.MissingFieldError("fault", "body"))
	}
	return
}

// ValidateByCatalogKindNameInternalErrorResponseBody runs the validations
// defined on ByCatalogKindName_internal-error_Response_Body
func ValidateByCatalogKindNameInternalErrorResponseBody(body *ByCatalogKindNameInternalErrorResponseBody) (err error) {
	if body.Name == nil {
		err = goa.MergeErrors(err, goa.MissingFieldError("name", "body"))
	}
	if body.ID == nil {
		err = goa.MergeErrors(err, goa.MissingFieldError("id", "body"))
	}
	if body.Message == nil {
		err = goa.MergeErrors(err, goa.MissingFieldError("message", "body"))
	}
	if body.Temporary == nil {
		err = goa.MergeErrors(err, goa.MissingFieldError("temporary", "body"))
	}
	if body.Timeout == nil {
		err = goa.MergeErrors(err, goa.MissingFieldError("timeout", "body"))
	}
	if body.Fault == nil {
		err = goa.MergeErrors(err, goa.MissingFieldError("fault", "body"))
	}
	return
}

// ValidateByCatalogKindNameNotFoundResponseBody runs the validations defined
// on ByCatalogKindName_not-found_Response_Body
func ValidateByCatalogKindNameNotFoundResponseBody(body *ByCatalogKindNameNotFoundResponseBody) (err error) {
	if body.Name == nil {
		err = goa.MergeErrors(err, goa.MissingFieldError("name", "body"))
	}
	if body.ID == nil {
		err = goa.MergeErrors(err, goa.MissingFieldError("id", "body"))
	}
	if body.Message == nil {
		err = goa.MergeErrors(err, goa.MissingFieldError("message", "body"))
	}
	if body.Temporary == nil {
		err = goa.MergeErrors(err, goa.MissingFieldError("temporary", "body"))
	}
	if body.Timeout == nil {
		err = goa.MergeErrors(err, goa.MissingFieldError("timeout", "body"))
	}
	if body.Fault == nil {
		err = goa.MergeErrors(err, goa.MissingFieldError("fault", "body"))
	}
	return
}

// ValidateByIDInternalErrorResponseBody runs the validations defined on
// ById_internal-error_Response_Body
func ValidateByIDInternalErrorResponseBody(body *ByIDInternalErrorResponseBody) (err error) {
	if body.Name == nil {
		err = goa.MergeErrors(err, goa.MissingFieldError("name", "body"))
	}
	if body.ID == nil {
		err = goa.MergeErrors(err, goa.MissingFieldError("id", "body"))
	}
	if body.Message == nil {
		err = goa.MergeErrors(err, goa.MissingFieldError("message", "body"))
	}
	if body.Temporary == nil {
		err = goa.MergeErrors(err, goa.MissingFieldError("temporary", "body"))
	}
	if body.Timeout == nil {
		err = goa.MergeErrors(err, goa.MissingFieldError("timeout", "body"))
	}
	if body.Fault == nil {
		err = goa.MergeErrors(err, goa.MissingFieldError("fault", "body"))
	}
	return
}

// ValidateByIDNotFoundResponseBody runs the validations defined on
// ById_not-found_Response_Body
func ValidateByIDNotFoundResponseBody(body *ByIDNotFoundResponseBody) (err error) {
	if body.Name == nil {
		err = goa.MergeErrors(err, goa.MissingFieldError("name", "body"))
	}
	if body.ID == nil {
		err = goa.MergeErrors(err, goa.MissingFieldError("id", "body"))
	}
	if body.Message == nil {
		err = goa.MergeErrors(err, goa.MissingFieldError("message", "body"))
	}
	if body.Temporary == nil {
		err = goa.MergeErrors(err, goa.MissingFieldError("temporary", "body"))
	}
	if body.Timeout == nil {
		err = goa.MergeErrors(err, goa.MissingFieldError("timeout", "body"))
	}
	if body.Fault == nil {
		err = goa.MergeErrors(err, goa.MissingFieldError("fault", "body"))
	}
	return
}

// ValidateGetRawYamlByCatalogKindNameVersionInternalErrorResponseBody runs the
// validations defined on
// GetRawYamlByCatalogKindNameVersion_internal-error_Response_Body
func ValidateGetRawYamlByCatalogKindNameVersionInternalErrorResponseBody(body *GetRawYamlByCatalogKindNameVersionInternalErrorResponseBody) (err error) {
	if body.Name == nil {
		err = goa.MergeErrors(err, goa.MissingFieldError("name", "body"))
	}
	if body.ID == nil {
		err = goa.MergeErrors(err, goa.MissingFieldError("id", "body"))
	}
	if body.Message == nil {
		err = goa.MergeErrors(err, goa.MissingFieldError("message", "body"))
	}
	if body.Temporary == nil {
		err = goa.MergeErrors(err, goa.MissingFieldError("temporary", "body"))
	}
	if body.Timeout == nil {
		err = goa.MergeErrors(err, goa.MissingFieldError("timeout", "body"))
	}
	if body.Fault == nil {
		err = goa.MergeErrors(err, goa.MissingFieldError("fault", "body"))
	}
	return
}

// ValidateGetRawYamlByCatalogKindNameVersionNotFoundResponseBody runs the
// validations defined on
// GetRawYamlByCatalogKindNameVersion_not-found_Response_Body
func ValidateGetRawYamlByCatalogKindNameVersionNotFoundResponseBody(body *GetRawYamlByCatalogKindNameVersionNotFoundResponseBody) (err error) {
	if body.Name == nil {
		err = goa.MergeErrors(err, goa.MissingFieldError("name", "body"))
	}
	if body.ID == nil {
		err = goa.MergeErrors(err, goa.MissingFieldError("id", "body"))
	}
	if body.Message == nil {
		err = goa.MergeErrors(err, goa.MissingFieldError("message", "body"))
	}
	if body.Temporary == nil {
		err = goa.MergeErrors(err, goa.MissingFieldError("temporary", "body"))
	}
	if body.Timeout == nil {
		err = goa.MergeErrors(err, goa.MissingFieldError("timeout", "body"))
	}
	if body.Fault == nil {
		err = goa.MergeErrors(err, goa.MissingFieldError("fault", "body"))
	}
	return
}

// ValidateResourceDataCollectionResponseBody runs the validations defined on
// ResourceDataCollectionResponseBody
func ValidateResourceDataCollectionResponseBody(body ResourceDataCollectionResponseBody) (err error) {
	for _, e := range body {
		if e != nil {
			if err2 := ValidateResourceDataResponseBody(e); err2 != nil {
				err = goa.MergeErrors(err, err2)
			}
		}
	}
	return
}

// ValidateResourceDataResponseBody runs the validations defined on
// ResourceDataResponseBody
func ValidateResourceDataResponseBody(body *ResourceDataResponseBody) (err error) {
	if body.ID == nil {
		err = goa.MergeErrors(err, goa.MissingFieldError("id", "body"))
	}
	if body.Name == nil {
		err = goa.MergeErrors(err, goa.MissingFieldError("name", "body"))
	}
	if body.Catalog == nil {
		err = goa.MergeErrors(err, goa.MissingFieldError("catalog", "body"))
	}
	if body.Categories == nil {
		err = goa.MergeErrors(err, goa.MissingFieldError("categories", "body"))
	}
	if body.Kind == nil {
		err = goa.MergeErrors(err, goa.MissingFieldError("kind", "body"))
	}
	if body.HubURLPath == nil {
		err = goa.MergeErrors(err, goa.MissingFieldError("hubURLPath", "body"))
	}
	if body.LatestVersion == nil {
		err = goa.MergeErrors(err, goa.MissingFieldError("latestVersion", "body"))
	}
	if body.Tags == nil {
		err = goa.MergeErrors(err, goa.MissingFieldError("tags", "body"))
	}
	if body.Platforms == nil {
		err = goa.MergeErrors(err, goa.MissingFieldError("platforms", "body"))
	}
	if body.Rating == nil {
		err = goa.MergeErrors(err, goa.MissingFieldError("rating", "body"))
	}
	if body.Versions == nil {
		err = goa.MergeErrors(err, goa.MissingFieldError("versions", "body"))
	}
	if body.Catalog != nil {
		if err2 := ValidateCatalogResponseBody(body.Catalog); err2 != nil {
			err = goa.MergeErrors(err, err2)
		}
	}
	for _, e := range body.Categories {
		if e != nil {
			if err2 := ValidateCategoryResponseBody(e); err2 != nil {
				err = goa.MergeErrors(err, err2)
			}
		}
	}
	if body.LatestVersion != nil {
		if err2 := ValidateResourceVersionDataResponseBody(body.LatestVersion); err2 != nil {
			err = goa.MergeErrors(err, err2)
		}
	}
	for _, e := range body.Tags {
		if e != nil {
			if err2 := ValidateTagResponseBody(e); err2 != nil {
				err = goa.MergeErrors(err, err2)
			}
		}
	}
	for _, e := range body.Platforms {
		if e != nil {
			if err2 := ValidatePlatformResponseBody(e); err2 != nil {
				err = goa.MergeErrors(err, err2)
			}
		}
	}
	for _, e := range body.Versions {
		if e != nil {
			if err2 := ValidateResourceVersionDataResponseBody(e); err2 != nil {
				err = goa.MergeErrors(err, err2)
			}
		}
	}
	return
}

// ValidateCatalogResponseBody runs the validations defined on
// CatalogResponseBody
func ValidateCatalogResponseBody(body *CatalogResponseBody) (err error) {
	if body.ID == nil {
		err = goa.MergeErrors(err, goa.MissingFieldError("id", "body"))
	}
	if body.Name == nil {
		err = goa.MergeErrors(err, goa.MissingFieldError("name", "body"))
	}
	if body.Type == nil {
		err = goa.MergeErrors(err, goa.MissingFieldError("type", "body"))
	}
	if body.URL == nil {
		err = goa.MergeErrors(err, goa.MissingFieldError("url", "body"))
	}
	if body.Provider == nil {
		err = goa.MergeErrors(err, goa.MissingFieldError("provider", "body"))
	}
	if body.Type != nil {
		if !(*body.Type == "official" || *body.Type == "community") {
			err = goa.MergeErrors(err, goa.InvalidEnumValueError("body.type", *body.Type, []interface{}{"official", "community"}))
		}
	}
	return
}

// ValidateCategoryResponseBody runs the validations defined on
// CategoryResponseBody
func ValidateCategoryResponseBody(body *CategoryResponseBody) (err error) {
	if body.ID == nil {
		err = goa.MergeErrors(err, goa.MissingFieldError("id", "body"))
	}
	if body.Name == nil {
		err = goa.MergeErrors(err, goa.MissingFieldError("name", "body"))
	}
	return
}

// ValidateResourceVersionDataResponseBody runs the validations defined on
// ResourceVersionDataResponseBody
func ValidateResourceVersionDataResponseBody(body *ResourceVersionDataResponseBody) (err error) {
	if body.ID == nil {
		err = goa.MergeErrors(err, goa.MissingFieldError("id", "body"))
	}
	if body.Version == nil {
		err = goa.MergeErrors(err, goa.MissingFieldError("version", "body"))
	}
	if body.DisplayName == nil {
		err = goa.MergeErrors(err, goa.MissingFieldError("displayName", "body"))
	}
	if body.Description == nil {
		err = goa.MergeErrors(err, goa.MissingFieldError("description", "body"))
	}
	if body.MinPipelinesVersion == nil {
		err = goa.MergeErrors(err, goa.MissingFieldError("minPipelinesVersion", "body"))
	}
	if body.RawURL == nil {
		err = goa.MergeErrors(err, goa.MissingFieldError("rawURL", "body"))
	}
	if body.WebURL == nil {
		err = goa.MergeErrors(err, goa.MissingFieldError("webURL", "body"))
	}
	if body.UpdatedAt == nil {
		err = goa.MergeErrors(err, goa.MissingFieldError("updatedAt", "body"))
	}
	if body.Platforms == nil {
		err = goa.MergeErrors(err, goa.MissingFieldError("platforms", "body"))
	}
	if body.Resource == nil {
		err = goa.MergeErrors(err, goa.MissingFieldError("resource", "body"))
	}
	if body.HubURLPath == nil {
		err = goa.MergeErrors(err, goa.MissingFieldError("hubURLPath", "body"))
	}
	if body.RawURL != nil {
		err = goa.MergeErrors(err, goa.ValidateFormat("body.rawURL", *body.RawURL, goa.FormatURI))
	}
	if body.WebURL != nil {
		err = goa.MergeErrors(err, goa.ValidateFormat("body.webURL", *body.WebURL, goa.FormatURI))
	}
	if body.UpdatedAt != nil {
		err = goa.MergeErrors(err, goa.ValidateFormat("body.updatedAt", *body.UpdatedAt, goa.FormatDateTime))
	}
	for _, e := range body.Platforms {
		if e != nil {
			if err2 := ValidatePlatformResponseBody(e); err2 != nil {
				err = goa.MergeErrors(err, err2)
			}
		}
	}
	if body.Resource != nil {
		if err2 := ValidateResourceDataResponseBody(body.Resource); err2 != nil {
			err = goa.MergeErrors(err, err2)
		}
	}
	return
}

// ValidatePlatformResponseBody runs the validations defined on
// PlatformResponseBody
func ValidatePlatformResponseBody(body *PlatformResponseBody) (err error) {
	if body.ID == nil {
		err = goa.MergeErrors(err, goa.MissingFieldError("id", "body"))
	}
	if body.Name == nil {
		err = goa.MergeErrors(err, goa.MissingFieldError("name", "body"))
	}
	return
}

// ValidateTagResponseBody runs the validations defined on TagResponseBody
func ValidateTagResponseBody(body *TagResponseBody) (err error) {
	if body.ID == nil {
		err = goa.MergeErrors(err, goa.MissingFieldError("id", "body"))
	}
	if body.Name == nil {
		err = goa.MergeErrors(err, goa.MissingFieldError("name", "body"))
	}
	return
}

// ValidateVersionsResponseBody runs the validations defined on
// VersionsResponseBody
func ValidateVersionsResponseBody(body *VersionsResponseBody) (err error) {
	if body.Latest == nil {
		err = goa.MergeErrors(err, goa.MissingFieldError("latest", "body"))
	}
	if body.Versions == nil {
		err = goa.MergeErrors(err, goa.MissingFieldError("versions", "body"))
	}
	if body.Latest != nil {
		if err2 := ValidateResourceVersionDataResponseBody(body.Latest); err2 != nil {
			err = goa.MergeErrors(err, err2)
		}
	}
	for _, e := range body.Versions {
		if e != nil {
			if err2 := ValidateResourceVersionDataResponseBody(e); err2 != nil {
				err = goa.MergeErrors(err, err2)
			}
		}
	}
	return
}
