/*
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
 
#include "include/gnotify.h"

int timeouthdl;
GtkWidget *frmNotify;

int gnotify_notify(int cid)
{
  GtkWidget *tabNotify;
  GtkWidget *imgNotify;
  GtkWidget *lblNotify;
  GtkWidget *lblApp;
  GtkWidget *cmdButton;
	GtkWidget *ckBox;
	GtkWidget *fraNotify;
  char buff[524];
	int ibuff[2];
  pthread_t soundplay;
 
  /* Switching into GTK-Mode */
	gtk_set_locale ();
 	gtk_init (NULL,NULL);
  frmNotify=gtk_window_new(GTK_WINDOW_TOPLEVEL);
  g_signal_connect(GTK_OBJECT(frmNotify), "destroy",G_CALLBACK(gtk_main_quit),NULL);
  gtk_window_set_title(GTK_WINDOW(frmNotify),"GNotify");
  gtk_window_set_default_size(GTK_WINDOW(frmNotify),10,10);
	if((cfg.notify_allowmove==1)&&(cdb[cid].move_x>-2)&&(cdb[cid].move_y>-2))
	{
		gtk_window_move(GTK_WINDOW(frmNotify),cdb[cid].move_x,cdb[cid].move_y);
	}
	else
	{
	 	gtk_window_move(GTK_WINDOW(frmNotify),cfg.notify_x,cfg.notify_y);
	}			
  gtk_window_set_decorated(GTK_WINDOW(frmNotify), FALSE);
  gtk_window_set_skip_taskbar_hint(GTK_WINDOW(frmNotify),TRUE);
  gtk_window_set_skip_pager_hint(GTK_WINDOW(frmNotify),TRUE);
	
	/* Check if the gtk version is 2.4.0 or higher */
	#if GTK_CHECK_VERSION(2, 4, x)
		gtk_window_set_accept_focus(GTK_WINDOW(frmNotify), FALSE);
	#endif
	
  gtk_window_stick(GTK_WINDOW(frmNotify));
  	
  tabNotify=gtk_table_new(3,3,FALSE);
  
  lblApp=gtk_label_new(NULL);
  sprintf(buff,"<b>%s</b>",cdb[cid].app);
  gtk_label_set_markup(GTK_LABEL(lblApp),buff);
  lblNotify=gtk_label_new(NULL);
	sprintf(buff,"<i>%s</i>",cdb[cid].msg);
  gtk_label_set_markup(GTK_LABEL(lblNotify),buff);
		
	fraNotify=gtk_frame_new(NULL);
	gtk_frame_set_shadow_type(GTK_FRAME(fraNotify),GTK_SHADOW_OUT);
		
	gtk_container_set_border_width(GTK_CONTAINER(fraNotify),0);
  
  gtk_container_set_border_width(GTK_CONTAINER(frmNotify),0);
	if(strncmp(cdb[cid].icon,"<NULL>",6)!=0)  
	{
  	imgNotify=gtk_image_new_from_file(cdb[cid].icon);
 		gtk_table_attach(GTK_TABLE(tabNotify),imgNotify,0,1,0,2,GTK_FILL,GTK_FILL,6,6);
	}
  gtk_table_attach(GTK_TABLE(tabNotify),lblApp,1,3,0,1,GTK_FILL,GTK_FILL,6,0);
  gtk_table_attach(GTK_TABLE(tabNotify),lblNotify,1,3,1,2,GTK_FILL,GTK_FILL,6,6);
  if(strncmp(cdb[cid].button,"<NULL>",6)!=0)
  {
	  cmdButton=gtk_button_new_with_label(cdb[cid].button);
	  g_signal_connect(G_OBJECT(cmdButton),"clicked",G_CALLBACK(buttonclick),(int *)cid);
	  gtk_table_attach(GTK_TABLE(tabNotify),cmdButton,2,3,2,3,GTK_FILL,GTK_FILL,6,6);
	}
  if(strncmp(cdb[cid].ckbox,"<NULL>",6)!=0)
  {
	  ckBox=gtk_check_button_new_with_label(cdb[cid].ckbox);
	  g_signal_connect(G_OBJECT(ckBox),"clicked",G_CALLBACK(ckboxonclick),(int *)cid);
	  gtk_table_attach(GTK_TABLE(tabNotify),ckBox,0,2,2,3,GTK_FILL,GTK_FILL,6,6);
	}
  gtk_container_add(GTK_CONTAINER(fraNotify),tabNotify);
	gtk_container_add(GTK_CONTAINER(frmNotify),fraNotify);
  timeouthdl=gtk_timeout_add(cfg.notify_delay,(GtkFunction)gnotify_notify_quit,NULL);

  gtk_widget_show_all(frmNotify);
	
	if(((strncmp(cdb[cid].snd,"",1)!=0)||(strncmp(cdb[cid].snd,"<NULL>",6)!=0))&&(cfg.notify_play==1))
	{
	 	if(pthread_create(&soundplay,NULL,(void *)&playsound,(void *)cdb[cid].snd)!=0)
	  {
			printflog(LOG_DAEMON|LOG_ERR,"couldn't play sound, cause: failed to create sound-thread!\n");
	  }
	}

	gtk_window_get_size(GTK_WINDOW(frmNotify), &ibuff[0], &ibuff[1]);

	/* 
	 * Some moving stuff:
	 * If a moving value is -1 then the window will be moved to
	 * (width/height of screen) - (width/heght of window)
	 */
	if(cdb[cid].move_x==-1&&cdb[cid].move_y==-1) 
		gtk_window_move(GTK_WINDOW(frmNotify),(gdk_screen_width()-ibuff[0]),(gdk_screen_height()-ibuff[1]));
	else if(cdb[cid].move_x>-1&&cdb[cid].move_y==-1) 
		gtk_window_move(GTK_WINDOW(frmNotify),cdb[cid].move_x,(gdk_screen_height()-ibuff[1]));
	else if(cdb[cid].move_x==-1&&cdb[cid].move_y>-1) 
		gtk_window_move(GTK_WINDOW(frmNotify),(gdk_screen_width()-ibuff[0]),cdb[cid].move_y);

  gtk_main();
	if(((strncmp(cdb[cid].snd,"",1)!=0)||(strncmp(cdb[cid].snd,"<NULL>",6)!=0))&&(cfg.notify_play==1)) pthread_cancel(soundplay);
  return(0);
}

void gnotify_notify_quit(GtkWidget *widget,gpointer data)
{
	gtk_widget_destroy(frmNotify);
	gtk_main_quit();
}

void buttonclick(GtkWidget *widget,gpointer data)
{
	cdb[(int)data].btnpress=1;
	gtk_timeout_remove(timeouthdl);
	gtk_widget_destroy(frmNotify);
	gtk_main_quit();
	return;
}

void ckboxonclick(GtkWidget *widget,gpointer data)
{
	cdb[(int)data].ckboxpress=gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(widget));
	return;
}

void gnotify_about(void)
{
	GtkWidget *frmAbout;
  GtkWidget *tabAbout;
  GtkWidget *imgAbout;
  GtkWidget *lblAbout;
  GtkWidget *lblAbout2;
  GtkWidget *cmdClose;
	char abouttbuff[32];
	char aboutbuff[1024];
  
  gtk_set_locale ();
 	gtk_init (&g_argc,&g_argv);
	
 	frmAbout=gtk_window_new(GTK_WINDOW_TOPLEVEL);
	gtk_window_set_position (GTK_WINDOW(frmAbout),GTK_WIN_POS_CENTER);
 	g_signal_connect_swapped(GTK_OBJECT(frmAbout), "destroy",G_CALLBACK(gtk_main_quit),NULL);
 	gtk_window_set_title(GTK_WINDOW(frmAbout),"About GNotify");
 	gtk_window_set_default_size(GTK_WINDOW(frmAbout),100,150);
  	
 	tabAbout=gtk_table_new(3,3,FALSE);
  	
 	lblAbout=gtk_label_new(NULL);
 	sprintf(abouttbuff,"\n<span size=\"xx-large\" weight=\"bold\">GNotify %s</span>\n\n",VERSION);
 	gtk_label_set_markup(GTK_LABEL(lblAbout),abouttbuff);
 	lblAbout2=gtk_label_new(NULL);
 	sprintf(aboutbuff,"GNotify %s\nby DevilX [devilx@users.sourceforge.net], Copyright (c) 2004\n\nhttp://gnotify.sourceforge.net\n\nThis program is free software; you can redistribute it and/or modify\nit under the terms of the GNU General Public License as published by\nthe Free Software Foundation; either version 2 of the License, or\n(at your option) any later version.\n\n\
		\rusage: gnotify (option)\n\
		\rOptions:\n\
		-h,--help\t\t\tShow this help\n\
		-v,--version\t\tDisplay version and quit\n\
		-c,--configure\t\tOpen GNotify Config-GUI\n\
		-d,--daemon\t\tRun GNotify in background\n\
		-V,--verbose\t\tRun in Verbose-mode\n\n",VERSION);
 	gtk_label_set_markup(GTK_LABEL(lblAbout2),aboutbuff);
		
	imgAbout=gtk_image_new_from_file(GNOTIFY_ICON);
	
	cmdClose=gtk_button_new_with_label("Close");
	g_signal_connect_swapped(GTK_OBJECT(cmdClose), "clicked",G_CALLBACK(gtk_main_quit),NULL);

	gtk_table_attach(GTK_TABLE(tabAbout),imgAbout,0,1,0,1,GTK_FILL,GTK_FILL,6,6);
	gtk_table_attach(GTK_TABLE(tabAbout),lblAbout,1,3,0,1,GTK_FILL|GTK_EXPAND,GTK_FILL,6,6);
 	gtk_table_attach(GTK_TABLE(tabAbout),lblAbout2,1,3,1,2,GTK_EXPAND,GTK_EXPAND,6,6);
 	gtk_table_attach(GTK_TABLE(tabAbout),cmdClose,2,3,2,3,GTK_FILL,GTK_FILL,6,6);
		
  gtk_container_add(GTK_CONTAINER(frmAbout),tabAbout);
		
  gtk_widget_show_all(frmAbout);
  gtk_main();
	exit(0);
}

void showmessage(int type, int buttons, char *text)
{
  GtkWidget *msg;
  msg=gtk_message_dialog_new(NULL,GTK_DIALOG_DESTROY_WITH_PARENT,type,buttons,text);
  g_signal_connect_swapped(GTK_OBJECT(msg),"response",G_CALLBACK(gtk_widget_destroy),GTK_OBJECT(msg));
  gtk_widget_show_all(msg);
  return;
}
