/*
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "include/gnotify.h"

int gnotify_client(int cid)
{
  int i;
  int ffd=-1;
  int sockfd=cdb[cid].sockfd;
  char cmd[512];
	char buff[512];
	char *htmlc=NULL;
	
	cdb[cid].move_x=cfg.notify_x;
	cdb[cid].move_y=cfg.notify_y;
	cdb[cid].occupied=1;
	strcpy(cdb[cid].snd,"<NULL>");
	strcpy(cdb[cid].app,"GNotify");
	strcpy(cdb[cid].icon,GNOTIFY_ICON);
	strcpy(cdb[cid].button,"<NULL>");
	strcpy(cdb[cid].ckbox,"<NULL>");
	strcpy(cdb[cid].msg,"<NULL>");
	printflog(LOG_DAEMON|LOG_NOTICE,"new client connected: %s\n",cdb[cid].ip);
  do
	{
	  memset(cmd,0x00,sizeof(cmd));
		i=recv(sockfd,cmd,(sizeof(cmd)-1),0);
		if(i<=0) break;
		cmd[strlen(cmd)]='\0';
		if(cfg.notify_verbose==1) printflog(LOG_DAEMON|LOG_NOTICE,"[%s] %s\n", cdb[cid].ip, cmd);
		if(strncmp(cmd,"APP:",4)==0)
    {
     	strcpy(cdb[cid].app,reverse_strnget(cmd,strlen(cmd)-4));
			sprintf(cmd,"220 Ok\n");
      send(sockfd,cmd,strlen(cmd)+1,0);
    }
		else if(strncmp(cmd,"ICON:",5)==0)
    {
     	strncpy(cdb[cid].icon,reverse_strnget(cmd,strlen(cmd)-5),511);
    	if(strncmp(cdb[cid].icon,"<NULL>",6)!=0&&strcmp(cdb[cid].icon,"")!=0&&(ffd=open(cdb[cid].icon,O_RDONLY))<0)
    	{
    		sprintf(cmd,"500 Icon does not exist\n");
    	}
    	else if(strcmp(cdb[cid].icon,"")==0)
			{
				strcpy(cdb[cid].icon,GNOTIFY_ICON);
      	sprintf(cmd,"220 Ok\n");
			}
    	else
    	{
		    close(ffd);
      	sprintf(cmd,"220 Ok\n");
	    }
      send(sockfd,cmd,strlen(cmd)+1,0);
    }
		else if(strncmp(cmd,"SND:",4)==0)
    {
     	strncpy(cdb[cid].snd,reverse_strnget(cmd,strlen(cmd)-4),511);
    	if(strncmp(cdb[cid].snd,"<NULL>",6)!=0&&(ffd=open(cdb[cid].snd,O_RDONLY))<0)
    	{
    		sprintf(cmd,"500 Soundfile does not exist\n");
    	}
    	else
    	{
		    close(ffd);
      	sprintf(cmd,"220 Ok\n");
	    }
      send(sockfd,cmd,strlen(cmd)+1,0);
    }
		else if(strncmp(cmd,"BTN:",4)==0)
    {
     	strncpy(cdb[cid].button,reverse_strnget(cmd,strlen(cmd)-4),127);
			sprintf(cmd,"220 Ok\n");
      send(sockfd,cmd,strlen(cmd)+1,0);
	  }
		else if(strncmp(cmd,"CKB:",4)==0)
    {
     	strncpy(cdb[cid].ckbox,reverse_strnget(cmd,strlen(cmd)-4),127);
			sprintf(cmd,"220 Ok\n");
      send(sockfd,cmd,strlen(cmd)+1,0);
	  }
		else if(strncmp(cmd,"MVX:",4)==0)
    {
			if(cfg.notify_allowmove==1)
			{
	      cdb[cid].move_x=atoi(reverse_strnget(cmd,strlen(cmd)-4));
    	  sprintf(cmd,"220 Ok\n");
			}
			else
			{
				sprintf(cmd,"500 Moving is not allowed!\n");
			}
      send(sockfd,cmd,strlen(cmd)+1,0);
    }
		else if(strncmp(cmd,"MVY:",4)==0)
    {
			if(cfg.notify_allowmove==1)
			{
	      cdb[cid].move_y=atoi(reverse_strnget(cmd,strlen(cmd)-4));
    	  sprintf(cmd,"220 Ok\n");
			}
			else
			{
				sprintf(cmd,"500 Moving is not allowed!\n");
			}
      send(sockfd,cmd,strlen(cmd)+1,0);
    }
		else if(strncmp(cmd,"MSG:",4)==0)
    {
     	strncpy(cdb[cid].msg,reverse_strnget(cmd,strlen(cmd)-4),511);
			if(pthread_mutex_lock(&mutex)!=0)
		  {
   			printflog(LOG_DAEMON|LOG_ERR,"couldn't lock mutex to thread %ld!\n",pthread_self());
    		exit(-1);
			}
   	  gnotify_notify(cid);
		  if(pthread_mutex_unlock(&mutex)!=0)
		 	{
   			printflog(LOG_DAEMON|LOG_ERR,"couldn't release mutex from thread %ld!\n",pthread_self());
    		exit(-1);
 			}
			if(cdb[cid].btnpress==1) run_button_event(cid);
			if(cdb[cid].ckboxpress==1&&cdb[cid].btnpress==1) 
			{
	      sprintf(cmd,"223 Checkbox and Button pressed\n");
		    send(sockfd,cmd,strlen(cmd)+1,0);
				cdb[cid].ckboxpress=0;	
				cdb[cid].btnpress=0;
			}
			else if(cdb[cid].ckboxpress==1&&cdb[cid].btnpress!=1) 
			{
	      sprintf(cmd,"222 Checkbox pressed\n");
		    send(sockfd,cmd,strlen(cmd)+1,0);
				cdb[cid].ckboxpress=0;
			}
			else if(cdb[cid].btnpress==1&&cdb[cid].ckboxpress!=1) 
			{
	      sprintf(cmd,"221 Button pressed\n");
		    send(sockfd,cmd,strlen(cmd)+1,0);
				cdb[cid].btnpress=0;
			}
			else
			{
      	sprintf(cmd,"220 Ok\n");
		    send(sockfd,cmd,strlen(cmd)+1,0);
			}
    }
    else if(strncmp(cmd,"VERSION",7)==0)
    {
			sprintf(cmd,"214 %s\n",VERSION);
			send(sockfd,cmd,strlen(cmd)+1,0);
    }
    else if(strncmp(cmd,"GET ",4)==0)
    {
			if(cfg.notify_allowhtml==1)
			{
				if((htmlc=(char*)malloc(2048))==NULL)
				{
					send(sockfd,"111 Error, couldn't allocate memory!\n",16,0);
				}
				else
				{
					sprintf(htmlc,"HTTP/1.1 200 OK\nServer: GNotify/%s\n\n\
					<html><head><meta http-equiv=\"content-type\" content=\"text/html; charset=iso-8859-1\">\
					<title>GNotify %s</title>\
					<style type=\"text/css\">\nbody{background-color:#ffffff}\ntable{color:#000000;background-color:transparent;font-size:8pt;font-family:verdana;font-weight:bold}\na:link{font-size:8pt;font-family:verdana;text-decoration:none;color:#ff0000}\na:visited{font-size:8pt;font-family:verdana;text-decoration:none;color:#ff0000}\na:hover{font-size:8pt;font-family:verdana;text-decoration:none;color:#550000}\nh3{font-size:16pt;font-family:verdana;text-decoration:none}\n</style>\
					</head><body><div align=\"center\"><table cellpadding=\"1\" cellspacing=\"0\" width=\"640\" border=\"0\" style=\"border-width:1px;border-color:#000000;border-style:solid\">\
					<tr bgcolor=\"#CDD6EE\"><td><table align=\"left\" width=\"432\" cellpadding=\"0\" cellspacing=\"1\" border=\"0\"><tr><td><a href=\"http://gnotify.sourceforge.net\">&raquo; Home</a></td></tr></table></td></tr><tr>\
					<td valign=\"top\"><br><br>\
					<h3>GNotify %s</h3><br><br>&nbsp; Machine: %s<br>\
					&nbsp; Kernel-Name: %s<br>\
					&nbsp; Kernel-Release: %s<br>\
					&nbsp; Kernel-Version: %s<br>\
					&nbsp; Node: %s<br>\
					<br>\
					&nbsp; Max. connections: %i<br>\
					&nbsp; Current connections: %i<br>\
					<br><br><br></td></tr><tr bgcolor=\"#CDD6EE\"><td>GNotify by Marius M. M. < devilx (at) users.sourceforge.net >, Copyright (c) 2004<br>Webdesign by Benjamin K. < las (at) proggen.net >, Copyright (c) 2004</td></tr></table></div></body></html>",VERSION,VERSION,VERSION,sysinfo.machine,sysinfo.opsys,sysinfo.k_release,sysinfo.k_version,sysinfo.nodename,MAX_CLIENTS,count_connections());
					send(sockfd,htmlc,strlen(htmlc)+1,0);
					free(htmlc);
				}
				break;
			}
			else
			{
				sprintf(cmd,"500 HTML is not allowed!\n");
				send(sockfd,cmd,strlen(cmd)+1,0);
			}
    }
    else if(strncmp(cmd,"GETCFG:",7)==0)
    {
      strncpy(buff,reverse_strnget(cmd,strlen(cmd)-7),511);
			if(strncmp(buff,"X",1)==0)
			{
				sprintf(cmd,"214 X:%i\n",cfg.notify_x);
			}
			else if(strncmp(buff,"Y",1)==0)
			{
				sprintf(cmd,"214 Y:%i\n",cfg.notify_y);
			}
			else if(strncmp(buff,"DELAY",5)==0)
			{
				sprintf(cmd,"214 DELAY:%i\n",cfg.notify_delay);
			}
			else if(strncmp(buff,"PLAY",4)==0)
			{
				sprintf(cmd,"214 PLAY:%i\n",cfg.notify_play);
			}
			else if(strncmp(buff,"ALLOWMOVE",9)==0)
			{
				sprintf(cmd,"214 ALLOWMOVE:%i\n",cfg.notify_allowmove);
			}
			else if(strncmp(buff,"ALLOWHTML",9)==0)
			{
				sprintf(cmd,"214 ALLOWHTML:%i\n",cfg.notify_allowhtml);
			}
			else if(strncmp(buff,"SSINK",5)==0)
			{
				sprintf(cmd,"214 SSINK:%s\n",cfg.notify_ssink);
			}
			else if(strncmp(buff,"LOGOUT",5)==0)
			{
				sprintf(cmd,"214 LOGOUT:%s\n",cfg.notify_logout);
			}
			else if(strncmp(buff,"ALLOWRELOAD",11)==0)
			{
				sprintf(cmd,"214 ALLOWRELOAD:%i\n",cfg.notify_allowreload);
			}
			else if(strncmp(buff,"ALLOWCONFCHANGE",15)==0)
			{
				sprintf(cmd,"214 ALLOWCONFCHANGE:%i\n",cfg.notify_allowconfchange);
			}
			else if(strncmp(buff,"SAVECONFONEXIT",14)==0)
			{
				sprintf(cmd,"214 SAVECONFONEXIT:%i\n",cfg.notify_saveconfonexit);
			}
			else if(strncmp(buff,"BTNEVENTS",9)==0)
			{
				sprintf(cmd,"214 BTNEVENTS:%i\n",cfg.notify_btnevents);
			}
			else
			{
				sprintf(cmd,"510 Unrecognized argument for GETCFG:\n");
			}
			send(sockfd,cmd,strlen(cmd)+1,0);
    }
    else if(strncmp(cmd,"SETCFG:",7)==0)
    {
			if(cfg.notify_allowconfchange!=1)
			{
				sprintf(cmd,"500 Configuration changes not allowed\n");
			}
			else
			{
	      strncpy(buff,reverse_strnget(cmd,strlen(cmd)-7),511);
				sprintf(cmd,"220 Ok\n");
				if(strncmp(buff,"X",1)==0)
				{
					cfg.notify_x=atoi(reverse_strnget(buff,strlen(buff)-2));
				}
				else if(strncmp(buff,"Y",1)==0)
				{
					cfg.notify_y=atoi(reverse_strnget(buff,strlen(buff)-2));
				}
				else if(strncmp(buff,"DELAY",5)==0)
				{
					cfg.notify_delay=atoi(reverse_strnget(buff,strlen(buff)-6));
				}
				else if(strncmp(buff,"PLAY",4)==0)
				{
					cfg.notify_play=atoi(reverse_strnget(buff,strlen(buff)-5));
				}
				else if(strncmp(buff,"ALLOWMOVE",9)==0)
				{
					cfg.notify_allowmove=atoi(reverse_strnget(buff,strlen(buff)-10));
				}	
				else if(strncmp(buff,"ALLOWHTML",9)==0)
				{
					cfg.notify_allowhtml=atoi(reverse_strnget(buff,strlen(buff)-10));
				}
				else if(strncmp(buff,"SSINK",5)==0)
				{
					strncpy(cfg.notify_ssink,reverse_strnget(buff,strlen(buff)-6),11);
				}
				/* Up to now, this is not allowed. A on-the-fly Logout-change would be
						a risky thing... */
				/* else if(strncmp(buff,"LOGOUT",6)==0)
				{
					strcpy(cfg.notify_logout,reverse_strnget(buff,strlen(buff)-7));
				} */
				else if(strncmp(buff,"ALLOWRELOAD",11)==0)
				{
					cfg.notify_allowreload=atoi(reverse_strnget(buff,strlen(buff)-12));
				}
				else if(strncmp(buff,"ALLOWCONFCHANGE",15)==0)
				{
					cfg.notify_allowconfchange=atoi(reverse_strnget(buff,strlen(buff)-16));
				}
				else if(strncmp(buff,"SAVECONFONEXIT",14)==0)
				{
					cfg.notify_saveconfonexit=atoi(reverse_strnget(buff,strlen(buff)-15));
				}
				else if(strncmp(buff,"BTNEVENTS",9)==0)
				{
					cfg.notify_btnevents=atoi(reverse_strnget(buff,strlen(buff)-10));
				}
				else
				{
					sprintf(cmd,"510 Unrecognized argument for SETCFG:\n");
				}
			}
			send(sockfd,cmd,strlen(cmd)+1,0);
    }
    else if(strncmp(cmd,"LANG",4)==0)
    {
			sprintf(cmd,"214 LANG:%s\n",getenv("LANG"));
			send(sockfd,cmd,strlen(cmd)+1,0);
		}
    else if(strncmp(cmd,"QUIT",4)==0)
    {
      break;
    }
    else if(strncmp(cmd,"RELOAD",6)==0)
    {
      if(cfg.notify_allowreload==1)
			{
			  sprintf(buff,"%s/.gnotify.xml",getenv("HOME"));
			  readconfig(buff);
				sprintf(cmd,"220 Ok\n");
			}
			else
			{
				sprintf(cmd,"500 RELOAD is not allowed\n");
			}
			send(sockfd,cmd,strlen(cmd)+1,0);
    }
		else if(strncmp(cmd,"SAVECONFIG",10)==0)
		{
			if(cfg.notify_allowconfchange==1)
			{
				if(getuid==0&&getgid==0)
				{
					saveconfig(GNOTIFY_ETC);
				}
				else
				{
					saveconfig(buff);
				}
				sprintf(cmd,"220 Ok\n");
			}
			else
			{
				sprintf(cmd,"500 SAVECONFIG is not allowed\n");
			}
			send(sockfd,cmd,strlen(cmd)+1,0);
		}
    else if(strncmp(cmd,"BTNEVENT",8)==0)
    {
			if(cfg.notify_btnevents!=1)
			{
				sprintf(cmd,"500 Button-events are not allowed\n");
			}
			else
			{
	      strncpy(buff,reverse_strnget(cmd,strlen(cmd)-9),511);
				sprintf(cmd,"220 Ok\n");
				if(strncmp(buff,"HTTP",4)==0)
				{
					strncpy(cdb[cid].btnevent,reverse_strnget(buff,strlen(buff)-5),511);
					cdb[cid].btnevent_type=BTNEVENT_HTTP;
				}
				else if(strncmp(buff,"FTP",3)==0)
				{
					strncpy(cdb[cid].btnevent,reverse_strnget(buff,strlen(buff)-4),511);
					cdb[cid].btnevent_type=BTNEVENT_FTP;
				}
				else if(strncmp(buff,"FILE",4)==0)
				{
					strncpy(cdb[cid].btnevent,reverse_strnget(buff,strlen(buff)-5),511);
					cdb[cid].btnevent_type=BTNEVENT_FILE;
				}
				else
				{
					sprintf(cmd,"510 Unrecognized Button-Event type: %s\n",buff);
				}
			}
			send(sockfd,cmd,strlen(cmd)+1,0);
		}
		else
		{
			sprintf(cmd,"510 Unrecognized command\n");
			send(sockfd,cmd,strlen(cmd)+1,0);
		}
	}while(i>0);
  close(sockfd);
	printflog(LOG_DAEMON|LOG_NOTICE,"client disconnected: %s\n",cdb[cid].ip);
	cdb[cid].occupied=0;
	pthread_exit((void *)0);
}

void run_button_event(int cid)
{
	char buff[524];
	
	if(cdb[cid].btnevent_type==0)
	{
		return;
	}
	else
	{
		sprintf(buff,"gnome-open %s",cdb[cid].btnevent);
		system(buff);
	}
	return;	
}
