/*
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "include/gnotify.h"

GtkWidget *txtPositionX;
GtkWidget *txtPositionY;
GtkWidget *txtDelay;

GtkTextBuffer *lblIplist;
GtkWidget *frmIplist;

char aiplist[128][32];

void gnotify_cfggui(void)
{
	GtkWidget *frmCfggui;
  GtkWidget *tabCfggui;
  GtkWidget *cmdIpconfig;
  GtkWidget *cmdCancel;
  GtkWidget *cmdSave;
	
	GtkWidget *lblPositionX;
	GtkWidget *lblPositionY;
	GtkWidget *lblDelay;
	GtkWidget *ckPlaysound;
	GtkWidget *lblSsink,*cboSsink;
	GtkWidget *ckAllowmove;
	GtkWidget *ckAllowhtml;
	GtkWidget *ckAllowreload;
	GtkWidget *ckAllowcfgchange;
	GtkWidget *ckSaveconf;
	GtkWidget *ckBtnevents;
	GtkWidget *lblLogout,*cboLogout;
	
	GList *cbolSsink=NULL,*cbolLogout=NULL;
	char buffer[8];
	
  gtk_set_locale ();
 	gtk_init (&g_argc,&g_argv);
	
 	frmCfggui=gtk_window_new(GTK_WINDOW_TOPLEVEL);
	gtk_window_set_position (GTK_WINDOW(frmCfggui),GTK_WIN_POS_CENTER);
 	g_signal_connect_swapped(GTK_OBJECT(frmCfggui), "destroy",G_CALLBACK(gtk_main_quit),NULL);
 	gtk_window_set_title(GTK_WINDOW(frmCfggui),"GNotify Config-GUI");
 	gtk_window_set_default_size(GTK_WINDOW(frmCfggui),100,150);
  	
 	tabCfggui=gtk_table_new(2,15,FALSE);
	
	
	lblPositionX=gtk_label_new("Default X-position [default: 0]: ");
	lblPositionY=gtk_label_new("Default Y-position [default: 0]: ");
	lblDelay=gtk_label_new("Notification delay in ms [default: 5000]: ");
	lblSsink=gtk_label_new("Sound-sink [default: esdsink]: ");
	lblLogout=gtk_label_new("Log-output [default: syslog]: ");

	txtPositionX=gtk_entry_new();
	sprintf(buffer,"%i",cfg.notify_x);
	gtk_entry_set_text(GTK_ENTRY(txtPositionX),buffer);
	txtPositionY=gtk_entry_new();	
	sprintf(buffer,"%i",cfg.notify_y);
	gtk_entry_set_text(GTK_ENTRY(txtPositionY),buffer);
	txtDelay=gtk_entry_new();	
	sprintf(buffer,"%i",cfg.notify_delay);
	gtk_entry_set_text(GTK_ENTRY(txtDelay),buffer);

	ckPlaysound=gtk_check_button_new_with_label("Play sound [default: 1]");
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(ckPlaysound),cfg.notify_play);
	g_signal_connect(GTK_OBJECT(ckPlaysound), "clicked",G_CALLBACK(ckPlaysound_callback),NULL);
	
	ckAllowhtml=gtk_check_button_new_with_label("Allow HTTP-Informationpage [default: 1]");
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(ckAllowhtml),cfg.notify_allowhtml);
	g_signal_connect(GTK_OBJECT(ckAllowhtml), "clicked",G_CALLBACK(ckAllowhtml_callback),NULL);

	ckAllowreload=gtk_check_button_new_with_label("Allow configuration on-the-fly reloading [default: 0]");
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(ckAllowreload),cfg.notify_allowreload);
	g_signal_connect(GTK_OBJECT(ckAllowreload), "clicked",G_CALLBACK(ckAllowreload_callback),NULL);

	ckAllowcfgchange=gtk_check_button_new_with_label("Allow configuration changes [default: 0]");
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(ckAllowcfgchange),cfg.notify_allowconfchange);
	g_signal_connect(GTK_OBJECT(ckAllowcfgchange), "clicked",G_CALLBACK(ckAllowcfgchange_callback),NULL);

	ckSaveconf=gtk_check_button_new_with_label("Save configuration on exit [default: 0]");
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(ckSaveconf),cfg.notify_saveconfonexit);
	g_signal_connect(GTK_OBJECT(ckSaveconf), "clicked",G_CALLBACK(ckSaveconf_callback),NULL);

	ckAllowmove=gtk_check_button_new_with_label("Allow clients to move the Notificationbox [default: 0]");
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(ckAllowmove),cfg.notify_allowmove);
	g_signal_connect(GTK_OBJECT(ckAllowmove), "clicked",G_CALLBACK(ckAllowmove_callback),NULL);

	ckBtnevents=gtk_check_button_new_with_label("Allow clients to set up button-events [default: 1]");
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(ckBtnevents),cfg.notify_btnevents);
	g_signal_connect(GTK_OBJECT(ckBtnevents), "clicked",G_CALLBACK(ckBtnevent_callback),NULL);
	
	cbolSsink=g_list_append(cbolSsink,"alsasink");
	cbolSsink=g_list_append(cbolSsink,"artsdsink");
	cbolSsink=g_list_append(cbolSsink,"esdsink");
	cbolSsink=g_list_append(cbolSsink,"jacksink");
	cbolSsink=g_list_append(cbolSsink,"osssink");

	cboSsink=gtk_combo_new();
	gtk_combo_set_value_in_list(GTK_COMBO(cboSsink),TRUE,FALSE);	
	gtk_entry_set_text(GTK_ENTRY(GTK_COMBO(cboSsink)->entry),cfg.notify_ssink);
	g_signal_connect(GTK_OBJECT(GTK_COMBO(cboSsink)->entry), "changed",G_CALLBACK(cboSsink_callback),NULL);
	gtk_combo_set_popdown_strings(GTK_COMBO(cboSsink),cbolSsink);
	

	cbolLogout=g_list_append(cbolLogout,"syslog");
	cbolLogout=g_list_append(cbolLogout,"stdout");
	cbolLogout=g_list_append(cbolLogout,"stderr");
	
	cboLogout=gtk_combo_new();
	gtk_combo_set_value_in_list(GTK_COMBO(cboLogout),TRUE,FALSE);	
	gtk_entry_set_text(GTK_ENTRY(GTK_COMBO(cboLogout)->entry),cfg.notify_logout);
	g_signal_connect(GTK_OBJECT(GTK_COMBO(cboLogout)->entry), "changed",G_CALLBACK(cboLogout_callback),NULL);
	gtk_combo_set_popdown_strings(GTK_COMBO(cboLogout),cbolLogout);

	cmdIpconfig=gtk_button_new_with_label("IP-Config");
 	g_signal_connect_swapped(GTK_OBJECT(cmdIpconfig), "clicked",G_CALLBACK(gnotify_cfggui_iplist),NULL);

	cmdCancel=gtk_button_new_with_label("Cancel");
 	g_signal_connect_swapped(GTK_OBJECT(cmdCancel), "clicked",G_CALLBACK(gtk_main_quit),NULL);
	cmdSave=gtk_button_new_with_label("Save");
	g_signal_connect(GTK_OBJECT(cmdSave),"clicked",G_CALLBACK(cmdSave_callback),NULL);

	gtk_table_attach(GTK_TABLE(tabCfggui),ckPlaysound,0,2,0,1,GTK_FILL|GTK_EXPAND,GTK_FILL,2,2);
	gtk_table_attach(GTK_TABLE(tabCfggui),ckSaveconf,0,2,1,2,GTK_FILL|GTK_EXPAND,GTK_FILL,2,2);
	gtk_table_attach(GTK_TABLE(tabCfggui),ckAllowreload,0,2,3,4,GTK_FILL|GTK_EXPAND,GTK_FILL,2,2);
	gtk_table_attach(GTK_TABLE(tabCfggui),ckAllowcfgchange,0,2,4,5,GTK_FILL|GTK_EXPAND,GTK_FILL,2,2);
	gtk_table_attach(GTK_TABLE(tabCfggui),ckAllowhtml,0,2,5,6,GTK_FILL|GTK_EXPAND,GTK_FILL,2,2);
	gtk_table_attach(GTK_TABLE(tabCfggui),ckAllowmove,0,2,6,7,GTK_FILL|GTK_EXPAND,GTK_FILL,2,2);
	gtk_table_attach(GTK_TABLE(tabCfggui),ckBtnevents,0,2,7,8,GTK_FILL|GTK_EXPAND,GTK_FILL,2,2);

	gtk_table_attach(GTK_TABLE(tabCfggui),lblPositionX,0,1,8,9,GTK_FILL,GTK_FILL,2,2);
	gtk_table_attach(GTK_TABLE(tabCfggui),txtPositionX,1,2,8,9,GTK_FILL|GTK_EXPAND,GTK_FILL,2,2);

	gtk_table_attach(GTK_TABLE(tabCfggui),lblPositionY,0,1,9,10,GTK_FILL,GTK_FILL,2,2);
	gtk_table_attach(GTK_TABLE(tabCfggui),txtPositionY,1,2,9,10,GTK_FILL|GTK_EXPAND,GTK_FILL,2,2);
		
	gtk_table_attach(GTK_TABLE(tabCfggui),lblDelay,0,1,10,11,GTK_FILL,GTK_FILL,2,2);
	gtk_table_attach(GTK_TABLE(tabCfggui),txtDelay,1,2,10,11,GTK_FILL|GTK_EXPAND,GTK_FILL,2,2);

	gtk_table_attach(GTK_TABLE(tabCfggui),lblSsink,0,1,11,12,GTK_FILL,GTK_FILL,2,2);
	gtk_table_attach(GTK_TABLE(tabCfggui),cboSsink,1,2,11,12,GTK_FILL|GTK_EXPAND,GTK_FILL,2,2);

	gtk_table_attach(GTK_TABLE(tabCfggui),lblLogout,0,1,12,13,GTK_FILL,GTK_FILL,2,2);
	gtk_table_attach(GTK_TABLE(tabCfggui),cboLogout,1,2,12,13,GTK_FILL|GTK_EXPAND,GTK_FILL,2,2);

	gtk_table_attach(GTK_TABLE(tabCfggui),cmdIpconfig,0,1,13,14,GTK_FILL,GTK_FILL,2,2);
	gtk_table_attach(GTK_TABLE(tabCfggui),cmdSave,0,1,14,15,GTK_FILL,GTK_FILL,2,2);
	gtk_table_attach(GTK_TABLE(tabCfggui),cmdCancel,1,2,14,15,GTK_FILL|GTK_EXPAND,GTK_FILL,2,2);

	gtk_container_add(GTK_CONTAINER(frmCfggui),tabCfggui);
		
  gtk_widget_show_all(frmCfggui);
  gtk_main();
	exit(0);
}


void ckPlaysound_callback(GtkObject *widget, gpointer user_data)
{
	cfg.notify_play=gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(widget));
}

void ckAllowhtml_callback(GtkObject *widget, gpointer user_data)
{
	cfg.notify_allowhtml=gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(widget));
}

void ckAllowcfgchange_callback(GtkObject *widget, gpointer user_data)
{
	cfg.notify_allowconfchange=gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(widget));
}

void ckSaveconf_callback(GtkObject *widget, gpointer user_data)
{
	cfg.notify_saveconfonexit=gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(widget));
}

void ckAllowmove_callback(GtkObject *widget, gpointer user_data)
{
	cfg.notify_allowmove=gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(widget));
}

void ckAllowreload_callback(GtkObject *widget, gpointer user_data)
{
	cfg.notify_allowreload=gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(widget));
}

void ckBtnevent_callback(GtkObject *widget, gpointer user_data)
{
	cfg.notify_btnevents=gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(widget));
}

void cboSsink_callback(GtkObject *widget, gpointer user_data)
{
	strcpy(cfg.notify_ssink,gtk_entry_get_text(GTK_ENTRY(widget)));
}

void cboLogout_callback(GtkObject *widget, gpointer user_data)
{
	strcpy(cfg.notify_logout,gtk_entry_get_text(GTK_ENTRY(widget)));
}

void cmdSave_callback(GtkObject *widget, gpointer user_data)
{
	char buff[128];
	cfg.notify_x=atoi(gtk_entry_get_text(GTK_ENTRY(txtPositionX)));		
	cfg.notify_y=atoi(gtk_entry_get_text(GTK_ENTRY(txtPositionY)));		
	cfg.notify_delay=atoi(gtk_entry_get_text(GTK_ENTRY(txtDelay)));
  sprintf(buff,"%s/.gnotify.xml",getenv("HOME"));
	if(getuid==0&&getgid==0)
	{
		saveconfig(GNOTIFY_ETC);
	}
	else
	{
		saveconfig(buff);
	}
	gtk_main_quit();
}


void gnotify_cfggui_iplist(void)
{
  GtkWidget *tabIplist;
	GtkWidget *txtIp;
	GtkWidget *txtIplist;
	GtkWidget *scIplist;
	GtkWidget *lblDescription;
	GtkWidget *cmdAdd;
	GtkWidget *cmdRemove;
  GtkWidget *cmdCancel;
  GtkWidget *cmdSave;
	int i=0,j=0;
	
	memset(&aiplist,0x00,sizeof(aiplist));	
	for(i=0;i<127;i++)
	{
		if(strcmp(cfg.notify_allowip[i],"")!=0)
		{
			strcpy(aiplist[j],cfg.notify_allowip[i]);
			j++;
		}
	}

 	frmIplist=gtk_window_new(GTK_WINDOW_TOPLEVEL);
	gtk_window_set_position (GTK_WINDOW(frmIplist),GTK_WIN_POS_CENTER);
 	g_signal_connect_swapped(GTK_OBJECT(frmIplist), "destroy",G_CALLBACK(gtk_widget_destroy),GTK_OBJECT(frmIplist));
 	gtk_window_set_title(GTK_WINDOW(frmIplist),"IP-Config");
 	gtk_window_set_default_size(GTK_WINDOW(frmIplist),100,150);
  	
 	tabIplist=gtk_table_new(3,4,FALSE);
	
	lblDescription=gtk_label_new("These are all IPs which are allowed to connect to your GNotify daemon:");
	gtk_label_set_line_wrap(GTK_LABEL(lblDescription), TRUE);
	
	txtIp=gtk_entry_new();
	
	lblIplist=gtk_text_buffer_new(NULL);
	gtk_text_buffer_set_text(GTK_TEXT_BUFFER(lblIplist),list_to_plain(),-1);
	
	txtIplist=gtk_text_view_new_with_buffer(lblIplist);
	gtk_text_view_set_editable(GTK_TEXT_VIEW(txtIplist),FALSE);
	
	scIplist=gtk_scrolled_window_new(NULL,NULL);
	gtk_scrolled_window_add_with_viewport(GTK_SCROLLED_WINDOW(scIplist),txtIplist);

	cmdAdd=gtk_button_new_with_label("Add");
	g_signal_connect(GTK_OBJECT(cmdAdd),"clicked",G_CALLBACK(cmdAddip_callback),(gpointer)gtk_entry_get_text(GTK_ENTRY(txtIp)));

	cmdRemove=gtk_button_new_with_label("Remove");
	g_signal_connect(GTK_OBJECT(cmdRemove),"clicked",G_CALLBACK(cmdRemoveip_callback),(gpointer)gtk_entry_get_text(GTK_ENTRY(txtIp)));

	cmdCancel=gtk_button_new_with_label("Cancel");
 	g_signal_connect_swapped(GTK_OBJECT(cmdCancel), "clicked",G_CALLBACK(gtk_widget_destroy),GTK_OBJECT(frmIplist));
	cmdSave=gtk_button_new_with_label("Save");
	g_signal_connect(GTK_OBJECT(cmdSave),"clicked",G_CALLBACK(cmdSaveip_callback),NULL);
	
	gtk_table_attach(GTK_TABLE(tabIplist),txtIp,0,1,0,1,GTK_FILL|GTK_EXPAND,GTK_FILL,2,2);
	gtk_table_attach(GTK_TABLE(tabIplist),cmdAdd,1,2,0,1,GTK_FILL,GTK_FILL,2,2);
	gtk_table_attach(GTK_TABLE(tabIplist),cmdRemove,2,3,0,1,GTK_FILL,GTK_FILL,2,2);
	gtk_table_attach(GTK_TABLE(tabIplist),lblDescription,0,3,1,2,GTK_FILL,GTK_FILL,2,2);
	gtk_table_attach(GTK_TABLE(tabIplist),scIplist,0,3,2,3,GTK_FILL|GTK_EXPAND,GTK_FILL|GTK_EXPAND,2,2);
	gtk_table_attach(GTK_TABLE(tabIplist),cmdSave,1,2,3,4,GTK_FILL,GTK_FILL,2,2);
	gtk_table_attach(GTK_TABLE(tabIplist),cmdCancel,2,3,3,4,GTK_FILL,GTK_FILL,2,2);

	gtk_container_add(GTK_CONTAINER(frmIplist),tabIplist);
		
	gtk_widget_show_all(frmIplist);
	return;
}

char *list_to_plain(void)
{
	int i;
	char buff[64];
	static char buffer[8192];
	
	strcpy(buffer,"");
	for(i=0;i<127;i++)
	{
		if(strcmp(aiplist[i],"")!=0)
		{
			snprintf(buff,62,"%s\n",aiplist[i]);
			strcat(buffer,buff);
		}
	}
	return(buffer);
}

int searchip(char *ip)
{
	int i;

	if(ip==NULL)
		return(-1);
	
	for(i=0;i<127;i++)
	{
		if(strcmp(aiplist[i],ip)==0)
			return(i);
	}
	return(-2);
}	

int add_ip_to_list(char *ip)
{
	int i;
	
	if(ip==NULL)
		return(-1);
	if(is_ip(ip)!=0)
		return(-4);
	if(searchip(ip)!=-2)
		return(-2);
	
	for(i=0;i<127;i++)
	{
		if(strcmp(aiplist[i],"")==0)
		{
			strcpy(aiplist[i],ip);
			gtk_text_buffer_set_text(GTK_TEXT_BUFFER(lblIplist),list_to_plain(),-1);
			return(0);
		}
	}
	return(-3);
}

int remove_ip_from_list(char *ip)
{
	int i;

	if(ip==NULL)
		return(-1);
	if(is_ip(ip)!=0)
		return(-4);
	
	for(i=0;i<127;i++)
	{
		if(strcmp(aiplist[i],ip)==0)
		{
			strcpy(aiplist[i],"");
			gtk_text_buffer_set_text(GTK_TEXT_BUFFER(lblIplist),list_to_plain(),-1);
			memcpy(&cfg.notify_allowip,&aiplist,sizeof(cfg.notify_allowip));
			return(0);
		}
	}
	return(-1);
}

void cmdAddip_callback(GtkObject *widget, gpointer user_data)
{
	int i=add_ip_to_list((char*)user_data);
	if(i==-1)
		showmessage(GTK_MESSAGE_ERROR,GTK_BUTTONS_CLOSE,"Couldn't add IP to list:\nNo IP entered!");
	else if(i==-2)
		showmessage(GTK_MESSAGE_ERROR,GTK_BUTTONS_CLOSE,"Couldn't add IP to list:\nIP already in list!");
	else if(i==-3)
		showmessage(GTK_MESSAGE_ERROR,GTK_BUTTONS_CLOSE,"Couldn't add IP to list:\nList seems to be full!");
	else if(i==-4)
		showmessage(GTK_MESSAGE_ERROR,GTK_BUTTONS_CLOSE,"Couldn't add IP to list:\nThis is not a valid IP!");
	return;
}

void cmdRemoveip_callback(GtkObject *widget, gpointer user_data)
{
	if(remove_ip_from_list((char*)user_data)!=0)
	{
		showmessage(GTK_MESSAGE_ERROR,GTK_BUTTONS_CLOSE,"Couldn't remove IP from list!");
	}
	return;
}

void cmdSaveip_callback(GtkObject *widget, gpointer user_data)
{
	int i=0,j=1;
	
	for(i=0;i<127;i++)
	{
		if(strcmp(aiplist[i],"")!=0)
		{
			strcpy(cfg.notify_allowip[j],aiplist[i]);
			j++;
			cfg.notify_ipdisallows=j;
		}
	}
	gtk_widget_destroy(frmIplist);
	return;
}
