/*
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "include/gnotify.h"

int saveconfig(char *config)
{
	FILE *fle;
	int i;
	
/*	if(cfg.notify_saveconfonexit!=1)
	{
		return(-1);
	}*/
	if((fle=fopen(config,"w"))==NULL)
	{
		return(-1);
	}
	fprintf(fle,"<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<gnotify>\n");
		fprintf(fle,"\t<position_x>%i</position_x>\n",cfg.notify_x);
		fprintf(fle,"\t<position_y>%i</position_y>\n",cfg.notify_y);
		fprintf(fle,"\t<notify_delay>%i</notify_delay>\n",cfg.notify_delay);
		fprintf(fle,"\t<playsound>%i</playsound>\n",cfg.notify_play);
		fprintf(fle,"\t<gstreamer_sink>%s</gstreamer_sink>\n",cfg.notify_ssink);
		fprintf(fle,"\t<logout>%s</logout>\n",cfg.notify_logout);
		if(cfg.notify_ipdisallows>0)
		{
			for(i=1;i<cfg.notify_ipdisallows;i++)
			{
				fprintf(fle,"\t<allow_ip>%s</allow_ip>\n",cfg.notify_allowip[i]);
			}
		}
		fprintf(fle,"\t<allowmove>%i</allowmove>\n",cfg.notify_allowmove);
		fprintf(fle,"\t<allowhtml>%i</allowhtml>\n",cfg.notify_allowhtml);
		fprintf(fle,"\t<allowreload>%i</allowreload>\n",cfg.notify_allowreload);
		fprintf(fle,"\t<allowcfgchange>%i</allowcfgchange>\n",cfg.notify_allowconfchange);
		fprintf(fle,"\t<savecfgonexit>%i</savecfgonexit>\n",cfg.notify_saveconfonexit);
		fprintf(fle,"\t<buttonevents>%i</buttonevents>\n",cfg.notify_btnevents);
	fprintf(fle,"</gnotify>");
	fclose(fle);
	return(0);
}

int readconfig(char *config)
{
  xmlDocPtr conffile;
	xmlNodePtr cur;

	conffile = xmlParseFile(config);
	if(conffile==NULL)
  {
		printf("[xml] couldn't parse config-file successfully!\n");
		return(-1);
	}
	cur = xmlDocGetRootElement(conffile);
	if(cur==NULL)
	{
		printf("[xml] couldn't parse config-file: empty document!");
		xmlFreeDoc(conffile);
		return(-1);
	}
	if(xmlStrcmp(cur->name,(const xmlChar *)"gnotify"))
	{
		printf("[xml] config-file error: rootnode != \"gnotify\"");
		xmlFreeDoc(conffile);
		return(-1);
	}
	cur=cur->xmlChildrenNode;
	while(cur!=NULL)
	{
	  if((!xmlStrcmp(cur->name,(const xmlChar *)"position_x")))
		{
		  cfg.notify_x=atoi(xmlNodeListGetString(conffile,cur->xmlChildrenNode,1));
		}
	  else if((!xmlStrcmp(cur->name,(const xmlChar *)"position_y")))
		{
		  cfg.notify_y=atoi(xmlNodeListGetString(conffile,cur->xmlChildrenNode,1));
		}
	  else if((!xmlStrcmp(cur->name,(const xmlChar *)"notify_delay")))
		{
		  cfg.notify_delay=atoi(xmlNodeListGetString(conffile,cur->xmlChildrenNode,1));
		  if(cfg.notify_delay<1000)
		  {
		  	printf("setting the notify-delay lower than 1000ms is senseless...\n");
		  }
		}
	  else if((!xmlStrcmp(cur->name,(const xmlChar *)"playsound")))
		{
		  cfg.notify_play=atoi(xmlNodeListGetString(conffile,cur->xmlChildrenNode,1));
		}
	  else if((!xmlStrcmp(cur->name,(const xmlChar *)"gstreamer_sink")))
		{
		  strncpy(cfg.notify_ssink,xmlNodeListGetString(conffile,cur->xmlChildrenNode,1),8);
		}
	  else if((!xmlStrcmp(cur->name,(const xmlChar *)"allow_ip")))
		{
			if(is_ip(xmlNodeListGetString(conffile,cur->xmlChildrenNode,1))==0)
			{
				cfg.notify_ipdisallows++;
			  strncpy(cfg.notify_allowip[cfg.notify_ipdisallows],xmlNodeListGetString(conffile,cur->xmlChildrenNode,1),16);
			}
			else
			{
				printf("'%s' is not a valid IP! Skipping ... it (if you want to stop getting bugged, remove it!)\n",xmlNodeListGetString(conffile,cur->xmlChildrenNode,1));
			}
		}
	  else if((!xmlStrcmp(cur->name,(const xmlChar *)"allowhtml")))
		{
		  cfg.notify_allowhtml=atoi(xmlNodeListGetString(conffile,cur->xmlChildrenNode,1));
		}
	  else if((!xmlStrcmp(cur->name,(const xmlChar *)"allowreload")))
		{
		  cfg.notify_allowreload=atoi(xmlNodeListGetString(conffile,cur->xmlChildrenNode,1));
		}
	  else if((!xmlStrcmp(cur->name,(const xmlChar *)"allowcfgchange")))
		{
		  cfg.notify_allowconfchange=atoi(xmlNodeListGetString(conffile,cur->xmlChildrenNode,1));
		}
	  else if((!xmlStrcmp(cur->name,(const xmlChar *)"allowmove")))
		{
		  cfg.notify_allowmove=atoi(xmlNodeListGetString(conffile,cur->xmlChildrenNode,1));
		}
	  else if((!xmlStrcmp(cur->name,(const xmlChar *)"savecfgonexit")))
		{
		  cfg.notify_saveconfonexit=atoi(xmlNodeListGetString(conffile,cur->xmlChildrenNode,1));
		}
	  else if((!xmlStrcmp(cur->name,(const xmlChar *)"buttonevents")))
		{
		  cfg.notify_btnevents=atoi(xmlNodeListGetString(conffile,cur->xmlChildrenNode,1));
		}
	  else if((!xmlStrcmp(cur->name,(const xmlChar *)"logout")))
		{
		  strcpy(cfg.notify_logout,xmlNodeListGetString(conffile,cur->xmlChildrenNode,1));
		}
  	cur=cur->next;
	}
	xmlFreeDoc(conffile);
	return(0);
}

int createconfig(char *config)
{
	FILE *fle;
	
	if((fle=fopen(config,"w"))==NULL)
	{
		printf("couldn't create '%s' successfully!\n",config);
		return(-1);
	}
	fprintf(fle,"<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<gnotify>\n");
		fprintf(fle,"\t<position_x>0</position_x>\n");
		fprintf(fle,"\t<position_y>0</position_y>\n");
		fprintf(fle,"\t<notify_delay>5000</notify_delay>\n");
		fprintf(fle,"\t<playsound>1</playsound>\n");
		fprintf(fle,"\t<gstreamer_sink>esdsink</gstreamer_sink>\n");
		fprintf(fle,"\t<logout>syslog</logout>\n");
		fprintf(fle,"\t<!--\n\tuncomment this to allow\n\tonly connections from 127.0.0.1\n\t<allow_ip>127.0.0.1</allow_ip>\n\t-->\n");
		fprintf(fle,"\t<allowmove>0</allowmove>\n");
		fprintf(fle,"\t<allowhtml>1</allowhtml>\n");
		fprintf(fle,"\t<allowreload>0</allowreload>\n");
		fprintf(fle,"\t<allowcfgchange>0</allowcfgchange>\n");
		fprintf(fle,"\t<savecfgonexit>0</savecfgonexit>\n");
		fprintf(fle,"\t<buttonevents>1</buttonevents>\n");
		fprintf(fle,"\t<logout>stdout</logout>\n");
	fprintf(fle,"</gnotify>");
	fclose(fle);
	printf("'%s' created successfully!\n",config);
	return(0);
}
