/*
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
 
#include "include/gnotify.h"

int sockett;
int cfggui;

int main(int argc, char *argv[])
{
	int i=0;
	int daemon=0;
	cfggui=0;
  
	if(argc>=2)
  {
	  if(strcmp(argv[1],"-h")==0||strcmp(argv[1],"--help")==0)
	  {
  		gnotify_about();
	  }
	  else if(strcmp(argv[1],"-v")==0||strcmp(argv[1],"--version")==0)
	  {
	  	printf("%s\n",VERSION);
			exit(0);
	  }
	  else if(strcmp(argv[1],"-c")==0||strcmp(argv[1],"--configure")==0)
	  {
	  	cfggui=1;
	  }
		else
		{
			for(i=0;i<argc;i++)
			{
	  		if(strcmp(argv[i],"-d")==0||strcmp(argv[i],"--daemon")==0)
		  	{
					daemon=1;
		  	}
	  		else if(strcmp(argv[i],"-V")==0||strcmp(argv[i],"--verbose")==0)
		  	{
					cfg.notify_verbose=1;
		  	}
			}
		}
	}
	g_argc=argc;
	memcpy(&g_argv,&argv,sizeof(argv));
	if(daemon==1)
	{
		switch(fork())
		{
			case -1: printf("error, couldn't fork GNotify!\n"); exit(-1); break;
			case 0: gnotify_constructor(); break;
			default: exit(0); break;
		}
	}
	else
	{
		gnotify_constructor();
	}
	exit(0);
}

int gnotify_constructor(void)
{
  char buff[128];
	FILE *pidfile;
	
  setsid(); 
	getsysinfo();
  cfg.notify_x=0;  
  cfg.notify_y=0;  
  cfg.notify_delay=5000; 
  cfg.notify_play=1;
  cfg.notify_ipdisallows=0;
	strcpy(cfg.notify_ssink,"esdsink");
	strcpy(cfg.notify_logout,"stdout");
  if(readconfig(GNOTIFY_ETC)!=0)
	{
		printflog(LOG_DAEMON|LOG_ERR,"couldn't open: %s\n",GNOTIFY_ETC);
	  sprintf(buff,"%s/.gnotify.xml",getenv("HOME"));
		printflog(LOG_DAEMON|LOG_ERR,"trying: %s\n",buff);
  	if(readconfig(buff)!=0)
		{
			printflog(LOG_DAEMON|LOG_ERR,"couldn't open: %s\n",buff);
			printflog(LOG_DAEMON|LOG_ERR,"trying to create it...\n");
			if(getuid==0&&getgid==0)
			{
				createconfig(GNOTIFY_ETC);
			}
			else
			{
				createconfig(buff);
			}
			printflog(LOG_DAEMON|LOG_ERR,"please restart gnotify!\n");
			exit(-1);
		}
	}
	printflog(LOG_DAEMON|LOG_ERR,"configuration loaded!\n");
	if(cfggui==1) gnotify_cfggui();
	sprintf(buff,"/tmp/gnotify-%s.pid",getenv("USER"));
	if((pidfile=fopen(buff,"w"))==NULL)
	{
		printflog(LOG_DAEMON|LOG_ERR,"couldn't open '%s' for writing pid into it... *argh*\n");
		exit(-1);
	}
	else
	{
		fprintf(pidfile,"%i",(GNOTIFYPID=getpid()));
		fclose(pidfile);
	}
	atexit(gnotify_atexit);
  signal(SIGHUP,gnotify_signal);
  signal(SIGINT,gnotify_signal);
  signal(SIGQUIT,gnotify_signal);
  signal(SIGILL,gnotify_signal);
  signal(SIGABRT,gnotify_signal);
  signal(SIGFPE,gnotify_signal);
  signal(SIGKILL,gnotify_signal);
  signal(SIGSEGV,gnotify_signal);
  signal(SIGPIPE,gnotify_signal);
  signal(SIGTERM,gnotify_signal);
  signal(SIGUSR1,gnotify_signal);
  signal(SIGSTOP,gnotify_signal);
  signal(SIGTSTP,gnotify_signal);
	if(strncmp(cfg.notify_logout,"syslog",6)==0) openlog("gnotify",LOG_CONS,LOG_DAEMON);
 	gnotify_main();
  exit(0);
}

void gnotify_main(void)
{
  struct sockaddr_in server;
	struct sockaddr_in client;
	int fd;
	int len;
	int i=1;
	int j=0;
	int allowed=0;
	int tth;
	
	setsid();
	if((sockett=socket(PF_INET,SOCK_STREAM,0))<0)
	{
	  printflog(LOG_DAEMON|LOG_ERR,"couldn't create socket!\n");
	  exit(-1);
  }
  setsockopt(sockett,SOL_SOCKET,SO_REUSEADDR,&i,sizeof(i));
  memset(&server,0,sizeof(server));
  server.sin_family=AF_INET;
  server.sin_addr.s_addr=htonl(INADDR_ANY);
  server.sin_port = htons(7206);
	if(bind(sockett,(struct sockaddr*)&server,sizeof(server))<0)
	{
	  printflog(LOG_DAEMON|LOG_ERR,"couldn't bind socket!\nMaybe GNotify is already running ...?\n");
	  exit(-1);
	}
	listen(sockett,5);
	pthread_mutex_init(&mutex, NULL);
	for(;;)
	{
    len=sizeof(client);
    if((fd=accept(sockett,(struct sockaddr*)&client, &len))<0)
		{
		  printflog(LOG_DAEMON|LOG_ERR,"couldn't accept client request!\n");
    }
		else
		{
			cid_zombiekill();
			if((tth=cid_getfree())==-1)
			{
				printflog(LOG_DAEMON|LOG_ERR,"couldn't accept client request, cause: no free slot available!\n");
				close(fd);
			}
			else
			{
				strcpy(cdb[tth].ip,inet_ntoa(client.sin_addr));
				cdb[tth].sockfd=fd;
				if(cfg.notify_ipdisallows>0)
				{
					for(j=1;j<128;j++)
					{
						if(strcmp(cdb[tth].ip,cfg.notify_allowip[j])==0)
						{
							allowed=1;
							break;
						}
					}
				}
				if((cfg.notify_ipdisallows>0&&allowed==1)||(cfg.notify_ipdisallows==0))
				{
			  	if((pthread_create(&cdb[tth].th,NULL,(void *)&gnotify_client,(void*)tth))!=0)
					{
					  printflog(LOG_DAEMON|LOG_ERR,"couldn't create new thread!\n");
					}
				}
				else
				{
					printflog(LOG_DAEMON|LOG_NOTICE,"ip '%s' is not allowed to connect!\n",cdb[tth].ip);
					close(fd);
				}
    	}
		}
  }
	return;
}

void gnotify_atexit(void)
{
	char buff[128];
	
	cid_zombiekill();
	close(sockett);
  sprintf(buff,"%s/.gnotify.xml",getenv("HOME"));
	if(cfg.notify_saveconfonexit==1)
	{
		if(getuid==0&&getgid==0)
		{
			saveconfig(GNOTIFY_ETC);
		}
		else
		{
			saveconfig(buff);
		}
	}
	sprintf(buff,"/tmp/gnotify-%s.pid",getenv("USER"));
	if(remove(buff)!=0)
		printflog(LOG_DAEMON|LOG_ERR,"error, couldn't remove '%s'... wtf?\n");
	pthread_mutex_destroy(&mutex);
	if(strncmp(cfg.notify_logout,"syslog",6)==0) closelog();
	return;
}

void gnotify_signal(int sign)
{
	char buff[128];
	
	switch(sign)
	{
		/* if SIGUSR1 arrives, GNotify will (re)load his config file... */
		case SIGUSR1: sprintf(buff,"%s/.gnotify.xml",getenv("HOME")); readconfig(buff); break;
		default: gnotify_atexit(); break;
	}
	return;
}

int playsound(const char *file)
{
	char buff[512];
	int i;
	/* I know, I shouldn't use such a quick 'n' dirty sound-hack,
	 * but so, there is no need for gstreamer libraries or development files,
	 * the only thing you need is the gst-launch binary. If it's not available
	 * you will not get an error or anything else... nice, hm?
	 */
	if(strcmp(cfg.notify_ssink,"")==0)
	{
		printflog(LOG_DAEMON|LOG_ERR,"no gstreamer-sink set! setting esdsink...");
		strcpy(cfg.notify_ssink,"esdsink");
	}
	sprintf(buff,"/usr/bin/gst-launch filesrc location=\"%s\" ! spider ! %s > /dev/null",file,cfg.notify_ssink);
	i=system(buff);
	pthread_exit((void *)i);
}

int cid_getfree(void)
{
	int i;
	
	for(i=0;i<128;i++)
	{
		if(cdb[i].occupied!=1)
		{
			return(i);
		}			
	}
	return(-1);
}

void cid_zombiekill(void)
{
	int i;
	
	for(i=0;i<128;i++)
	{
		if(cdb[i].occupied!=1)
		{
			if(pthread_equal(cdb[i].th,NULLTHREAD)==0)
				pthread_cancel(cdb[i].th);
		}
	}
}

void getsysinfo(void)
{
  struct utsname info;
	uname(&info);
  strcpy(sysinfo.k_version,info.version);
  strcpy(sysinfo.k_release,info.release);
  strcpy(sysinfo.machine,info.machine);
  strcpy(sysinfo.opsys,info.sysname);
  strcpy(sysinfo.nodename,info.nodename);
  return;
}

int is_ip(char ip[64])
{
	int i,j=0,k=0,l=0;
	
	for(i=0;i<16;i++)
	{
		if(l>3)
			return(-1);
		if(ip[i]=='.')
		{
			j++;
			l=0;
		}
		else if(ip[i]=='\0')
		{
			break;
		}
		else if(ip[i]==' ')
		{
			return(-1);
		}
		else
		{
			if(isdigit(ip[i])==0)
				return(-1);
			k++;
			l++;
		}
	}
	if(j>3||j<3)
		return(-1);
	if(k>13)
		return(-1);
	return(0);
}

int count_connections(void)
{
	int i,j=0;
	
	for(i=0;i<MAX_CLIENTS;i++)
	{
		if(cdb[i].occupied==1)
			j++;
	}
	return(j);
}

char *reverse_strnget(const char* string1, int n)
{
  static char buffer[1024];

  strcpy(buffer, &string1[strlen(string1)-n]);
	return(buffer);
}

int printflog(int syslogpriority, const char *text, ...)
{
  va_list ap;
	char output[1024];

  va_start(ap, text);
  vsprintf(output, text, ap);
  va_end(ap);
	if(strncmp(cfg.notify_logout,"syslog",6)==0)
	{
		syslog(syslogpriority,"%s",output);
	}
	else if(strncmp(cfg.notify_logout,"stdout",6)==0)
	{
  	printf("%s",output);
	}
	else if(strncmp(cfg.notify_logout,"stderr",6)==0)
	{
  	fprintf(stderr,"%s",output);
	}
	else
	{
		strncpy(cfg.notify_logout,"stdout",6);
  	printf("%s",output);
	}		
	return(0);
}
