/*
 * Decompiled with CFR 0.152.
 */
package agent.frida.model.iface1;

import agent.frida.model.iface1.FridaModelSelectableObject;
import agent.frida.model.iface2.FridaModelTargetObject;
import ghidra.async.AsyncUtils;
import ghidra.dbg.error.DebuggerIllegalArgumentException;
import ghidra.dbg.target.TargetFocusScope;
import ghidra.dbg.target.TargetObject;
import ghidra.dbg.util.PathUtils;
import java.util.List;
import java.util.concurrent.CompletableFuture;

public interface FridaModelTargetFocusScope
extends FridaModelTargetObject,
TargetFocusScope {
    public FridaModelSelectableObject getFocus();

    public boolean setFocus(FridaModelSelectableObject var1);

    default public CompletableFuture<Void> requestFocus(TargetObject obj) {
        return this.getModel().gateFuture(this.getManager().requestFocus(this, obj));
    }

    default public CompletableFuture<Void> doRequestFocus(TargetObject obj) {
        if (this.getManager().isWaiting()) {
            return AsyncUtils.NIL;
        }
        this.getModel().assertMine(TargetObject.class, obj);
        if (obj.equals((Object)this.getFocus())) {
            return AsyncUtils.NIL;
        }
        if (!PathUtils.isAncestor((List)this.getPath(), (List)obj.getPath())) {
            throw new DebuggerIllegalArgumentException("Can only focus a successor of the scope");
        }
        TargetObject cur = obj;
        while (cur != null) {
            if (cur instanceof FridaModelSelectableObject) {
                FridaModelSelectableObject sel = (FridaModelSelectableObject)cur;
                this.setFocus(sel);
                return AsyncUtils.NIL;
            }
            if (cur instanceof FridaModelTargetObject) {
                FridaModelTargetObject def = (FridaModelTargetObject)cur;
                cur = def.getParent();
                continue;
            }
            throw new AssertionError();
        }
        return AsyncUtils.NIL;
    }
}

