/*
 * Decompiled with CFR 0.152.
 */
package agent.frida.manager.cmd;

import agent.frida.frida.FridaClient;
import agent.frida.manager.FridaImport;
import agent.frida.manager.FridaModule;
import agent.frida.manager.cmd.AbstractFridaCommand;
import agent.frida.manager.cmd.FridaPendingCommand;
import agent.frida.manager.impl.FridaManagerImpl;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.HashMap;
import java.util.Map;

public class FridaListModuleImportsCommand
extends AbstractFridaCommand<Map<String, FridaImport>> {
    protected final FridaModule module;
    private Map<String, FridaImport> imports;

    public FridaListModuleImportsCommand(FridaManagerImpl manager, FridaModule module) {
        super(manager);
        this.module = module;
    }

    @Override
    public Map<String, FridaImport> complete(FridaPendingCommand<?> pending) {
        return this.imports;
    }

    @Override
    public void invoke() {
        this.imports = new HashMap<String, FridaImport>();
        this.manager.loadScript(this, "list_module_imports", "result = Process.findModuleByAddress('" + this.module.getRangeAddress() + "').enumerateImports();");
        for (FridaImport imp : this.imports.values()) {
            this.imports.put(FridaClient.getId(imp), imp);
        }
    }

    @Override
    public void parseSpecifics(JsonElement element) {
        FridaImport imp = new FridaImport(this.module);
        JsonObject symDetails = element.getAsJsonObject();
        imp.setName(symDetails.get("name").getAsString());
        imp.setAddress(symDetails.get("address").getAsString());
        imp.setType(symDetails.get("type").getAsString());
        imp.setMod(symDetails.get("module").getAsString());
        JsonElement slot = symDetails.get("slot");
        if (slot != null) {
            imp.setSlot(slot.getAsString());
        }
        this.imports.put(FridaClient.getId(imp), imp);
    }
}

