/*
 * Decompiled with CFR 0.152.
 */
package agent.frida.manager;

import agent.frida.frida.FridaClient;
import agent.frida.manager.FridaCommand;
import agent.frida.manager.FridaEvent;
import agent.frida.manager.FridaEventsListener;
import agent.frida.manager.FridaExport;
import agent.frida.manager.FridaFrame;
import agent.frida.manager.FridaImport;
import agent.frida.manager.FridaMemoryRegionInfo;
import agent.frida.manager.FridaModule;
import agent.frida.manager.FridaProcess;
import agent.frida.manager.FridaSection;
import agent.frida.manager.FridaSession;
import agent.frida.manager.FridaState;
import agent.frida.manager.FridaStateListener;
import agent.frida.manager.FridaSymbol;
import agent.frida.manager.FridaTarget;
import agent.frida.manager.FridaThread;
import agent.frida.manager.impl.FridaManagerImpl;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.apache.commons.lang3.tuple.Pair;

public interface FridaManager
extends AutoCloseable {
    public static FridaManager newInstance() {
        return new FridaManagerImpl();
    }

    public CompletableFuture<Void> start(String[] var1);

    public void terminate();

    public boolean isRunning();

    public void addStateListener(FridaStateListener var1);

    public void removeStateListener(FridaStateListener var1);

    public void addEventsListener(FridaEventsListener var1);

    public void removeEventsListener(FridaEventsListener var1);

    public FridaThread getThread(FridaProcess var1, String var2);

    public FridaProcess getProcess(FridaSession var1, String var2);

    public FridaSession getSession(String var1);

    public FridaModule getModule(FridaProcess var1, String var2);

    public FridaMemoryRegionInfo getMemoryRegion(FridaProcess var1, String var2);

    public Map<String, FridaThread> getKnownThreads(FridaProcess var1);

    public Map<String, FridaProcess> getKnownProcesses(FridaSession var1);

    public Map<String, FridaSession> getKnownSessions();

    public Map<String, FridaModule> getKnownModules(FridaProcess var1);

    public Map<String, FridaMemoryRegionInfo> getKnownRegions(FridaProcess var1);

    public FridaState getState();

    public CompletableFuture<FridaProcess> addProcess();

    public CompletableFuture<Void> removeProcess(FridaProcess var1);

    public CompletableFuture<FridaSession> addSession();

    public CompletableFuture<Void> console(String var1);

    public CompletableFuture<String> consoleCapture(String var1);

    public CompletableFuture<Void> listThreads(FridaProcess var1);

    public CompletableFuture<Map<String, FridaProcess>> listProcesses(FridaSession var1);

    public CompletableFuture<List<Pair<String, String>>> listAvailableProcesses();

    public CompletableFuture<List<Pair<String, String>>> listAvailableDevices();

    public CompletableFuture<Map<String, FridaSession>> listSessions();

    public CompletableFuture<Map<String, FridaFrame>> listStackFrames(FridaThread var1);

    public CompletableFuture<Map<String, String>> listRegisters(FridaThread var1);

    public CompletableFuture<Void> listModules(FridaProcess var1);

    public CompletableFuture<Map<String, FridaSection>> listModuleSections(FridaModule var1);

    public CompletableFuture<Map<String, FridaSymbol>> listModuleSymbols(FridaModule var1);

    public CompletableFuture<Map<String, FridaImport>> listModuleImports(FridaModule var1);

    public CompletableFuture<Map<String, FridaExport>> listModuleExports(FridaModule var1);

    public CompletableFuture<Void> listMemory(FridaProcess var1);

    public CompletableFuture<Void> listHeapMemory(FridaProcess var1);

    public CompletableFuture<Void> setExceptionHandler(FridaProcess var1);

    public CompletableFuture<?> attach(String var1);

    public CompletableFuture<?> attachDeviceById(String var1);

    public CompletableFuture<?> attachDeviceByType(String var1);

    public CompletableFuture<?> launch(String var1, List<String> var2);

    public CompletableFuture<?> launch(Map<String, ?> var1);

    public FridaProcess currentProcess();

    public CompletableFuture<Void> waitForPrompt();

    public <T> CompletableFuture<T> execute(FridaCommand<? extends T> var1);

    public FridaClient.DebugStatus processEvent(FridaEvent<?> var1);

    public FridaClient.DebugStatus getStatus();

    public void updateState(FridaSession var1);

    public FridaTarget getCurrentTarget();

    public void setCurrentTarget(FridaTarget var1);

    public CompletableFuture<Void> getSessionAttributes(FridaSession var1);

    public void enableDebugger(FridaSession var1, int var2);
}

