/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.emulator;

import generic.ULongSpan;
import ghidra.app.emulator.AdaptedMemoryState;
import ghidra.app.emulator.Emulator;
import ghidra.app.emulator.EmulatorConfiguration;
import ghidra.app.emulator.FilteredMemoryState;
import ghidra.app.emulator.MemoryAccessFilter;
import ghidra.app.emulator.memory.MemoryLoadImage;
import ghidra.app.emulator.state.RegisterState;
import ghidra.app.plugin.processors.sleigh.SleighLanguage;
import ghidra.lifecycle.Transitional;
import ghidra.pcode.emu.AbstractPcodeMachine;
import ghidra.pcode.emu.BytesPcodeThread;
import ghidra.pcode.emu.PcodeEmulator;
import ghidra.pcode.emu.PcodeMachine;
import ghidra.pcode.emu.PcodeThread;
import ghidra.pcode.emu.ThreadPcodeExecutorState;
import ghidra.pcode.emulate.BreakCallBack;
import ghidra.pcode.emulate.BreakTableCallBack;
import ghidra.pcode.emulate.EmulateExecutionState;
import ghidra.pcode.emulate.InstructionDecodeException;
import ghidra.pcode.error.LowlevelError;
import ghidra.pcode.exec.AbstractBytesPcodeExecutorStatePiece;
import ghidra.pcode.exec.AbstractLongOffsetPcodeExecutorStatePiece;
import ghidra.pcode.exec.AccessPcodeExecutionException;
import ghidra.pcode.exec.AnnotatedPcodeUseropLibrary;
import ghidra.pcode.exec.BytesPcodeExecutorState;
import ghidra.pcode.exec.BytesPcodeExecutorStateSpace;
import ghidra.pcode.exec.InterruptPcodeExecutionException;
import ghidra.pcode.exec.PcodeExecutorState;
import ghidra.pcode.exec.PcodeExecutorStatePiece;
import ghidra.pcode.exec.PcodeFrame;
import ghidra.pcode.exec.PcodeUseropLibrary;
import ghidra.pcode.memstate.MemoryFaultHandler;
import ghidra.pcode.memstate.MemoryState;
import ghidra.pcode.pcoderaw.PcodeOpRaw;
import ghidra.pcode.utils.Utils;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.lang.Language;
import ghidra.program.model.lang.Register;
import ghidra.program.model.lang.RegisterValue;
import ghidra.program.model.pcode.PcodeOp;
import ghidra.util.Msg;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;

@Transitional
public class AdaptedEmulator
implements Emulator {
    private final Language language;
    private final Register pcReg;
    private final AdaptedPcodeEmulator emu;
    private final AdaptedPcodeThread thread;
    private final MemoryState adaptedMemState;
    private final AdaptedBreakTableCallback adaptedBreakTable;
    private boolean isExecuting = false;
    private RuntimeException lastError;

    public AdaptedEmulator(EmulatorConfiguration config) {
        this.language = config.getLanguage();
        this.pcReg = this.language.getProgramCounter();
        if (config.isWriteBackEnabled()) {
            throw new IllegalArgumentException("write-back is not supported");
        }
        this.emu = this.newPcodeEmulator(config);
        this.thread = this.emu.newThread();
        this.initializeRegisters(config);
        this.adaptedMemState = new AdaptedMemoryState(this.thread.getState(), PcodeExecutorStatePiece.Reason.INSPECT);
        this.adaptedBreakTable = new AdaptedBreakTableCallback();
    }

    protected AdaptedPcodeEmulator newPcodeEmulator(EmulatorConfiguration config) {
        return new AdaptedPcodeEmulator(this.language, config.getLoadData().getMemoryLoadImage(), config.getMemoryFaultHandler());
    }

    protected void initializeRegisters(EmulatorConfiguration config) {
        RegisterState initRegs = config.getLoadData().getInitialRegisterState();
        ThreadPcodeExecutorState<byte[]> regState = this.thread.getState();
        for (String key : initRegs.getKeys()) {
            if (!initRegs.isInitialized(key).get(0).booleanValue()) continue;
            Register register = this.language.getRegister(key);
            if (register == null) {
                Msg.warn((Object)this, (Object)("No such register '" + key + "' in language " + this.language));
                continue;
            }
            byte[] val = initRegs.getVals(key).get(0);
            regState.setVar(register, val);
        }
    }

    @Override
    public String getPCRegisterName() {
        return this.pcReg.getName();
    }

    @Override
    public void setExecuteAddress(long addressableWordOffset) {
        Address address = this.language.getDefaultSpace().getTruncatedAddress(addressableWordOffset, true);
        this.thread.overrideCounter(address);
    }

    @Override
    public Address getExecuteAddress() {
        return this.thread.getCounter();
    }

    @Override
    public Address getLastExecuteAddress() {
        return this.thread.lastExecuteAddress;
    }

    @Override
    public long getPC() {
        return Utils.bytesToLong((byte[])((byte[])this.thread.getState().getVar(this.pcReg, PcodeExecutorStatePiece.Reason.INSPECT)), (int)this.pcReg.getNumBytes(), (boolean)this.language.isBigEndian());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void executeInstruction(boolean stopAtBreakpoint, TaskMonitor monitor) throws CancelledException, LowlevelError, InstructionDecodeException {
        if (this.lastError != null && !(this.lastError instanceof InterruptPcodeExecutionException)) {
            throw this.lastError;
        }
        try {
            this.emu.setSoftwareInterruptMode(stopAtBreakpoint ? PcodeMachine.SwiMode.ACTIVE : PcodeMachine.SwiMode.IGNORE_ALL);
            this.isExecuting = true;
            if (this.thread.getFrame() != null) {
                this.thread.finishInstruction();
            } else {
                this.thread.stepInstruction();
            }
            this.lastError = null;
        }
        catch (RuntimeException e) {
            this.lastError = e;
        }
        finally {
            this.emu.setSoftwareInterruptMode(PcodeMachine.SwiMode.ACTIVE);
            this.isExecuting = false;
        }
    }

    @Override
    public boolean isExecuting() {
        return this.isExecuting;
    }

    @Override
    public EmulateExecutionState getEmulateExecutionState() {
        if (this.lastError instanceof InterruptPcodeExecutionException) {
            return EmulateExecutionState.BREAKPOINT;
        }
        if (this.lastError != null) {
            return EmulateExecutionState.FAULT;
        }
        PcodeFrame frame = this.thread.getFrame();
        if (frame != null) {
            return EmulateExecutionState.EXECUTE;
        }
        if (this.isExecuting) {
            return EmulateExecutionState.INSTRUCTION_DECODE;
        }
        return EmulateExecutionState.STOPPED;
    }

    @Override
    public MemoryState getMemState() {
        return this.adaptedMemState;
    }

    @Override
    public void addMemoryAccessFilter(MemoryAccessFilter filter) {
        filter.addFilter(this);
    }

    @Override
    public FilteredMemoryState getFilteredMemState() {
        return new FilteredMemoryState(this.language);
    }

    @Override
    public void setContextRegisterValue(RegisterValue regValue) {
        if (regValue == null) {
            return;
        }
        this.thread.overrideContext(regValue);
    }

    @Override
    public RegisterValue getContextRegisterValue() {
        return this.thread.getContext();
    }

    @Override
    public BreakTableCallBack getBreakTable() {
        return this.adaptedBreakTable;
    }

    @Override
    public boolean isAtBreakpoint() {
        return this.lastError instanceof InterruptPcodeExecutionException;
    }

    @Override
    public void setHalt(boolean halt) {
        this.thread.setSuspended(halt);
    }

    @Override
    public boolean getHalt() {
        return this.thread.isSuspended();
    }

    @Override
    public void dispose() {
    }

    class AdaptedPcodeEmulator
    extends PcodeEmulator {
        private final MemoryLoadImage loadImage;
        private final MemoryFaultHandler faultHandler;

        public AdaptedPcodeEmulator(Language language, MemoryLoadImage loadImage, MemoryFaultHandler faultHandler) {
            super(language);
            this.loadImage = loadImage;
            this.faultHandler = faultHandler;
        }

        @Override
        protected PcodeExecutorState<byte[]> createSharedState() {
            return new AdaptedBytesPcodeExecutorState((Language)this.language, new StateBacking(this.faultHandler, this.loadImage));
        }

        @Override
        protected PcodeExecutorState<byte[]> createLocalState(PcodeThread<byte[]> thread) {
            return new AdaptedBytesPcodeExecutorState((Language)this.language, new StateBacking(this.faultHandler, null));
        }

        @Override
        protected AdaptedPcodeThread createThread(String name) {
            return new AdaptedPcodeThread(name, this);
        }

        public AdaptedPcodeThread newThread() {
            return (AdaptedPcodeThread)super.newThread();
        }

        @Override
        protected PcodeUseropLibrary<byte[]> createUseropLibrary() {
            return new AdaptedPcodeUseropLibrary();
        }
    }

    class AdaptedPcodeThread
    extends BytesPcodeThread {
        Address lastExecuteAddress;

        public AdaptedPcodeThread(String name, AbstractPcodeMachine<byte[]> machine) {
            super(name, machine);
        }

        @Override
        protected void preExecuteInstruction() {
            super.preExecuteInstruction();
            this.lastExecuteAddress = this.getCounter();
        }

        @Override
        protected boolean onMissingUseropDef(PcodeOp op, String opName) {
            if (super.onMissingUseropDef(op, opName)) {
                return true;
            }
            return AdaptedEmulator.this.adaptedBreakTable.doPcodeOpBreak(new PcodeOpRaw(op));
        }
    }

    class AdaptedBreakTableCallback
    extends BreakTableCallBack {
        public AdaptedBreakTableCallback() {
            super((SleighLanguage)AdaptedEmulator.this.language);
        }

        @Override
        public void registerAddressCallback(Address addr, BreakCallBack func) {
            super.registerAddressCallback(addr, func);
            AdaptedEmulator.this.emu.inject(addr, "__addr_cb();\nemu_exec_decoded();\n");
        }

        @Override
        public void unregisterAddressCallback(Address addr) {
            AdaptedEmulator.this.emu.clearInject(addr);
            super.unregisterAddressCallback(addr);
        }
    }

    static class AdaptedBytesPcodeExecutorStateSpace
    extends BytesPcodeExecutorStateSpace<StateBacking> {
        public AdaptedBytesPcodeExecutorStateSpace(Language language, AddressSpace space, StateBacking backing) {
            super(language, space, backing);
        }

        @Override
        protected ULongSpan.ULongSpanSet readUninitializedFromBacking(ULongSpan.ULongSpanSet uninitialized) {
            if (uninitialized.isEmpty()) {
                return uninitialized;
            }
            if (((StateBacking)this.backing).loadImage == null) {
                if (this.space.isUniqueSpace()) {
                    throw new AccessPcodeExecutionException("Attempted to read from uninitialized unique: " + uninitialized);
                }
                return uninitialized;
            }
            ULongSpan bound = (ULongSpan)uninitialized.bound();
            byte[] data = new byte[(int)bound.length()];
            ((StateBacking)this.backing).loadImage.loadFill(data, data.length, this.space.getAddress(((Long)bound.min()).longValue()), 0, false);
            for (ULongSpan span : uninitialized.spans()) {
                this.bytes.putData((Long)span.min(), data, (int)((Long)span.min() - (Long)bound.min()), (int)span.length());
            }
            return this.bytes.getUninitialized((Long)bound.min(), (Long)bound.max());
        }

        @Override
        protected void warnUninit(ULongSpan.ULongSpanSet uninit) {
            ULongSpan bound = (ULongSpan)uninit.bound();
            byte[] data = new byte[(int)bound.length()];
            if (((StateBacking)this.backing).faultHandler.uninitializedRead(this.space.getAddress(((Long)bound.min()).longValue()), data.length, data, 0)) {
                for (ULongSpan span : uninit.spans()) {
                    this.bytes.putData((Long)span.min(), data, (int)((Long)span.min() - (Long)bound.min()), (int)span.length());
                }
            }
        }
    }

    static class AdaptedBytesPcodeExecutorStatePiece
    extends AbstractBytesPcodeExecutorStatePiece<AdaptedBytesPcodeExecutorStateSpace> {
        private final StateBacking backing;

        public AdaptedBytesPcodeExecutorStatePiece(Language language, StateBacking backing) {
            super(language);
            this.backing = backing;
        }

        @Override
        protected AbstractLongOffsetPcodeExecutorStatePiece.AbstractSpaceMap<AdaptedBytesPcodeExecutorStateSpace> newSpaceMap() {
            return new AbstractLongOffsetPcodeExecutorStatePiece.SimpleSpaceMap<AdaptedBytesPcodeExecutorStateSpace>(){

                @Override
                protected AdaptedBytesPcodeExecutorStateSpace newSpace(AddressSpace space) {
                    return new AdaptedBytesPcodeExecutorStateSpace(language, space, backing);
                }
            };
        }
    }

    static class AdaptedBytesPcodeExecutorState
    extends BytesPcodeExecutorState {
        public AdaptedBytesPcodeExecutorState(Language language, StateBacking backing) {
            super(new AdaptedBytesPcodeExecutorStatePiece(language, backing));
        }
    }

    record StateBacking(MemoryFaultHandler faultHandler, MemoryLoadImage loadImage) {
    }

    @Transitional
    public class AdaptedPcodeUseropLibrary
    extends AnnotatedPcodeUseropLibrary<byte[]> {
        @AnnotatedPcodeUseropLibrary.PcodeUserop
        public void __addr_cb() {
            AdaptedEmulator.this.adaptedBreakTable.doAddressBreak(AdaptedEmulator.this.thread.getCounter());
            if (AdaptedEmulator.this.thread.isSuspended()) {
                throw new InterruptPcodeExecutionException(null, null);
            }
        }
    }
}

