/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.services;

import ghidra.app.plugin.core.debug.DebuggerCoordinates;
import ghidra.app.plugin.core.debug.service.control.DebuggerControlServicePlugin;
import ghidra.app.services.ControlMode;
import ghidra.framework.plugintool.ServiceInfo;
import ghidra.pcode.utils.Utils;
import ghidra.program.model.address.Address;
import ghidra.program.model.lang.Register;
import ghidra.program.model.lang.RegisterValue;
import ghidra.program.model.mem.LiveMemoryHandler;
import ghidra.trace.model.Trace;
import ghidra.trace.model.program.TraceProgramView;
import java.math.BigInteger;
import java.util.concurrent.CompletableFuture;

@ServiceInfo(defaultProvider={DebuggerControlServicePlugin.class}, description="Centralized service for modifying machine states")
public interface DebuggerControlService {
    public ControlMode getCurrentMode(Trace var1);

    public void setCurrentMode(Trace var1, ControlMode var2);

    public void addModeChangeListener(ControlModeChangeListener var1);

    public void removeModeChangeListener(ControlModeChangeListener var1);

    public StateEditor createStateEditor(DebuggerCoordinates var1);

    public StateEditor createStateEditor(Trace var1);

    public StateEditingMemoryHandler createStateEditor(TraceProgramView var1);

    public static interface ControlModeChangeListener {
        public void modeChanged(Trace var1, ControlMode var2);
    }

    public static interface StateEditingMemoryHandler
    extends StateEditor,
    LiveMemoryHandler {
    }

    public static interface StateEditor {
        public DebuggerControlService getService();

        public DebuggerCoordinates getCoordinates();

        public boolean isVariableEditable(Address var1, int var2);

        default public boolean isRegisterEditable(Register register) {
            return this.isVariableEditable(register.getAddress(), register.getNumBytes());
        }

        public CompletableFuture<Void> setVariable(Address var1, byte[] var2);

        default public CompletableFuture<Void> setRegister(RegisterValue value) {
            Register register = value.getRegister();
            byte[] bytes = Utils.bigIntegerToBytes((BigInteger)value.getUnsignedValue(), (int)register.getNumBytes(), (boolean)register.isBigEndian());
            return this.setVariable(register.getAddress(), bytes);
        }
    }
}

