/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.service.model;

import ghidra.app.plugin.core.debug.event.ModelActivatedPluginEvent;
import ghidra.app.plugin.core.debug.event.ModelObjectFocusedPluginEvent;
import ghidra.app.plugin.core.debug.event.TraceRecorderAdvancedPluginEvent;
import ghidra.app.plugin.core.debug.mapping.DebuggerTargetTraceMapper;
import ghidra.app.services.DebuggerModelService;
import ghidra.app.services.DebuggerTraceManagerService;
import ghidra.app.services.TraceRecorder;
import ghidra.dbg.DebuggerModelFactory;
import ghidra.dbg.DebuggerObjectModel;
import ghidra.dbg.target.TargetObject;
import ghidra.framework.plugintool.PluginEvent;
import ghidra.lifecycle.Internal;
import ghidra.util.Swing;
import java.io.IOException;
import java.util.Collection;

@Internal
public interface DebuggerModelServiceInternal
extends DebuggerModelService {
    public void setModelFactories(Collection<DebuggerModelFactory> var1);

    public void refreshFactoryInstances();

    public TraceRecorder recordTargetAndActivateTrace(TargetObject var1, DebuggerTargetTraceMapper var2, DebuggerTraceManagerService var3) throws IOException;

    public boolean doActivateModel(DebuggerObjectModel var1);

    default public void fireModelActivatedEvent(DebuggerObjectModel model) {
        this.firePluginEvent(new ModelActivatedPluginEvent(this.getName(), model));
    }

    default public void fireFocusEvent(TargetObject focused) {
        Swing.runIfSwingOrRunLater(() -> this.firePluginEvent(new ModelObjectFocusedPluginEvent(this.getName(), focused)));
    }

    default public void fireSnapEvent(TraceRecorder recorder, long snap) {
        Swing.runIfSwingOrRunLater(() -> this.firePluginEvent(new TraceRecorderAdvancedPluginEvent(this.getName(), recorder, snap)));
    }

    public String getName();

    public void firePluginEvent(PluginEvent var1);

    @Override
    default public void activateModel(DebuggerObjectModel model) {
        if (this.doActivateModel(model)) {
            this.fireModelActivatedEvent(model);
        }
    }
}

