/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.mapping;

import db.Transaction;
import ghidra.app.plugin.core.debug.mapping.DebuggerMemoryMapper;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressFactory;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressSpace;
import ghidra.trace.model.Trace;
import ghidra.util.exception.DuplicateNameException;
import java.util.HashMap;
import java.util.Map;

public class ObjectBasedDebuggerMemoryMapper
implements DebuggerMemoryMapper {
    protected final Trace trace;
    protected final AddressSpace base;
    protected final Map<Integer, AddressSpace> targetToTraceSpaces = new HashMap<Integer, AddressSpace>();
    protected final Map<Integer, AddressSpace> traceToTargetSpaces = new HashMap<Integer, AddressSpace>();

    public ObjectBasedDebuggerMemoryMapper(Trace trace) {
        this.trace = trace;
        this.base = trace.getBaseAddressFactory().getDefaultAddressSpace();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Address traceToTarget(Address traceAddr) {
        AddressSpace targetSpace;
        AddressSpace traceSpace = traceAddr.getAddressSpace();
        int traceIdHash = System.identityHashCode(traceSpace);
        Map<Integer, AddressSpace> map = this.traceToTargetSpaces;
        synchronized (map) {
            targetSpace = this.traceToTargetSpaces.get(traceIdHash);
        }
        if (targetSpace == null) {
            return null;
        }
        return targetSpace.getAddress(traceAddr.getOffset());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Address targetToTrace(Address targetAddr) {
        AddressSpace traceSpace;
        AddressSpace targetSpace = targetAddr.getAddressSpace();
        int targetIdHash = System.identityHashCode(targetSpace);
        Map<Integer, AddressSpace> map = this.traceToTargetSpaces;
        synchronized (map) {
            traceSpace = this.targetToTraceSpaces.get(targetIdHash);
            if (traceSpace == null) {
                traceSpace = this.createSpace(targetSpace.getName());
                this.targetToTraceSpaces.put(targetIdHash, traceSpace);
                this.traceToTargetSpaces.put(System.identityHashCode(traceSpace), targetSpace);
            }
        }
        return traceSpace.getAddress(targetAddr.getOffset());
    }

    @Override
    public AddressRange targetToTraceTruncated(AddressRange targetRange) {
        return this.targetToTrace(targetRange);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected AddressSpace createSpace(String name) {
        try (Transaction tx = this.trace.openTransaction("Create space for mapping");){
            AddressFactory factory = this.trace.getBaseAddressFactory();
            AddressSpace space = factory.getAddressSpace(name);
            if (space == null) {
                AddressSpace addressSpace = this.trace.getMemoryManager().createOverlayAddressSpace(name, this.base);
                return addressSpace;
            }
            if (space == this.base || space.isOverlaySpace()) {
                AddressSpace addressSpace = space;
                return addressSpace;
            }
            AddressSpace addressSpace = this.trace.getMemoryManager().createOverlayAddressSpace("_" + name, this.base);
            return addressSpace;
        }
        catch (DuplicateNameException e) {
            throw new AssertionError((Object)e);
        }
    }
}

