/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.gui.objects.components;

import docking.ActionContext;
import docking.ReusableDialogComponentProvider;
import docking.action.DockingActionIf;
import docking.action.ToolBarData;
import docking.widgets.table.DefaultEnumeratedColumnTableModel;
import docking.widgets.table.GTable;
import docking.widgets.table.RowObjectTableModel;
import ghidra.app.plugin.core.debug.gui.DebuggerResources;
import ghidra.app.plugin.core.debug.gui.objects.DebuggerObjectsPlugin;
import ghidra.app.plugin.core.debug.gui.objects.DebuggerObjectsProvider;
import ghidra.app.plugin.core.debug.gui.objects.components.AttachableProcessesTableColumns;
import ghidra.async.AsyncUtils;
import ghidra.async.TypeSpec;
import ghidra.async.seq.AsyncSequenceHandlerForProducer;
import ghidra.dbg.target.TargetAttachable;
import ghidra.dbg.target.TargetAttacher;
import ghidra.dbg.target.TargetObject;
import ghidra.util.MessageType;
import ghidra.util.Msg;
import ghidra.util.table.GhidraTableFilterPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;

public class DebuggerAttachDialog
extends ReusableDialogComponentProvider {
    private final DebuggerObjectsPlugin plugin;
    private final DebuggerObjectsProvider provider;
    protected RefreshAction actionRefresh;
    protected JButton attachButton;
    private final RowObjectTableModel<TargetAttachable> processes;
    protected TargetAttacher attacher;
    private GTable processTable;

    public DebuggerAttachDialog(DebuggerObjectsProvider provider) {
        super("Attach", true, true, true, false);
        this.provider = provider;
        this.plugin = provider.getPlugin();
        this.processes = new DefaultEnumeratedColumnTableModel(this.plugin.getTool(), "Attachables", AttachableProcessesTableColumns.class);
        this.populateComponents();
        this.createActions();
    }

    protected void populateComponents() {
        JPanel panel = new JPanel(new BorderLayout());
        this.processTable = new GTable(this.processes);
        this.processTable.setSelectionMode(0);
        panel.add(new JScrollPane((Component)this.processTable));
        this.processTable.setAutoLookupColumn(AttachableProcessesTableColumns.NAME.ordinal());
        GhidraTableFilterPanel filterPanel = new GhidraTableFilterPanel((JTable)this.processTable, this.processes);
        panel.add((Component)filterPanel, "South");
        this.addWorkPanel(panel);
        this.processTable.getColumn((Object)AttachableProcessesTableColumns.ID.getHeader()).setPreferredWidth(8);
        this.processTable.getColumn((Object)AttachableProcessesTableColumns.NAME.getHeader()).setPreferredWidth(16);
        this.attachButton = new JButton();
        DebuggerResources.AbstractAttachAction.styleButton(this.attachButton);
        this.attachButton.setToolTipText("Attach to the selected target");
        this.attachButton.addActionListener(e -> this.attach());
        DebuggerResources.tableRowActivationAction(this.processTable, () -> this.attach());
        this.addButton(this.attachButton);
        this.addCancelButton();
    }

    protected void createActions() {
        this.actionRefresh = new RefreshAction();
    }

    protected void attach() {
        TargetAttachable proc = (TargetAttachable)this.processes.getRowObject(this.processTable.getSelectedRow());
        if (proc == null) {
            return;
        }
        this.setStatusText("Attaching");
        ((CompletableFuture)this.attacher.attach(proc).thenAccept(__ -> this.close())).exceptionally(e -> {
            Msg.showError((Object)((Object)this), (Component)this.getComponent(), (String)"Could not attach", (Object)e);
            this.setStatusText("Could not attach: " + e.getMessage(), MessageType.ERROR);
            return null;
        });
    }

    public void fetchAndDisplayAttachable() {
        AtomicReference available = new AtomicReference();
        AtomicReference procs = new AtomicReference();
        AsyncUtils.sequence((TypeSpec)TypeSpec.VOID).then(seq -> {
            this.setStatusText("Fetching process list");
            this.provider.getModel().fetchModelObject(List.of("Available")).handle((arg_0, arg_1) -> ((AsyncSequenceHandlerForProducer)seq).next(arg_0, arg_1));
        }, available).then(seq -> ((TargetObject)available.get()).fetchElements().handle((arg_0, arg_1) -> ((AsyncSequenceHandlerForProducer)seq).next(arg_0, arg_1)), procs).then(seq -> {
            List modelData = this.processes.getModelData();
            modelData.clear();
            for (Object p : ((Map)procs.get()).values()) {
                if (!(p instanceof TargetAttachable)) continue;
                modelData.add((TargetAttachable)p);
            }
            this.processes.fireTableDataChanged();
            this.setStatusText("");
            seq.exit();
        }).finish().exceptionally(e -> {
            Msg.showError((Object)((Object)this), (Component)this.getComponent(), (String)"Could not fetch process list", (Object)e);
            this.setStatusText("Could not fetch process list: " + e.getMessage(), MessageType.ERROR);
            return null;
        });
    }

    public void setAttacher(TargetAttacher attacher) {
        this.attacher = attacher;
    }

    protected class RefreshAction
    extends DebuggerResources.AbstractRefreshAction {
        public static final String GROUP = "Dbg1. General";

        public RefreshAction() {
            super(DebuggerAttachDialog.this.plugin);
            this.setToolBarData(new ToolBarData(ICON, GROUP));
            DebuggerAttachDialog.this.addAction((DockingActionIf)this);
            this.setEnabled(true);
        }

        public void actionPerformed(ActionContext context) {
            DebuggerAttachDialog.this.fetchAndDisplayAttachable();
        }
    }
}

