/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.gui.objects;

import docking.ActionContext;
import docking.ComponentProvider;
import docking.DialogComponentProvider;
import docking.WindowPosition;
import docking.action.DockingAction;
import docking.action.DockingActionIf;
import docking.action.MenuData;
import docking.action.ToggleDockingAction;
import docking.action.builder.ActionBuilder;
import docking.action.builder.ToggleActionBuilder;
import docking.widgets.OptionDialog;
import docking.widgets.table.AbstractSortedTableModel;
import docking.widgets.table.DefaultEnumeratedColumnTableModel;
import docking.widgets.tree.GTree;
import generic.jar.ResourceFile;
import generic.theme.GColor;
import ghidra.app.plugin.core.debug.DebuggerCoordinates;
import ghidra.app.plugin.core.debug.gui.DebuggerResources;
import ghidra.app.plugin.core.debug.gui.objects.DebuggerObjectsPlugin;
import ghidra.app.plugin.core.debug.gui.objects.ObjectContainer;
import ghidra.app.plugin.core.debug.gui.objects.ObjectContainerListener;
import ghidra.app.plugin.core.debug.gui.objects.actions.DisplayAsGraphAction;
import ghidra.app.plugin.core.debug.gui.objects.actions.DisplayAsTableAction;
import ghidra.app.plugin.core.debug.gui.objects.actions.DisplayAsTreeAction;
import ghidra.app.plugin.core.debug.gui.objects.actions.DisplayAsXMLAction;
import ghidra.app.plugin.core.debug.gui.objects.actions.DisplayFilteredGraphAction;
import ghidra.app.plugin.core.debug.gui.objects.actions.DisplayFilteredTableAction;
import ghidra.app.plugin.core.debug.gui.objects.actions.DisplayFilteredTreeAction;
import ghidra.app.plugin.core.debug.gui.objects.actions.DisplayFilteredXMLAction;
import ghidra.app.plugin.core.debug.gui.objects.actions.DisplayMethodsAction;
import ghidra.app.plugin.core.debug.gui.objects.actions.ExportAsFactsAction;
import ghidra.app.plugin.core.debug.gui.objects.actions.ExportAsXMLAction;
import ghidra.app.plugin.core.debug.gui.objects.actions.ImportFromFactsAction;
import ghidra.app.plugin.core.debug.gui.objects.actions.ImportFromXMLAction;
import ghidra.app.plugin.core.debug.gui.objects.actions.OpenWinDbgTraceAction;
import ghidra.app.plugin.core.debug.gui.objects.actions.SetTimeoutAction;
import ghidra.app.plugin.core.debug.gui.objects.components.DebuggerAttachDialog;
import ghidra.app.plugin.core.debug.gui.objects.components.DebuggerBreakpointDialog;
import ghidra.app.plugin.core.debug.gui.objects.components.DebuggerMethodInvocationDialog;
import ghidra.app.plugin.core.debug.gui.objects.components.DummyTargetObject;
import ghidra.app.plugin.core.debug.gui.objects.components.GenericDebuggerProgramLaunchOffer;
import ghidra.app.plugin.core.debug.gui.objects.components.ObjectAttributeColumn;
import ghidra.app.plugin.core.debug.gui.objects.components.ObjectAttributeRow;
import ghidra.app.plugin.core.debug.gui.objects.components.ObjectElementColumn;
import ghidra.app.plugin.core.debug.gui.objects.components.ObjectElementRow;
import ghidra.app.plugin.core.debug.gui.objects.components.ObjectEnumeratedColumnTableModel;
import ghidra.app.plugin.core.debug.gui.objects.components.ObjectNode;
import ghidra.app.plugin.core.debug.gui.objects.components.ObjectPane;
import ghidra.app.plugin.core.debug.gui.objects.components.ObjectTable;
import ghidra.app.plugin.core.debug.gui.objects.components.ObjectTree;
import ghidra.app.plugin.core.debug.mapping.DebuggerMemoryMapper;
import ghidra.app.script.GhidraScript;
import ghidra.app.script.GhidraScriptLoadException;
import ghidra.app.script.GhidraScriptProvider;
import ghidra.app.script.GhidraScriptUtil;
import ghidra.app.script.GhidraState;
import ghidra.app.services.ConsoleService;
import ghidra.app.services.DebuggerListingService;
import ghidra.app.services.DebuggerModelService;
import ghidra.app.services.DebuggerStaticMappingService;
import ghidra.app.services.DebuggerTraceManagerService;
import ghidra.app.services.GraphDisplayBroker;
import ghidra.app.services.TraceRecorder;
import ghidra.async.AsyncFence;
import ghidra.async.AsyncUtils;
import ghidra.async.TypeSpec;
import ghidra.async.loop.AsyncLoopHandlerForSecond;
import ghidra.async.seq.AsyncSequenceHandlerForProducer;
import ghidra.dbg.AnnotatedDebuggerAttributeListener;
import ghidra.dbg.DebugModelConventions;
import ghidra.dbg.DebuggerModelListener;
import ghidra.dbg.DebuggerObjectModel;
import ghidra.dbg.error.DebuggerMemoryAccessException;
import ghidra.dbg.target.TargetAccessConditioned;
import ghidra.dbg.target.TargetAttachable;
import ghidra.dbg.target.TargetAttacher;
import ghidra.dbg.target.TargetBreakpointSpecContainer;
import ghidra.dbg.target.TargetConfigurable;
import ghidra.dbg.target.TargetConsole;
import ghidra.dbg.target.TargetDetachable;
import ghidra.dbg.target.TargetExecutionStateful;
import ghidra.dbg.target.TargetInterpreter;
import ghidra.dbg.target.TargetInterruptible;
import ghidra.dbg.target.TargetKillable;
import ghidra.dbg.target.TargetLauncher;
import ghidra.dbg.target.TargetMethod;
import ghidra.dbg.target.TargetObject;
import ghidra.dbg.target.TargetProcess;
import ghidra.dbg.target.TargetResumable;
import ghidra.dbg.target.TargetSteppable;
import ghidra.dbg.target.TargetTogglable;
import ghidra.dbg.util.DebuggerCallbackReorderer;
import ghidra.dbg.util.PathUtils;
import ghidra.framework.model.Project;
import ghidra.framework.options.AutoOptions;
import ghidra.framework.options.SaveState;
import ghidra.framework.options.annotation.AutoOptionDefined;
import ghidra.framework.plugintool.AutoConfigState;
import ghidra.framework.plugintool.AutoService;
import ghidra.framework.plugintool.ComponentProviderAdapter;
import ghidra.framework.plugintool.Plugin;
import ghidra.framework.plugintool.annotation.AutoConfigStateField;
import ghidra.framework.plugintool.annotation.AutoServiceConsumed;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.listing.Program;
import ghidra.program.util.ProgramLocation;
import ghidra.program.util.ProgramSelection;
import ghidra.trace.model.Trace;
import ghidra.trace.model.thread.TraceThread;
import ghidra.util.HelpLocation;
import ghidra.util.Msg;
import ghidra.util.Swing;
import ghidra.util.datastruct.PrivatelyQueuedListener;
import ghidra.util.table.GhidraTable;
import ghidra.util.task.TaskMonitor;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.io.PrintWriter;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.tree.TreePath;
import org.apache.commons.collections4.map.LinkedMap;
import org.apache.commons.lang3.StringUtils;

public class DebuggerObjectsProvider
extends ComponentProviderAdapter
implements ObjectContainerListener {
    public static final String PATH_JOIN_CHAR = ".";
    public static final Color COLOR_FOREGROUND = new GColor("color.fg.debugger.plugin.objects.default");
    public static final Color COLOR_BACKGROUND = new GColor("color.bg.debugger.plugin.objects.default");
    public static final Color COLOR_FOREGROUND_INVISIBLE = new GColor("color.fg.debugger.plugin.objects.invisible");
    public static final Color COLOR_FOREGROUND_INVALIDATED = new GColor("color.fg.debugger.plugin.objects.invalidated");
    public static final Color COLOR_FOREGROUND_MODIFIED = new GColor("color.fg.debugger.plugin.objects.modified");
    public static final Color COLOR_FOREGROUND_SUBSCRIBED = new GColor("color.fg.debugger.plugin.objects.subscribed");
    public static final Color COLOR_FOREGROUND_ERROR = new GColor("color.fg.debugger.plugin.objects.error");
    public static final Color COLOR_FOREGROUND_INTRINSIC = new GColor("color.fg.debugger.plugin.objects.intrinsic");
    public static final Color COLOR_FOREGROUND_TARGET = new GColor("color.fg.debugger.plugin.objects.target");
    public static final Color COLOR_FOREGROUND_ACCESSOR = new GColor("color.fg.debugger.plugin.objects.accessor");
    public static final Color COLOR_FOREGROUND_LINK = new GColor("color.fg.debugger.plugin.objects.link");
    private static final AutoConfigState.ClassHandler<DebuggerObjectsProvider> CONFIG_STATE_HANDLER = AutoConfigState.wireHandler(DebuggerObjectsProvider.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final DebuggerObjectsPlugin plugin;
    @AutoServiceConsumed
    public DebuggerModelService modelService;
    @AutoServiceConsumed
    private DebuggerTraceManagerService traceManager;
    @AutoServiceConsumed
    private DebuggerStaticMappingService mappingService;
    @AutoServiceConsumed
    private DebuggerListingService listingService;
    @AutoServiceConsumed
    private GraphDisplayBroker graphBroker;
    @AutoServiceConsumed
    private ConsoleService consoleService;
    private final AutoService.Wiring autoServiceWiring;
    @AutoOptionDefined(name={"Default Extended Step"}, description="The default string for the extended step command")
    String extendedStep = "";
    private final AutoOptions.Wiring autoOptionsWiring;
    private JPanel mainPanel;
    private ObjectPane pane;
    protected ObjectContainer root;
    private Map<String, ObjectContainer> targetMap;
    private Set<TargetObject> refSet;
    public Program currentProgram;
    protected Map<Long, Trace> traces = new HashMap<Long, Trace>();
    protected Trace currentTrace;
    protected DebuggerObjectModel currentModel;
    private TargetObject targetFocus;
    protected Runnable repeatLastSet = () -> {};
    private boolean asTree = true;
    private MyObjectListener listener = new MyObjectListener();
    public DebuggerMethodInvocationDialog configDialog;
    public DebuggerMethodInvocationDialog methodDialog;
    public DebuggerAttachDialog attachDialog;
    public DebuggerBreakpointDialog breakpointDialog;
    private GenericDebuggerProgramLaunchOffer launchOffer;
    DockingAction actionLaunch;
    DockingAction actionAddBreakpoint;
    DisplayAsTreeAction displayAsTreeAction;
    DisplayAsTableAction displayAsTableAction;
    DisplayAsGraphAction displayAsGraphAction;
    DisplayAsXMLAction displayAsXMLAction;
    DisplayFilteredTreeAction displayFilteredTreeAction;
    DisplayFilteredTableAction displayFilteredTableAction;
    DisplayFilteredGraphAction displayFilteredGraphAction;
    DisplayFilteredXMLAction displayFilteredXMLAction;
    DisplayMethodsAction displayMethodsAction;
    ExportAsXMLAction exportAsXMLAction;
    ExportAsFactsAction exportAsFactsAction;
    ImportFromXMLAction importFromXMLAction;
    ImportFromFactsAction importFromFactsAction;
    OpenWinDbgTraceAction openTraceAction;
    SetTimeoutAction setTimeoutAction;
    private ToggleDockingAction actionToggleBase;
    private ToggleDockingAction actionToggleSubscribe;
    private ToggleDockingAction actionToggleAutoRecord;
    private ToggleDockingAction actionToggleHideIntrinsics;
    private ToggleDockingAction actionToggleSelectionOnly;
    private ToggleDockingAction actionToggleIgnoreState;
    private ToggleDockingAction actionToggleUpdateWhileRunning;
    private ToggleDockingAction actionSuppressDescent;
    @AutoConfigStateField
    private boolean autoRecord = true;
    @AutoConfigStateField
    private boolean hideIntrinsics = true;
    @AutoConfigStateField
    private boolean selectionOnly = false;
    @AutoConfigStateField
    private boolean ignoreState = false;
    @AutoConfigStateField
    private boolean updateWhileRunning = true;
    @AutoConfigStateField
    private boolean suppressDescent = false;
    @AutoConfigStateField
    private int nodeTimeout = 60;
    Set<TargetConfigurable> configurables = new HashSet<TargetConfigurable>();
    private String lastMethod = "";
    Map<String, GhidraScript> scripts = new HashMap<String, GhidraScript>();
    Map<String, String> scriptNames = new HashMap<String, String>();

    public DebuggerObjectsProvider(DebuggerObjectsPlugin plugin, DebuggerObjectModel model, ObjectContainer container, boolean asTree) throws Exception {
        super(plugin.getTool(), container.getPrefixedName(), plugin.getName());
        this.plugin = plugin;
        this.currentProgram = plugin.getActiveProgram();
        plugin.addProvider(this);
        this.currentModel = model;
        this.launchOffer = new GenericDebuggerProgramLaunchOffer(this.currentProgram, this.tool, this.currentModel);
        this.root = container;
        this.asTree = asTree;
        this.setIcon(asTree ? ObjectTree.ICON_TREE : ObjectTable.ICON_TABLE);
        this.targetMap = new LinkedMap();
        this.refSet = new HashSet<TargetObject>();
        this.getRoot().propagateProvider(this);
        this.autoServiceWiring = AutoService.wireServicesConsumed((Plugin)plugin, (Object)this);
        this.autoOptionsWiring = AutoOptions.wireOptions((Plugin)plugin, (Object)this);
        this.setHelpLocation(DebuggerResources.HELP_PROVIDER_OBJECTS);
        this.setDefaultWindowPosition(WindowPosition.STACK);
        this.setWindowGroup("Debugger.Core.Objects");
        this.setIntraGroupPosition(WindowPosition.STACK);
        this.setWindowMenuGroup("Debugger");
        this.buildMainPanel();
        this.setVisible(true);
        this.createActions();
        this.repeatLastSet.run();
    }

    void dispose() {
        this.configDialog.dispose();
        this.methodDialog.dispose();
        this.attachDialog.dispose();
        this.breakpointDialog.dispose();
    }

    public void addLocalAction(DockingActionIf action) {
        super.addLocalAction(action);
    }

    public ObjectActionContext getActionContext(MouseEvent event) {
        return new ObjectActionContext(this);
    }

    public TargetObject getObjectFromContext(ActionContext context) {
        return this.pane == null ? null : this.pane.getSelectedObject();
    }

    public DebuggerObjectModel getModel() {
        return this.currentModel;
    }

    public void setModel(DebuggerObjectModel model) {
        this.currentModel = model;
        this.currentModel.addModelListener(this.getListener(), true);
        this.launchOffer = new GenericDebuggerProgramLaunchOffer(this.currentProgram, this.tool, this.currentModel);
        this.refresh();
    }

    public JComponent getComponent() {
        return this.mainPanel;
    }

    private void buildMainPanel() throws Exception {
        this.mainPanel = new JPanel(new BorderLayout());
        if (this.asTree) {
            this.addTree(this.getRoot());
        } else {
            this.addTable(this.getRoot());
        }
        this.methodDialog = new DebuggerMethodInvocationDialog(this.tool, "Method", "Method", DebuggerResources.ICON_LAUNCH);
        this.attachDialog = new DebuggerAttachDialog(this);
        this.breakpointDialog = new DebuggerBreakpointDialog(this);
        this.configDialog = new DebuggerMethodInvocationDialog(this.tool, "Configuration", "Configure", DebuggerResources.ICON_CONFIG);
    }

    private void addToPanel(ObjectPane p) throws Exception {
        if (p == null) {
            throw new Exception("NULL PANE generated!");
        }
        this.pane = p;
        this.mainPanel.add(this.pane.getComponent());
    }

    JComponent getContextObject() {
        return this.pane == null ? null : this.pane.getPrincipalComponent();
    }

    public void setProgram(Program program) {
        if (program == this.currentProgram) {
            return;
        }
        this.currentProgram = program;
        this.plugin.setActiveProgram(this.currentProgram);
        this.launchOffer = new GenericDebuggerProgramLaunchOffer(this.currentProgram, this.tool, this.currentModel);
        this.contextChanged();
    }

    private boolean hasModelAndProgram() {
        return this.currentModel != null && this.currentProgram != null;
    }

    public void traceOpened(Trace trace) {
        this.repeatLastSet.run();
    }

    public void refresh() {
        if (this.pane != null && this.currentModel != null) {
            ((CompletableFuture)this.currentModel.fetchModelRoot().thenAccept(this::refresh)).exceptionally(ex -> {
                this.plugin.objectError("Error refreshing model root");
                return null;
            });
        }
    }

    public void refresh(TargetObject targetObject) {
        if (this.pane != null) {
            Swing.runIfSwingOrRunLater(() -> {
                this.pane.setRoot(this.getRoot(), targetObject);
                this.getRoot().propagateProvider(this.getRoot().getProvider());
                this.pane.signalUpdate(this.getRoot());
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh(String key) {
        if (this.pane != null) {
            if (key != null) {
                ArrayList<ObjectContainer> containers = new ArrayList<ObjectContainer>();
                for (String path : this.targetMap.keySet()) {
                    if (!path.endsWith(key)) continue;
                    Map<String, ObjectContainer> map = this.targetMap;
                    synchronized (map) {
                        ObjectContainer container = this.targetMap.get(path);
                        containers.add(container);
                    }
                }
                for (ObjectContainer container : containers) {
                    this.pane.signalUpdate(container);
                }
            } else {
                this.pane.signalUpdate(this.pane.getContainer());
            }
        }
    }

    public void modelActivated(DebuggerObjectModel model) {
        if (model != null && model.equals(this.currentModel)) {
            this.requestFocus();
            this.toFront();
            this.setSubTitle(this.currentModel.getBrief());
        }
    }

    public void traceActivated(DebuggerCoordinates coordinates) {
        if (this.currentTrace == coordinates.getTrace()) {
            return;
        }
        this.setTrace(coordinates.getTrace(), coordinates.getThread(), true);
    }

    public void setTrace(Trace trace, TraceThread thread, boolean select) {
        TargetObject target = this.modelService.getTarget(trace);
        if (!this.refSet.contains(target)) {
            return;
        }
        this.repeatLastSet = () -> this.setTrace(trace, thread, select);
        if (trace != null) {
            this.currentTrace = trace;
        }
        this.contextChanged();
    }

    public void traceClosed(Trace trace) {
        if (trace == this.currentTrace) {
            this.setTrace(null, null, true);
        }
    }

    public GraphDisplayBroker getGraphBroker() {
        return this.graphBroker;
    }

    public ConsoleService getConsoleService() {
        return this.consoleService;
    }

    public ObjectContainer getSelectedContainer(Object obj) {
        if (obj instanceof GTree) {
            Object last;
            GTree tree = (GTree)obj;
            TreePath path = tree.getSelectionPath();
            if (path != null && (last = path.getLastPathComponent()) instanceof ObjectNode) {
                return ((ObjectNode)((Object)last)).getContainer();
            }
            return this.pane.getContainer();
        }
        if (obj instanceof GhidraTable) {
            GhidraTable table = (GhidraTable)obj;
            ObjectContainer container = this.pane.getContainer();
            if (this.pane.getPrincipalComponent().equals(table)) {
                TargetObject object = this.pane.getSelectedObject();
                if (object instanceof DummyTargetObject) {
                    return container;
                }
                ObjectContainer subContainer = container.getSubContainer(object);
                if (subContainer != null) {
                    return subContainer;
                }
            }
            return container;
        }
        return null;
    }

    public TargetObject getSelectedObject() {
        TargetObject selectedObject = this.pane.getSelectedObject();
        if (selectedObject != null) {
            return selectedObject;
        }
        return null;
    }

    public void addTree(ObjectContainer container) {
        ObjectTree objTree = new ObjectTree(container);
        try {
            this.addToPanel(objTree);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        GTree tree = (GTree)objTree.getPrincipalComponent();
        tree.setRootVisible(true);
    }

    public void addTable(ObjectContainer container) {
        AtomicReference update = new AtomicReference();
        AsyncUtils.sequence((TypeSpec)TypeSpec.cls(ObjectContainer.class)).then(seq -> container.getOffspring().handle((arg_0, arg_1) -> ((AsyncSequenceHandlerForProducer)seq).next(arg_0, arg_1)), update).then(seq -> {
            try {
                ObjectContainer oc = (ObjectContainer)update.get();
                if (oc.hasElements()) {
                    this.addToPanel(this.buildTableFromElements(oc));
                } else {
                    this.addToPanel(this.buildTableFromAttributes(oc));
                }
                seq.exit();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }).finish().completeExceptionally(new RuntimeException("Unable to add table"));
    }

    private ObjectTable<ObjectAttributeRow> buildTableFromAttributes(ObjectContainer container) {
        TargetObject targetObject = container.getTargetObject();
        String name = targetObject.getName();
        DefaultEnumeratedColumnTableModel model = new DefaultEnumeratedColumnTableModel(this.tool, name, ObjectAttributeColumn.class);
        Map<String, Object> map = container.getAttributeMap();
        ArrayList<ObjectAttributeRow> list = new ArrayList<ObjectAttributeRow>();
        for (Object val : map.values()) {
            if (!(val instanceof TargetObject)) continue;
            TargetObject ref = (TargetObject)val;
            list.add(new ObjectAttributeRow(ref, container.getProvider()));
        }
        model.addAll(list);
        return new ObjectTable<ObjectAttributeRow>(container, ObjectAttributeRow.class, (AbstractSortedTableModel<ObjectAttributeRow>)model);
    }

    private ObjectTable<ObjectElementRow> buildTableFromElements(ObjectContainer container) {
        TargetObject targetObject = container.getTargetObject();
        String name = targetObject.getName();
        Map<String, TargetObject> map = container.getElementMap();
        ArrayList<ObjectElementRow> list = new ArrayList<ObjectElementRow>();
        for (TargetObject obj : map.values()) {
            if (!(obj instanceof TargetObject)) continue;
            TargetObject ref = obj;
            list.add(new ObjectElementRow(ref, container.getProvider()));
        }
        ObjectEnumeratedColumnTableModel.ObjectsEnumeratedTableColumn[] cols = new ObjectElementColumn[]{new ObjectElementColumn("Accessor", ObjectElementRow::getValue)};
        ObjectEnumeratedColumnTableModel model = new ObjectEnumeratedColumnTableModel(name, cols);
        model.addAll(list);
        ObjectTable<ObjectElementRow> table = new ObjectTable<ObjectElementRow>(container, ObjectElementRow.class, model);
        for (TargetObject obj : map.values()) {
            if (!(obj instanceof TargetObject)) continue;
            TargetObject ref = obj;
            ((CompletableFuture)ref.fetchAttributes(DebuggerObjectModel.RefreshBehavior.REFRESH_ALWAYS).thenAccept(attrs -> table.setColumns())).exceptionally(ex -> {
                this.plugin.objectError("Failed to fetch attributes");
                return null;
            });
        }
        return table;
    }

    public DebuggerObjectsPlugin getPlugin() {
        return this.plugin;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTargetToMap(ObjectContainer container) {
        TargetObject targetObject;
        DebuggerObjectsProvider provider = container.getProvider();
        if (!this.equals(provider)) {
            this.plugin.objectError("TargetMap corrupted");
        }
        if ((targetObject = container.getTargetObject()) != null && !container.isLink()) {
            String key = targetObject.getJoinedPath(PATH_JOIN_CHAR);
            container.subscribe();
            Map<String, ObjectContainer> map = this.targetMap;
            synchronized (map) {
                this.targetMap.put(key, container);
                this.refSet.add(targetObject);
                if (targetObject instanceof TargetConfigurable) {
                    this.configurables.add((TargetConfigurable)targetObject);
                }
            }
            if (targetObject instanceof TargetInterpreter) {
                TargetInterpreter interpreter = (TargetInterpreter)targetObject;
                this.getPlugin().showConsole(interpreter);
                this.pane.setSelectedObject(targetObject);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteFromMap(ObjectContainer container) {
        TargetObject targetObject = container.getTargetObject();
        if (targetObject != null) {
            Map<String, ObjectContainer> map = this.targetMap;
            synchronized (map) {
                this.targetMap.remove(targetObject.getJoinedPath(PATH_JOIN_CHAR));
                this.refSet.remove(targetObject);
                if (targetObject instanceof TargetConfigurable) {
                    this.configurables.remove(targetObject);
                }
            }
        }
    }

    public ObjectContainer getContainerByPath(List<String> path) {
        return this.targetMap.get(PathUtils.toString(path, (String)PATH_JOIN_CHAR));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static List<ObjectContainer> getContainersFromObjects(Map<String, ?> objectMap, TargetObject parent, boolean usingAttributes) {
        ArrayList<ObjectContainer> result = new ArrayList<ObjectContainer>();
        if (parent == null || parent instanceof DummyTargetObject) {
            return result;
        }
        Map<String, ?> map = objectMap;
        synchronized (map) {
            for (String key : objectMap.keySet()) {
                Object object = objectMap.get(key);
                if (object == null) {
                    System.err.println("null object for " + key);
                    continue;
                }
                ObjectContainer container = null;
                try {
                    container = DebuggerObjectsProvider.buildContainerFromObject(parent, key, object, usingAttributes);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                if (container == null) continue;
                result.add(container);
            }
        }
        return result;
    }

    static ObjectContainer buildContainerFromObject(TargetObject parent, String key, Object val, boolean usingAttributes) {
        Object xkey;
        Object object = xkey = usingAttributes ? key : "[" + key + "]";
        if (val instanceof TargetObject) {
            TargetObject to = (TargetObject)val;
            List path = to.getPath();
            boolean isLink = PathUtils.isLink((List)parent.getPath(), (String)xkey, (List)path);
            boolean isMethod = false;
            isMethod = to instanceof TargetMethod;
            if (!(val instanceof DummyTargetObject) && !isMethod) {
                return new ObjectContainer(to, (String)(isLink ? xkey : null));
            }
        } else {
            List xpath = PathUtils.extend((List)parent.getPath(), (String)key);
            DummyTargetObject to = new DummyTargetObject(parent, (List<String>)xpath, "", val, "");
            return new ObjectContainer(to, null);
        }
        return null;
    }

    public void closeComponent() {
        DebuggerObjectModel model = this.getModel();
        if (model != null) {
            model.removeModelListener(this.getListener());
        }
        super.closeComponent();
    }

    public void signalDataChanged(ObjectContainer container) {
        if (this.pane != null) {
            this.pane.signalDataChanged(container);
        }
    }

    public void signalContentsChanged(ObjectContainer container) {
        if (this.pane != null) {
            this.pane.signalContentsChanged(container);
        }
    }

    @Override
    public void update(ObjectContainer container) {
        if (this.pane != null) {
            this.pane.signalUpdate(container);
        }
    }

    public ObjectContainer getRoot() {
        return this.root;
    }

    public ObjectContainer getParent(ObjectContainer container) {
        List path = container.getTargetObject().getPath();
        ArrayList<String> ppath = new ArrayList<String>();
        for (String link : path) {
            ppath.add(link);
        }
        if (path.size() == 0) {
            return null;
        }
        ppath.remove(path.size() - 1);
        String joinedPath = StringUtils.join(ppath, (String)PATH_JOIN_CHAR);
        return this.targetMap.get(joinedPath);
    }

    public void fireObjectUpdated(ObjectContainer object) {
        this.plugin.fireObjectUpdated(object);
    }

    public boolean isRoot(ActionContext context) {
        TargetObject object = this.getObjectFromContext(context);
        if (object == null) {
            return false;
        }
        return object.isRoot();
    }

    public boolean isInstance(ActionContext context, Class<? extends TargetObject> clazz) {
        TargetObject object = this.getObjectFromContext(context);
        if (object == null) {
            return false;
        }
        if (this.isLocalOnly()) {
            return clazz.isInstance(object);
        }
        TargetObject result = null;
        try {
            result = (TargetObject)DebugModelConventions.findSuitable(clazz, (TargetObject)object).get(100L, TimeUnit.MILLISECONDS);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result != null;
    }

    public boolean hasInstance(ActionContext context, Class<? extends TargetObject> clazz) {
        TargetObject object = this.getObjectFromContext(context);
        if (object == null) {
            return false;
        }
        if (this.isLocalOnly()) {
            return clazz.isInstance(object);
        }
        for (Object attr : object.getCachedAttributes().values()) {
            if (!clazz.isInstance(attr)) continue;
            return true;
        }
        return false;
    }

    public TargetObject getAncestor(ActionContext context, Class<? extends TargetObject> clazz) {
        TargetObject object;
        for (TargetObject ref = object = this.getObjectFromContext(context); ref != null; ref = ref.getParent()) {
            if (!clazz.isInstance(ref)) continue;
            return ref;
        }
        return null;
    }

    public boolean descendsFrom(ActionContext context, Class<? extends TargetObject> clazz) {
        TargetObject ref = this.getAncestor(context, clazz);
        return ref != null;
    }

    private void createActions() {
        int groupTargetIndex = 0;
        ((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder("Refresh Node", this.plugin.getName()).keyBinding("SHIFT R")).toolBarGroup("Dbg8. Maintenance", "M" + groupTargetIndex)).toolBarIcon(DebuggerResources.AbstractRefreshAction.ICON)).helpLocation(new HelpLocation(this.plugin.getName(), "refresh"))).onAction(ctx -> this.performRefresh((ActionContext)ctx))).enabled(true)).buildAndInstallLocal((ComponentProvider)this);
        this.actionToggleBase = (ToggleDockingAction)((ToggleActionBuilder)((ToggleActionBuilder)((ToggleActionBuilder)((ToggleActionBuilder)((ToggleActionBuilder)new ToggleActionBuilder("Toggle Base", this.plugin.getName()).keyBinding("B")).menuPath(new String[]{"&Toggle base"})).menuGroup("Dbg5. Target", "M" + ++groupTargetIndex)).helpLocation(new HelpLocation(this.plugin.getName(), "toggle_base"))).onAction(ctx -> this.performToggleBase((ActionContext)ctx))).buildAndInstallLocal((ComponentProvider)this);
        this.actionToggleSubscribe = (ToggleDockingAction)((ToggleActionBuilder)((ToggleActionBuilder)((ToggleActionBuilder)((ToggleActionBuilder)((ToggleActionBuilder)new ToggleActionBuilder("Toggle Subscription", this.plugin.getName()).keyBinding("U")).menuPath(new String[]{"&Toggle subscription"})).menuGroup("Dbg5. Target", "M" + ++groupTargetIndex)).helpLocation(new HelpLocation(this.plugin.getName(), "toggle_subscription"))).onAction(ctx -> this.performToggleSubscription((ActionContext)ctx))).buildAndInstallLocal((ComponentProvider)this);
        this.actionToggleAutoRecord = (ToggleDockingAction)((ToggleActionBuilder)((ToggleActionBuilder)((ToggleActionBuilder)((ToggleActionBuilder)((ToggleActionBuilder)new ToggleActionBuilder("&Record Automatically", this.plugin.getName()).menuPath(new String[]{"&Record Automatically"})).menuGroup("Dbg5. Target", "M" + ++groupTargetIndex)).helpLocation(new HelpLocation(this.plugin.getName(), "record_automatically"))).onAction(ctx -> this.performToggleAutoRecord((ActionContext)ctx))).selected(this.autoRecord).enabled(true)).buildAndInstallLocal((ComponentProvider)this);
        this.actionToggleHideIntrinsics = (ToggleDockingAction)((ToggleActionBuilder)((ToggleActionBuilder)((ToggleActionBuilder)((ToggleActionBuilder)((ToggleActionBuilder)new ToggleActionBuilder("Hide Intrinsic Atributes", this.plugin.getName()).menuPath(new String[]{"Maintenance", "&Hide Intrinsic Attributes"})).menuGroup("Dbg5. Target", "M" + ++groupTargetIndex)).helpLocation(new HelpLocation(this.plugin.getName(), "hide_intrinsic_attributes"))).onAction(ctx -> this.performToggleHideIntrinsics((ActionContext)ctx))).selected(this.hideIntrinsics).enabled(true)).buildAndInstallLocal((ComponentProvider)this);
        this.actionToggleSelectionOnly = (ToggleDockingAction)((ToggleActionBuilder)((ToggleActionBuilder)((ToggleActionBuilder)((ToggleActionBuilder)((ToggleActionBuilder)new ToggleActionBuilder("Enable By Selection Only", this.plugin.getName()).menuPath(new String[]{"Maintenance", "Enable By &Selection Only"})).menuGroup("Dbg5. Target", "M" + ++groupTargetIndex)).helpLocation(new HelpLocation(this.plugin.getName(), "act_on_selection_only"))).onAction(ctx -> this.performToggleSelectionOnly((ActionContext)ctx))).selected(this.selectionOnly).enabled(true)).buildAndInstallLocal((ComponentProvider)this);
        this.actionToggleIgnoreState = (ToggleDockingAction)((ToggleActionBuilder)((ToggleActionBuilder)((ToggleActionBuilder)((ToggleActionBuilder)((ToggleActionBuilder)new ToggleActionBuilder("Toggle ignore state on/off", this.plugin.getName()).menuPath(new String[]{"Maintenance", "&Ignore State"})).menuGroup("Dbg5. Target", "M" + ++groupTargetIndex)).helpLocation(new HelpLocation(this.plugin.getName(), "toggle_ignore_state"))).onAction(ctx -> this.performToggleIgnoreState((ActionContext)ctx))).selected(this.ignoreState).enabled(true)).buildAndInstallLocal((ComponentProvider)this);
        this.actionToggleUpdateWhileRunning = (ToggleDockingAction)((ToggleActionBuilder)((ToggleActionBuilder)((ToggleActionBuilder)((ToggleActionBuilder)((ToggleActionBuilder)new ToggleActionBuilder("Toggle update while running", this.plugin.getName()).menuPath(new String[]{"Maintenance", "&Update While Running"})).menuGroup("Dbg5. Target", "M" + ++groupTargetIndex)).helpLocation(new HelpLocation(this.plugin.getName(), "toggle_update_while_running"))).onAction(ctx -> this.performToggleUpdateWhileRunning((ActionContext)ctx))).selected(this.isUpdateWhileRunning()).enabled(true)).buildAndInstallLocal((ComponentProvider)this);
        ++groupTargetIndex;
        groupTargetIndex = 0;
        ((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder("Quick Launch", this.plugin.getName()).keyBinding("Q")).toolBarGroup("Dbg5. Target", "" + groupTargetIndex)).toolBarIcon(DebuggerResources.AbstractQuickLaunchAction.ICON)).helpLocation(DebuggerResources.AbstractQuickLaunchAction.help(this.plugin))).enabledWhen(ctx -> this.hasModelAndProgram())).onAction(ctx -> this.performQuickLaunch((ActionContext)ctx))).enabled(this.currentModel != null)).buildAndInstallLocal((ComponentProvider)this);
        this.actionLaunch = (DockingAction)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder("Launch", this.plugin.getName()).keyBinding("X")).toolBarGroup("Dbg5. Target", "T" + ++groupTargetIndex)).toolBarIcon(DebuggerResources.AbstractLaunchAction.ICON)).popupMenuPath(new String[]{"&Exec"})).popupMenuGroup("Dbg5. Target", "T" + groupTargetIndex)).popupMenuIcon(DebuggerResources.AbstractLaunchAction.ICON)).helpLocation(DebuggerResources.AbstractLaunchAction.help(this.plugin))).enabledWhen(ctx -> this.isInstance((ActionContext)ctx, (Class<? extends TargetObject>)TargetLauncher.class))).popupWhen(ctx -> this.isInstance((ActionContext)ctx, (Class<? extends TargetObject>)TargetLauncher.class))).onAction(ctx -> this.performLaunch((ActionContext)ctx))).enabled(false)).buildAndInstallLocal((ComponentProvider)this);
        ((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder("Attach", this.plugin.getName()).keyBinding("A")).toolBarGroup("Dbg5. Target", "T" + ++groupTargetIndex)).toolBarIcon(DebuggerResources.AbstractAttachAction.ICON)).popupMenuPath(new String[]{"&Attach"})).popupMenuGroup("Dbg5. Target", "T" + groupTargetIndex)).popupMenuIcon(DebuggerResources.AbstractAttachAction.ICON)).helpLocation(DebuggerResources.AbstractAttachAction.help(this.plugin))).enabledWhen(ctx -> this.isInstance((ActionContext)ctx, (Class<? extends TargetObject>)TargetAttachable.class))).onAction(ctx -> this.performAttach((ActionContext)ctx))).enabled(true)).buildAndInstallLocal((ComponentProvider)this);
        ((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder("Re-attach", this.plugin.getName()).keyBinding("ALT A")).menuPath(new String[]{"&Reattach"})).menuGroup("Dbg5. Target", "T" + ++groupTargetIndex)).menuIcon(DebuggerResources.AbstractDetachAction.ICON)).helpLocation(DebuggerResources.AbstractAttachAction.help(this.plugin))).enabledWhen(ctx -> this.isInstance((ActionContext)ctx, (Class<? extends TargetObject>)TargetAttachable.class) && this.isStopped((ActionContext)ctx))).onAction(ctx -> this.performReattach((ActionContext)ctx))).enabled(true)).buildAndInstallLocal((ComponentProvider)this);
        ((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder("Method", this.plugin.getName()).keyBinding("M")).menuPath(new String[]{"Exec &Method"})).menuGroup("Dbg5. Target", "T" + ++groupTargetIndex)).menuIcon(DebuggerResources.AbstractDetachAction.ICON)).popupMenuPath(new String[]{"Exec &Method"})).popupMenuGroup("Dbg5. Target", "T" + groupTargetIndex)).popupMenuIcon(DebuggerResources.AbstractDetachAction.ICON)).helpLocation(DebuggerResources.AbstractAttachAction.help(this.plugin))).enabledWhen(ctx -> this.hasInstance((ActionContext)ctx, (Class<? extends TargetObject>)TargetMethod.class))).onAction(ctx -> this.performMethod((ActionContext)ctx))).enabled(true)).buildAndInstallLocal((ComponentProvider)this);
        ((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder("Detach", this.plugin.getName()).keyBinding("D")).menuPath(new String[]{"&Detach"})).menuGroup("Dbg5. Target", "T" + ++groupTargetIndex)).menuIcon(DebuggerResources.AbstractDetachAction.ICON)).popupMenuPath(new String[]{"&Detach"})).popupMenuGroup("Dbg5. Target", "T" + groupTargetIndex)).popupMenuIcon(DebuggerResources.AbstractDetachAction.ICON)).helpLocation(DebuggerResources.AbstractDetachAction.help(this.plugin))).popupWhen(ctx -> this.isInstance((ActionContext)ctx, (Class<? extends TargetObject>)TargetDetachable.class) && this.isStopped((ActionContext)ctx))).enabledWhen(ctx -> this.isInstance((ActionContext)ctx, (Class<? extends TargetObject>)TargetDetachable.class) && this.isStopped((ActionContext)ctx))).onAction(ctx -> this.performDetach((ActionContext)ctx))).enabled(false)).buildAndInstallLocal((ComponentProvider)this);
        ((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder("Kill", this.plugin.getName()).keyBinding("K")).menuPath(new String[]{"&Kill"})).menuGroup("Dbg5. Target", "T" + ++groupTargetIndex)).menuIcon(DebuggerResources.AbstractKillAction.ICON)).popupMenuPath(new String[]{"&Kill"})).popupMenuGroup("Dbg5. Target", "T" + groupTargetIndex)).popupMenuIcon(DebuggerResources.AbstractKillAction.ICON)).helpLocation(DebuggerResources.AbstractKillAction.help(this.plugin))).enabledWhen(ctx -> this.isInstance((ActionContext)ctx, (Class<? extends TargetObject>)TargetKillable.class) && (this.isStopped((ActionContext)ctx) || !this.isAccessConditioned((ActionContext)ctx)))).popupWhen(ctx -> this.isInstance((ActionContext)ctx, (Class<? extends TargetObject>)TargetKillable.class) && (this.isStopped((ActionContext)ctx) || !this.isAccessConditioned((ActionContext)ctx)))).onAction(ctx -> this.performKill((ActionContext)ctx))).enabled(false)).buildAndInstallLocal((ComponentProvider)this);
        ((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder("Start Recording", this.plugin.getName()).keyBinding("R")).menuPath(new String[]{"&Record"})).menuGroup("Dbg5. Target", "T" + ++groupTargetIndex)).menuIcon(DebuggerResources.AbstractRecordAction.ICON)).popupMenuPath(new String[]{"&Record"})).popupMenuGroup("Dbg5. Target", "T" + groupTargetIndex)).popupMenuIcon(DebuggerResources.AbstractRecordAction.ICON)).helpLocation(new HelpLocation(this.plugin.getName(), "record"))).enabledWhen(ctx -> this.isInstance((ActionContext)ctx, (Class<? extends TargetObject>)TargetProcess.class) || this.isRoot((ActionContext)ctx))).popupWhen(ctx -> this.isInstance((ActionContext)ctx, (Class<? extends TargetObject>)TargetProcess.class) || this.isRoot((ActionContext)ctx))).onAction(ctx -> this.performStartRecording((ActionContext)ctx))).enabled(true)).buildAndInstallLocal((ComponentProvider)this);
        groupTargetIndex = 0;
        ((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder("Resume", this.plugin.getName()).keyBinding("F5")).toolBarGroup("Dbg4. Control", "C" + groupTargetIndex)).toolBarIcon(DebuggerResources.AbstractResumeAction.ICON)).popupMenuPath(new String[]{"&Resume"})).popupMenuGroup("Dbg4. Control", "C" + groupTargetIndex)).popupMenuIcon(DebuggerResources.AbstractResumeAction.ICON)).helpLocation(DebuggerResources.AbstractResumeAction.help(this.plugin))).enabledWhen(ctx -> this.isInstance((ActionContext)ctx, (Class<? extends TargetObject>)TargetResumable.class) && this.isStopped((ActionContext)ctx))).popupWhen(ctx -> this.isInstance((ActionContext)ctx, (Class<? extends TargetObject>)TargetResumable.class) && this.isStopped((ActionContext)ctx))).onAction(ctx -> this.performResume((ActionContext)ctx))).enabled(false)).buildAndInstallLocal((ComponentProvider)this);
        ((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder("Interrupt", this.plugin.getName()).keyBinding("pause")).toolBarGroup("Dbg4. Control", "C" + ++groupTargetIndex)).toolBarIcon(DebuggerResources.AbstractInterruptAction.ICON)).popupMenuPath(new String[]{"&Interrupt"})).popupMenuGroup("Dbg4. Control", "C" + groupTargetIndex)).popupMenuIcon(DebuggerResources.AbstractInterruptAction.ICON)).helpLocation(DebuggerResources.AbstractInterruptAction.help(this.plugin))).enabledWhen(ctx -> this.isInstance((ActionContext)ctx, (Class<? extends TargetObject>)TargetInterruptible.class) && (!this.isStopped((ActionContext)ctx) || this.ignoreState))).popupWhen(ctx -> this.isInstance((ActionContext)ctx, (Class<? extends TargetObject>)TargetInterruptible.class) && (!this.isStopped((ActionContext)ctx) || this.ignoreState))).onAction(ctx -> this.performInterrupt((ActionContext)ctx))).enabled(false)).buildAndInstallLocal((ComponentProvider)this);
        ((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder("Step Into", this.plugin.getName()).keyBinding("F8")).toolBarGroup("Dbg4. Control", "C" + ++groupTargetIndex)).toolBarIcon(DebuggerResources.AbstractStepIntoAction.ICON)).popupMenuPath(new String[]{"&Step Into"})).popupMenuGroup("Dbg4. Control", "C" + groupTargetIndex)).popupMenuIcon(DebuggerResources.AbstractStepIntoAction.ICON)).helpLocation(DebuggerResources.AbstractStepIntoAction.help(this.plugin))).enabledWhen(ctx -> this.isInstance((ActionContext)ctx, (Class<? extends TargetObject>)TargetSteppable.class) && this.isStopped((ActionContext)ctx))).popupWhen(ctx -> this.isInstance((ActionContext)ctx, (Class<? extends TargetObject>)TargetSteppable.class) && this.isStopped((ActionContext)ctx))).onAction(ctx -> this.performStepInto((ActionContext)ctx))).enabled(false)).buildAndInstallLocal((ComponentProvider)this);
        ((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder("Step Over", this.plugin.getName()).keyBinding("F10")).toolBarGroup("Dbg4. Control", "C" + ++groupTargetIndex)).toolBarIcon(DebuggerResources.AbstractStepOverAction.ICON)).popupMenuPath(new String[]{"&Step Over"})).popupMenuGroup("Dbg4. Control", "C" + groupTargetIndex)).popupMenuIcon(DebuggerResources.AbstractStepOverAction.ICON)).helpLocation(DebuggerResources.AbstractStepOverAction.help(this.plugin))).enabledWhen(ctx -> this.isInstance((ActionContext)ctx, (Class<? extends TargetObject>)TargetSteppable.class) && this.isStopped((ActionContext)ctx))).popupWhen(ctx -> this.isInstance((ActionContext)ctx, (Class<? extends TargetObject>)TargetSteppable.class) && this.isStopped((ActionContext)ctx))).onAction(ctx -> this.performStepOver((ActionContext)ctx))).enabled(false)).buildAndInstallLocal((ComponentProvider)this);
        ((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder("Finish", this.plugin.getName()).keyBinding("F12")).toolBarGroup("Dbg4. Control", "C" + ++groupTargetIndex)).toolBarIcon(DebuggerResources.AbstractStepFinishAction.ICON)).popupMenuPath(new String[]{"&Finish"})).popupMenuGroup("Dbg4. Control", "C" + groupTargetIndex)).popupMenuIcon(DebuggerResources.AbstractStepFinishAction.ICON)).helpLocation(DebuggerResources.AbstractStepFinishAction.help(this.plugin))).enabledWhen(ctx -> this.isInstance((ActionContext)ctx, (Class<? extends TargetObject>)TargetSteppable.class) && this.isStopped((ActionContext)ctx))).popupWhen(ctx -> this.isInstance((ActionContext)ctx, (Class<? extends TargetObject>)TargetSteppable.class) && this.isStopped((ActionContext)ctx))).onAction(ctx -> this.performStepFinish((ActionContext)ctx))).enabled(false)).buildAndInstallLocal((ComponentProvider)this);
        ((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder("Step Last", this.plugin.getName()).keyBinding("ALT F8")).toolBarGroup("Dbg4. Control", "C" + ++groupTargetIndex)).toolBarIcon(DebuggerResources.AbstractStepLastAction.ICON)).popupMenuPath(new String[]{"&Step Last"})).popupMenuGroup("Dbg4. Control", "C" + groupTargetIndex)).popupMenuIcon(DebuggerResources.AbstractStepLastAction.ICON)).helpLocation(DebuggerResources.AbstractStepLastAction.help(this.plugin))).enabledWhen(ctx -> this.isInstance((ActionContext)ctx, (Class<? extends TargetObject>)TargetSteppable.class) && this.isStopped((ActionContext)ctx))).popupWhen(ctx -> this.isInstance((ActionContext)ctx, (Class<? extends TargetObject>)TargetSteppable.class) && this.isStopped((ActionContext)ctx))).onAction(ctx -> this.performStepLast((ActionContext)ctx))).enabled(false)).buildAndInstallLocal((ComponentProvider)this);
        this.actionAddBreakpoint = (DockingAction)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder("Add Breakpoint", this.plugin.getName()).keyBinding("F3")).toolBarGroup("Dbg4. Control", "C" + ++groupTargetIndex)).toolBarIcon(DebuggerResources.AbstractSetBreakpointAction.ICON)).popupMenuPath(new String[]{"&Add Breakpoint"})).popupMenuGroup("Dbg4. Control", "C" + groupTargetIndex)).popupMenuIcon(DebuggerResources.AbstractSetBreakpointAction.ICON)).helpLocation(DebuggerResources.AbstractSetBreakpointAction.help(this.plugin))).enabledWhen(ctx -> this.isInstance((ActionContext)ctx, (Class<? extends TargetObject>)TargetBreakpointSpecContainer.class) && this.isStopped((ActionContext)ctx))).popupWhen(ctx -> this.isInstance((ActionContext)ctx, (Class<? extends TargetObject>)TargetBreakpointSpecContainer.class) && this.isStopped((ActionContext)ctx))).onAction(ctx -> this.performSetBreakpoint((ActionContext)ctx))).enabled(false)).buildAndInstallLocal((ComponentProvider)this);
        groupTargetIndex = 0;
        ((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder("Show Console", this.plugin.getName()).toolBarGroup("Dbg2. Connection", "X" + groupTargetIndex)).toolBarIcon(DebuggerResources.AbstractConsoleAction.ICON)).popupMenuPath(new String[]{"&Show Console"})).popupMenuGroup("Dbg2. Connection", "X" + groupTargetIndex)).popupMenuIcon(DebuggerResources.AbstractConsoleAction.ICON)).helpLocation(DebuggerResources.AbstractConsoleAction.help(this.plugin))).enabledWhen(ctx -> this.isInstance((ActionContext)ctx, (Class<? extends TargetObject>)TargetInterpreter.class))).popupWhen(ctx -> this.isInstance((ActionContext)ctx, (Class<? extends TargetObject>)TargetInterpreter.class))).onAction(ctx -> this.initiateConsole((ActionContext)ctx))).enabled(false)).buildAndInstallLocal((ComponentProvider)this);
        ((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder("Toggle", this.plugin.getName()).keyBinding("T")).toolBarGroup("Dbg4. Control", "X" + ++groupTargetIndex)).popupMenuPath(new String[]{"&Toggle"})).popupMenuGroup("Dbg4. Control", "X" + groupTargetIndex)).helpLocation(DebuggerResources.AbstractToggleAction.help(this.plugin))).enabledWhen(ctx -> this.isInstance((ActionContext)ctx, (Class<? extends TargetObject>)TargetTogglable.class))).popupWhen(ctx -> this.isInstance((ActionContext)ctx, (Class<? extends TargetObject>)TargetTogglable.class))).onAction(ctx -> this.performToggle((ActionContext)ctx))).enabled(false)).buildAndInstallLocal((ComponentProvider)this);
        ((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder("Configure", this.plugin.getName()).keyBinding("C")).toolBarGroup("Dbg4. Control", "X" + ++groupTargetIndex)).popupMenuPath(new String[]{"&Configure"})).popupMenuGroup("Dbg4. Control", "X" + groupTargetIndex)).helpLocation(DebuggerResources.AbstractToggleAction.help(this.plugin))).enabledWhen(ctx -> this.isInstance((ActionContext)ctx, (Class<? extends TargetObject>)TargetConfigurable.class))).popupWhen(ctx -> this.isInstance((ActionContext)ctx, (Class<? extends TargetObject>)TargetConfigurable.class))).onAction(ctx -> this.performConfigure((ActionContext)ctx))).enabled(false)).buildAndInstallLocal((ComponentProvider)this);
        ((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder("GoTo", this.plugin.getName()).keyBinding("G")).toolBarGroup("Dbg4. Control", "X" + ++groupTargetIndex)).popupMenuPath(new String[]{"&GoTo"})).popupMenuGroup("Dbg4. Control", "X" + groupTargetIndex)).helpLocation(DebuggerResources.AbstractToggleAction.help(this.plugin))).enabledWhen(ctx -> this.isInstance((ActionContext)ctx, (Class<? extends TargetObject>)TargetObject.class))).popupWhen(ctx -> this.isInstance((ActionContext)ctx, (Class<? extends TargetObject>)TargetObject.class))).onAction(ctx -> this.performNavigate((ActionContext)ctx))).enabled(false)).buildAndInstallLocal((ComponentProvider)this);
        ++groupTargetIndex;
        this.displayAsTreeAction = new DisplayAsTreeAction(this.tool, this.plugin.getName(), this);
        this.displayAsTableAction = new DisplayAsTableAction(this.tool, this.plugin.getName(), this);
        this.displayAsGraphAction = new DisplayAsGraphAction(this.tool, this.plugin.getName(), this);
        this.displayAsXMLAction = new DisplayAsXMLAction(this.tool, this.plugin.getName(), this);
        this.displayFilteredTreeAction = new DisplayFilteredTreeAction(this.tool, this.plugin.getName(), this);
        this.displayFilteredTableAction = new DisplayFilteredTableAction(this.tool, this.plugin.getName(), this);
        this.displayFilteredGraphAction = new DisplayFilteredGraphAction(this.tool, this.plugin.getName(), this);
        this.displayFilteredXMLAction = new DisplayFilteredXMLAction(this.tool, this.plugin.getName(), this);
        this.displayMethodsAction = new DisplayMethodsAction(this.tool, this.plugin.getName(), this);
        this.exportAsXMLAction = new ExportAsXMLAction(this.tool, this.plugin.getName(), this);
        this.exportAsFactsAction = new ExportAsFactsAction(this.tool, this.plugin.getName(), this);
        this.importFromXMLAction = new ImportFromXMLAction(this.tool, this.plugin.getName(), this);
        this.importFromFactsAction = new ImportFromFactsAction(this.tool, this.plugin.getName(), this);
        this.openTraceAction = new OpenWinDbgTraceAction(this.tool, this.plugin.getName(), this);
        this.setTimeoutAction = new SetTimeoutAction(this.tool, this.plugin.getName(), this);
    }

    public void performRefresh(ActionContext context) {
        TargetObject current = this.getObjectFromContext(context);
        if (current != null) {
            this.refresh(current.getName());
        } else {
            this.refresh();
        }
    }

    public void performToggleAutoupdate(ActionContext context) {
    }

    public void performToggleBase(ActionContext context) {
        for (TargetConfigurable configurable : this.configurables) {
            Object value = configurable.getCachedAttribute("_base");
            if (value == null) continue;
            Integer base = (Integer)value;
            base = base == 10 ? 16 : 10;
            configurable.writeConfigurationOption("_base", (Object)base);
        }
    }

    public void performToggleSubscription(ActionContext context) {
        Object contextObject = context.getContextObject();
        ObjectContainer container = this.getSelectedContainer(contextObject);
        if (container.isSubscribed()) {
            container.unsubscribe();
        } else {
            container.subscribe();
        }
    }

    public void performToggleAutoRecord(ActionContext context) {
        this.autoRecord = this.actionToggleAutoRecord.isSelected();
    }

    public void performToggleHideIntrinsics(ActionContext context) {
        this.hideIntrinsics = this.actionToggleHideIntrinsics.isSelected();
        this.refresh("");
    }

    public void performToggleSelectionOnly(ActionContext context) {
        this.selectionOnly = this.actionToggleSelectionOnly.isSelected();
        this.refresh("");
    }

    public void performToggleIgnoreState(ActionContext context) {
        this.ignoreState = this.actionToggleIgnoreState.isSelected();
        this.refresh("");
    }

    public void performToggleUpdateWhileRunning(ActionContext context) {
        this.updateWhileRunning = this.actionToggleUpdateWhileRunning.isSelected();
        this.refresh("");
    }

    protected <T extends TargetObject> void performAction(ActionContext context, boolean fallbackRoot, Class<T> cls, Function<T, CompletableFuture<Void>> func, String errorMsg) {
        TargetObject obj = this.getObjectFromContext(context);
        if (obj == null && fallbackRoot) {
            obj = this.root.getTargetObject();
        }
        if (!this.isLocalOnly()) {
            ((CompletableFuture)DebugModelConventions.findSuitable(cls, (TargetObject)obj).thenCompose(t -> (CompletionStage)func.apply((TargetObject)t))).exceptionally(DebuggerResources.showError(this.getComponent(), errorMsg));
        } else {
            TargetObject t2 = (TargetObject)cls.cast(obj);
            func.apply(t2).exceptionally(DebuggerResources.showError(this.getComponent(), errorMsg));
        }
    }

    public void performQuickLaunch(ActionContext context) {
        if (this.currentProgram == null) {
            return;
        }
        this.performLaunchAction(context, false);
    }

    public void performLaunch(ActionContext context) {
        this.performLaunchAction(context, true);
    }

    private void performLaunchAction(ActionContext context, final boolean p) {
        this.performAction(context, true, TargetLauncher.class, launcher -> {
            Object locals = new Object(){
                boolean prompt;
                {
                    this.prompt = p;
                }
            };
            return AsyncUtils.loop((TypeSpec)TypeSpec.VOID, arg_0 -> this.lambda$performLaunchAction$71(launcher, locals, arg_0));
        }, "Couldn't launch");
    }

    public void performAttach(ActionContext context) {
        TargetObject obj = this.getObjectFromContext(context);
        this.performAction(context, false, TargetAttacher.class, attacher -> {
            this.attachDialog.setAttacher((TargetAttacher)attacher);
            if (obj instanceof TargetAttachable) {
                return attacher.attach((TargetAttachable)obj);
            }
            this.attachDialog.fetchAndDisplayAttachable();
            this.tool.showDialog((DialogComponentProvider)this.attachDialog);
            return AsyncUtils.NIL;
        }, "Couldn't attach");
    }

    public void performReattach(ActionContext context) {
        TargetObject obj = this.getObjectFromContext(context);
        if (!(obj instanceof TargetAttachable)) {
            return;
        }
        ((CompletableFuture)DebugModelConventions.findSuitable(TargetAttacher.class, (TargetObject)obj).thenCompose(attacher -> attacher.attach((TargetAttachable)obj))).exceptionally(DebuggerResources.showError(this.getComponent(), "Couldn't re-attach"));
    }

    public void performMethod(ActionContext context) {
        TargetObject obj = this.getObjectFromContext(context);
        ArrayList<String> list = new ArrayList<String>();
        Map attributes = obj.getCachedAttributes();
        for (Map.Entry entry : attributes.entrySet()) {
            if (!(entry.getValue() instanceof TargetMethod)) continue;
            list.add((String)entry.getKey());
        }
        String choice = OptionDialog.showInputChoiceDialog((Component)this.getComponent(), (String)"Methods", (String)"Methods", (String[])list.toArray(new String[0]), (String)this.lastMethod, (int)3);
        if (choice != null) {
            TargetMethod method = (TargetMethod)attributes.get(choice);
            TargetMethod.TargetParameterMap parameters = method.getParameters();
            if (parameters.isEmpty()) {
                method.invoke(new HashMap());
                if (!choice.equals("unload")) {
                    this.lastMethod = choice;
                }
                return;
            }
            Map<String, ?> args = this.methodDialog.promptArguments((Map<String, TargetMethod.ParameterDescription<?>>)parameters);
            if (args != null) {
                String script = (String)args.get("Script");
                if (script != null && !script.isEmpty()) {
                    this.mapScript(args);
                }
                method.invoke(args);
                if (!choice.equals("unload")) {
                    this.lastMethod = choice;
                }
            }
        }
    }

    private void mapScript(Map<String, ?> args) {
        GhidraScript script;
        String name = (String)args.get("Name");
        String scriptName = (String)args.get("Script");
        if (name.isEmpty() || scriptName.isEmpty()) {
            return;
        }
        ResourceFile sourceFile = GhidraScriptUtil.findScriptByName((String)scriptName);
        if (sourceFile == null) {
            Msg.error((Object)this, (Object)"Couldn't find script");
            return;
        }
        GhidraScriptProvider provider = GhidraScriptUtil.getProvider((ResourceFile)sourceFile);
        if (provider == null) {
            Msg.error((Object)this, (Object)"Couldn't find script provider");
            return;
        }
        PrintWriter writer = this.consoleService.getStdOut();
        try {
            script = provider.getScriptInstance(sourceFile, writer);
        }
        catch (GhidraScriptLoadException e) {
            Msg.error((Object)this, (Object)e.getMessage());
            return;
        }
        this.scripts.put(name, script);
        this.scriptNames.put(name, scriptName);
    }

    private void fireScript(String key, String[] args) {
        GhidraScript script = this.scripts.get(key);
        String scriptName = this.scriptNames.get(key);
        if (script == null || scriptName == null) {
            return;
        }
        Project project = this.tool.getProject();
        ProgramLocation currentLocation = this.listingService.getCurrentLocation();
        ProgramSelection currentSelection = this.listingService.getCurrentSelection();
        GhidraState state = new GhidraState(this.tool, project, this.currentProgram, currentLocation, currentSelection, null);
        PrintWriter writer = this.consoleService.getStdOut();
        TaskMonitor monitor = TaskMonitor.DUMMY;
        script.set(state, monitor, writer);
        try {
            script.runScript(scriptName, args);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void startRecording(TargetObject targetObject, boolean prompt) {
        TraceRecorder rec = this.modelService.getRecorder(targetObject);
        if (rec != null) {
            return;
        }
        rec = prompt ? this.modelService.recordTargetPromptOffers(targetObject) : this.modelService.recordTargetBestOffer(targetObject);
        if (rec == null) {
            return;
        }
        Trace trace = rec.getTrace();
        this.traceManager.openTrace(trace);
        this.traceManager.activate(this.traceManager.resolveTrace(trace), DebuggerTraceManagerService.ActivationCause.START_RECORDING);
    }

    public void stopRecording(TargetObject targetObject) {
        TraceRecorder rec = this.modelService.getRecorderForSuccessor(targetObject);
        if (rec != null) {
            rec.stopRecording();
        }
    }

    public void performDetach(ActionContext context) {
        this.performAction(context, false, TargetDetachable.class, TargetDetachable::detach, "Couldn't detach");
    }

    public void performKill(ActionContext context) {
        this.performAction(context, false, TargetKillable.class, TargetKillable::kill, "Couldn't kill");
    }

    public void performStartRecording(ActionContext context) {
        TargetObject maybeRoot = this.getObjectFromContext(context);
        if (maybeRoot.isRoot()) {
            this.startRecording(maybeRoot, true);
            return;
        }
        this.performAction(context, false, TargetProcess.class, proc -> {
            TargetProcess valid = DebugModelConventions.liveProcessOrNull((TargetObject)proc);
            if (valid != null) {
                this.startRecording((TargetObject)valid, true);
            }
            return AsyncUtils.NIL;
        }, "Couldn't record");
    }

    public void performResume(ActionContext context) {
        this.performAction(context, false, TargetResumable.class, TargetResumable::resume, "Couldn't resume");
    }

    public void performInterrupt(ActionContext context) {
        this.performAction(context, false, TargetInterruptible.class, TargetInterruptible::interrupt, "Couldn't interrupt");
    }

    public void performStepInto(ActionContext context) {
        this.performAction(context, false, TargetSteppable.class, TargetSteppable::step, "Couldn't step into");
    }

    public void performStepOver(ActionContext context) {
        this.performAction(context, false, TargetSteppable.class, s -> s.step(TargetSteppable.TargetStepKind.OVER), "Couldn't step over");
    }

    public void performStepFinish(ActionContext context) {
        this.performAction(context, false, TargetSteppable.class, s -> s.step(TargetSteppable.TargetStepKind.FINISH), "Couldn't step finish");
    }

    public void performStepLast(ActionContext context) {
        this.performAction(context, false, TargetSteppable.class, s -> {
            if (this.extendedStep.equals("")) {
                return s.step(TargetSteppable.TargetStepKind.EXTENDED);
            }
            return s.step(Map.of("Command", this.extendedStep));
        }, "Couldn't step extended(" + this.extendedStep + ")");
    }

    public void performSetBreakpoint(ActionContext context) {
        this.setText(context);
        this.performAction(context, false, TargetBreakpointSpecContainer.class, container -> {
            this.breakpointDialog.setContainer((TargetBreakpointSpecContainer)container);
            this.tool.showDialog((DialogComponentProvider)this.breakpointDialog);
            return AsyncUtils.NIL;
        }, "Couldn't set breakpoint");
    }

    private void setText(ActionContext context) {
        this.breakpointDialog.setText("");
        TargetObject obj = this.getObjectFromContext(context);
        Object key = obj.getCachedAttribute("_bpt");
        if (key != null) {
            this.breakpointDialog.setText(key.toString());
        } else if (obj instanceof DummyTargetObject) {
            DummyTargetObject dto = (DummyTargetObject)obj;
            this.breakpointDialog.setText(dto.getValue().toString());
        }
    }

    public void performToggle(ActionContext context) {
        this.performAction(context, false, TargetTogglable.class, t -> t.toggle(!t.isEnabled()), "Couldn't toggle");
    }

    public void performConfigure(ActionContext context) {
        this.performAction(context, false, TargetConfigurable.class, configurable -> {
            Map configParameters = configurable.getConfigurableOptions();
            if (configParameters.isEmpty()) {
                return AsyncUtils.NIL;
            }
            Map<String, ?> args = this.configDialog.promptArguments(configParameters);
            if (args == null) {
                return AsyncUtils.NIL;
            }
            AsyncFence fence = new AsyncFence();
            for (Map.Entry<String, ?> entry : args.entrySet()) {
                fence.include(configurable.writeConfigurationOption(entry.getKey(), entry.getValue()));
            }
            return fence.ready();
        }, "Couldn't configure one or more options");
    }

    public void performNavigate(ActionContext context) {
        this.performAction(context, false, TargetObject.class, t -> {
            if (t != null) {
                this.navigateToSelectedObject((TargetObject)t, null);
            }
            return AsyncUtils.NIL;
        }, "Couldn't navigate");
    }

    public void initiateConsole(ActionContext context) {
        this.performAction(context, false, TargetInterpreter.class, interpreter -> {
            this.getPlugin().showConsole((TargetInterpreter)interpreter);
            return AsyncUtils.NIL;
        }, "Couldn't show interpreter");
    }

    public boolean isAccessConditioned(ActionContext context) {
        TargetObject object = this.getObjectFromContext(context);
        if (object == null) {
            return false;
        }
        return object instanceof TargetAccessConditioned;
    }

    public boolean isStopped(ActionContext context) {
        TargetObject object = this.getObjectFromContext(context);
        return this.isStopped(object);
    }

    public boolean isStopped(TargetObject object) {
        if (object == null) {
            return false;
        }
        if (this.ignoreState) {
            return true;
        }
        if (this.isLocalOnly()) {
            if (object instanceof TargetExecutionStateful) {
                TargetExecutionStateful stateful = (TargetExecutionStateful)object;
                TargetExecutionStateful.TargetExecutionState executionState = stateful.getExecutionState();
                return !executionState.equals((Object)TargetExecutionStateful.TargetExecutionState.RUNNING);
            }
            return false;
        }
        TargetObject result = null;
        try {
            result = (TargetObject)DebugModelConventions.findSuitable(TargetExecutionStateful.class, (TargetObject)object).get(100L, TimeUnit.MILLISECONDS);
        }
        catch (Exception executionState) {
            // empty catch block
        }
        if (result != null) {
            TargetExecutionStateful stateful = (TargetExecutionStateful)result;
            TargetExecutionStateful.TargetExecutionState executionState = stateful.getExecutionState();
            return !executionState.equals((Object)TargetExecutionStateful.TargetExecutionState.RUNNING);
        }
        return false;
    }

    public void setFocus(TargetObject object, TargetObject focused) {
        if (focused.getModel() != this.currentModel) {
            return;
        }
        this.targetFocus = focused;
        if ((this.isStopped(focused) || this.isUpdateWhileRunning()) && this.pane != null) {
            this.pane.setFocus(object, focused);
        }
    }

    public DebuggerTraceManagerService getTraceManager() {
        return this.traceManager;
    }

    public boolean isHideIntrinsics() {
        return this.hideIntrinsics;
    }

    public void setHideIntrinsics(boolean hideIntrinsics) {
        this.hideIntrinsics = hideIntrinsics;
    }

    public boolean isLocalOnly() {
        return this.selectionOnly;
    }

    public void setLocalOnly(boolean localOnly) {
        this.selectionOnly = localOnly;
    }

    public boolean isAutorecord() {
        return this.autoRecord;
    }

    public void setAutorecord(boolean autorecord) {
        this.autoRecord = autorecord;
    }

    public int getNodeTimeout() {
        return this.nodeTimeout;
    }

    public void setNodeTimeout(int timeout) {
        this.nodeTimeout = timeout;
    }

    public void updateActions(ObjectContainer providerContainer) {
        TargetObject obj = this.getSelectedObject();
        if (obj != null) {
            this.actionToggleSubscribe.setEnabled(true);
            this.actionToggleSubscribe.setSelected(providerContainer.isSubscribed());
            MenuData menuData = this.actionToggleSubscribe.getMenuBarData();
            if (menuData != null) {
                menuData.setMenuPath(new String[]{"Subscribe to '" + obj.getDisplay() + "'"});
            }
        } else {
            this.actionToggleSubscribe.setEnabled(false);
            this.actionToggleSubscribe.setSelected(false);
            MenuData menuData = this.actionToggleSubscribe.getMenuBarData();
            if (menuData != null) {
                menuData.setMenuPath(new String[]{"Subscribe"});
            }
        }
    }

    public void writeConfigState(SaveState saveState) {
        CONFIG_STATE_HANDLER.writeConfigState((Object)this, saveState);
        this.methodDialog.writeConfigState(saveState);
    }

    public void readConfigState(SaveState saveState) {
        CONFIG_STATE_HANDLER.readConfigState((Object)this, saveState);
        this.actionToggleAutoRecord.setSelected(this.autoRecord);
        this.actionToggleHideIntrinsics.setSelected(this.hideIntrinsics);
        this.actionToggleSelectionOnly.setSelected(this.selectionOnly);
        this.setTimeoutAction.setNodeTimeout(this.nodeTimeout);
        this.methodDialog.readConfigState(saveState);
    }

    public void componentActivated() {
        if (this.currentTrace != null && !this.isActive()) {
            this.traceManager.activateTrace(this.currentTrace);
        }
    }

    public DebuggerModelService getModelService() {
        return this.modelService;
    }

    public DebuggerListingService getListingService() {
        return this.listingService;
    }

    public DebuggerModelListener getListener() {
        return (DebuggerModelListener)this.listener.queue.in;
    }

    public Address navigateToSelectedObject(TargetObject object, Object value) {
        if (this.listingService == null || this.modelService == null) {
            return null;
        }
        if (value == null) {
            value = object.getCachedAttribute("_address");
        }
        if (value == null) {
            value = object.getCachedAttribute("_range");
        }
        if (value == null) {
            value = object.getCachedAttribute("_value");
        }
        if (value == null) {
            return null;
        }
        Address addr = null;
        if (value instanceof Address) {
            Address a;
            addr = a = (Address)value;
        } else if (value instanceof AddressRange) {
            AddressRange range = (AddressRange)value;
            addr = range.getMinAddress();
        } else if (value instanceof Long) {
            Long lval = (Long)value;
            addr = object.getModel().getAddress("ram", lval.longValue());
        } else if (value instanceof String) {
            String sval = (String)value;
            addr = this.stringToAddress(object, addr, sval);
        }
        if (addr != null) {
            TraceRecorder recorder = this.modelService.getRecorderForSuccessor(object);
            if (recorder == null && (recorder = this.modelService.getRecorder(this.currentTrace)) == null) {
                return addr;
            }
            DebuggerMemoryMapper memoryMapper = recorder.getMemoryMapper();
            Address traceAddr = memoryMapper.targetToTrace(addr);
            this.listingService.goTo(traceAddr, true);
        }
        return addr;
    }

    private Address stringToAddress(TargetObject selectedObject, Address addr, String sval) {
        Integer base = 16;
        if (selectedObject instanceof TargetConfigurable) {
            TargetConfigurable configurable = (TargetConfigurable)selectedObject;
            base = (Integer)configurable.getCachedAttribute("_base");
        }
        try {
            Long lval = Long.parseLong(sval, base);
            addr = selectedObject.getModel().getAddress("ram", lval.longValue());
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return addr;
    }

    public boolean isUpdateWhileRunning() {
        return this.updateWhileRunning;
    }

    public TargetObject getFocus() {
        return this.targetFocus;
    }

    private /* synthetic */ void lambda$performLaunchAction$71(TargetLauncher launcher, 1 locals, AsyncLoopHandlerForSecond loop) {
        Map<String, ?> args = this.launchOffer.getLauncherArgs(launcher, locals.prompt);
        if (args == null) {
            loop.exit();
        } else {
            ((CompletableFuture)launcher.launch(args).thenAccept(arg_0 -> ((AsyncLoopHandlerForSecond)loop).exit(arg_0))).exceptionally(ex -> {
                loop.repeat();
                return null;
            });
        }
        locals.prompt = true;
    }

    class MyObjectListener
    extends AnnotatedDebuggerAttributeListener {
        protected final DebuggerCallbackReorderer reorderer;
        protected final PrivatelyQueuedListener<DebuggerModelListener> queue;

        public MyObjectListener() {
            super(MethodHandles.lookup());
            this.reorderer = new DebuggerCallbackReorderer((DebuggerModelListener)this);
            this.queue = new PrivatelyQueuedListener(DebuggerModelListener.class, "ObjectsProvider-EventQueue", (Object)this.reorderer);
        }

        @AnnotatedDebuggerAttributeListener.AttributeCallback(value="_accessible")
        public void accessibilityChanged(TargetObject object, boolean accessible) {
            DebuggerObjectsProvider.this.plugin.getTool().contextChanged((ComponentProvider)DebuggerObjectsProvider.this);
        }

        public void consoleOutput(TargetObject console, TargetConsole.Channel channel, byte[] bytes) {
            String ret = new String(bytes);
            if (ret.contains("<=")) {
                String[] split = ret.split("<=");
                String key = split[0];
                String val = split[1];
                GhidraScript script = DebuggerObjectsProvider.this.scripts.get(key);
                if (script != null) {
                    String[] args = new String[]{val};
                    DebuggerObjectsProvider.this.fireScript(key, args);
                    return;
                }
            }
            System.err.println("consoleOutput: " + new String(ret));
        }

        @AnnotatedDebuggerAttributeListener.AttributeCallback(value="_display")
        public void displayChanged(TargetObject object, String display) {
            if (ObjectContainer.visibleByDefault(object.getName())) {
                DebuggerObjectsProvider.this.pane.signalDataChanged(DebuggerObjectsProvider.this.getContainerByPath(object.getPath()));
            }
        }

        @AnnotatedDebuggerAttributeListener.AttributeCallback(value="_modified")
        public void modifiedChanged(TargetObject object, boolean modified) {
            if (ObjectContainer.visibleByDefault(object.getName())) {
                DebuggerObjectsProvider.this.pane.signalDataChanged(DebuggerObjectsProvider.this.getContainerByPath(object.getPath()));
            }
        }

        @AnnotatedDebuggerAttributeListener.AttributeCallback(value="_state")
        public void executionStateChanged(TargetObject object, TargetExecutionStateful.TargetExecutionState state) {
            DebuggerObjectsProvider.this.contextChanged();
        }

        @AnnotatedDebuggerAttributeListener.AttributeCallback(value="_focus")
        public void focusChanged(TargetObject object, TargetObject focused) {
            DebuggerObjectsProvider.this.plugin.setFocus(object, focused);
            DebuggerObjectsProvider.this.contextChanged();
        }

        public void memoryUpdated(TargetObject memory, Address address, byte[] data) {
        }

        public void memoryReadError(TargetObject memory, AddressRange range, DebuggerMemoryAccessException e) {
            System.err.println("memoryReadError");
        }

        @AnnotatedDebuggerAttributeListener.AttributeCallback(value="_prompt")
        public void promptChanged(TargetObject interpreter, String prompt) {
        }

        public void registersUpdated(TargetObject bank, Map<String, byte[]> updates) {
            Map cachedElements = bank.getCachedElements();
            for (String key : cachedElements.keySet()) {
                TargetObject ref = (TargetObject)cachedElements.get(key);
                this.displayChanged(ref, "registersUpdated");
            }
            Map cachedAttributes = bank.getCachedAttributes();
            for (String key : cachedAttributes.keySet()) {
                Object obj = cachedAttributes.get(key);
                if (!(obj instanceof TargetObject)) continue;
                this.displayChanged((TargetObject)obj, "registersUpdated");
            }
        }

        public void elementsChanged(TargetObject parent, Collection<String> removed, Map<String, ? extends TargetObject> added) {
            ObjectContainer container;
            ObjectContainer objectContainer = container = parent == null ? null : DebuggerObjectsProvider.this.getContainerByPath(parent.getPath());
            if (container != null) {
                container.augmentElements(removed, added);
                boolean visibleChange = false;
                for (String key : removed) {
                    visibleChange |= ObjectContainer.visibleByDefault(key);
                }
                for (String key : added.keySet()) {
                    visibleChange |= ObjectContainer.visibleByDefault(key);
                }
                if (visibleChange) {
                    container.propagateProvider(DebuggerObjectsProvider.this);
                    DebuggerObjectsProvider.this.update(container);
                    DebuggerObjectsProvider.this.getComponent().repaint();
                }
            }
        }

        public void attributesChanged(TargetObject parent, Collection<String> removed, Map<String, ?> added) {
            TargetProcess proc;
            ObjectContainer container;
            super.attributesChanged(parent, removed, added);
            ObjectContainer objectContainer = container = parent == null ? null : DebuggerObjectsProvider.this.getContainerByPath(parent.getPath());
            if (container != null) {
                container.augmentAttributes(removed, added);
                boolean visibleChange = false;
                for (String key : removed) {
                    visibleChange |= ObjectContainer.visibleByDefault(key);
                }
                for (String key : added.keySet()) {
                    visibleChange |= ObjectContainer.visibleByDefault(key);
                }
                if (visibleChange) {
                    container.propagateProvider(DebuggerObjectsProvider.this);
                    DebuggerObjectsProvider.this.update(container);
                    DebuggerObjectsProvider.this.getComponent().repaint();
                }
            }
            if (parent != null && DebuggerObjectsProvider.this.isAutorecord() && parent.getCachedAttribute("_state") != null && (proc = DebugModelConventions.liveProcessOrNull((TargetObject)parent)) != null) {
                DebuggerObjectsProvider.this.startRecording((TargetObject)proc, false);
            }
        }
    }

    class ObjectActionContext
    extends ActionContext {
        private DebuggerObjectsProvider provider;

        ObjectActionContext(DebuggerObjectsProvider provider) {
            super((ComponentProvider)provider);
            this.provider = provider;
        }

        public Object getContextObject() {
            return this.provider.getContextObject();
        }
    }
}

