/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.gui.model.columns;

import docking.widgets.checkbox.GCheckBox;
import docking.widgets.table.AbstractDynamicTableColumn;
import docking.widgets.table.DynamicColumnTableModel;
import docking.widgets.table.GTableCellRenderingData;
import docking.widgets.table.sort.ColumnRenderedValueBackupComparator;
import docking.widgets.table.sort.DefaultColumnComparator;
import ghidra.app.plugin.core.debug.gui.DebuggerResources;
import ghidra.app.plugin.core.debug.gui.model.ColorsModified;
import ghidra.app.plugin.core.debug.gui.model.ObjectTableModel;
import ghidra.docking.settings.Settings;
import ghidra.framework.plugintool.ServiceProvider;
import ghidra.trace.model.Trace;
import ghidra.util.table.column.AbstractGColumnRenderer;
import ghidra.util.table.column.GColumnRenderer;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.util.Comparator;
import java.util.function.Function;
import javax.swing.JTable;

public abstract class TraceValueObjectPropertyColumn<T>
extends AbstractDynamicTableColumn<ObjectTableModel.ValueRow, ObjectTableModel.ValueProperty<T>, Trace> {
    protected final Class<T> propertyType;
    private final GColumnRenderer<ObjectTableModel.ValueProperty<T>> renderer;
    private final Comparator<ObjectTableModel.ValueProperty<T>> comparator;
    private Color diffColor = DebuggerResources.COLOR_VALUE_CHANGED;
    private Color diffColorSel = DebuggerResources.COLOR_VALUE_CHANGED_SEL;

    public TraceValueObjectPropertyColumn(Class<T> propertyType) {
        this.propertyType = propertyType;
        this.comparator = this.newTypedComparator();
        this.renderer = this.createRenderer();
    }

    public GColumnRenderer<ObjectTableModel.ValueProperty<T>> createRenderer() {
        if (this.propertyType == Boolean.class) {
            return new BooleanPropertyRenderer();
        }
        return new PropertyRenderer();
    }

    public GColumnRenderer<ObjectTableModel.ValueProperty<T>> getColumnRenderer() {
        return this.renderer;
    }

    public Comparator<ObjectTableModel.ValueProperty<T>> getComparator(DynamicColumnTableModel<?> model, int columnIndex) {
        return this.comparator == null ? null : this.comparator.thenComparing((Comparator<ObjectTableModel.ValueProperty<T>>)new ColumnRenderedValueBackupComparator(model, columnIndex));
    }

    public abstract ObjectTableModel.ValueProperty<T> getProperty(ObjectTableModel.ValueRow var1);

    public ObjectTableModel.ValueProperty<T> getValue(ObjectTableModel.ValueRow rowObject, Settings settings, Trace data, ServiceProvider serviceProvider) throws IllegalArgumentException {
        return this.getProperty(rowObject);
    }

    protected <C extends Comparable<C>> Comparator<ObjectTableModel.ValueProperty<T>> newTypedComparator() {
        if (Comparable.class.isAssignableFrom(this.propertyType)) {
            Class<Comparable> cls = this.propertyType.asSubclass(Comparable.class);
            Function<ObjectTableModel.ValueProperty, Comparable> keyExtractor = r -> (Comparable)cls.cast(r.getValue());
            return Comparator.comparing(keyExtractor, new DefaultColumnComparator());
        }
        return null;
    }

    public void setDiffColor(Color diffColor) {
        this.diffColor = diffColor;
    }

    public void setDiffColorSel(Color diffColorSel) {
        this.diffColorSel = diffColorSel;
    }

    public class BooleanPropertyRenderer
    extends PropertyRenderer {
        protected GCheckBox cb;

        public BooleanPropertyRenderer() {
            this.setLayout(new BorderLayout());
            this.cb = new GCheckBox();
            this.cb.setHorizontalAlignment(0);
            this.cb.setOpaque(false);
            this.add((Component)this.cb);
        }

        @Override
        public Component getTableCellRendererComponent(GTableCellRenderingData data) {
            super.getTableCellRendererComponent(data);
            ObjectTableModel.ValueProperty property = (ObjectTableModel.ValueProperty)data.getValue();
            Object value = property.getValue();
            if (value instanceof Boolean) {
                Boolean b = (Boolean)value;
                this.cb.setVisible(true);
                this.cb.setSelected(b.booleanValue());
                this.setText("");
            } else {
                this.cb.setVisible(false);
            }
            return this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void validate() {
            Object object = this.getTreeLock();
            synchronized (object) {
                this.validateTree();
            }
        }
    }

    public class PropertyRenderer
    extends AbstractGColumnRenderer<ObjectTableModel.ValueProperty<T>>
    implements ColorsModified.InTable {
        public PropertyRenderer() {
            this.setHTMLRenderingEnabled(true);
        }

        public String getFilterString(ObjectTableModel.ValueProperty<T> p, Settings settings) {
            return p.getDisplay();
        }

        public Component getTableCellRendererComponent(GTableCellRenderingData data) {
            super.getTableCellRendererComponent(data);
            ObjectTableModel.ValueProperty p = (ObjectTableModel.ValueProperty)data.getValue();
            this.setText(p.getHtmlDisplay());
            this.setToolTipText(p.getToolTip());
            this.setForeground(this.getForegroundFor(data.getTable(), p.isModified(), data.isSelected()));
            if (p.getRow().isCurrent()) {
                this.setBold();
            }
            return this;
        }

        @Override
        public Color getDiffForeground(JTable p) {
            return TraceValueObjectPropertyColumn.this.diffColor;
        }

        @Override
        public Color getDiffSelForeground(JTable p) {
            return TraceValueObjectPropertyColumn.this.diffColorSel;
        }
    }
}

