/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.gui.diff;

import docking.ActionContext;
import docking.action.DockingAction;
import docking.action.ToggleDockingAction;
import docking.action.builder.ActionBuilder;
import docking.action.builder.ToggleActionBuilder;
import docking.widgets.fieldpanel.support.BackgroundColorModel;
import generic.theme.GColor;
import ghidra.app.plugin.core.codebrowser.MarkerServiceBackgroundColorModel;
import ghidra.app.plugin.core.debug.AbstractDebuggerPlugin;
import ghidra.app.plugin.core.debug.DebuggerCoordinates;
import ghidra.app.plugin.core.debug.event.TraceClosedPluginEvent;
import ghidra.app.plugin.core.debug.gui.DebuggerResources;
import ghidra.app.plugin.core.debug.gui.action.DebuggerTrackLocationTrait;
import ghidra.app.plugin.core.debug.gui.action.LocationTrackingSpec;
import ghidra.app.plugin.core.debug.gui.listing.MultiBlendedListingBackgroundColorModel;
import ghidra.app.plugin.core.debug.gui.time.DebuggerTimeSelectionDialog;
import ghidra.app.plugin.core.debug.utils.BackgroundUtils;
import ghidra.app.services.CoordinatedListingPanelListener;
import ghidra.app.services.DebuggerListingService;
import ghidra.app.services.DebuggerTraceManagerService;
import ghidra.app.services.MarkerService;
import ghidra.app.services.MarkerSet;
import ghidra.app.util.viewer.listingpanel.ListingBackgroundColorModel;
import ghidra.app.util.viewer.listingpanel.ListingPanel;
import ghidra.async.AsyncUtils;
import ghidra.framework.plugintool.PluginEvent;
import ghidra.framework.plugintool.PluginInfo;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.annotation.AutoServiceConsumed;
import ghidra.framework.plugintool.util.PluginStatus;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressIterator;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressRangeImpl;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.listing.Program;
import ghidra.program.util.ProgramLocation;
import ghidra.trace.model.Trace;
import ghidra.trace.model.memory.TraceMemoryManager;
import ghidra.trace.model.memory.TraceMemoryState;
import ghidra.trace.model.program.TraceProgramView;
import ghidra.trace.model.time.schedule.TraceSchedule;
import ghidra.util.Msg;
import java.awt.Color;
import java.nio.ByteBuffer;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.BiPredicate;
import java.util.function.Function;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

@PluginInfo(shortDescription="Compare memory state between times in a trace", description="Provides a side-by-side diff view between snapshots (points in time) in a trace. The comparison is limited to raw bytes.", category="Debugger", packageName="Debugger", status=PluginStatus.RELEASED, eventsConsumed={TraceClosedPluginEvent.class}, eventsProduced={}, servicesRequired={DebuggerListingService.class}, servicesProvided={})
public class DebuggerTraceViewDiffPlugin
extends AbstractDebuggerPlugin {
    static final Color COLOR_DIFF = new GColor("color.bg.highlight.listing.diff");
    protected static final String MARKER_NAME = "Trace Diff";
    protected static final String MARKER_DESCRIPTION = "Difference between snapshots in this trace";
    private DebuggerListingService listingService;
    @AutoServiceConsumed
    private DebuggerTraceManagerService traceManager;
    private MarkerService markerService;
    protected final DebuggerTimeSelectionDialog timeDialog;
    protected ToggleDockingAction actionCompare;
    protected DockingAction actionPrevDiff;
    protected DockingAction actionNextDiff;
    protected ListingPanel altListingPanel;
    protected final ForAltListingTrackingTrait trackingTrait;
    protected boolean sessionActive;
    protected final ListingCoordinationListener coordinationListener = new ListingCoordinationListener();
    protected final SyncAltListingTrackingSpecChangeListener syncTrackingSpecListener = new SyncAltListingTrackingSpecChangeListener();
    protected MultiBlendedListingBackgroundColorModel colorModel;
    protected final MarkerSetChangeListener markerChangeListener = new MarkerSetChangeListener();
    protected MarkerServiceBackgroundColorModel markerServiceColorModel;
    protected MarkerSet diffMarkersL;
    protected MarkerSet diffMarkersR;

    public DebuggerTraceViewDiffPlugin(PluginTool tool) {
        super(tool);
        this.timeDialog = new DebuggerTimeSelectionDialog(tool);
        this.trackingTrait = new ForAltListingTrackingTrait();
        this.createActions();
    }

    protected void createActions() {
        this.actionCompare = ((ToggleActionBuilder)((ToggleActionBuilder)((ToggleActionBuilder)DebuggerResources.CompareTimesAction.builder(this).enabled(false)).enabledWhen(ctx -> this.traceManager != null && this.traceManager.getCurrentTrace() != null)).onAction(this::activatedCompare)).build();
        this.actionPrevDiff = ((ActionBuilder)((ActionBuilder)((ActionBuilder)DebuggerResources.PrevDifferenceAction.builder(this).enabled(false)).enabledWhen(ctx -> this.hasPrevDiff())).onAction(ctx -> this.gotoPrevDiff())).build();
        this.actionNextDiff = ((ActionBuilder)((ActionBuilder)((ActionBuilder)DebuggerResources.NextDifferenceAction.builder(this).enabled(false)).enabledWhen(ctx -> this.hasNextDiff())).onAction(ctx -> this.gotoNextDiff())).build();
    }

    protected void activatedCompare(ActionContext ctx) {
        if (!this.actionCompare.isSelected()) {
            this.endComparison();
            return;
        }
        if (this.sessionActive) {
            return;
        }
        DebuggerCoordinates current = this.traceManager.getCurrent();
        TraceSchedule time = this.timeDialog.promptTime(current.getTrace(), current.getTime());
        if (time == null) {
            return;
        }
        if (this.traceManager == null) {
            return;
        }
        if (this.traceManager.getCurrentTrace() != current.getTrace()) {
            Msg.warn((Object)((Object)this), (Object)"Trace changed during time prompt. Aborting");
            return;
        }
        this.startComparison(time);
    }

    public CompletableFuture<Void> startComparison(TraceSchedule time) {
        this.sessionActive = true;
        this.actionCompare.setSelected(true);
        DebuggerCoordinates current = this.traceManager.getCurrent();
        DebuggerCoordinates alternate = this.traceManager.resolveTime(time);
        BackgroundUtils.PluginToolExecutorService toolExecutorService = new BackgroundUtils.PluginToolExecutorService(this.tool, "Computing diff", null, 500, BackgroundUtils.PluginToolExecutorService.TaskOpt.HAS_PROGRESS, BackgroundUtils.PluginToolExecutorService.TaskOpt.CAN_CANCEL);
        return ((CompletableFuture)((CompletableFuture)((CompletableFuture)this.traceManager.materialize(alternate).thenApplyAsync(snap -> {
            this.clearMarkers();
            TraceProgramView altView = alternate.getTrace().getFixedProgramView(snap.longValue());
            this.altListingPanel.setProgram((Program)altView);
            this.trackingTrait.goToCoordinates(alternate.view(altView));
            this.listingService.setListingPanel(this.altListingPanel);
            return altView;
        }, (Executor)AsyncUtils.SWING_EXECUTOR)).thenApplyAsync(altView -> this.computeDiff(current.getView(), (TraceProgramView)altView), (Executor)toolExecutorService)).thenAcceptAsync(diffSet -> {
            this.addMarkers((AddressSetView)diffSet);
            this.listingService.addLocalAction(this.actionNextDiff);
            this.listingService.addLocalAction(this.actionPrevDiff);
            this.updateActions();
        }, (Executor)AsyncUtils.SWING_EXECUTOR)).exceptionally(ex -> {
            Msg.showError((Object)((Object)this), null, (String)"Compare", (Object)"Could not compare trace snapshots/times", (Throwable)ex);
            return null;
        });
    }

    protected void updateActions() {
        this.actionNextDiff.setEnabled(this.actionNextDiff.isEnabledForContext(null));
        this.actionPrevDiff.setEnabled(this.actionPrevDiff.isEnabledForContext(null));
    }

    public boolean endComparison() {
        this.sessionActive = false;
        this.actionCompare.setSelected(false);
        this.clearMarkers();
        if (this.altListingPanel.getProgram() != null) {
            this.listingService.removeListingPanel(this.altListingPanel);
            this.altListingPanel.setProgram(null);
            this.listingService.removeLocalAction(this.actionNextDiff);
            this.listingService.removeLocalAction(this.actionPrevDiff);
            return true;
        }
        return false;
    }

    protected Address getCurrentAddress() {
        if (this.listingService == null) {
            return null;
        }
        ProgramLocation loc = this.listingService.getCurrentLocation();
        if (loc == null) {
            return null;
        }
        return loc.getAddress();
    }

    public AddressSetView getDiffs() {
        if (this.diffMarkersL == null) {
            return null;
        }
        return this.diffMarkersL.getAddressSet();
    }

    protected boolean hasSeqDiff(Function<AddressSetView, AddressRange> getExtremeRange, BiPredicate<AddressRange, Address> checkRange) {
        Address cur = this.getCurrentAddress();
        if (cur == null) {
            return false;
        }
        AddressSetView set = this.getDiffs();
        if (set == null) {
            return false;
        }
        AddressRange extreme = getExtremeRange.apply(set);
        if (extreme == null) {
            return false;
        }
        return checkRange.test(extreme, cur);
    }

    public boolean hasPrevDiff() {
        return this.hasSeqDiff(AddressSetView::getFirstRange, (first, cur) -> first.getMaxAddress().compareTo(cur) < 0);
    }

    public boolean hasNextDiff() {
        return this.hasSeqDiff(AddressSetView::getLastRange, (last, cur) -> cur.compareTo((Object)last.getMinAddress()) < 0);
    }

    protected Address getSeqDiff(boolean forward, Function<AddressRange, Address> getFarthestAddress, Function<Address, Address> getStepped) {
        Address cur = this.getCurrentAddress();
        if (cur == null) {
            return null;
        }
        AddressSetView set = this.getDiffs();
        if (set == null) {
            return null;
        }
        AddressRange range = set.getRangeContaining(cur);
        if (range != null) {
            cur = getFarthestAddress.apply(range);
        }
        if ((cur = getStepped.apply(cur)) == null) {
            return null;
        }
        AddressIterator it = set.getAddresses(cur, forward);
        if (!it.hasNext()) {
            return null;
        }
        return it.next();
    }

    public Address getPrevDiff() {
        return this.getSeqDiff(false, AddressRange::getMinAddress, Address::previous);
    }

    public Address getNextDiff() {
        return this.getSeqDiff(true, AddressRange::getMaxAddress, Address::next);
    }

    public boolean gotoPrevDiff() {
        Address prevDiff = this.getPrevDiff();
        if (prevDiff == null) {
            return false;
        }
        return this.listingService.goTo(prevDiff, true) && this.altListingPanel.goTo(prevDiff);
    }

    public boolean gotoNextDiff() {
        Address nextDiff = this.getNextDiff();
        if (nextDiff == null) {
            return false;
        }
        return this.listingService.goTo(nextDiff, true) && this.altListingPanel.goTo(nextDiff);
    }

    protected void injectOnListingService() {
        if (this.listingService != null) {
            this.listingService.addLocalAction((DockingAction)this.actionCompare);
            this.altListingPanel = new ListingPanel(this.listingService.getFormatManager());
            this.listingService.setCoordinatedListingPanelListener(this.coordinationListener);
            this.listingService.addTrackingSpecChangeListener(this.syncTrackingSpecListener);
            this.colorModel = this.listingService.createListingBackgroundColorModel(this.altListingPanel);
            this.colorModel.addModel((BackgroundColorModel)this.trackingTrait.createListingBackgroundColorModel(this.altListingPanel));
            this.altListingPanel.setBackgroundColorModel((ListingBackgroundColorModel)this.colorModel);
            this.updateMarkerServiceColorModel();
        }
    }

    protected void ejectFromListingService() {
        if (this.altListingPanel != null) {
            this.altListingPanel.dispose();
            this.altListingPanel = null;
        }
        this.colorModel = null;
        if (this.listingService != null) {
            this.listingService.removeLocalAction((DockingAction)this.actionCompare);
            this.listingService.setCoordinatedListingPanelListener(null);
            this.listingService.removeTrackingSpecChangeListener(this.syncTrackingSpecListener);
        }
    }

    @AutoServiceConsumed
    private void setListingService(DebuggerListingService listingService) {
        this.ejectFromListingService();
        this.listingService = listingService;
        this.injectOnListingService();
    }

    protected void updateMarkerServiceColorModel() {
        if (this.colorModel == null) {
            return;
        }
        this.colorModel.removeModel((BackgroundColorModel)this.markerServiceColorModel);
        if (this.markerService != null && this.altListingPanel != null) {
            this.markerServiceColorModel = new MarkerServiceBackgroundColorModel(this.markerService, this.altListingPanel.getProgram(), this.altListingPanel.getAddressIndexMap());
            this.colorModel.addModel((BackgroundColorModel)this.markerServiceColorModel);
        }
    }

    protected void createMarkers() {
        if (this.diffMarkersL != null) {
            return;
        }
        if (this.markerService == null) {
            this.diffMarkersL = null;
            this.diffMarkersR = null;
            return;
        }
        if (this.altListingPanel == null) {
            this.diffMarkersL = null;
            this.diffMarkersR = null;
            return;
        }
        Program viewR = this.altListingPanel.getProgram();
        if (viewR == null) {
            this.diffMarkersR = null;
            this.diffMarkersL = null;
            return;
        }
        TraceProgramView viewL = this.traceManager.getCurrentView();
        this.diffMarkersL = this.markerService.createAreaMarker(MARKER_NAME, MARKER_DESCRIPTION, (Program)viewL, 0, true, true, true, COLOR_DIFF, true);
        this.diffMarkersR = this.markerService.createAreaMarker(MARKER_NAME, MARKER_DESCRIPTION, viewR, 0, true, true, true, COLOR_DIFF, true);
    }

    protected void addMarkers(AddressSetView diffSet) {
        this.createMarkers();
        if (this.diffMarkersL != null) {
            this.diffMarkersL.add(diffSet);
        }
        if (this.diffMarkersR != null) {
            this.diffMarkersR.add(diffSet);
        }
    }

    protected void clearMarkers() {
        if (this.diffMarkersL != null) {
            this.diffMarkersL.clearAll();
        }
        if (this.diffMarkersR != null) {
            this.diffMarkersR.clearAll();
        }
    }

    protected void deleteMarkers() {
        if (this.diffMarkersL == null) {
            return;
        }
        if (this.markerService == null) {
            return;
        }
        if (this.altListingPanel == null) {
            return;
        }
        Program altView = this.altListingPanel.getProgram();
        if (altView == null) {
            return;
        }
        this.markerService.removeMarker(this.diffMarkersL, altView);
        this.markerService.removeMarker(this.diffMarkersR, altView);
    }

    @AutoServiceConsumed
    private void setMarkerService(MarkerService markerService) {
        if (this.markerService != null) {
            this.markerService.removeChangeListener((ChangeListener)this.markerChangeListener);
            this.deleteMarkers();
        }
        this.markerService = markerService;
        this.updateMarkerServiceColorModel();
        if (this.markerService != null) {
            this.markerService.addChangeListener((ChangeListener)this.markerChangeListener);
        }
    }

    public void processEvent(PluginEvent event) {
        super.processEvent(event);
        if (event instanceof TraceClosedPluginEvent) {
            TraceClosedPluginEvent evt = (TraceClosedPluginEvent)event;
            if (this.timeDialog.getTrace() == evt.getTrace()) {
                this.timeDialog.close();
            }
        }
    }

    public static int lenRemainsBlock(int blockSize, long off) {
        return blockSize - (int)(off % (long)blockSize);
    }

    public static long minOfBlock(int blockSize, long off) {
        return off / (long)blockSize * (long)blockSize;
    }

    public static long maxOfBlock(int blockSize, long off) {
        return (off + (long)blockSize - 1L) / (long)blockSize * (long)blockSize - 1L;
    }

    public static Address maxOfBlock(int blockSize, Address address) {
        long off = address.getOffset();
        long max = DebuggerTraceViewDiffPlugin.maxOfBlock(blockSize, off);
        AddressSpace space = address.getAddressSpace();
        return space.getAddress(max);
    }

    public static AddressRange blockFor(int blockSize, Address address) {
        long off = address.getOffset();
        long min = DebuggerTraceViewDiffPlugin.minOfBlock(blockSize, off);
        long max = DebuggerTraceViewDiffPlugin.maxOfBlock(blockSize, off);
        AddressSpace space = address.getAddressSpace();
        return new AddressRangeImpl(space.getAddress(min), space.getAddress(max));
    }

    protected AddressSetView computeDiff(TraceProgramView view1, TraceProgramView view2) {
        long snap2;
        Trace trace = view1.getTrace();
        assert (trace == view2.getTrace());
        long snap1 = view1.getSnap();
        if (snap1 == (snap2 = view2.getSnap())) {
            return new AddressSet();
        }
        TraceMemoryManager mm = trace.getMemoryManager();
        AddressSetView known1 = mm.getAddressesWithState(snap1, s -> s == TraceMemoryState.KNOWN);
        AddressSetView known2 = mm.getAddressesWithState(snap2, s -> s == TraceMemoryState.KNOWN);
        AddressSet knownBoth = known1.intersect(known2);
        AddressSet diff = new AddressSet();
        int blockSize = mm.getBlockSize();
        if (blockSize == 0) {
            throw new UnsupportedOperationException("TODO: Unoptimized byte diff");
        }
        ByteBuffer buf1 = ByteBuffer.allocate(blockSize);
        ByteBuffer buf2 = ByteBuffer.allocate(blockSize);
        while (!knownBoth.isEmpty()) {
            Long mrs2;
            Address next = knownBoth.getMinAddress();
            Long mrs1 = mm.getSnapOfMostRecentChangeToBlock(snap1, next);
            if (Objects.equals(mrs1, mrs2 = mm.getSnapOfMostRecentChangeToBlock(snap2, next))) {
                knownBoth.delete(DebuggerTraceViewDiffPlugin.blockFor(blockSize, next));
                continue;
            }
            int len = DebuggerTraceViewDiffPlugin.lenRemainsBlock(blockSize, next.getOffset());
            buf1.clear();
            buf1.limit(len);
            if (len != mm.getBytes(snap1, next, buf1)) {
                throw new AssertionError((Object)"Read failed");
            }
            buf2.clear();
            buf2.limit(len);
            if (len != mm.getBytes(snap2, next, buf2)) {
                throw new AssertionError((Object)"Read failed");
            }
            this.compareBytes(diff, next, buf1, buf2);
            knownBoth.delete(DebuggerTraceViewDiffPlugin.blockFor(blockSize, next));
        }
        return diff;
    }

    protected void compareBytes(AddressSet diff, Address addr, ByteBuffer buf1, ByteBuffer buf2) {
        int len = buf1.limit();
        byte[] arr1 = buf1.array();
        byte[] arr2 = buf2.array();
        Address rngStart = null;
        for (int i = 0; i < len; ++i) {
            if (arr1[i] != arr2[i]) {
                if (rngStart != null) continue;
                rngStart = addr.add((long)i);
                continue;
            }
            if (rngStart == null) continue;
            diff.add(rngStart, addr.add((long)(i - 1)));
            rngStart = null;
        }
        if (rngStart != null) {
            diff.add(rngStart, addr.add((long)(len - 1)));
        }
    }

    protected class ListingCoordinationListener
    implements CoordinatedListingPanelListener {
        protected ListingCoordinationListener() {
        }

        public boolean listingClosed() {
            return DebuggerTraceViewDiffPlugin.this.endComparison();
        }

        public void activeProgramChanged(Program activeProgram) {
            DebuggerTraceViewDiffPlugin.this.endComparison();
        }
    }

    protected class SyncAltListingTrackingSpecChangeListener
    implements DebuggerListingService.LocationTrackingSpecChangeListener {
        protected SyncAltListingTrackingSpecChangeListener() {
        }

        @Override
        public void locationTrackingSpecChanged(LocationTrackingSpec spec) {
            DebuggerTraceViewDiffPlugin.this.trackingTrait.setSpec(spec);
        }
    }

    protected class MarkerSetChangeListener
    implements ChangeListener {
        protected MarkerSetChangeListener() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            if (DebuggerTraceViewDiffPlugin.this.altListingPanel == null) {
                return;
            }
            DebuggerTraceViewDiffPlugin.this.altListingPanel.getFieldPanel().repaint();
        }
    }

    protected class ForAltListingTrackingTrait
    extends DebuggerTrackLocationTrait {
        public ForAltListingTrackingTrait() {
            super(DebuggerTraceViewDiffPlugin.this.getTool(), DebuggerTraceViewDiffPlugin.this, null);
        }

        @Override
        protected void locationTracked() {
            if (DebuggerTraceViewDiffPlugin.this.altListingPanel == null) {
                return;
            }
            DebuggerTraceViewDiffPlugin.this.altListingPanel.getFieldPanel().repaint();
        }
    }
}

