/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.gui.action;

import ghidra.app.plugin.core.debug.DebuggerCoordinates;
import ghidra.app.plugin.core.debug.gui.action.GoToInput;
import ghidra.app.plugin.core.debug.gui.action.LocationTracker;
import ghidra.app.plugin.core.debug.gui.action.LocationTrackingSpec;
import ghidra.framework.plugintool.PluginTool;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.lang.Register;
import ghidra.program.model.lang.RegisterValue;
import ghidra.program.util.ProgramLocation;
import ghidra.trace.model.Trace;
import ghidra.trace.model.TraceAddressSnapRange;
import ghidra.trace.model.guest.TracePlatform;
import ghidra.trace.model.memory.TraceMemorySpace;
import ghidra.trace.model.memory.TraceMemoryState;
import ghidra.trace.model.stack.TraceStack;
import ghidra.trace.model.thread.TraceThread;
import ghidra.trace.util.TraceAddressSpace;
import java.util.concurrent.CompletableFuture;

public interface RegisterLocationTrackingSpec
extends LocationTrackingSpec,
LocationTracker {
    public Register computeRegister(DebuggerCoordinates var1);

    public AddressSpace computeDefaultAddressSpace(DebuggerCoordinates var1);

    @Override
    default public String computeTitle(DebuggerCoordinates coordinates) {
        Register register = this.computeRegister(coordinates);
        if (register == null) {
            return null;
        }
        return register.getName();
    }

    @Override
    default public LocationTracker getTracker() {
        return this;
    }

    default public Address doComputeTraceAddress(PluginTool tool, DebuggerCoordinates coordinates) {
        Trace trace = coordinates.getTrace();
        TracePlatform platform = coordinates.getPlatform();
        TraceThread thread = coordinates.getThread();
        long viewSnap = coordinates.getViewSnap();
        long snap = coordinates.getSnap();
        int frame = coordinates.getFrame();
        Register reg = this.computeRegister(coordinates);
        if (reg == null) {
            return null;
        }
        if (!thread.getLifespan().contains(snap)) {
            return null;
        }
        TraceMemorySpace regs = trace.getMemoryManager().getMemoryRegisterSpace(thread, frame, false);
        if (regs == null) {
            return null;
        }
        RegisterValue value = regs.getState(platform, viewSnap, reg) == TraceMemoryState.KNOWN ? regs.getValue(platform, viewSnap, reg) : regs.getValue(platform, snap, reg);
        if (value == null) {
            return null;
        }
        return platform.mapGuestToHost(this.computeDefaultAddressSpace(coordinates).getAddress(value.getUnsignedValue().longValue(), true));
    }

    @Override
    default public CompletableFuture<Address> computeTraceAddress(PluginTool tool, DebuggerCoordinates coordinates) {
        return CompletableFuture.supplyAsync(() -> this.doComputeTraceAddress(tool, coordinates));
    }

    @Override
    default public GoToInput getDefaultGoToInput(PluginTool tool, DebuggerCoordinates coordinates, ProgramLocation location) {
        Register register = this.computeRegister(coordinates);
        return GoToInput.offsetOnly(register.getName());
    }

    @Override
    default public boolean affectedByBytesChange(TraceAddressSpace space, TraceAddressSnapRange range, DebuggerCoordinates coordinates) {
        if (!LocationTrackingSpec.changeIsCurrent(space, range, coordinates)) {
            return false;
        }
        Register register = this.computeRegister(coordinates);
        if (register == null) {
            return false;
        }
        AddressSpace as = space.getAddressSpace();
        AddressRange regRng = coordinates.getPlatform().getConventionalRegisterRange((AddressSpace)(as.isRegisterSpace() ? as : null), register);
        return range.getRange().intersects(regRng);
    }

    @Override
    default public boolean affectedByStackChange(TraceStack stack, DebuggerCoordinates coordinates) {
        return false;
    }
}

