/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.decompile.actions;

import docking.action.MenuData;
import ghidra.app.plugin.core.decompile.DecompilerActionContext;
import ghidra.app.plugin.core.decompile.actions.AbstractDecompilerAction;
import ghidra.program.model.listing.Program;
import ghidra.program.model.pcode.HighFunction;
import ghidra.program.model.pcode.HighFunctionDBUtil;
import ghidra.program.model.symbol.SourceType;
import ghidra.util.HelpLocation;

public class CommitLocalsAction
extends AbstractDecompilerAction {
    public CommitLocalsAction() {
        super("Commit Locals");
        this.setHelpLocation(new HelpLocation("DecompilePlugin", "ActionCommitLocals"));
        this.setPopupMenuData(new MenuData(new String[]{"Commit Local Names"}, "Commit"));
        this.setDescription("Save Local variable names from Decompiler window to Program");
    }

    @Override
    protected boolean isEnabledForDecompilerContext(DecompilerActionContext context) {
        if (!context.hasRealFunction()) {
            return false;
        }
        return context.getHighFunction() != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void decompilerActionPerformed(DecompilerActionContext context) {
        Program program = context.getProgram();
        int transaction = program.startTransaction("Commit Local Names");
        try {
            HighFunction hfunc = context.getHighFunction();
            HighFunctionDBUtil.commitLocalNamesToDatabase((HighFunction)hfunc, (SourceType)SourceType.USER_DEFINED);
        }
        finally {
            program.endTransaction(transaction, true);
        }
    }
}

