/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.decompiler.component.hover;

import docking.widgets.fieldpanel.field.Field;
import docking.widgets.fieldpanel.support.FieldLocation;
import ghidra.app.decompiler.ClangFieldToken;
import ghidra.app.decompiler.ClangToken;
import ghidra.app.decompiler.component.ClangTextField;
import ghidra.app.decompiler.component.DecompilerUtils;
import ghidra.app.decompiler.component.hover.DecompilerHoverService;
import ghidra.app.plugin.core.datamgr.util.DataTypeUtils;
import ghidra.app.plugin.core.hover.AbstractConfigurableHover;
import ghidra.app.util.ToolTipUtils;
import ghidra.framework.plugintool.PluginTool;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeComponent;
import ghidra.program.model.data.Structure;
import ghidra.program.model.listing.Program;
import ghidra.program.util.ProgramLocation;
import ghidra.util.HTMLUtilities;
import ghidra.util.NumericUtilities;
import javax.swing.JComponent;

public class DataTypeDecompilerHover
extends AbstractConfigurableHover
implements DecompilerHoverService {
    private static final String NAME = "Data Type Display";
    private static final String DESCRIPTION = "Show data type contents when hovering over a type name.";
    private static final int PRIORITY = 20;

    protected DataTypeDecompilerHover(PluginTool tool) {
        super(tool, 20);
    }

    protected String getName() {
        return NAME;
    }

    protected String getDescription() {
        return DESCRIPTION;
    }

    protected String getOptionsCategory() {
        return "Decompiler Popups";
    }

    public JComponent getHoverComponent(Program program, ProgramLocation programLocation, FieldLocation fieldLocation, Field field) {
        if (!this.enabled) {
            return null;
        }
        if (!(field instanceof ClangTextField)) {
            return null;
        }
        ClangToken token = ((ClangTextField)field).getToken(fieldLocation);
        DataType dt = DecompilerUtils.getDataType(token);
        if (dt == null) {
            return null;
        }
        String toolTipText = null;
        toolTipText = token instanceof ClangFieldToken ? this.createFieldToolTipText((ClangFieldToken)token, dt) : ToolTipUtils.getToolTipText((DataType)dt);
        return this.createTooltipComponent(toolTipText);
    }

    private String createFieldToolTipText(ClangFieldToken token, DataType parentType) {
        ClangFieldToken fieldToken = token;
        int offset = fieldToken.getOffset();
        DataType fieldType = DataTypeDecompilerHover.getFieldDataType(fieldToken);
        StringBuilder buffy = new StringBuilder("<HTML>");
        buffy.append("<TABLE>");
        buffy.append(this.row("Parent: ", HTMLUtilities.friendlyEncodeHTML((String)parentType.getName())));
        buffy.append(this.row("Offset: ", NumericUtilities.toHexString((long)offset)));
        buffy.append(this.row("Field Name: ", HTMLUtilities.friendlyEncodeHTML((String)token.getText())));
        buffy.append("</TABLE>");
        if (fieldType != null) {
            buffy.append("<BR>").append("<HR WIDTH=\"95%\">").append("<BR>");
            buffy.append(ToolTipUtils.getHTMLRepresentation((DataType)fieldType).getFullHTMLContentString());
        }
        return buffy.toString();
    }

    private String row(String ... cols) {
        StringBuilder sb = new StringBuilder("<TR>");
        for (String col : cols) {
            sb.append("<TD>").append(col).append("</TD>");
        }
        sb.append("</TR>");
        return sb.toString();
    }

    public static DataType getFieldDataType(ClangFieldToken field) {
        DataType fieldDt = DataTypeUtils.getBaseDataType((DataType)field.getDataType());
        if (fieldDt instanceof Structure) {
            Structure parent = (Structure)fieldDt;
            int offset = field.getOffset();
            int n = parent.getLength();
            if (offset >= 0 && offset < n) {
                DataTypeComponent dtc = parent.getComponentAt(offset);
                if (dtc == null) {
                    return null;
                }
                fieldDt = dtc.getDataType();
            }
        }
        return fieldDt;
    }
}

