/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.elf.relocation;

import ghidra.app.util.bin.format.elf.ElfHeader;
import ghidra.app.util.bin.format.elf.ElfLoadHelper;
import ghidra.app.util.bin.format.elf.ElfRelocation;
import ghidra.app.util.bin.format.elf.ElfSymbol;
import ghidra.app.util.bin.format.elf.relocation.ElfRelocationContext;
import ghidra.app.util.bin.format.elf.relocation.ElfRelocationHandler;
import ghidra.app.util.bin.format.elf.relocation.X86_64_ElfRelocationContext;
import ghidra.app.util.importer.MessageLog;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.Memory;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.program.model.reloc.Relocation;
import ghidra.program.model.reloc.RelocationResult;
import ghidra.util.exception.NotFoundException;
import java.util.Map;

public class X86_64_ElfRelocationHandler
extends ElfRelocationHandler {
    public boolean canRelocate(ElfHeader elf) {
        return elf.e_machine() == 62;
    }

    public int getRelrRelocationType() {
        return 8;
    }

    public X86_64_ElfRelocationContext createRelocationContext(ElfLoadHelper loadHelper, Map<ElfSymbol, Address> symbolMap) {
        return new X86_64_ElfRelocationContext(this, loadHelper, symbolMap);
    }

    public RelocationResult relocate(ElfRelocationContext elfRelocationContext, ElfRelocation relocation, Address relocationAddress) throws MemoryAccessException, NotFoundException {
        ElfHeader elf = elfRelocationContext.getElfHeader();
        if (elf.e_machine() != 62) {
            return RelocationResult.FAILURE;
        }
        Program program = elfRelocationContext.getProgram();
        Memory memory = program.getMemory();
        X86_64_ElfRelocationContext x86RelocationContext = (X86_64_ElfRelocationContext)elfRelocationContext;
        int type = relocation.getType();
        if (type == 0) {
            return RelocationResult.SKIPPED;
        }
        int symbolIndex = relocation.getSymbolIndex();
        long addend = relocation.hasAddend() ? relocation.getAddend() : memory.getLong(relocationAddress);
        ElfSymbol sym = elfRelocationContext.getSymbol(symbolIndex);
        Address symbolAddr = elfRelocationContext.getSymbolAddress(sym);
        long symbolValue = elfRelocationContext.getSymbolValue(sym);
        String symbolName = elfRelocationContext.getSymbolName(symbolIndex);
        long symbolSize = sym.getSize();
        long offset = relocationAddress.getOffset();
        int byteLength = 8;
        switch (type) {
            case 5: {
                X86_64_ElfRelocationHandler.markAsWarning((Program)program, (Address)relocationAddress, (String)"R_X86_64_COPY", (String)symbolName, (long)symbolIndex, (String)"Runtime copy not supported", (MessageLog)elfRelocationContext.getLog());
                return RelocationResult.UNSUPPORTED;
            }
            case 1: {
                long value = symbolValue + addend;
                memory.setLong(relocationAddress, value);
                if (symbolIndex == 0 || addend == 0L || sym.isSection()) break;
                X86_64_ElfRelocationHandler.warnExternalOffsetRelocation((Program)program, (Address)relocationAddress, (Address)symbolAddr, (String)symbolName, (long)addend, (MessageLog)elfRelocationContext.getLog());
                X86_64_ElfRelocationHandler.applyComponentOffsetPointer((Program)program, (Address)relocationAddress, (long)addend);
                break;
            }
            case 12: {
                long value = symbolValue + addend;
                memory.setShort(relocationAddress, (short)(value &= 0xFFFFL));
                byteLength = 2;
                break;
            }
            case 14: {
                long value = symbolValue + addend;
                memory.setByte(relocationAddress, (byte)(value &= 0xFFL));
                byteLength = 1;
                break;
            }
            case 2: {
                long value = symbolValue + addend - offset;
                memory.setInt(relocationAddress, (int)(value &= 0xFFFFFFFFFFFFFFFFL));
                byteLength = 4;
                break;
            }
            case 13: {
                long value = symbolValue + addend - offset;
                memory.setShort(relocationAddress, (short)(value &= 0xFFFFL));
                byteLength = 2;
                break;
            }
            case 15: {
                long value = symbolValue + addend - offset;
                memory.setByte(relocationAddress, (byte)(value &= 0xFFL));
                byteLength = 1;
                break;
            }
            case 3: {
                long value = symbolValue + addend;
                memory.setInt(relocationAddress, (int)value);
                byteLength = 4;
                break;
            }
            case 4: {
                long value = symbolValue + addend - offset;
                memory.setInt(relocationAddress, (int)value);
                byteLength = 4;
                break;
            }
            case 6: 
            case 7: {
                long value = symbolValue + addend;
                memory.setLong(relocationAddress, value);
                break;
            }
            case 25: {
                try {
                    long dotgot = elfRelocationContext.getGOTValue();
                    long value = symbolValue + addend - dotgot;
                    memory.setLong(relocationAddress, value);
                }
                catch (NotFoundException e) {
                    X86_64_ElfRelocationHandler.markAsError((Program)program, (Address)relocationAddress, (String)"R_X86_64_GOTOFF64", (String)symbolName, (String)e.getMessage(), (MessageLog)elfRelocationContext.getLog());
                }
                break;
            }
            case 10: 
            case 11: {
                long value = (symbolValue += addend) & 0xFFFFFFFFFFFFFFFFL;
                memory.setInt(relocationAddress, (int)value);
                byteLength = 4;
                break;
            }
            case 32: {
                long value = symbolSize + addend;
                memory.setInt(relocationAddress, (int)(value &= 0xFFFFFFFFFFFFFFFFL));
                byteLength = 4;
                break;
            }
            case 33: {
                long value = symbolSize + addend;
                memory.setLong(relocationAddress, value);
                break;
            }
            case 16: {
                X86_64_ElfRelocationHandler.markAsWarning((Program)program, (Address)relocationAddress, (String)"R_X86_64_DTPMOD64", (String)symbolName, (long)symbolIndex, (String)"Thread Local Symbol relocation not supported", (MessageLog)elfRelocationContext.getLog());
                return RelocationResult.UNSUPPORTED;
            }
            case 17: {
                X86_64_ElfRelocationHandler.markAsWarning((Program)program, (Address)relocationAddress, (String)"R_X86_64_DTPOFF64", (String)symbolName, (long)symbolIndex, (String)"Thread Local Symbol relocation not supported", (MessageLog)elfRelocationContext.getLog());
                return RelocationResult.UNSUPPORTED;
            }
            case 18: {
                X86_64_ElfRelocationHandler.markAsWarning((Program)program, (Address)relocationAddress, (String)"R_X86_64_TPOFF64", (String)symbolName, (long)symbolIndex, (String)"Thread Local Symbol relocation not supported", (MessageLog)elfRelocationContext.getLog());
                return RelocationResult.UNSUPPORTED;
            }
            case 36: {
                X86_64_ElfRelocationHandler.markAsWarning((Program)program, (Address)relocationAddress, (String)"R_X86_64_TLSDESC", (String)symbolName, (long)symbolIndex, (String)"Thread Local Symbol relocation not supported", (MessageLog)elfRelocationContext.getLog());
                return RelocationResult.UNSUPPORTED;
            }
            case 26: {
                try {
                    long dotgot = elfRelocationContext.getGOTValue();
                    long value = dotgot + addend - offset;
                    memory.setInt(relocationAddress, (int)value);
                    byteLength = 4;
                }
                catch (NotFoundException e) {
                    X86_64_ElfRelocationHandler.markAsError((Program)program, (Address)relocationAddress, (String)"R_X86_64_GOTPC32", (String)symbolName, (String)e.getMessage(), (MessageLog)elfRelocationContext.getLog());
                }
                break;
            }
            case 41: 
            case 42: {
                Address opAddr = relocationAddress.subtract(2L);
                Address modRMAddr = relocationAddress.subtract(1L);
                Address directValueAddr = null;
                byte op = memory.getByte(opAddr);
                byte modRM = memory.getByte(modRMAddr);
                byte symbolType = sym.getType();
                if (symbolType >= 0 && symbolType <= 5) {
                    if (op == -117) {
                        elfRelocationContext.getLoadHelper().addArtificialRelocTableEntry(opAddr, 2);
                        memory.setByte(opAddr, (byte)-115);
                        directValueAddr = relocationAddress;
                    } else if (op == -1) {
                        if (modRM == 37) {
                            elfRelocationContext.getLoadHelper().addArtificialRelocTableEntry(opAddr, 2);
                            memory.setByte(opAddr, (byte)-23);
                            memory.setByte(relocationAddress.add(3L), (byte)-112);
                            directValueAddr = modRMAddr;
                            ++addend;
                        } else if (modRM == 21) {
                            elfRelocationContext.getLoadHelper().addArtificialRelocTableEntry(opAddr, 2);
                            memory.setByte(opAddr, (byte)103);
                            memory.setByte(modRMAddr, (byte)-24);
                            directValueAddr = relocationAddress;
                        }
                    }
                }
                if (directValueAddr != null) {
                    long value = symbolValue + addend - offset;
                    memory.setInt(directValueAddr, (int)value);
                    byteLength = 4;
                    break;
                }
            }
            case 9: {
                Address symbolGotAddress = x86RelocationContext.getGotEntryAddress(symbolValue);
                if (symbolGotAddress == null) {
                    X86_64_ElfRelocationHandler.markAsError((Program)program, (Address)relocationAddress, (long)type, (String)symbolName, (String)"GOT allocation failure", (MessageLog)elfRelocationContext.getLog());
                    break;
                }
                long value = symbolGotAddress.getOffset() + addend - offset;
                memory.setInt(relocationAddress, (int)value);
                byteLength = 4;
                break;
            }
            case 28: {
                Address symbolGotAddress = x86RelocationContext.getGotEntryAddress(symbolValue);
                if (symbolGotAddress == null) {
                    X86_64_ElfRelocationHandler.markAsError((Program)program, (Address)relocationAddress, (String)"R_X86_64_GOTPCREL64", (String)symbolName, (String)"GOT allocation failure", (MessageLog)elfRelocationContext.getLog());
                    break;
                }
                long value = symbolGotAddress.getOffset() + addend - offset;
                memory.setLong(relocationAddress, value);
            }
            case 8: 
            case 38: {
                long imageBaseAdjustment = elfRelocationContext.getImageBaseWordAdjustmentOffset();
                long value = elf.isPreLinked() ? memory.getLong(relocationAddress) + imageBaseAdjustment : addend + imageBaseAdjustment;
                memory.setLong(relocationAddress, value);
                break;
            }
            case 37: {
                long value = addend + elfRelocationContext.getImageBaseWordAdjustmentOffset();
                memory.setLong(relocationAddress, value);
                break;
            }
            default: {
                X86_64_ElfRelocationHandler.markAsUnhandled((Program)program, (Address)relocationAddress, (long)type, (long)symbolIndex, (String)symbolName, (MessageLog)elfRelocationContext.getLog());
                return RelocationResult.UNSUPPORTED;
            }
        }
        return new RelocationResult(Relocation.Status.APPLIED, byteLength);
    }
}

