/*
 * Decompiled with CFR 0.152.
 */
package ghidra.trace.database.target;

import db.DBRecord;
import db.StringField;
import ghidra.dbg.target.TargetObject;
import ghidra.dbg.target.schema.TargetObjectSchema;
import ghidra.dbg.util.PathMatcher;
import ghidra.dbg.util.PathPredicates;
import ghidra.dbg.util.PathUtils;
import ghidra.program.model.address.AddressSpace;
import ghidra.trace.database.DBTrace;
import ghidra.trace.database.breakpoint.DBTraceObjectBreakpointLocation;
import ghidra.trace.database.breakpoint.DBTraceObjectBreakpointSpec;
import ghidra.trace.database.map.DBTraceAddressSnapRangePropertyMapSpace;
import ghidra.trace.database.map.DBTraceAddressSnapRangePropertyMapTree;
import ghidra.trace.database.memory.DBTraceObjectMemoryRegion;
import ghidra.trace.database.memory.DBTraceObjectRegister;
import ghidra.trace.database.module.DBTraceObjectModule;
import ghidra.trace.database.module.DBTraceObjectSection;
import ghidra.trace.database.module.TraceObjectSection;
import ghidra.trace.database.stack.DBTraceObjectStack;
import ghidra.trace.database.stack.DBTraceObjectStackFrame;
import ghidra.trace.database.target.DBTraceObjectAddressRangeValue;
import ghidra.trace.database.target.DBTraceObjectInterface;
import ghidra.trace.database.target.DBTraceObjectManager;
import ghidra.trace.database.target.DBTraceObjectValPath;
import ghidra.trace.database.target.DBTraceObjectValue;
import ghidra.trace.database.target.InternalTraceObjectValue;
import ghidra.trace.database.target.visitors.AllPathsVisitor;
import ghidra.trace.database.target.visitors.AncestorsRelativeVisitor;
import ghidra.trace.database.target.visitors.AncestorsRootVisitor;
import ghidra.trace.database.target.visitors.CanonicalSuccessorsRelativeVisitor;
import ghidra.trace.database.target.visitors.OrderedSuccessorsVisitor;
import ghidra.trace.database.target.visitors.SuccessorsRelativeVisitor;
import ghidra.trace.database.target.visitors.TreeTraversal;
import ghidra.trace.database.thread.DBTraceObjectThread;
import ghidra.trace.model.Lifespan;
import ghidra.trace.model.Trace;
import ghidra.trace.model.breakpoint.TraceObjectBreakpointLocation;
import ghidra.trace.model.breakpoint.TraceObjectBreakpointSpec;
import ghidra.trace.model.memory.TraceObjectMemoryRegion;
import ghidra.trace.model.memory.TraceObjectRegister;
import ghidra.trace.model.modules.TraceObjectModule;
import ghidra.trace.model.stack.TraceObjectStack;
import ghidra.trace.model.stack.TraceObjectStackFrame;
import ghidra.trace.model.target.DuplicateKeyException;
import ghidra.trace.model.target.TraceObject;
import ghidra.trace.model.target.TraceObjectInterface;
import ghidra.trace.model.target.TraceObjectKeyPath;
import ghidra.trace.model.target.TraceObjectValPath;
import ghidra.trace.model.target.TraceObjectValue;
import ghidra.trace.model.target.annot.TraceObjectInterfaceUtils;
import ghidra.trace.model.thread.TraceObjectThread;
import ghidra.trace.util.TraceChangeRecord;
import ghidra.util.LockHold;
import ghidra.util.Msg;
import ghidra.util.StreamUtils;
import ghidra.util.database.DBAnnotatedObject;
import ghidra.util.database.DBCachedObjectIndex;
import ghidra.util.database.DBCachedObjectStore;
import ghidra.util.database.DBCachedObjectStoreFactory;
import ghidra.util.database.DBObjectColumn;
import ghidra.util.database.annot.DBAnnotatedColumn;
import ghidra.util.database.annot.DBAnnotatedField;
import ghidra.util.database.annot.DBAnnotatedObjectInfo;
import ghidra.util.database.spatial.rect.Rectangle2DDirection;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.Spliterator;
import java.util.concurrent.locks.Lock;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

@DBAnnotatedObjectInfo(version=0)
public class DBTraceObject
extends DBAnnotatedObject
implements TraceObject {
    protected static final String TABLE_NAME = "Objects";
    protected static final Map<Class<? extends TraceObjectInterface>, Function<DBTraceObject, ? extends TraceObjectInterface>> CTORS = Map.ofEntries(DBTraceObject.safeEntry(TraceObjectThread.class, DBTraceObjectThread::new), DBTraceObject.safeEntry(TraceObjectMemoryRegion.class, DBTraceObjectMemoryRegion::new), DBTraceObject.safeEntry(TraceObjectModule.class, DBTraceObjectModule::new), DBTraceObject.safeEntry(TraceObjectSection.class, DBTraceObjectSection::new), DBTraceObject.safeEntry(TraceObjectBreakpointSpec.class, DBTraceObjectBreakpointSpec::new), DBTraceObject.safeEntry(TraceObjectBreakpointLocation.class, DBTraceObjectBreakpointLocation::new), DBTraceObject.safeEntry(TraceObjectStack.class, DBTraceObjectStack::new), DBTraceObject.safeEntry(TraceObjectStackFrame.class, DBTraceObjectStackFrame::new), DBTraceObject.safeEntry(TraceObjectRegister.class, DBTraceObjectRegister::new));
    static final String PATH_COLUMN_NAME = "Path";
    @DBAnnotatedColumn(value="Path")
    static DBObjectColumn PATH_COLUMN;
    @DBAnnotatedField(column="Path", codec=ObjectPathDBFieldCodec.class, indexed=true)
    private TraceObjectKeyPath path;
    protected final DBTraceObjectManager manager;
    private Map<Class<? extends TraceObjectInterface>, TraceObjectInterface> ifaces;

    protected static <T extends TraceObjectInterface> Map.Entry<Class<? extends T>, Function<DBTraceObject, ? extends T>> safeEntry(Class<T> cls, Function<DBTraceObject, ? extends T> ctor) {
        return Map.entry(cls, ctor);
    }

    public DBTraceObject(DBTraceObjectManager manager, DBCachedObjectStore<?> store, DBRecord record) {
        super(store, record);
        this.manager = manager;
    }

    protected void fresh(boolean created) throws IOException {
        if (created) {
            return;
        }
        if (this.path != null) {
            this.freshIfaces();
        }
    }

    public String toString() {
        return "TraceObject: " + this.getCanonicalPath();
    }

    protected void freshIfaces() {
        if (this.ifaces != null) {
            return;
        }
        Set targetIfaces = this.getTargetSchema().getInterfaces();
        this.ifaces = CTORS.entrySet().stream().filter(e -> targetIfaces.contains(TraceObjectInterfaceUtils.toTargetIf((Class)e.getKey()))).collect(Collectors.toUnmodifiableMap(e -> (Class)e.getKey(), e -> (TraceObjectInterface)((Function)e.getValue()).apply(this)));
    }

    protected void set(TraceObjectKeyPath path) {
        this.path = path;
        this.update(PATH_COLUMN);
        this.freshIfaces();
    }

    @Override
    public DBTrace getTrace() {
        return this.manager.trace;
    }

    public DBTraceObjectManager getManager() {
        return this.manager;
    }

    @Override
    public DBTraceObject getRoot() {
        return this.manager.getRootObject();
    }

    @Override
    public TraceObjectKeyPath getCanonicalPath() {
        try (LockHold hold = this.manager.trace.lockRead();){
            TraceObjectKeyPath traceObjectKeyPath = this.path;
            return traceObjectKeyPath;
        }
    }

    @Override
    public Lifespan.LifeSet getLife() {
        try (LockHold hold = this.manager.trace.lockRead();){
            Lifespan.DefaultLifeSet result = new Lifespan.DefaultLifeSet();
            this.getCanonicalParents(Lifespan.ALL).forEach(v -> result.add(v.getLifespan()));
            Lifespan.DefaultLifeSet defaultLifeSet = result;
            return defaultLifeSet;
        }
    }

    protected DBTraceObject doCreateCanonicalParentObject() {
        return this.manager.doCreateObject(this.path.parent());
    }

    protected DBTraceObject doGetCanonicalParentObject() {
        return this.manager.doGetObject(this.path.parent());
    }

    protected DBTraceObjectValPath doInsert(Lifespan lifespan, TraceObject.ConflictResolution resolution) {
        if (this.path.isRoot()) {
            return DBTraceObjectValPath.of();
        }
        DBTraceObject parent = this.doCreateCanonicalParentObject();
        InternalTraceObjectValue value = parent.setValue(lifespan, this.path.key(), this, resolution);
        DBTraceObjectValPath path = parent.doInsert(lifespan, resolution);
        return path.append(value);
    }

    @Override
    public DBTraceObjectValPath insert(Lifespan lifespan, TraceObject.ConflictResolution resolution) {
        try (LockHold hold = this.manager.trace.lockWrite();){
            DBTraceObjectValPath dBTraceObjectValPath = this.doInsert(lifespan, resolution);
            return dBTraceObjectValPath;
        }
    }

    protected void doRemove(Lifespan span) {
        if (this.isRoot()) {
            throw new IllegalArgumentException("Cannot remove the root object");
        }
        DBTraceObject parent = this.doGetCanonicalParentObject();
        parent.setValue(span, this.path.key(), null);
    }

    @Override
    public void remove(Lifespan span) {
        try (LockHold hold = this.manager.trace.lockWrite();){
            this.doRemove(span);
        }
    }

    protected void doRemoveTree(Lifespan span) {
        for (DBTraceObjectValue dBTraceObjectValue : this.getParents()) {
            dBTraceObjectValue.doTruncateOrDeleteAndEmitLifeChange(span);
        }
        for (InternalTraceObjectValue internalTraceObjectValue : this.getValues()) {
            internalTraceObjectValue.doTruncateOrDeleteAndEmitLifeChange(span);
            if (!internalTraceObjectValue.isCanonical()) continue;
            internalTraceObjectValue.getChild().doRemoveTree(span);
        }
    }

    @Override
    public void removeTree(Lifespan span) {
        try (LockHold hold = this.manager.trace.lockWrite();){
            this.doRemoveTree(span);
        }
    }

    @Override
    public TraceObjectValue getCanonicalParent(long snap) {
        try (LockHold hold = this.manager.trace.lockRead();){
            if (this.isRoot()) {
                TraceObjectValue traceObjectValue = (TraceObjectValue)this.manager.valueStore.getObjectAt(0L);
                return traceObjectValue;
            }
            TraceObjectValue traceObjectValue = this.getCanonicalParents(Lifespan.at(snap)).findAny().orElse(null);
            return traceObjectValue;
        }
    }

    public Stream<? extends DBTraceObjectValue> getCanonicalParents(Lifespan lifespan) {
        try (LockHold hold = this.manager.trace.lockRead();){
            if (this.isRoot()) {
                Stream<DBTraceObjectValue> stream = Stream.of((DBTraceObjectValue)this.manager.valueStore.getObjectAt(0L));
                return stream;
            }
            String canonicalKey = this.path.key();
            TraceObjectKeyPath canonicalTail = this.path.parent();
            Stream<DBTraceObjectValue> stream = this.manager.valuesByChild.getLazily((Object)this).stream().filter(v -> canonicalKey.equals(v.getEntryKey())).filter(v -> v.getLifespan().intersects(lifespan)).filter(v -> canonicalTail.equals(v.getParent().getCanonicalPath()));
            return stream;
        }
    }

    @Override
    public boolean isRoot() {
        try (LockHold hold = this.manager.trace.lockRead();){
            boolean bl = this.path.isRoot();
            return bl;
        }
    }

    @Override
    public Stream<? extends TraceObjectValPath> getAllPaths(Lifespan span) {
        try (LockHold hold = this.manager.trace.lockRead();){
            if (this.isRoot()) {
                Stream<DBTraceObjectValPath> stream = Stream.of(DBTraceObjectValPath.of());
                return stream;
            }
            Stream<? extends TraceObjectValPath> stream = this.doStreamVisitor(span, AllPathsVisitor.INSTANCE);
            return stream;
        }
    }

    @Override
    public Collection<Class<? extends TraceObjectInterface>> getInterfaces() {
        Set targetIfs = this.getTargetSchema().getInterfaces();
        return CTORS.keySet().stream().filter(iface -> targetIfs.contains(TraceObjectInterfaceUtils.toTargetIf(iface))).collect(Collectors.toSet());
    }

    @Override
    public <I extends TraceObjectInterface> I queryInterface(Class<I> ifCls) {
        return (I)((TraceObjectInterface)ifCls.cast(this.ifaces.get(ifCls)));
    }

    protected Collection<? extends DBTraceObjectValue> doGetParents() {
        return this.manager.valuesByChild.get((Object)this);
    }

    public Collection<? extends DBTraceObjectValue> getParents() {
        try (LockHold hold = this.manager.trace.lockRead();){
            Collection<? extends DBTraceObjectValue> collection = this.doGetParents();
            return collection;
        }
    }

    protected void collectNonRangedValues(Collection<? super DBTraceObjectValue> result) {
        DBTraceObjectValue val;
        Iterator iterator = this.manager.valuesByTriple.tail((Object)new DBTraceObjectValue.PrimaryTriple(this, "", Long.MIN_VALUE), true).values().iterator();
        while (iterator.hasNext() && (val = (DBTraceObjectValue)iterator.next()).getParent() == this) {
            result.add(val);
        }
    }

    protected void collectNonRangedAttributes(List<? super DBTraceObjectValue> result) {
        DBTraceObjectValue val2;
        for (DBTraceObjectValue val2 : this.manager.valuesByTriple.sub((Object)new DBTraceObjectValue.PrimaryTriple(this, "", Long.MIN_VALUE), true, (Object)new DBTraceObjectValue.PrimaryTriple(this, "[", Long.MIN_VALUE), false).values()) {
            result.add(val2);
        }
        Iterator iterator = this.manager.valuesByTriple.tail((Object)new DBTraceObjectValue.PrimaryTriple(this, "\\", Long.MIN_VALUE), true).values().iterator();
        while (iterator.hasNext() && (val2 = (DBTraceObjectValue)iterator.next()).getParent() == this) {
            result.add(val2);
        }
    }

    protected void collectNonRangedElements(List<? super DBTraceObjectValue> result) {
        for (DBTraceObjectValue val : this.manager.valuesByTriple.sub((Object)new DBTraceObjectValue.PrimaryTriple(this, "[", Long.MIN_VALUE), true, (Object)new DBTraceObjectValue.PrimaryTriple(this, "\\", Long.MIN_VALUE), false).values()) {
            result.add(val);
        }
    }

    protected boolean doHasAnyNonRangedValues() {
        Iterator iterator = this.manager.valuesByTriple.tail((Object)new DBTraceObjectValue.PrimaryTriple(this, "", Long.MIN_VALUE), true).values().iterator();
        if (iterator.hasNext()) {
            DBTraceObjectValue val = (DBTraceObjectValue)iterator.next();
            return val.getParent() == this;
        }
        return false;
    }

    protected void collectRangedValues(Collection<? super DBTraceObjectAddressRangeValue> result) {
        for (DBTraceAddressSnapRangePropertyMapSpace space : this.manager.rangeValueMap.getActiveMemorySpaces()) {
            for (DBTraceObjectAddressRangeValue val : space.values()) {
                if (val.getParent() != this) continue;
                result.add(val);
            }
        }
    }

    protected void collectRangedAttributes(Collection<? super DBTraceObjectAddressRangeValue> result) {
        for (DBTraceAddressSnapRangePropertyMapSpace space : this.manager.rangeValueMap.getActiveMemorySpaces()) {
            for (DBTraceObjectAddressRangeValue val : space.values()) {
                if (val.getParent() != this || !PathUtils.isName((String)val.getEntryKey())) continue;
                result.add(val);
            }
        }
    }

    protected void collectRangedElements(Collection<? super DBTraceObjectAddressRangeValue> result) {
        for (DBTraceAddressSnapRangePropertyMapSpace space : this.manager.rangeValueMap.getActiveMemorySpaces()) {
            for (DBTraceObjectAddressRangeValue val : space.values()) {
                if (val.getParent() != this || !PathUtils.isIndex((String)val.getEntryKey())) continue;
                result.add(val);
            }
        }
    }

    protected boolean doHasAnyRangedValues() {
        for (DBTraceAddressSnapRangePropertyMapSpace space : this.manager.rangeValueMap.getActiveMemorySpaces()) {
            for (DBTraceObjectAddressRangeValue val : space.values()) {
                if (val.getParent() != this) continue;
                return true;
            }
        }
        return false;
    }

    protected Collection<? extends InternalTraceObjectValue> doGetValues() {
        ArrayList result = new ArrayList();
        this.collectNonRangedValues(result);
        this.collectRangedValues(result);
        return result;
    }

    protected boolean doHasAnyValues() {
        return this.doHasAnyNonRangedValues() || this.doHasAnyRangedValues();
    }

    protected boolean doHasAnyParents() {
        return this.manager.valuesByChild.containsKey((Object)this);
    }

    protected boolean doIsConnected() {
        return this.doHasAnyParents() || this.doHasAnyValues();
    }

    public Collection<? extends InternalTraceObjectValue> getValues() {
        try (LockHold hold = this.manager.trace.lockRead();){
            Collection<? extends InternalTraceObjectValue> collection = this.doGetValues();
            return collection;
        }
    }

    protected Collection<? extends InternalTraceObjectValue> doGetElements() {
        ArrayList result = new ArrayList();
        this.collectNonRangedElements(result);
        this.collectRangedElements(result);
        return result;
    }

    public Collection<? extends InternalTraceObjectValue> getElements() {
        try (LockHold hold = this.manager.trace.lockRead();){
            Collection<? extends InternalTraceObjectValue> collection = this.doGetElements();
            return collection;
        }
    }

    protected Collection<? extends InternalTraceObjectValue> doGetAttributes() {
        ArrayList result = new ArrayList();
        this.collectNonRangedAttributes(result);
        this.collectRangedAttributes(result);
        return result;
    }

    public Collection<? extends InternalTraceObjectValue> getAttributes() {
        try (LockHold hold = this.manager.trace.lockRead();){
            Collection<? extends InternalTraceObjectValue> collection = this.doGetAttributes();
            return collection;
        }
    }

    protected void doCheckConflicts(Lifespan span, String key, Object value) {
        for (InternalTraceObjectValue internalTraceObjectValue : this.doGetValues(span, key)) {
            if (Objects.equals(value, internalTraceObjectValue.getValue())) continue;
            throw new DuplicateKeyException(key);
        }
    }

    protected Collection<? extends InternalTraceObjectValue> doGetValues(Lifespan span, String key) {
        return this.doGetValues(span.lmin(), span.lmax(), key);
    }

    protected Collection<? extends InternalTraceObjectValue> doGetValues(long lower, long upper, String key) {
        LinkedHashSet<InternalTraceObjectValue> result = new LinkedHashSet<InternalTraceObjectValue>();
        DBTraceObjectValue.PrimaryTriple min = new DBTraceObjectValue.PrimaryTriple(this, key, lower);
        DBTraceObjectValue.PrimaryTriple max = new DBTraceObjectValue.PrimaryTriple(this, key, upper);
        DBTraceObjectValue floor = (DBTraceObjectValue)this.manager.valuesByTriple.floorValue((Object)min);
        if (floor != null && floor.getParent() == this && key.equals(floor.getEntryKey()) && floor.getLifespan().contains(lower)) {
            result.add(floor);
        }
        for (DBTraceObjectValue val : this.manager.valuesByTriple.sub((Object)min, true, (Object)max, true).values()) {
            result.add(val);
        }
        for (DBTraceAddressSnapRangePropertyMapSpace space : this.manager.rangeValueMap.getActiveMemorySpaces()) {
            AddressSpace as = space.getAddressSpace();
            for (DBTraceObjectAddressRangeValue val : this.manager.rangeValueMap.reduce(DBTraceAddressSnapRangePropertyMapTree.TraceAddressSnapRangeQuery.intersecting(as.getMinAddress(), as.getMaxAddress(), lower, upper)).values()) {
                if (val.getParent() != this || !key.equals(val.getEntryKey())) continue;
                result.add(val);
            }
        }
        return result.stream().sorted(Comparator.comparing(v -> v.getMinSnap())).collect(Collectors.toList());
    }

    public Collection<? extends InternalTraceObjectValue> getValues(Lifespan span, String key) {
        try (LockHold hold = this.manager.trace.lockRead();){
            Collection<? extends InternalTraceObjectValue> collection = this.doGetValues(span, key);
            return collection;
        }
    }

    protected DBTraceObjectValue doGetNonRangedValue(long snap, String key) {
        DBTraceObjectValue floor = (DBTraceObjectValue)this.manager.valuesByTriple.floorValue((Object)new DBTraceObjectValue.PrimaryTriple(this, key, snap));
        if (floor == null || floor.getParent() != this || !key.equals(floor.getEntryKey()) || !floor.getLifespan().contains(snap)) {
            return null;
        }
        return floor;
    }

    protected Stream<DBTraceObjectValue> doGetOrderedNonRangedValues(Lifespan span, String key, boolean forward) {
        DBCachedObjectIndex sub = this.manager.valuesByTriple.sub((Object)new DBTraceObjectValue.PrimaryTriple(this, key, span.lmin()), true, (Object)new DBTraceObjectValue.PrimaryTriple(this, key, span.lmax()), true);
        Spliterator spliterator = (forward ? sub : sub.descending()).values().spliterator();
        return StreamSupport.stream(spliterator, false);
    }

    protected DBTraceObjectAddressRangeValue doGetRangedValue(long snap, String key) {
        for (DBTraceAddressSnapRangePropertyMapSpace space : this.manager.rangeValueMap.getActiveMemorySpaces()) {
            AddressSpace as = space.getAddressSpace();
            for (DBTraceObjectAddressRangeValue val : space.reduce(DBTraceAddressSnapRangePropertyMapTree.TraceAddressSnapRangeQuery.atSnap(snap, as)).values()) {
                if (val.getParent() != this || !key.equals(val.getEntryKey())) continue;
                return val;
            }
        }
        return null;
    }

    protected Stream<DBTraceObjectAddressRangeValue> doGetOrderedRangedValues(Lifespan span, String key, boolean forward) {
        Rectangle2DDirection dir = forward ? Rectangle2DDirection.BOTTOMMOST : Rectangle2DDirection.TOPMOST;
        List<Stream> streams = this.manager.rangeValueMap.getActiveMemorySpaces().stream().map(s -> StreamSupport.stream(s.reduce((DBTraceAddressSnapRangePropertyMapTree.TraceAddressSnapRangeQuery)DBTraceAddressSnapRangePropertyMapTree.TraceAddressSnapRangeQuery.intersecting(span, s.getAddressSpace()).starting(dir)).orderedValues().spliterator(), false).filter(v -> key.equals(v.getEntryKey()) && this == v.getParent())).toList();
        Comparator order = forward ? Comparator.naturalOrder() : Comparator.reverseOrder();
        Comparator<DBTraceObjectAddressRangeValue> comparator = Comparator.comparing(v -> v.getMinSnap(), order);
        return StreamUtils.merge(streams, comparator);
    }

    @Override
    public InternalTraceObjectValue getValue(long snap, String key) {
        try (LockHold hold = this.manager.trace.lockRead();){
            DBTraceObjectValue nrVal = this.doGetNonRangedValue(snap, key);
            if (nrVal != null) {
                DBTraceObjectValue dBTraceObjectValue = nrVal;
                return dBTraceObjectValue;
            }
            DBTraceObjectAddressRangeValue dBTraceObjectAddressRangeValue = this.doGetRangedValue(snap, key);
            return dBTraceObjectAddressRangeValue;
        }
    }

    protected Stream<InternalTraceObjectValue> doGetOrderedValues(Lifespan span, String key, boolean forward) {
        Stream<DBTraceObjectValue> nrVals = this.doGetOrderedNonRangedValues(span, key, forward);
        Stream<DBTraceObjectAddressRangeValue> rVals = this.doGetOrderedRangedValues(span, key, forward);
        Comparator order = forward ? Comparator.naturalOrder() : Comparator.reverseOrder();
        Comparator<InternalTraceObjectValue> comparator = Comparator.comparing(v -> v.getMinSnap(), order);
        return StreamUtils.merge(List.of(nrVals, rVals), comparator);
    }

    public Stream<? extends InternalTraceObjectValue> getOrderedValues(Lifespan span, String key, boolean forward) {
        try (LockHold hold = this.manager.trace.lockRead();){
            Stream<InternalTraceObjectValue> stream = this.doGetOrderedValues(span, key, forward);
            return stream;
        }
    }

    @Override
    public InternalTraceObjectValue getElement(long snap, String index) {
        return this.getValue(snap, PathUtils.makeKey((String)index));
    }

    @Override
    public InternalTraceObjectValue getElement(long snap, long index) {
        return this.getElement(snap, PathUtils.makeIndex((long)index));
    }

    @Override
    public TraceObjectValue getAttribute(long snap, String name) {
        if (!PathUtils.isName((String)name)) {
            throw new IllegalArgumentException("name cannot be an index");
        }
        return this.getValue(snap, name);
    }

    protected Stream<? extends TraceObjectValPath> doStreamVisitor(Lifespan span, TreeTraversal.Visitor visitor) {
        return TreeTraversal.INSTANCE.walkObject(visitor, this, span, DBTraceObjectValPath.of());
    }

    @Override
    public Stream<? extends TraceObjectValPath> getAncestors(Lifespan span, PathPredicates relativePredicates) {
        try (LockHold hold = this.manager.trace.lockRead();){
            Stream<? extends TraceObjectValPath> ancestors = this.doStreamVisitor(span, new AncestorsRelativeVisitor(relativePredicates));
            if (relativePredicates.matches(List.of())) {
                Stream<? extends TraceObjectValPath> stream = Stream.concat(Stream.of(DBTraceObjectValPath.of()), ancestors);
                return stream;
            }
            Stream<? extends TraceObjectValPath> stream = ancestors;
            return stream;
        }
    }

    @Override
    public Stream<? extends TraceObjectValPath> getAncestorsRoot(Lifespan span, PathPredicates rootPredicates) {
        try (LockHold hold = this.manager.trace.lockRead();){
            Stream<? extends TraceObjectValPath> stream = this.doStreamVisitor(span, new AncestorsRootVisitor(rootPredicates));
            return stream;
        }
    }

    @Override
    public Stream<? extends TraceObjectValPath> getSuccessors(Lifespan span, PathPredicates relativePredicates) {
        try (LockHold hold = this.manager.trace.lockRead();){
            Stream<? extends TraceObjectValPath> succcessors = this.doStreamVisitor(span, new SuccessorsRelativeVisitor(relativePredicates));
            if (relativePredicates.matches(List.of())) {
                Stream<? extends TraceObjectValPath> stream = Stream.concat(Stream.of(DBTraceObjectValPath.of()), succcessors);
                return stream;
            }
            Stream<? extends TraceObjectValPath> stream = succcessors;
            return stream;
        }
    }

    @Override
    public Stream<? extends TraceObjectValPath> getOrderedSuccessors(Lifespan span, TraceObjectKeyPath relativePath, boolean forward) {
        DBTraceObjectValPath empty = DBTraceObjectValPath.of();
        try (LockHold hold = this.manager.trace.lockRead();){
            if (relativePath.isRoot()) {
                Stream<DBTraceObjectValPath> stream = Stream.of(empty);
                return stream;
            }
            Stream<? extends TraceObjectValPath> stream = this.doStreamVisitor(span, new OrderedSuccessorsVisitor(relativePath, forward));
            return stream;
        }
    }

    @Override
    public Stream<? extends TraceObjectValPath> getCanonicalSuccessors(PathPredicates relativePredicates) {
        try (LockHold hold = this.manager.trace.lockRead();){
            Stream<? extends TraceObjectValPath> successors = this.doStreamVisitor(Lifespan.ALL, new CanonicalSuccessorsRelativeVisitor(relativePredicates));
            if (relativePredicates.matches(List.of())) {
                Stream<? extends TraceObjectValPath> stream = Stream.concat(Stream.of(DBTraceObjectValPath.of()), successors);
                return stream;
            }
            Stream<? extends TraceObjectValPath> stream = successors;
            return stream;
        }
    }

    protected InternalTraceObjectValue doCreateValue(Lifespan lifespan, String key, Object value) {
        return this.manager.doCreateValue(lifespan, this, key, value);
    }

    @Override
    public InternalTraceObjectValue setValue(Lifespan lifespan, final String key, Object value, TraceObject.ConflictResolution resolution) {
        try (LockHold hold = this.manager.trace.lockWrite();){
            if (this.isDeleted()) {
                throw new IllegalStateException("Cannot set value on deleted object.");
            }
            if (resolution == TraceObject.ConflictResolution.DENY) {
                this.doCheckConflicts(lifespan, key, value);
            }
            var setter = new InternalTraceObjectValue.ValueLifespanSetter(lifespan, value){
                DBTraceObject canonicalLifeChanged;
                {
                    super(range, value);
                    this.canonicalLifeChanged = null;
                }

                protected Iterable<InternalTraceObjectValue> getIntersecting(Long lower, Long upper) {
                    return Collections.unmodifiableCollection(DBTraceObject.this.doGetValues(lower, upper, key));
                }

                @Override
                protected void remove(InternalTraceObjectValue entry) {
                    if (entry.isCanonical()) {
                        this.canonicalLifeChanged = entry.getChild();
                    }
                    super.remove(entry);
                }

                @Override
                protected InternalTraceObjectValue put(Lifespan range, Object value) {
                    InternalTraceObjectValue entry = super.put(range, value);
                    if (entry != null && entry.isCanonical()) {
                        this.canonicalLifeChanged = entry.getChild();
                    }
                    return entry;
                }

                @Override
                protected InternalTraceObjectValue create(Lifespan range, Object value) {
                    return DBTraceObject.this.doCreateValue(range, key, value);
                }
            };
            InternalTraceObjectValue result = (InternalTraceObjectValue)setter.set(lifespan, value);
            DBTraceObject child = setter.canonicalLifeChanged;
            if (child != null) {
                child.emitEvents(new TraceChangeRecord<DBTraceObject, Void>(Trace.TraceObjectChangeType.LIFE_CHANGED, null, child));
            }
            InternalTraceObjectValue internalTraceObjectValue = result;
            return internalTraceObjectValue;
        }
    }

    @Override
    public TraceObjectValue setValue(Lifespan lifespan, String key, Object value) {
        return this.setValue(lifespan, key, value, TraceObject.ConflictResolution.TRUNCATE);
    }

    @Override
    public TraceObjectValue setAttribute(Lifespan lifespan, String name, Object value) {
        if (!PathUtils.isName((String)name)) {
            throw new IllegalArgumentException("Attribute name must not be an index");
        }
        return this.setValue(lifespan, name, value);
    }

    @Override
    public TraceObjectValue setElement(Lifespan lifespan, String index, Object value) {
        return this.setValue(lifespan, PathUtils.makeKey((String)index), value);
    }

    @Override
    public TraceObjectValue setElement(Lifespan lifespan, long index, Object value) {
        return this.setElement(lifespan, PathUtils.makeIndex((long)index), value);
    }

    @Override
    public TargetObjectSchema getTargetSchema() {
        return this.manager.rootSchema.getSuccessorSchema(this.path.getKeyList());
    }

    @Override
    public Stream<? extends TraceObjectValPath> queryAncestorsTargetInterface(Lifespan span, Class<? extends TargetObject> targetIf) {
        PathMatcher matcher = this.getManager().getRootSchema().searchFor(targetIf, false);
        return this.getAncestorsRoot(span, (PathPredicates)matcher);
    }

    @Override
    public <I extends TraceObjectInterface> Stream<I> queryAncestorsInterface(Lifespan span, Class<I> ifClass) {
        return this.queryAncestorsTargetInterface(span, TraceObjectInterfaceUtils.toTargetIf(ifClass)).map(p -> p.getSource(this).queryInterface(ifClass));
    }

    @Override
    public Stream<? extends TraceObject> queryCanonicalAncestorsTargetInterface(Class<? extends TargetObject> targetIf) {
        PathMatcher matcher = this.getManager().getRootSchema().searchFor(targetIf, false);
        try (LockHold hold = this.manager.trace.lockRead();){
            Stream<DBTraceObject> stream = this.path.streamMatchingAncestry((PathPredicates)matcher).map(kp -> this.manager.getObjectByCanonicalPath((TraceObjectKeyPath)kp));
            return stream;
        }
    }

    @Override
    public <I extends TraceObjectInterface> Stream<I> queryCanonicalAncestorsInterface(Class<I> ifClass) {
        return this.queryCanonicalAncestorsTargetInterface(TraceObjectInterfaceUtils.toTargetIf(ifClass)).map(o -> o.queryInterface(ifClass));
    }

    private boolean isActuallyInterface(TraceObjectValPath path, Class<? extends TargetObject> targetIf) {
        TraceObjectValue lastEntry = path.getLastEntry();
        if (lastEntry == null) {
            return this.getTargetSchema().getInterfaces().contains(targetIf);
        }
        if (!lastEntry.isObject()) {
            return false;
        }
        return lastEntry.getChild().getTargetSchema().getInterfaces().contains(targetIf);
    }

    @Override
    public Stream<? extends TraceObjectValPath> querySuccessorsTargetInterface(Lifespan span, Class<? extends TargetObject> targetIf, boolean requireCanonical) {
        PathMatcher matcher = this.getTargetSchema().searchFor(targetIf, requireCanonical);
        return this.getSuccessors(span, (PathPredicates)matcher).filter(p -> this.isActuallyInterface((TraceObjectValPath)p, targetIf));
    }

    @Override
    public <I extends TraceObjectInterface> Stream<I> querySuccessorsInterface(Lifespan span, Class<I> ifClass, boolean requireCanonical) {
        return this.querySuccessorsTargetInterface(span, TraceObjectInterfaceUtils.toTargetIf(ifClass), requireCanonical).map(p -> p.getDestination(this).queryInterface(ifClass));
    }

    protected void doDelete() {
        this.manager.doDeleteObject(this);
    }

    protected void doDeleteReferringValues() {
        for (InternalTraceObjectValue internalTraceObjectValue : this.getValues()) {
            internalTraceObjectValue.doDeleteAndEmit();
        }
        for (DBTraceObjectValue dBTraceObjectValue : this.getParents()) {
            dBTraceObjectValue.doDeleteAndEmit();
        }
    }

    @Override
    public void delete() {
        try (LockHold hold = LockHold.lock((Lock)this.manager.lock.writeLock());){
            this.doDeleteReferringValues();
            this.doDelete();
        }
    }

    protected void emitEvents(TraceChangeRecord<?, ?> rec) {
        this.manager.trace.setChanged(rec);
        for (TraceObjectInterface iface : this.ifaces.values()) {
            DBTraceObjectInterface dbIface = (DBTraceObjectInterface)iface;
            try {
                TraceChangeRecord<?, ?> evt = dbIface.translateEvent(rec);
                if (evt == null) continue;
                this.manager.trace.setChanged(evt);
            }
            catch (Throwable t) {
                Msg.error((Object)this, (Object)("Error while translating event " + rec + " for interface " + iface));
            }
        }
    }

    protected static final class ObjectPathDBFieldCodec
    extends DBCachedObjectStoreFactory.AbstractDBFieldCodec<TraceObjectKeyPath, DBAnnotatedObject, StringField> {
        public ObjectPathDBFieldCodec(Class<DBAnnotatedObject> objectType, Field field, int column) {
            super(TraceObjectKeyPath.class, objectType, StringField.class, field, column);
        }

        protected String encode(TraceObjectKeyPath value) {
            return value == null ? null : value.toString();
        }

        protected TraceObjectKeyPath decode(String path) {
            return TraceObjectKeyPath.parse(path);
        }

        public void store(TraceObjectKeyPath value, StringField f) {
            f.setString(this.encode(value));
        }

        protected void doStore(DBAnnotatedObject obj, DBRecord record) throws IllegalArgumentException, IllegalAccessException {
            record.setString(this.column, this.encode((TraceObjectKeyPath)this.getValue(obj)));
        }

        protected void doLoad(DBAnnotatedObject obj, DBRecord record) throws IllegalArgumentException, IllegalAccessException {
            this.setValue(obj, this.decode(record.getString(this.column)));
        }
    }
}

