/*
 * Decompiled with CFR 0.152.
 */
package ghidra.trace.database.module;

import db.DBHandle;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressRange;
import ghidra.trace.database.DBTrace;
import ghidra.trace.database.DBTraceManager;
import ghidra.trace.database.address.DBTraceOverlaySpaceAdapter;
import ghidra.trace.database.module.DBTraceStaticMapping;
import ghidra.trace.model.Lifespan;
import ghidra.trace.model.Trace;
import ghidra.trace.model.modules.TraceConflictedMappingException;
import ghidra.trace.model.modules.TraceStaticMappingManager;
import ghidra.trace.util.TraceChangeRecord;
import ghidra.util.LockHold;
import ghidra.util.database.DBAnnotatedObject;
import ghidra.util.database.DBCachedObjectIndex;
import ghidra.util.database.DBCachedObjectStore;
import ghidra.util.database.DBCachedObjectStoreFactory;
import ghidra.util.database.DBOpenMode;
import ghidra.util.exception.VersionException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;

public class DBTraceStaticMappingManager
implements TraceStaticMappingManager,
DBTraceManager {
    protected final DBHandle dbh;
    protected final ReadWriteLock lock;
    protected final DBTrace trace;
    protected final DBTraceOverlaySpaceAdapter overlayAdapter;
    protected final DBCachedObjectStore<DBTraceStaticMapping> mappingStore;
    protected final DBCachedObjectIndex<Address, DBTraceStaticMapping> mappingsByAddress;
    protected final Collection<DBTraceStaticMapping> view;

    public DBTraceStaticMappingManager(DBHandle dbh, DBOpenMode openMode, ReadWriteLock lock, TaskMonitor monitor, DBTrace trace, DBTraceOverlaySpaceAdapter overlayAdapter) throws VersionException, IOException {
        this.dbh = dbh;
        this.lock = lock;
        this.trace = trace;
        this.overlayAdapter = overlayAdapter;
        DBCachedObjectStoreFactory factory = trace.getStoreFactory();
        this.mappingStore = factory.getOrCreateCachedStore("StaticMappings", DBTraceStaticMapping.class, (s, r) -> new DBTraceStaticMapping(this, s, r), true);
        this.mappingsByAddress = this.mappingStore.getIndex(Address.class, DBTraceStaticMapping.TRACE_ADDRESS_COLUMN);
        this.view = Collections.unmodifiableCollection(this.mappingStore.asMap().values());
    }

    @Override
    public void invalidateCache(boolean all) {
        this.mappingStore.invalidateCache();
    }

    public void dbError(IOException e) {
        this.trace.dbError(e);
    }

    @Override
    public DBTraceStaticMapping add(AddressRange range, Lifespan lifespan, URL toProgramURL, String toAddress) throws TraceConflictedMappingException {
        Objects.requireNonNull(toProgramURL, "Program URL cannot be null. Program must be in a project to have a URL.");
        try (LockHold hold = LockHold.lock((Lock)this.lock.writeLock());){
            DBTraceStaticMapping conflict = this.findAnyConflicting(range, lifespan, toProgramURL, toAddress);
            if (conflict != null) {
                throw new TraceConflictedMappingException("Another mapping would conflict", Set.of(conflict));
            }
            for (DBTraceStaticMapping dBTraceStaticMapping : this.findAllOverlapping(range, lifespan)) {
                if (!dBTraceStaticMapping.getTraceAddressRange().contains(range.getMinAddress()) || !dBTraceStaticMapping.getTraceAddressRange().contains(range.getMaxAddress()) || !dBTraceStaticMapping.getLifespan().encloses(lifespan)) continue;
                DBTraceStaticMapping dBTraceStaticMapping2 = dBTraceStaticMapping;
                return dBTraceStaticMapping2;
            }
            DBTraceStaticMapping mapping = (DBTraceStaticMapping)this.mappingStore.create();
            mapping.set(range, lifespan, toProgramURL, toAddress);
            this.trace.setChanged(new TraceChangeRecord(Trace.TraceStaticMappingChangeType.ADDED, null, mapping));
            DBTraceStaticMapping dBTraceStaticMapping = mapping;
            return dBTraceStaticMapping;
        }
    }

    public Collection<? extends DBTraceStaticMapping> getAllEntries() {
        return this.view;
    }

    @Override
    public DBTraceStaticMapping findContaining(Address address, long snap) {
        for (DBTraceStaticMapping mapping : this.mappingsByAddress.head((Object)address, true).descending().values()) {
            if (!mapping.getLifespan().contains(snap)) continue;
            if (!mapping.getTraceAddressRange().contains(address)) break;
            return mapping;
        }
        return null;
    }

    @Override
    public DBTraceStaticMapping findAnyConflicting(AddressRange range, Lifespan lifespan, URL toProgramURL, String toAddress) {
        for (DBTraceStaticMapping mapping : this.mappingsByAddress.head((Object)range.getMaxAddress(), true).descending().values()) {
            if (!mapping.conflictsWith(range, lifespan, toProgramURL, toAddress)) continue;
            if (!mapping.getTraceAddressRange().intersects(range)) {
                if (!mapping.getLifespan().encloses(lifespan)) continue;
                break;
            }
            return mapping;
        }
        return null;
    }

    public Collection<? extends DBTraceStaticMapping> findAllOverlapping(AddressRange range, Lifespan lifespan) {
        HashSet<DBTraceStaticMapping> result = new HashSet<DBTraceStaticMapping>();
        for (DBTraceStaticMapping mapping : this.mappingsByAddress.head((Object)range.getMaxAddress(), true).descending().values()) {
            if (!mapping.getLifespan().intersects(lifespan)) continue;
            if (!mapping.getTraceAddressRange().intersects(range)) {
                if (!mapping.getLifespan().encloses(lifespan)) continue;
                break;
            }
            result.add(mapping);
        }
        return result;
    }

    public void delete(DBTraceStaticMapping mapping) {
        this.mappingStore.delete((DBAnnotatedObject)mapping);
        this.trace.setChanged(new TraceChangeRecord(Trace.TraceStaticMappingChangeType.DELETED, null, mapping));
    }
}

