/*
 * Decompiled with CFR 0.152.
 */
package ghidra.trace.database.listing;

import db.DBHandle;
import db.DBRecord;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressRangeImpl;
import ghidra.program.model.lang.Language;
import ghidra.trace.database.DBTrace;
import ghidra.trace.database.DBTraceUtils;
import ghidra.trace.database.map.DBTraceAddressSnapRangePropertyMap;
import ghidra.trace.database.map.DBTraceAddressSnapRangePropertyMapTree;
import ghidra.trace.database.space.DBTraceSpaceKey;
import ghidra.trace.database.thread.DBTraceThreadManager;
import ghidra.trace.model.ImmutableTraceAddressSnapRange;
import ghidra.trace.model.Lifespan;
import ghidra.trace.model.Trace;
import ghidra.trace.model.TraceAddressSnapRange;
import ghidra.trace.util.TraceChangeRecord;
import ghidra.util.LockHold;
import ghidra.util.database.DBCachedObjectStore;
import ghidra.util.database.DBObjectColumn;
import ghidra.util.database.DBOpenMode;
import ghidra.util.database.annot.DBAnnotatedColumn;
import ghidra.util.database.annot.DBAnnotatedField;
import ghidra.util.database.annot.DBAnnotatedObjectInfo;
import ghidra.util.exception.VersionException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.util.Iterator;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import org.apache.commons.lang3.StringUtils;

public class DBTraceCommentAdapter
extends DBTraceAddressSnapRangePropertyMap<DBTraceCommentEntry, DBTraceCommentEntry> {
    protected static final String[] EMPTY_STRING_ARRAY = new String[0];
    protected static final int MIN_COMMENT_TYPE = 0;
    protected static final int MAX_COMMENT_TYPE = 4;

    public DBTraceCommentAdapter(DBHandle dbh, DBOpenMode openMode, ReadWriteLock lock, TaskMonitor monitor, Language baseLanguage, DBTrace trace, DBTraceThreadManager threadManager) throws IOException, VersionException {
        super("Comments", dbh, openMode, lock, monitor, baseLanguage, trace, threadManager, DBTraceCommentEntry.class, DBTraceCommentEntry::new);
    }

    protected void makeWay(DBTraceCommentEntry entry, Lifespan span) {
        DBTraceUtils.makeWay(entry, span, (e, s) -> e.setLifespan((Lifespan)s), e -> this.deleteData(e));
    }

    public void setComment(Lifespan lifespan, Address address, int commentType, String comment) {
        if (commentType < 0 || commentType > 4) {
            throw new IllegalArgumentException("commentType");
        }
        String oldValue = null;
        try (LockHold hold = LockHold.lock((Lock)this.lock.writeLock());){
            for (DBTraceCommentEntry entry : this.reduce(DBTraceAddressSnapRangePropertyMapTree.TraceAddressSnapRangeQuery.intersecting((AddressRange)new AddressRangeImpl(address, address), lifespan)).values()) {
                if (entry.type != commentType) continue;
                if (entry.getLifespan().contains(lifespan.lmin())) {
                    oldValue = entry.comment;
                }
                this.makeWay(entry, lifespan);
            }
            if (comment != null) {
                DBTraceCommentEntry entry = (DBTraceCommentEntry)this.put(address, lifespan, null);
                entry.set((byte)commentType, comment);
            }
        }
        this.trace.setChanged(new TraceChangeRecord<ImmutableTraceAddressSnapRange, String>(Trace.TraceCommentChangeType.byType(commentType), DBTraceSpaceKey.create(address.getAddressSpace(), null, 0), new ImmutableTraceAddressSnapRange(address, lifespan), oldValue, comment));
    }

    public static String commentFromArray(String[] comment) {
        return comment == null || comment.length == 0 ? null : StringUtils.join((Object[])comment, (char)'\n');
    }

    public static String[] arrayFromComment(String comment) {
        return comment == null || comment.length() == 0 ? EMPTY_STRING_ARRAY : comment.split("\n");
    }

    public String getComment(long snap, Address address, int commentType) {
        try (LockHold hold = LockHold.lock((Lock)this.lock.readLock());){
            for (DBTraceCommentEntry entry : this.reduce(DBTraceAddressSnapRangePropertyMapTree.TraceAddressSnapRangeQuery.at(address, snap)).values()) {
                if (entry.type != commentType) continue;
                String string = entry.comment;
                return string;
            }
            Iterator iterator = null;
            return iterator;
        }
    }

    public void clearComments(Lifespan span, AddressRange range, int commentType) {
        try (LockHold hold = LockHold.lock((Lock)this.lock.writeLock());){
            for (DBTraceCommentEntry entry : this.reduce(DBTraceAddressSnapRangePropertyMapTree.TraceAddressSnapRangeQuery.intersecting(range, span)).values()) {
                if (commentType != -1 && entry.type != commentType) continue;
                this.makeWay(entry, span);
            }
        }
    }

    @Override
    public DBTraceCommentEntry put(TraceAddressSnapRange shape, DBTraceCommentEntry value) {
        assert (shape.getRange().getLength() == 1L);
        return super.put(shape, value);
    }

    @DBAnnotatedObjectInfo(version=0)
    public static class DBTraceCommentEntry
    extends DBTraceAddressSnapRangePropertyMapTree.AbstractDBTraceAddressSnapRangePropertyMapData<DBTraceCommentEntry> {
        static final String TYPE_COLUMN_NAME = "Type";
        static final String COMMENT_COLUMN_NAME = "Comment";
        @DBAnnotatedColumn(value="Type")
        static DBObjectColumn TYPE_COLUMN;
        @DBAnnotatedColumn(value="Comment")
        static DBObjectColumn COMMENT_COLUMN;
        @DBAnnotatedField(column="Type")
        byte type;
        @DBAnnotatedField(column="Comment")
        String comment;

        public DBTraceCommentEntry(DBTraceAddressSnapRangePropertyMapTree<DBTraceCommentEntry, ?> tree, DBCachedObjectStore<?> store, DBRecord record) {
            super(tree, store, record);
        }

        protected void setRecordValue(DBTraceCommentEntry value) {
        }

        protected DBTraceCommentEntry getRecordValue() {
            return this;
        }

        void set(byte type, String comment) {
            this.type = type;
            this.comment = comment;
            this.update(TYPE_COLUMN, COMMENT_COLUMN);
        }

        void setLifespan(Lifespan lifespan) {
            super.doSetLifespan(lifespan);
        }

        public int getType() {
            return this.type;
        }
    }
}

