/*
 * Decompiled with CFR 0.152.
 */
package ghidra.trace.database.breakpoint;

import ghidra.dbg.target.TargetProcess;
import ghidra.dbg.target.schema.TargetObjectSchema;
import ghidra.dbg.util.PathMatcher;
import ghidra.dbg.util.PathPredicates;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressRange;
import ghidra.trace.database.target.DBTraceObject;
import ghidra.trace.database.target.DBTraceObjectInterface;
import ghidra.trace.database.target.DBTraceObjectManager;
import ghidra.trace.model.Lifespan;
import ghidra.trace.model.Trace;
import ghidra.trace.model.breakpoint.TraceBreakpoint;
import ghidra.trace.model.breakpoint.TraceBreakpointKind;
import ghidra.trace.model.breakpoint.TraceObjectBreakpointLocation;
import ghidra.trace.model.breakpoint.TraceObjectBreakpointSpec;
import ghidra.trace.model.target.TraceObject;
import ghidra.trace.model.target.annot.TraceObjectInterfaceUtils;
import ghidra.trace.model.thread.TraceObjectThread;
import ghidra.trace.model.thread.TraceThread;
import ghidra.trace.util.TraceAddressSpace;
import ghidra.trace.util.TraceChangeRecord;
import ghidra.trace.util.TraceChangeType;
import ghidra.util.LockHold;
import ghidra.util.exception.DuplicateNameException;
import java.util.Collection;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

public class DBTraceObjectBreakpointLocation
implements TraceObjectBreakpointLocation,
DBTraceObjectInterface {
    private final DBTraceObject object;
    private final BreakpointChangeTranslator translator;
    private AddressRange range;
    private Lifespan lifespan;

    public DBTraceObjectBreakpointLocation(DBTraceObject object) {
        this.object = object;
        this.translator = new BreakpointChangeTranslator(object, this);
    }

    @Override
    public Trace getTrace() {
        return this.object.getTrace();
    }

    @Override
    public String getPath() {
        return this.object.getCanonicalPath().toString();
    }

    @Override
    public void setName(Lifespan lifespan, String name) {
        this.object.setValue(lifespan, "_display", name);
    }

    @Override
    public void setName(String name) {
        try (LockHold hold = this.object.getTrace().lockWrite();){
            this.setName(this.getLifespan(), name);
        }
    }

    @Override
    public String getName() {
        try (LockHold hold = this.object.getTrace().lockRead();){
            String string = TraceObjectInterfaceUtils.getValue(this.object, this.getPlacedSnap(), "_display", String.class, "");
            return string;
        }
    }

    @Override
    public void setRange(Lifespan lifespan, AddressRange range) {
        try (LockHold hold = this.object.getTrace().lockWrite();){
            this.object.setValue(lifespan, "_range", range);
            this.range = range;
        }
    }

    @Override
    public AddressRange getRange() {
        try (LockHold hold = this.object.getTrace().lockRead();){
            if (this.object.getLife().isEmpty()) {
                AddressRange addressRange = this.range;
                return addressRange;
            }
            AddressRange addressRange = this.range = TraceObjectInterfaceUtils.getValue(this.object, this.getPlacedSnap(), "_range", AddressRange.class, this.range);
            return addressRange;
        }
    }

    @Override
    public Address getMinAddress() {
        AddressRange range = this.getRange();
        return range == null ? null : range.getMinAddress();
    }

    @Override
    public Address getMaxAddress() {
        AddressRange range = this.getRange();
        return range == null ? null : range.getMaxAddress();
    }

    @Override
    public long getLength() {
        AddressRange range = this.getRange();
        return range == null ? 0L : range.getLength();
    }

    @Override
    public void setLifespan(Lifespan lifespan) throws DuplicateNameException {
        try (LockHold hold = this.object.getTrace().lockWrite();){
            TraceObjectInterfaceUtils.setLifespan(TraceObjectBreakpointLocation.class, this.object, lifespan);
            this.lifespan = lifespan;
        }
    }

    @Override
    public Lifespan getLifespan() {
        try (LockHold hold = this.object.getTrace().lockRead();){
            Lifespan computed = this.computeSpan();
            if (computed != null) {
                this.lifespan = computed;
            }
            Lifespan lifespan = this.lifespan;
            return lifespan;
        }
    }

    @Override
    public Lifespan computeSpan() {
        Lifespan span = TraceObjectBreakpointLocation.super.computeSpan();
        if (span != null) {
            return span;
        }
        return this.getSpecification().computeSpan();
    }

    @Override
    public long getPlacedSnap() {
        return this.getLifespan().lmin();
    }

    @Override
    public void setClearedSnap(long clearedSnap) throws DuplicateNameException {
        try (LockHold hold = this.object.getTrace().lockWrite();){
            this.setLifespan(Lifespan.span(this.getPlacedSnap(), clearedSnap));
        }
    }

    @Override
    public long getClearedSnap() {
        return this.getLifespan().lmax();
    }

    @Override
    public TraceBreakpoint splitAndSet(long snap, boolean enabled, Collection<TraceBreakpointKind> kinds) {
        try (LockHold hold = this.object.getTrace().lockWrite();){
            Set yes;
            Set asSet;
            if (enabled != this.isEnabled(snap)) {
                this.object.setValue(Lifespan.span(snap, this.getClearedSnap()), "_enabled", enabled);
            }
            Set set = asSet = kinds instanceof Set ? (yes = (Set)kinds) : Set.copyOf(kinds);
            if (!Objects.equals(asSet, this.getKinds())) {
                this.setKinds(Lifespan.span(snap, this.getClearedSnap()), asSet);
            }
            DBTraceObjectBreakpointLocation dBTraceObjectBreakpointLocation = this;
            return dBTraceObjectBreakpointLocation;
        }
    }

    @Override
    public void setEnabled(Lifespan lifespan, boolean enabled) {
        this.object.setValue(lifespan, "_enabled", enabled);
    }

    @Override
    public void setEnabled(boolean enabled) {
        try (LockHold hold = this.object.getTrace().lockWrite();){
            this.setEnabled(this.getLifespan(), enabled);
        }
    }

    @Override
    public boolean isEnabled(long snap) {
        try (LockHold hold = this.object.getTrace().lockRead();){
            Boolean locEn = TraceObjectInterfaceUtils.getValue(this.object, snap, "_enabled", Boolean.class, null);
            if (locEn != null) {
                boolean bl = locEn;
                return bl;
            }
            boolean bl = this.getSpecification().isEnabled(snap);
            return bl;
        }
    }

    @Override
    public void setKinds(Lifespan lifespan, Collection<TraceBreakpointKind> kinds) {
        try (LockHold hold = this.object.getTrace().lockWrite();){
            TraceObjectBreakpointSpec spec = this.getSpecification();
            if (spec.getObject() != this.getObject()) {
                throw new UnsupportedOperationException("Set via the specification instead");
            }
            spec.setKinds(lifespan, kinds);
        }
    }

    @Override
    public void setKinds(Collection<TraceBreakpointKind> kinds) {
        try (LockHold hold = this.object.getTrace().lockWrite();){
            this.setKinds(this.getLifespan(), kinds);
        }
    }

    @Override
    public Set<TraceBreakpointKind> getKinds() {
        try (LockHold hold = this.object.getTrace().lockRead();){
            Set<TraceBreakpointKind> set = this.getSpecification().getKinds();
            return set;
        }
    }

    @Override
    public Set<TraceThread> getThreads() {
        DBTraceObjectManager manager = this.object.getManager();
        TargetObjectSchema schema = manager.getRootSchema();
        try (LockHold hold = this.object.getTrace().lockRead();){
            Set<TraceThread> threads = this.object.queryAncestorsInterface(this.getLifespan(), TraceObjectThread.class).collect(Collectors.toSet());
            if (!threads.isEmpty()) {
                Set<TraceThread> set = threads;
                return set;
            }
            PathMatcher procMatcher = schema.searchFor(TargetProcess.class, false);
            Set<TraceThread> set = this.object.getAncestorsRoot(this.getLifespan(), (PathPredicates)procMatcher).flatMap(proc -> proc.getSource(this.object).querySuccessorsInterface(this.getLifespan(), TraceObjectThread.class, true)).collect(Collectors.toSet());
            return set;
        }
    }

    @Override
    public void setComment(Lifespan lifespan, String comment) {
        this.object.setValue(lifespan, "_comment", comment);
    }

    @Override
    public void setComment(String comment) {
        try (LockHold hold = this.object.getTrace().lockWrite();){
            this.setComment(this.getLifespan(), comment);
        }
    }

    @Override
    public String getComment() {
        try (LockHold hold = this.object.getTrace().lockRead();){
            String string = TraceObjectInterfaceUtils.getValue(this.object, this.getPlacedSnap(), "_comment", String.class, "");
            return string;
        }
    }

    @Override
    public void setEmuEnabled(Lifespan lifespan, boolean emuEnabled) {
        this.object.setValue(lifespan, "_emu_enabled", emuEnabled ? null : Boolean.valueOf(false));
    }

    @Override
    public void setEmuEnabled(boolean emuEnabled) {
        try (LockHold hold = this.object.getTrace().lockWrite();){
            this.setEmuEnabled(this.getLifespan(), emuEnabled);
        }
    }

    @Override
    public boolean isEmuEnabled(long snap) {
        try (LockHold hold = this.object.getTrace().lockRead();){
            boolean bl = TraceObjectInterfaceUtils.getValue(this.object, this.getPlacedSnap(), "_emu_enabled", Boolean.class, true);
            return bl;
        }
    }

    @Override
    public void setEmuSleigh(Lifespan lifespan, String sleigh) {
        if (sleigh == null || "emu_swi();\nemu_exec_decoded();\n".equals(sleigh)) {
            this.object.setValue(lifespan, "_emu_sleigh", null);
        } else {
            this.object.setValue(lifespan, "_emu_sleigh", sleigh.trim());
        }
    }

    @Override
    public void setEmuSleigh(String sleigh) {
        try (LockHold hold = this.object.getTrace().lockWrite();){
            this.setEmuSleigh(this.getLifespan(), sleigh);
        }
    }

    @Override
    public String getEmuSleigh() {
        try (LockHold hold = this.object.getTrace().lockRead();){
            String string = TraceObjectInterfaceUtils.getValue(this.object, this.getPlacedSnap(), "_emu_sleigh", String.class, "emu_swi();\nemu_exec_decoded();\n");
            return string;
        }
    }

    @Override
    public void delete() {
        try (LockHold hold = this.object.getTrace().lockWrite();){
            this.object.removeTree(this.computeSpan());
        }
    }

    @Override
    public TraceObject getObject() {
        return this.object;
    }

    @Override
    public TraceObjectBreakpointSpec getSpecification() {
        try (LockHold hold = this.object.getTrace().lockRead();){
            TraceObjectBreakpointSpec traceObjectBreakpointSpec = this.object.queryCanonicalAncestorsInterface(TraceObjectBreakpointSpec.class).findAny().orElseThrow();
            return traceObjectBreakpointSpec;
        }
    }

    public TraceAddressSpace getTraceAddressSpace() {
        return this.spaceForValue(this.computeMinSnap(), "_range");
    }

    @Override
    public TraceChangeRecord<?, ?> translateEvent(TraceChangeRecord<?, ?> rec) {
        return this.translator.translate(rec);
    }

    protected class BreakpointChangeTranslator
    extends DBTraceObjectInterface.Translator<TraceBreakpoint> {
        protected BreakpointChangeTranslator(DBTraceObject object, TraceBreakpoint iface) {
            super("_range", object, iface);
        }

        @Override
        protected TraceChangeType<TraceBreakpoint, Void> getAddedType() {
            return Trace.TraceBreakpointChangeType.ADDED;
        }

        @Override
        protected TraceChangeType<TraceBreakpoint, Lifespan> getLifespanChangedType() {
            return Trace.TraceBreakpointChangeType.LIFESPAN_CHANGED;
        }

        @Override
        protected TraceChangeType<TraceBreakpoint, Void> getChangedType() {
            return Trace.TraceBreakpointChangeType.CHANGED;
        }

        @Override
        protected boolean appliesToKey(String key) {
            return "_range".equals(key) || "_display".equals(key) || "_enabled".equals(key) || "_comment".equals(key);
        }

        @Override
        protected TraceChangeType<TraceBreakpoint, Void> getDeletedType() {
            return Trace.TraceBreakpointChangeType.DELETED;
        }
    }
}

