/*
 * Decompiled with CFR 0.152.
 */
package ghidra.dbg.isf;

import com.google.gson.JsonObject;
import ghidra.async.AsyncUtils;
import ghidra.dbg.isf.IsfErrorException;
import ghidra.dbg.isf.IsfServer;
import ghidra.dbg.isf.protocol.Isf;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.ISF.IsfDataTypeWriter;
import ghidra.util.Msg;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.io.StringWriter;
import java.util.concurrent.atomic.AtomicInteger;

public class IsfClientHandler {
    protected static final boolean LOG_ERROR_REPLY_STACKS = false;
    protected static final AtomicInteger sequencer = new AtomicInteger();
    private IsfServer server;

    protected static <T> T errorSendNotify(Throwable e) {
        Msg.error(IsfClientHandler.class, (Object)("Could not send notification: " + e));
        return null;
    }

    public IsfClientHandler(IsfServer server) {
        this.server = server;
    }

    protected Isf.RootMessage buildError(Isf.RootMessage req, Isf.ErrorCode code, String message) {
        return Isf.RootMessage.newBuilder().setSequence(req.getSequence()).setErrorReply(Isf.ErrorReply.newBuilder().setCode(code).setMessage(message)).build();
    }

    protected Isf.RootMessage replyError(Isf.RootMessage req, Throwable e) {
        Throwable t = AsyncUtils.unwrapThrowable((Throwable)e);
        Msg.debug((Object)this, (Object)("Error caused by request " + req + ": " + e));
        if (t instanceof UnsupportedOperationException) {
            return this.buildError(req, Isf.ErrorCode.EC_NOT_SUPPORTED, t.getMessage());
        }
        return this.buildError(req, Isf.ErrorCode.EC_UNKNOWN, "Unknown server-side error");
    }

    protected String getVersion() {
        return "V1";
    }

    protected Isf.RootMessage processMessage(Isf.RootMessage msg) throws IOException {
        switch (msg.getMsgCase()) {
            case PING_REQUEST: {
                return this.processPing(msg.getSequence(), msg.getPingRequest());
            }
            case FULL_EXPORT_REQUEST: {
                return this.processFullExport(msg.getSequence(), msg.getFullExportRequest());
            }
            case LOOK_TYPE_REQUEST: {
                return this.processLookType(msg.getSequence(), msg.getLookTypeRequest());
            }
            case LOOK_SYMBOL_REQUEST: {
                return this.processLookSym(msg.getSequence(), msg.getLookSymbolRequest());
            }
            case LOOK_ADDRESS_REQUEST: {
                return this.processLookAddr(msg.getSequence(), msg.getLookAddressRequest());
            }
            case ENUM_TYPES_REQUEST: {
                return this.processEnumTypes(msg.getSequence(), msg.getEnumTypesRequest());
            }
            case ENUM_SYMBOLS_REQUEST: {
                return this.processEnumSyms(msg.getSequence(), msg.getEnumSymbolsRequest());
            }
        }
        throw new IsfErrorException(Isf.ErrorCode.EC_BAD_REQUEST, "Unrecognized request: " + msg.getMsgCase());
    }

    protected Isf.RootMessage processPing(int seqno, Isf.PingRequest req) {
        return Isf.RootMessage.newBuilder().setSequence(seqno).setPingReply(Isf.PingReply.newBuilder().setContent(req.getContent())).build();
    }

    protected Isf.RootMessage processFullExport(int seqno, Isf.FullExportRequest req) throws IOException {
        String data = this.fullExport(req.getNs());
        return Isf.RootMessage.newBuilder().setSequence(seqno).setFullExportReply(Isf.FullExportReply.newBuilder().setValue(data)).build();
    }

    private String fullExport(String ns) throws IOException {
        IsfDataTypeWriter isfWriter = this.createDataTypeWriter(this.server.getDataTypeManager(ns));
        return this.writeFrom(isfWriter);
    }

    protected Isf.RootMessage processLookType(int seqno, Isf.LookTypeRequest req) throws IOException {
        String data = this.lookType(req.getNs(), req.getKey());
        return Isf.RootMessage.newBuilder().setSequence(seqno).setLookTypeReply(Isf.LookTypeReply.newBuilder().setValue(data)).build();
    }

    private String lookType(String ns, String key) throws IOException {
        IsfDataTypeWriter isfWriter = this.createDataTypeWriter(this.server.getDataTypeManager(ns));
        isfWriter.setSkipSymbols(true);
        isfWriter.requestType(key);
        return this.writeFrom(isfWriter);
    }

    protected Isf.RootMessage processLookSym(int seqno, Isf.LookSymRequest req) throws IOException {
        String data = this.lookSym(req.getNs(), req.getKey());
        return Isf.RootMessage.newBuilder().setSequence(seqno).setLookSymbolReply(Isf.LookSymReply.newBuilder().setValue(data)).build();
    }

    private String lookSym(String ns, String key) throws IOException {
        IsfDataTypeWriter isfWriter = this.createDataTypeWriter(this.server.getDataTypeManager(ns));
        isfWriter.setSkipTypes(true);
        isfWriter.requestSymbol(key);
        return this.writeFrom(isfWriter);
    }

    protected Isf.RootMessage processLookAddr(int seqno, Isf.LookAddrRequest req) throws IOException {
        String data = this.lookAddr(req.getNs(), req.getKey());
        return Isf.RootMessage.newBuilder().setSequence(seqno).setLookAddressReply(Isf.LookAddrReply.newBuilder().setValue(data)).build();
    }

    private String lookAddr(String ns, String key) throws IOException {
        IsfDataTypeWriter isfWriter = this.createDataTypeWriter(this.server.getDataTypeManager(ns));
        isfWriter.setSkipTypes(true);
        isfWriter.requestAddress(key);
        return this.writeFrom(isfWriter);
    }

    protected Isf.RootMessage processEnumTypes(int seqno, Isf.EnumTypesRequest req) throws IOException {
        String data = this.enumTypes(req.getNs());
        return Isf.RootMessage.newBuilder().setSequence(seqno).setEnumTypesReply(Isf.EnumTypesReply.newBuilder().setValue(data)).build();
    }

    private String enumTypes(String ns) throws IOException {
        IsfDataTypeWriter isfWriter = this.createDataTypeWriter(this.server.getDataTypeManager(ns));
        isfWriter.setSkipSymbols(true);
        return this.writeFrom(isfWriter);
    }

    protected Isf.RootMessage processEnumSyms(int seqno, Isf.EnumSymsRequest req) throws IOException {
        String data = this.enumSyms(req.getNs());
        return Isf.RootMessage.newBuilder().setSequence(seqno).setEnumSymbolsReply(Isf.EnumSymsReply.newBuilder().setValue(data)).build();
    }

    private String enumSyms(String ns) throws IOException {
        IsfDataTypeWriter isfWriter = this.createDataTypeWriter(this.server.getDataTypeManager(ns));
        isfWriter.setSkipTypes(true);
        return this.writeFrom(isfWriter);
    }

    private IsfDataTypeWriter createDataTypeWriter(DataTypeManager dtm) throws IOException {
        StringWriter out = new StringWriter();
        return new IsfDataTypeWriter(dtm, out);
    }

    private String writeFrom(IsfDataTypeWriter dataTypeWriter) throws IOException {
        try {
            JsonObject object = dataTypeWriter.getRootObject(TaskMonitor.DUMMY);
            dataTypeWriter.write(object);
        }
        catch (CancelledException cancelledException) {
        }
        finally {
            dataTypeWriter.close();
        }
        return dataTypeWriter.toString();
    }
}

