/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.pcode;

import ghidra.program.model.address.Address;
import ghidra.program.model.pcode.AttributeId;
import ghidra.program.model.pcode.BlockGraph;
import ghidra.program.model.pcode.BlockMap;
import ghidra.program.model.pcode.Decoder;
import ghidra.program.model.pcode.DecoderException;
import ghidra.program.model.pcode.ElementId;
import ghidra.program.model.pcode.Encoder;
import java.io.IOException;
import java.util.ArrayList;

public class PcodeBlock {
    int index = -1;
    int blocktype = 0;
    PcodeBlock parent = null;
    private ArrayList<BlockEdge> intothis = new ArrayList();
    private ArrayList<BlockEdge> outofthis = new ArrayList();
    public static final int PLAIN = 0;
    public static final int BASIC = 1;
    public static final int GRAPH = 2;
    public static final int COPY = 3;
    public static final int GOTO = 4;
    public static final int MULTIGOTO = 5;
    public static final int LIST = 6;
    public static final int CONDITION = 7;
    public static final int PROPERIF = 8;
    public static final int IFELSE = 9;
    public static final int IFGOTO = 10;
    public static final int WHILEDO = 11;
    public static final int DOWHILE = 12;
    public static final int SWITCH = 13;
    public static final int INFLOOP = 14;

    public static String typeToName(int type) {
        switch (type) {
            case 0: {
                return "plain";
            }
            case 1: {
                return "basic";
            }
            case 2: {
                return "graph";
            }
            case 3: {
                return "plain";
            }
            case 4: {
                return "goto";
            }
            case 5: {
                return "multigoto";
            }
            case 6: {
                return "list";
            }
            case 7: {
                return "condition";
            }
            case 8: {
                return "properif";
            }
            case 9: {
                return "ifelse";
            }
            case 10: {
                return "ifgoto";
            }
            case 11: {
                return "whiledo";
            }
            case 12: {
                return "dowhile";
            }
            case 13: {
                return "switch";
            }
            case 14: {
                return "infloop";
            }
        }
        return null;
    }

    public static int nameToType(String name) {
        switch (name.charAt(0)) {
            case 'c': {
                return 3;
            }
            case 'd': {
                return 12;
            }
            case 'g': {
                if (name.equals("goto")) {
                    return 4;
                }
                return 2;
            }
            case 'i': {
                if (name.equals("ifelse")) {
                    return 9;
                }
                if (name.equals("infloop")) {
                    return 14;
                }
                return 10;
            }
            case 'l': {
                return 6;
            }
            case 'm': {
                return 5;
            }
            case 'p': {
                if (name.equals("properif")) {
                    return 8;
                }
                return 0;
            }
            case 's': {
                return 13;
            }
            case 'w': {
                return 11;
            }
        }
        return -1;
    }

    public String toString() {
        return PcodeBlock.typeToName(this.blocktype) + "@" + this.getStart();
    }

    public int getType() {
        return this.blocktype;
    }

    public Address getStart() {
        return Address.NO_ADDRESS;
    }

    public Address getStop() {
        return Address.NO_ADDRESS;
    }

    public void setIndex(int i) {
        this.index = i;
    }

    public int getIndex() {
        return this.index;
    }

    public PcodeBlock getParent() {
        return this.parent;
    }

    protected void addInEdge(PcodeBlock b, int lab) {
        int ourrev = b.outofthis.size();
        int brev = this.intothis.size();
        this.intothis.add(new BlockEdge(b, lab, ourrev));
        b.outofthis.add(new BlockEdge(this, lab, brev));
    }

    protected void decodeNextInEdge(Decoder decoder, BlockMap resolver) throws DecoderException {
        BlockEdge inEdge = new BlockEdge();
        this.intothis.add(inEdge);
        inEdge.decode(decoder, resolver);
        while (inEdge.point.outofthis.size() <= inEdge.reverse_index) {
            inEdge.point.outofthis.add(null);
        }
        BlockEdge outEdge = new BlockEdge(this, 0, this.intothis.size() - 1);
        inEdge.point.outofthis.set(inEdge.reverse_index, outEdge);
    }

    protected void decodeNextInEdge(Decoder decoder, ArrayList<? extends PcodeBlock> blockList) throws DecoderException {
        BlockEdge inEdge = new BlockEdge();
        this.intothis.add(inEdge);
        inEdge.decode(decoder, blockList);
        while (inEdge.point.outofthis.size() <= inEdge.reverse_index) {
            inEdge.point.outofthis.add(null);
        }
        BlockEdge outEdge = new BlockEdge(this, 0, this.intothis.size() - 1);
        inEdge.point.outofthis.set(inEdge.reverse_index, outEdge);
    }

    public PcodeBlock getIn(int i) {
        return this.intothis.get((int)i).point;
    }

    public PcodeBlock getOut(int i) {
        return this.outofthis.get((int)i).point;
    }

    public int getOutRevIndex(int i) {
        return this.outofthis.get((int)i).reverse_index;
    }

    public int getInRevIndex(int i) {
        return this.intothis.get((int)i).reverse_index;
    }

    public PcodeBlock getFalseOut() {
        return this.outofthis.get((int)0).point;
    }

    public PcodeBlock getTrueOut() {
        return this.outofthis.get((int)1).point;
    }

    public int getInSize() {
        return this.intothis.size();
    }

    public int getOutSize() {
        return this.outofthis.size();
    }

    public int calcDepth(PcodeBlock leaf) {
        int depth = 0;
        while (leaf != this) {
            if (leaf == null) {
                return -1;
            }
            leaf = leaf.getParent();
            ++depth;
        }
        return depth;
    }

    public PcodeBlock getFrontLeaf() {
        PcodeBlock bl = this;
        while (bl instanceof BlockGraph) {
            bl = ((BlockGraph)bl).getBlock(0);
        }
        return bl;
    }

    protected void encodeHeader(Encoder encoder) throws IOException {
        encoder.writeSignedInteger(AttributeId.ATTRIB_INDEX, this.index);
    }

    protected void decodeHeader(Decoder decoder) throws DecoderException {
        this.index = (int)decoder.readSignedInteger(AttributeId.ATTRIB_INDEX);
    }

    protected void encodeBody(Encoder encoder) throws IOException {
    }

    protected void encodeEdges(Encoder encoder) throws IOException {
        for (BlockEdge element : this.intothis) {
            element.encode(encoder);
        }
    }

    protected void decodeBody(Decoder decoder, BlockMap resolver) throws DecoderException {
    }

    protected void decodeEdges(Decoder decoder, BlockMap resolver) throws DecoderException {
        int el;
        while ((el = decoder.peekElement()) == ElementId.ELEM_EDGE.id()) {
            this.decodeNextInEdge(decoder, resolver);
        }
    }

    public void encode(Encoder encoder) throws IOException {
        encoder.openElement(ElementId.ELEM_BLOCK);
        this.encodeHeader(encoder);
        this.encodeBody(encoder);
        this.encodeEdges(encoder);
        encoder.closeElement(ElementId.ELEM_BLOCK);
    }

    public void decode(Decoder decoder, BlockMap resolver) throws DecoderException {
        int el = decoder.openElement(ElementId.ELEM_BLOCK);
        this.decodeHeader(decoder);
        this.decodeBody(decoder, resolver);
        this.decodeEdges(decoder, resolver);
        decoder.closeElement(el);
    }

    public static class BlockEdge {
        public int label;
        public PcodeBlock point;
        public int reverse_index;

        public BlockEdge(PcodeBlock pt, int lab, int rev) {
            this.label = lab;
            this.point = pt;
            this.reverse_index = rev;
        }

        public BlockEdge() {
        }

        public void encode(Encoder encoder) throws IOException {
            encoder.openElement(ElementId.ELEM_EDGE);
            encoder.writeSignedInteger(AttributeId.ATTRIB_END, this.point.getIndex());
            encoder.writeSignedInteger(AttributeId.ATTRIB_REV, this.reverse_index);
            encoder.closeElement(ElementId.ELEM_EDGE);
        }

        public void decode(Decoder decoder, BlockMap resolver) throws DecoderException {
            int el = decoder.openElement(ElementId.ELEM_EDGE);
            this.label = 0;
            int endIndex = (int)decoder.readSignedInteger(AttributeId.ATTRIB_END);
            this.point = resolver.findLevelBlock(endIndex);
            if (this.point == null) {
                throw new DecoderException("Bad serialized edge in block graph");
            }
            this.reverse_index = (int)decoder.readSignedInteger(AttributeId.ATTRIB_REV);
            decoder.closeElement(el);
        }

        public void decode(Decoder decoder, ArrayList<? extends PcodeBlock> blockList) throws DecoderException {
            int el = decoder.openElement(ElementId.ELEM_EDGE);
            this.label = 0;
            int endIndex = (int)decoder.readSignedInteger(AttributeId.ATTRIB_END);
            this.point = blockList.get(endIndex);
            if (this.point == null) {
                throw new DecoderException("Bad serialized edge in block list");
            }
            this.reverse_index = (int)decoder.readSignedInteger(AttributeId.ATTRIB_REV);
            decoder.closeElement(el);
        }

        public String toString() {
            return "Edge -> " + this.point;
        }
    }
}

