/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.pcode;

import ghidra.program.model.address.Address;
import ghidra.program.model.data.DataType;
import ghidra.program.model.lang.DynamicVariableStorage;
import ghidra.program.model.listing.AutoParameterType;
import ghidra.program.model.listing.Program;
import ghidra.program.model.listing.VariableStorage;
import ghidra.program.model.pcode.AttributeId;
import ghidra.program.model.pcode.Decoder;
import ghidra.program.model.pcode.DecoderException;
import ghidra.program.model.pcode.DynamicEntry;
import ghidra.program.model.pcode.ElementId;
import ghidra.program.model.pcode.Encoder;
import ghidra.program.model.pcode.EquateSymbol;
import ghidra.program.model.pcode.HighCodeSymbol;
import ghidra.program.model.pcode.HighFunction;
import ghidra.program.model.pcode.HighVariable;
import ghidra.program.model.pcode.MappedDataEntry;
import ghidra.program.model.pcode.MappedEntry;
import ghidra.program.model.pcode.PcodeDataTypeManager;
import ghidra.program.model.pcode.SymbolEntry;
import ghidra.program.model.symbol.Namespace;
import ghidra.program.model.symbol.Symbol;
import ghidra.util.exception.InvalidInputException;
import java.io.IOException;

public class HighSymbol {
    public static final long ID_BASE = 0x4000000000000000L;
    protected String name;
    protected DataType type;
    protected HighFunction function;
    protected int category;
    protected int categoryIndex;
    private boolean namelock;
    private boolean typelock;
    private boolean isThis;
    private boolean isHidden;
    private long id;
    protected SymbolEntry[] entryList;
    private HighVariable highVariable;
    protected PcodeDataTypeManager dtmanage;

    protected HighSymbol(HighFunction func) {
        this.function = func;
        this.dtmanage = this.function.getDataTypeManager();
        this.isThis = false;
        this.isHidden = false;
    }

    protected HighSymbol(long uniqueId, String nm, DataType tp, HighFunction func) {
        this.function = func;
        this.dtmanage = this.function.getDataTypeManager();
        this.name = nm;
        this.type = tp;
        this.namelock = false;
        this.typelock = false;
        this.isThis = false;
        this.isHidden = false;
        this.id = uniqueId;
        this.category = -1;
        this.categoryIndex = -1;
    }

    protected HighSymbol(long uniqueId, String nm, DataType tp, boolean tlock, boolean nlock, PcodeDataTypeManager manage) {
        this.function = null;
        this.dtmanage = manage;
        this.name = nm;
        this.type = tp;
        this.namelock = nlock;
        this.typelock = tlock;
        this.isThis = false;
        this.isHidden = false;
        this.id = uniqueId;
        this.category = -1;
        this.categoryIndex = -1;
    }

    protected void addMapEntry(SymbolEntry entry) {
        if (this.entryList == null) {
            this.entryList = new SymbolEntry[1];
            this.entryList[0] = entry;
            if (entry.getStorage().isAutoStorage()) {
                AutoParameterType autoType = entry.getStorage().getAutoParameterType();
                if (autoType == AutoParameterType.THIS) {
                    this.isThis = true;
                } else if (autoType == AutoParameterType.RETURN_STORAGE_PTR) {
                    this.isHidden = true;
                }
            }
        } else {
            SymbolEntry[] newList = new SymbolEntry[this.entryList.length + 1];
            for (int i = 0; i < this.entryList.length; ++i) {
                newList[i] = this.entryList[i];
            }
            newList[this.entryList.length] = entry;
            this.entryList = newList;
        }
    }

    public long getId() {
        return this.id;
    }

    public Symbol getSymbol() {
        if (this.id != 0L) {
            return this.getProgram().getSymbolTable().getSymbol(this.id);
        }
        return null;
    }

    public Namespace getNamespace() {
        Symbol sym = this.getSymbol();
        if (sym != null) {
            return sym.getParentNamespace();
        }
        return null;
    }

    void setHighVariable(HighVariable high) {
        if (this.highVariable != null && this.highVariable.getSize() >= high.getSize()) {
            return;
        }
        this.highVariable = high;
    }

    public HighVariable getHighVariable() {
        return this.highVariable;
    }

    public String getName() {
        return this.name;
    }

    public Program getProgram() {
        return this.dtmanage.getProgram();
    }

    public DataType getDataType() {
        return this.type;
    }

    public int getSize() {
        return this.entryList[0].getSize();
    }

    public Address getPCAddress() {
        return this.entryList[0].pcaddr;
    }

    protected int getFirstUseOffset() {
        Address pcaddr = this.entryList[0].pcaddr;
        if (pcaddr == null) {
            return 0;
        }
        return (int)pcaddr.subtract(this.getHighFunction().getFunction().getEntryPoint());
    }

    public HighFunction getHighFunction() {
        return this.function;
    }

    protected void setCategory(int cat, int index) {
        this.category = cat;
        this.categoryIndex = index;
    }

    public void setTypeLock(boolean typelock) {
        this.typelock = typelock;
    }

    public void setNameLock(boolean namelock) {
        this.namelock = namelock;
    }

    public boolean isTypeLocked() {
        return this.typelock;
    }

    public boolean isNameLocked() {
        return this.namelock;
    }

    public boolean isIsolated() {
        return this.typelock;
    }

    public boolean isReadOnly() {
        return this.entryList[0].isReadOnly();
    }

    public boolean isParameter() {
        return this.category == 0;
    }

    public int getCategoryIndex() {
        return this.categoryIndex;
    }

    public boolean isGlobal() {
        return false;
    }

    public boolean isThisPointer() {
        return this.isThis;
    }

    public boolean isHiddenReturn() {
        return this.isHidden;
    }

    public SymbolEntry getFirstWholeMap() {
        return this.entryList[0];
    }

    public VariableStorage getStorage() {
        return this.entryList[0].getStorage();
    }

    protected void encodeHeader(Encoder encoder) throws IOException {
        if (this.id >> 56 != 64L) {
            encoder.writeUnsignedInteger(AttributeId.ATTRIB_ID, this.id);
        }
        encoder.writeString(AttributeId.ATTRIB_NAME, this.name);
        encoder.writeBool(AttributeId.ATTRIB_TYPELOCK, this.typelock);
        encoder.writeBool(AttributeId.ATTRIB_NAMELOCK, this.namelock);
        encoder.writeBool(AttributeId.ATTRIB_READONLY, this.isReadOnly());
        boolean isVolatile = this.entryList[0].isVolatile();
        if (isVolatile) {
            encoder.writeBool(AttributeId.ATTRIB_VOLATILE, true);
        }
        if (this.isIsolated()) {
            encoder.writeBool(AttributeId.ATTRIB_MERGE, false);
        }
        if (this.isThis) {
            encoder.writeBool(AttributeId.ATTRIB_THISPTR, true);
        }
        if (this.isHidden) {
            encoder.writeBool(AttributeId.ATTRIB_HIDDENRETPARM, true);
        }
        encoder.writeSignedInteger(AttributeId.ATTRIB_CAT, this.category);
        if (this.categoryIndex >= 0) {
            encoder.writeUnsignedInteger(AttributeId.ATTRIB_INDEX, this.categoryIndex);
        }
    }

    public void encode(Encoder encoder) throws IOException {
        encoder.openElement(ElementId.ELEM_SYMBOL);
        this.encodeHeader(encoder);
        this.dtmanage.encodeTypeRef(encoder, this.type, this.getSize());
        encoder.closeElement(ElementId.ELEM_SYMBOL);
    }

    protected void decodeHeader(Decoder decoder) throws DecoderException {
        int attribId;
        this.name = null;
        this.id = 0L;
        this.typelock = false;
        this.namelock = false;
        this.isThis = false;
        this.isHidden = false;
        this.categoryIndex = -1;
        this.category = -1;
        while ((attribId = decoder.getNextAttributeId()) != 0) {
            if (attribId == AttributeId.ATTRIB_ID.id()) {
                this.id = decoder.readUnsignedInteger();
                continue;
            }
            if (attribId == AttributeId.ATTRIB_TYPELOCK.id()) {
                this.typelock = decoder.readBool();
                continue;
            }
            if (attribId == AttributeId.ATTRIB_NAMELOCK.id()) {
                this.namelock = decoder.readBool();
                continue;
            }
            if (attribId == AttributeId.ATTRIB_THISPTR.id()) {
                this.isThis = decoder.readBool();
                continue;
            }
            if (attribId == AttributeId.ATTRIB_HIDDENRETPARM.id()) {
                this.isHidden = decoder.readBool();
                continue;
            }
            if (attribId == AttributeId.ATTRIB_NAME.id()) {
                this.name = decoder.readString();
                continue;
            }
            if (attribId == AttributeId.ATTRIB_CAT.id()) {
                this.category = (int)decoder.readSignedInteger();
                continue;
            }
            if (attribId != AttributeId.ATTRIB_INDEX.id()) continue;
            this.categoryIndex = (int)decoder.readUnsignedInteger();
        }
        if (this.id == 0L) {
            throw new DecoderException("missing unique symbol id");
        }
    }

    public void decode(Decoder decoder) throws DecoderException {
        int el;
        int symel = decoder.openElement(ElementId.ELEM_SYMBOL);
        this.decodeHeader(decoder);
        this.type = this.dtmanage.decodeDataType(decoder);
        decoder.closeElement(symel);
        if (this.categoryIndex >= 0 && this.name.startsWith("$$undef")) {
            this.name = "param_" + Integer.toString(this.categoryIndex + 1);
        }
        while ((el = decoder.peekElement()) != 0) {
            SymbolEntry entry = el == ElementId.ELEM_HASH.id() ? new DynamicEntry(this) : (this instanceof HighCodeSymbol ? new MappedDataEntry(this) : new MappedEntry(this));
            ((SymbolEntry)entry).decode(decoder);
            this.addMapEntry(entry);
        }
        if ((this.isThis || this.isHidden) && this.entryList != null) {
            SymbolEntry entry = this.entryList[0];
            VariableStorage storage = entry.getStorage();
            AutoParameterType autoType = this.isThis ? AutoParameterType.THIS : AutoParameterType.RETURN_STORAGE_PTR;
            try {
                DynamicVariableStorage newStorage = new DynamicVariableStorage(storage.getProgramArchitecture(), autoType, storage.getFirstVarnode());
                this.entryList[0] = new MappedEntry(this, newStorage, entry.getPCAdress());
            }
            catch (InvalidInputException e) {
                throw new DecoderException("Unable to parse auto-parameter");
            }
        }
    }

    public static HighSymbol decodeMapSym(Decoder decoder, boolean isGlobal, HighFunction high) throws DecoderException {
        int subid;
        HighSymbol res = null;
        int mapel = decoder.openElement(ElementId.ELEM_MAPSYM);
        int symel = decoder.peekElement();
        if (symel == ElementId.ELEM_EQUATESYMBOL.id()) {
            res = new EquateSymbol(high);
        } else if (!isGlobal) {
            res = new HighSymbol(high);
        }
        res.decode(decoder);
        while ((subid = decoder.peekElement()) != 0) {
            SymbolEntry entry = subid == ElementId.ELEM_HASH.id() ? new DynamicEntry(res) : new MappedEntry(res);
            entry.decode(decoder);
            res.addMapEntry(entry);
        }
        decoder.closeElement(mapel);
        return res;
    }

    public static void encodeMapSym(Encoder encoder, HighSymbol sym) throws IOException {
        encoder.openElement(ElementId.ELEM_MAPSYM);
        sym.encode(encoder);
        for (SymbolEntry entry : sym.entryList) {
            entry.encode(encoder);
        }
        encoder.closeElement(ElementId.ELEM_MAPSYM);
    }
}

