/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.data;

import ghidra.program.model.data.ByteDataType;
import ghidra.program.model.data.CharDataType;
import ghidra.program.model.data.DWordDataType;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DoubleDataType;
import ghidra.program.model.data.FloatDataType;
import ghidra.program.model.data.Pointer;
import ghidra.program.model.data.QWordDataType;
import ghidra.program.model.data.StringDataType;
import ghidra.program.model.data.UnicodeDataType;
import ghidra.program.model.data.WordDataType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.swing.KeyStroke;

public class CycleGroup {
    public static final CycleGroup BYTE_CYCLE_GROUP = new ByteCycleGroup();
    public static final CycleGroup FLOAT_CYCLE_GROUP = new FloatCycleGroup();
    public static final CycleGroup STRING_CYCLE_GROUP = new StringCycleGroup();
    public static final List<CycleGroup> ALL_CYCLE_GROUPS = CycleGroup.createCycleGroups();
    private String name;
    private ArrayList<DataType> dataList;
    protected KeyStroke defaultKeyStroke;

    private static List<CycleGroup> createCycleGroups() {
        ArrayList<CycleGroup> list = new ArrayList<CycleGroup>();
        list.add(BYTE_CYCLE_GROUP);
        list.add(FLOAT_CYCLE_GROUP);
        list.add(STRING_CYCLE_GROUP);
        return Collections.unmodifiableList(list);
    }

    public CycleGroup(String name, DataType[] dataTypes, KeyStroke keyStroke) {
        this.name = name;
        this.defaultKeyStroke = keyStroke;
        List<DataType> list = Arrays.asList(dataTypes);
        this.dataList = new ArrayList<DataType>(list);
    }

    public CycleGroup(String name, DataType dt, KeyStroke keyStroke) {
        this(name, new DataType[]{dt}, keyStroke);
    }

    public CycleGroup(String name) {
        this(name, new DataType[0], null);
    }

    public DataType[] getDataTypes() {
        DataType[] dt = new DataType[this.dataList.size()];
        return this.dataList.toArray(dt);
    }

    public String getName() {
        return this.name;
    }

    public int size() {
        return this.dataList.size();
    }

    public KeyStroke getDefaultKeyStroke() {
        return this.defaultKeyStroke;
    }

    public void addDataType(DataType dt) {
        if (dt == null) {
            return;
        }
        if (!this.exists(dt)) {
            this.dataList.add(dt);
        }
    }

    public void addFirst(DataType dt) {
        if (dt == null) {
            return;
        }
        if (!this.exists(dt)) {
            this.dataList.add(0, dt);
        }
    }

    public void removeDataType(DataType dt) {
        this.dataList.remove(dt);
    }

    public void removeFirst() {
        this.dataList.remove(0);
    }

    public void removeLast() {
        this.dataList.remove(this.dataList.size() - 1);
    }

    public boolean contains(DataType dt) {
        return this.exists(dt);
    }

    private boolean exists(DataType dt) {
        for (int i = 0; i < this.dataList.size(); ++i) {
            DataType d = this.dataList.get(i);
            if (!dt.isEquivalent(d)) continue;
            return true;
        }
        return false;
    }

    public DataType getNextDataType(DataType currentDataType, boolean stackPointers) {
        if (this.dataList.size() == 0) {
            return null;
        }
        DataType dataType = currentDataType;
        Pointer ptr = null;
        if (stackPointers && dataType instanceof Pointer) {
            ptr = (Pointer)dataType;
            dataType = this.getNextDataType(ptr.getDataType(), true);
            return ptr.newPointer(dataType);
        }
        int index = -1;
        if (dataType != null && !dataType.isEquivalent(DataType.DEFAULT)) {
            for (int i = 0; i < this.dataList.size(); ++i) {
                DataType cycleDt = this.dataList.get(i);
                if (!dataType.isEquivalent(cycleDt)) continue;
                index = i;
                break;
            }
        }
        dataType = ++index >= this.dataList.size() ? this.dataList.get(0) : this.dataList.get(index);
        return dataType;
    }

    private static class ByteCycleGroup
    extends CycleGroup {
        public ByteCycleGroup() {
            super("Cycle: byte,word,dword,qword");
            this.addDataType(new ByteDataType());
            this.addDataType(new WordDataType());
            this.addDataType(new DWordDataType());
            this.addDataType(new QWordDataType());
            this.defaultKeyStroke = KeyStroke.getKeyStroke(66, 0);
        }
    }

    private static class FloatCycleGroup
    extends CycleGroup {
        public FloatCycleGroup() {
            super("Cycle: float,double");
            this.addDataType(new FloatDataType());
            this.addDataType(new DoubleDataType());
            this.defaultKeyStroke = KeyStroke.getKeyStroke(70, 0);
        }
    }

    private static class StringCycleGroup
    extends CycleGroup {
        public StringCycleGroup() {
            super("Cycle: char,string,unicode");
            this.addDataType(new CharDataType());
            this.addDataType(new StringDataType());
            this.addDataType(new UnicodeDataType());
            this.defaultKeyStroke = KeyStroke.getKeyStroke(222, 0);
        }
    }
}

