/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.database.reloc;

import db.BinaryCodedField;
import db.DBFieldIterator;
import db.DBHandle;
import db.DBRecord;
import db.Field;
import db.KeyToRecordIterator;
import db.RecordIterator;
import db.Table;
import ghidra.program.database.map.AddressIndexPrimaryKeyIterator;
import ghidra.program.database.map.AddressMap;
import ghidra.program.database.reloc.RelocationDBAdapter;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSetView;
import ghidra.util.exception.VersionException;
import java.io.IOException;

public class RelocationDBAdapterV6
extends RelocationDBAdapter {
    static final int VERSION = 6;
    private Table relocTable;
    private AddressMap addrMap;

    RelocationDBAdapterV6(DBHandle handle, AddressMap addrMap, boolean create) throws IOException, VersionException {
        this.addrMap = addrMap;
        if (create) {
            this.relocTable = handle.createTable("Relocations", SCHEMA, new int[]{0});
        } else {
            this.relocTable = handle.getTable("Relocations");
            if (this.relocTable == null) {
                throw new VersionException(true);
            }
            int version = this.relocTable.getSchema().getVersion();
            if (version != 6) {
                throw new VersionException(version < 6);
            }
        }
    }

    @Override
    void add(Address addr, byte flags, int type, long[] values, byte[] bytes, String symbolName) throws IOException {
        long key = this.relocTable.getKey();
        DBRecord r = SCHEMA.createRecord(key);
        r.setLongValue(0, this.addrMap.getKey(addr, true));
        r.setByteValue(1, flags);
        r.setIntValue(2, type);
        r.setField(3, (Field)new BinaryCodedField(values));
        r.setBinaryData(4, bytes);
        r.setString(5, symbolName);
        this.relocTable.putRecord(r);
    }

    @Override
    int getRecordCount() {
        return this.relocTable.getRecordCount();
    }

    @Override
    RecordIterator iterator() throws IOException {
        return new KeyToRecordIterator(this.relocTable, (DBFieldIterator)new AddressIndexPrimaryKeyIterator(this.relocTable, 0, this.addrMap, true));
    }

    @Override
    RecordIterator iterator(AddressSetView set) throws IOException {
        return new KeyToRecordIterator(this.relocTable, (DBFieldIterator)new AddressIndexPrimaryKeyIterator(this.relocTable, 0, this.addrMap, set, true));
    }

    @Override
    RecordIterator iterator(Address start) throws IOException {
        return new KeyToRecordIterator(this.relocTable, (DBFieldIterator)new AddressIndexPrimaryKeyIterator(this.relocTable, 0, this.addrMap, start, true));
    }

    @Override
    DBRecord adaptRecord(DBRecord rec) {
        throw new UnsupportedOperationException("Don't know how to adapt to the new version");
    }

    void put(DBRecord rec) throws IOException {
        this.relocTable.putRecord(rec);
    }
}

