/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.database.reloc;

import db.DBHandle;
import db.DBRecord;
import db.RecordIterator;
import db.Table;
import ghidra.program.database.map.AddressKeyRecordIterator;
import ghidra.program.database.map.AddressMap;
import ghidra.program.database.reloc.RelocationDBAdapter;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.reloc.Relocation;
import ghidra.util.exception.VersionException;
import java.io.IOException;

class RelocationDBAdapterV3
extends RelocationDBAdapter {
    static final int VERSION = 3;
    private static final int V3_TYPE_COL = 0;
    private static final int V3_VALUE_COL = 1;
    private static final int V3_BYTES_COL = 2;
    private Table relocTable;
    private AddressMap addrMap;

    RelocationDBAdapterV3(DBHandle handle, AddressMap addrMap) throws IOException, VersionException {
        this.addrMap = addrMap;
        this.relocTable = handle.getTable("Relocations");
        if (this.relocTable == null || this.relocTable.getSchema().getVersion() != 3) {
            throw new VersionException();
        }
    }

    @Override
    void add(Address addrKey, byte flags, int type, long[] values, byte[] bytes, String symbolName) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    int getRecordCount() {
        return this.relocTable.getRecordCount();
    }

    @Override
    RecordIterator iterator() throws IOException {
        AddressKeyRecordIterator recIter = new AddressKeyRecordIterator(this.relocTable, this.addrMap);
        return new RelocationDBAdapter.RecordIteratorAdapter(this, recIter);
    }

    @Override
    RecordIterator iterator(AddressSetView set) throws IOException {
        AddressKeyRecordIterator recIter = new AddressKeyRecordIterator(this.relocTable, this.addrMap, set, set.getMinAddress(), true);
        return new RelocationDBAdapter.RecordIteratorAdapter(this, recIter);
    }

    @Override
    RecordIterator iterator(Address start) throws IOException {
        AddressKeyRecordIterator recIter = new AddressKeyRecordIterator(this.relocTable, this.addrMap, start, true);
        return new RelocationDBAdapter.RecordIteratorAdapter(this, recIter);
    }

    @Override
    DBRecord adaptRecord(DBRecord rec) {
        if (rec == null) {
            return null;
        }
        DBRecord newRec = SCHEMA.createRecord(rec.getKey());
        newRec.setLongValue(0, rec.getKey());
        newRec.setByteValue(1, RelocationDBAdapterV3.getFlags(Relocation.Status.UNKNOWN, 0));
        newRec.setIntValue(2, rec.getIntValue(0));
        newRec.setBinaryData(3, rec.getBinaryData(1));
        newRec.setBinaryData(4, rec.getBinaryData(2));
        return newRec;
    }
}

