/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.database.reloc;

import db.DBHandle;
import db.DBRecord;
import db.RecordIterator;
import db.Table;
import ghidra.program.database.map.AddressKeyRecordIterator;
import ghidra.program.database.map.AddressMap;
import ghidra.program.database.reloc.RelocationDBAdapter;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.reloc.Relocation;
import ghidra.util.exception.VersionException;
import java.io.IOException;

class RelocationDBAdapterV1
extends RelocationDBAdapter {
    static final int VERSION = 1;
    private static final int V1_TYPE_COL = 0;
    private Table relocTable;
    private AddressMap addrMap;

    RelocationDBAdapterV1(DBHandle handle, AddressMap addrMap) throws IOException, VersionException {
        this.addrMap = addrMap;
        this.relocTable = handle.getTable("Relocations");
        if (this.relocTable == null || this.relocTable.getSchema().getVersion() != 1) {
            throw new VersionException();
        }
    }

    @Override
    void add(Address addrKey, byte flags, int type, long[] values, byte[] bytes, String symbolName) {
        throw new UnsupportedOperationException();
    }

    @Override
    int getRecordCount() {
        return this.relocTable.getRecordCount();
    }

    @Override
    RecordIterator iterator() throws IOException {
        AddressKeyRecordIterator recIter = new AddressKeyRecordIterator(this.relocTable, this.addrMap);
        return new RelocationDBAdapter.RecordIteratorAdapter(this, recIter);
    }

    @Override
    RecordIterator iterator(AddressSetView set) throws IOException {
        AddressKeyRecordIterator recIter = new AddressKeyRecordIterator(this.relocTable, this.addrMap, set, set.getMinAddress(), true);
        return new RelocationDBAdapter.RecordIteratorAdapter(this, recIter);
    }

    @Override
    RecordIterator iterator(Address start) throws IOException {
        AddressKeyRecordIterator recIter = new AddressKeyRecordIterator(this.relocTable, this.addrMap, start, true);
        return new RelocationDBAdapter.RecordIteratorAdapter(this, recIter);
    }

    @Override
    DBRecord adaptRecord(DBRecord rec) {
        if (rec == null) {
            return null;
        }
        DBRecord newRec = SCHEMA.createRecord(rec.getKey());
        newRec.setLongValue(0, rec.getKey());
        newRec.setByteValue(1, RelocationDBAdapterV1.getFlags(Relocation.Status.UNKNOWN, 0));
        newRec.setIntValue(2, rec.getIntValue(0));
        return newRec;
    }
}

