/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.database.register;

import db.BinaryField;
import db.DBHandle;
import db.Field;
import db.NoTransactionException;
import db.util.ErrorHandler;
import ghidra.program.database.map.AddressMap;
import ghidra.program.database.util.AddressRangeMapDB;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressRangeIterator;
import ghidra.program.model.lang.Register;
import ghidra.program.model.lang.RegisterValue;
import ghidra.program.util.LanguageTranslator;
import ghidra.program.util.RangeMapAdapter;
import ghidra.util.Lock;
import ghidra.util.exception.AssertException;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.task.TaskMonitor;

public class DatabaseRangeMapAdapter
implements RangeMapAdapter {
    static final String NAME_PREFIX = "Register_";
    static final String CONTEXT_TABLE_PREFIX = "Range Map - Register_";
    private String mapName;
    private ErrorHandler errorHandler;
    private DBHandle dbh;
    private AddressRangeMapDB rangeMap;
    private AddressMap addressMap;

    public DatabaseRangeMapAdapter(Register register, DBHandle dbHandle, AddressMap addrMap, Lock lock, ErrorHandler errorHandler) {
        this.dbh = dbHandle;
        this.errorHandler = errorHandler;
        this.mapName = NAME_PREFIX + register.getName();
        this.rangeMap = new AddressRangeMapDB(dbHandle, addrMap, lock, this.mapName, errorHandler, (Field)BinaryField.INSTANCE, false);
        this.addressMap = addrMap;
    }

    @Override
    public AddressRangeIterator getAddressRangeIterator(Address startAddr, Address endAddr) {
        return this.rangeMap.getAddressRanges(startAddr, endAddr);
    }

    @Override
    public AddressRangeIterator getAddressRangeIterator() {
        return this.rangeMap.getAddressRanges();
    }

    @Override
    public AddressRange getValueRangeContaining(Address addr) {
        return this.rangeMap.getAddressRangeContaining(addr);
    }

    @Override
    public byte[] getValue(Address address) {
        BinaryField field = (BinaryField)this.rangeMap.getValue(address);
        if (field != null) {
            return field.getBinaryData();
        }
        return null;
    }

    @Override
    public void moveAddressRange(Address fromAddr, Address toAddr, long length, TaskMonitor monitor) throws CancelledException {
        this.rangeMap.moveAddressRange(fromAddr, toAddr, length, monitor);
    }

    @Override
    public void set(Address start, Address end, byte[] bytes) {
        BinaryField field = new BinaryField(bytes);
        this.rangeMap.paintRange(start, end, (Field)field);
    }

    @Override
    public void clearRange(Address start, Address end) {
        this.rangeMap.clearRange(start, end);
    }

    @Override
    public void clearAll() {
        this.rangeMap.dispose();
    }

    @Override
    public boolean isEmpty() {
        return this.rangeMap.isEmpty();
    }

    @Override
    public void setLanguage(LanguageTranslator translator, Register mapReg, TaskMonitor monitor) throws CancelledException {
        Register newReg = translator.getNewRegister(mapReg);
        if (newReg == null) {
            this.rangeMap.dispose();
            this.rangeMap = null;
            return;
        }
        Register newBaseReg = newReg.getBaseRegister();
        AddressRangeMapDB tempMap = null;
        if (!newReg.isBaseRegister() || translator.isValueTranslationRequired(mapReg)) {
            Object tempName = "TEMP_MAP";
            int retry = 0;
            while (AddressRangeMapDB.exists(this.dbh, (String)tempName)) {
                tempName = "TEMP_MAP" + ++retry;
            }
            tempMap = new AddressRangeMapDB(this.dbh, this.addressMap, new Lock("Test"), (String)tempName, this.errorHandler, (Field)BinaryField.INSTANCE, false);
            monitor.initialize((long)this.rangeMap.getRecordCount());
            monitor.setMessage("Converting " + mapReg.getName() + " values...");
            int cnt = 0;
            AddressRangeIterator rangeIter = this.rangeMap.getAddressRanges();
            while (rangeIter.hasNext()) {
                if (monitor.isCancelled()) {
                    tempMap.dispose();
                    throw new CancelledException();
                }
                AddressRange range = (AddressRange)rangeIter.next();
                BinaryField value = (BinaryField)this.rangeMap.getValue(range.getMinAddress());
                byte[] oldBytes = value.getBinaryData();
                RegisterValue regValue = new RegisterValue(mapReg, oldBytes);
                if ((regValue = translator.getNewRegisterValue(regValue)) != null && regValue.hasAnyValue()) {
                    byte[] newBytes = regValue.toBytes();
                    tempMap.paintRange(range.getMinAddress(), range.getMaxAddress(), (Field)new BinaryField(newBytes));
                }
                monitor.setProgress((long)(++cnt));
            }
        }
        String newMapName = NAME_PREFIX + newBaseReg.getName();
        if (tempMap == null) {
            if (this.mapName.equals(newMapName)) {
                return;
            }
        } else {
            this.rangeMap.dispose();
            this.rangeMap = tempMap;
        }
        if (this.rangeMap != null) {
            try {
                this.rangeMap.setName(newMapName);
            }
            catch (DuplicateNameException e) {
                throw new AssertException("Unexpected DuplicateNameException");
            }
        }
        this.mapName = newMapName;
    }

    @Override
    public void checkWritableState() {
        try {
            this.dbh.checkTransaction();
        }
        catch (NoTransactionException e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }

    @Override
    public void invalidate() {
        this.rangeMap.invalidate();
    }
}

