/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.database.mem;

import db.DBBuffer;
import db.DBRecord;
import ghidra.framework.store.LockException;
import ghidra.program.database.map.AddressMapDB;
import ghidra.program.database.mem.BufferSubMemoryBlock;
import ghidra.program.database.mem.FileBytes;
import ghidra.program.database.mem.MemoryBlockInputStream;
import ghidra.program.database.mem.MemoryMapDB;
import ghidra.program.database.mem.MemoryMapDBAdapter;
import ghidra.program.database.mem.SubMemoryBlock;
import ghidra.program.database.mem.UninitializedSubMemoryBlock;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressOverflowException;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.SegmentedAddress;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.program.model.mem.MemoryBlock;
import ghidra.program.model.mem.MemoryBlockSourceInfo;
import ghidra.program.model.mem.MemoryBlockType;
import ghidra.util.NumericUtilities;
import ghidra.util.exception.AssertException;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.List;

public class MemoryBlockDB
implements MemoryBlock {
    private MemoryMapDBAdapter adapter;
    protected DBRecord record;
    private Address startAddress;
    private long length;
    private List<SubMemoryBlock> subBlocks;
    protected MemoryMapDB memMap;
    private volatile boolean invalid;
    private long id;
    private SubMemoryBlock lastSubBlock;
    private List<MemoryBlockDB> mappedBlocks;

    MemoryBlockDB(MemoryMapDBAdapter adapter, DBRecord record, List<SubMemoryBlock> subBlocks) {
        this.adapter = adapter;
        this.record = record;
        this.memMap = adapter.getMemoryMap();
        this.id = record.getKey();
        this.refresh(record, subBlocks);
    }

    long getID() {
        return this.id;
    }

    void refresh(DBRecord lRecord, List<SubMemoryBlock> list) {
        if (this.id != lRecord.getKey()) {
            throw new AssertException("Incorrect block record");
        }
        this.record = lRecord;
        AddressMapDB addrMap = this.memMap.getAddressMap();
        this.startAddress = addrMap.decodeAddress(lRecord.getLongValue(4));
        if (this.startAddress instanceof SegmentedAddress) {
            SegmentedAddress imageBase = (SegmentedAddress)addrMap.getImageBase();
            int baseSegment = imageBase.getSegment();
            int segment = lRecord.getIntValue(6);
            this.startAddress = ((SegmentedAddress)this.startAddress).normalize(segment + baseSegment);
        }
        this.length = lRecord.getLongValue(5);
        this.lastSubBlock = null;
        Collections.sort(list);
        this.subBlocks = list;
        this.mappedBlocks = null;
    }

    void addMappedBlock(MemoryBlockDB mappedBlock) {
        if (this.mappedBlocks == null) {
            this.mappedBlocks = new ArrayList<MemoryBlockDB>();
        }
        this.mappedBlocks.add(mappedBlock);
    }

    void clearMappedBlockList() {
        this.mappedBlocks = null;
    }

    Collection<MemoryBlockDB> getMappedBlocks() {
        this.memMap.buildAddressSets();
        return this.mappedBlocks;
    }

    @Override
    public int compareTo(MemoryBlock o) {
        return this.startAddress.compareTo(o.getStart());
    }

    @Override
    public int getPermissions() {
        return this.record.getByteValue(3);
    }

    @Override
    public InputStream getData() {
        return new MemoryBlockInputStream(this);
    }

    @Override
    public boolean contains(Address addr) {
        if (addr.hasSameAddressSpace(this.startAddress)) {
            long offset = addr.subtract(this.startAddress);
            return offset >= 0L && offset < this.length;
        }
        return false;
    }

    @Override
    public Address getStart() {
        return this.startAddress;
    }

    @Override
    public Address getEnd() {
        return this.startAddress.add(this.length - 1L);
    }

    @Override
    public long getSize() {
        return this.length;
    }

    @Override
    public BigInteger getSizeAsBigInteger() {
        return NumericUtilities.unsignedLongToBigInteger((long)this.length);
    }

    @Override
    public String getName() {
        String name = this.record.getString(0);
        if (name == null) {
            name = "";
        }
        return name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setName(String name) throws LockException {
        String oldName = this.getName();
        this.memMap.lock.acquire();
        try {
            this.checkValid();
            if (oldName.equals(name)) {
                return;
            }
            this.memMap.checkBlockName(name);
            try {
                if (this.isOverlay()) {
                    this.memMap.overlayBlockRenamed(this.startAddress.getAddressSpace().getName(), name);
                }
                this.record.setString(0, name);
                this.adapter.updateBlockRecord(this.record);
            }
            catch (IOException e) {
                this.memMap.dbError(e);
            }
            this.memMap.fireBlockChanged(this);
        }
        finally {
            this.memMap.lock.release();
        }
    }

    @Override
    public String getComment() {
        return this.record.getString(1);
    }

    @Override
    public void setComment(String comment) {
        this.memMap.lock.acquire();
        try {
            this.checkValid();
            try {
                this.record.setString(1, comment);
                this.adapter.updateBlockRecord(this.record);
                this.memMap.fireBlockChanged(this);
            }
            catch (IOException e) {
                this.memMap.dbError(e);
            }
        }
        finally {
            this.memMap.lock.release();
        }
    }

    @Override
    public boolean isRead() {
        return (this.record.getByteValue(3) & 4) != 0;
    }

    @Override
    public void setRead(boolean r) {
        this.memMap.lock.acquire();
        try {
            this.checkValid();
            this.setPermissionBit(4, r);
            this.memMap.fireBlockChanged(this);
        }
        finally {
            this.memMap.lock.release();
        }
    }

    @Override
    public boolean isWrite() {
        return (this.record.getByteValue(3) & 2) != 0;
    }

    @Override
    public void setWrite(boolean w) {
        this.memMap.lock.acquire();
        try {
            this.checkValid();
            this.setPermissionBit(2, w);
            this.memMap.fireBlockChanged(this);
        }
        finally {
            this.memMap.lock.release();
        }
    }

    @Override
    public boolean isExecute() {
        return (this.record.getByteValue(3) & 1) != 0;
    }

    @Override
    public void setExecute(boolean x) {
        this.memMap.lock.acquire();
        try {
            this.checkValid();
            this.setPermissionBit(1, x);
            this.memMap.blockExecuteChanged(this);
            this.memMap.fireBlockChanged(this);
        }
        finally {
            this.memMap.lock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setPermissions(boolean read, boolean write, boolean execute) {
        this.memMap.lock.acquire();
        try {
            this.checkValid();
            this.setPermissionBit(4, read);
            this.setPermissionBit(2, write);
            this.setPermissionBit(1, execute);
            this.memMap.blockExecuteChanged(this);
            this.memMap.fireBlockChanged(this);
        }
        finally {
            this.memMap.lock.release();
        }
    }

    @Override
    public boolean isVolatile() {
        return (this.record.getByteValue(3) & 8) != 0;
    }

    @Override
    public void setVolatile(boolean v) {
        this.memMap.lock.acquire();
        try {
            this.checkValid();
            this.setPermissionBit(8, v);
            this.memMap.fireBlockChanged(this);
        }
        finally {
            this.memMap.lock.release();
        }
    }

    @Override
    public String getSourceName() {
        return this.record.getString(2);
    }

    @Override
    public void setSourceName(String sourceName) {
        this.memMap.lock.acquire();
        try {
            this.checkValid();
            try {
                this.record.setString(2, sourceName);
                this.adapter.updateBlockRecord(this.record);
            }
            catch (IOException e) {
                this.memMap.dbError(e);
            }
            this.memMap.fireBlockChanged(this);
        }
        finally {
            this.memMap.lock.release();
        }
    }

    @Override
    public byte getByte(Address addr) throws MemoryAccessException {
        if (this.memMap.getLiveMemoryHandler() != null) {
            return this.memMap.getByte(addr);
        }
        this.checkValid();
        long offset = this.getBlockOffset(addr);
        return this.getByte(offset);
    }

    @Override
    public int getBytes(Address addr, byte[] b) throws MemoryAccessException {
        return this.getBytes(addr, b, 0, b.length);
    }

    @Override
    public int getBytes(Address addr, byte[] b, int off, int len) throws IndexOutOfBoundsException, MemoryAccessException {
        if (this.memMap.getLiveMemoryHandler() != null) {
            return this.memMap.getBytes(addr, b, off, len);
        }
        this.checkValid();
        long offset = this.getBlockOffset(addr);
        return this.getBytes(offset, b, off, len);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void putByte(Address addr, byte b) throws MemoryAccessException {
        if (this.memMap.getLiveMemoryHandler() != null) {
            this.memMap.setByte(addr, b);
            return;
        }
        long offset = this.getBlockOffset(addr);
        this.memMap.lock.acquire();
        try {
            this.checkValid();
            this.memMap.checkMemoryWrite(this, addr, 1L);
            this.putByte(offset, b);
            this.memMap.fireBytesChanged(addr, 1);
        }
        finally {
            this.memMap.lock.release();
        }
    }

    @Override
    public int putBytes(Address addr, byte[] b) throws MemoryAccessException {
        return this.putBytes(addr, b, 0, b.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int putBytes(Address addr, byte[] b, int off, int len) throws IndexOutOfBoundsException, MemoryAccessException {
        if (this.memMap.getLiveMemoryHandler() != null) {
            this.memMap.setBytes(addr, b, off, len);
            return len;
        }
        this.memMap.lock.acquire();
        try {
            this.checkValid();
            this.memMap.checkMemoryWrite(this, addr, len);
            long offset = this.getBlockOffset(addr);
            int n = this.putBytes(offset, b, off, len);
            this.memMap.fireBytesChanged(addr, n);
            int n2 = n;
            return n2;
        }
        finally {
            this.memMap.lock.release();
        }
    }

    @Override
    public boolean isInitialized() {
        return this.subBlocks.get(0).isInitialized();
    }

    @Override
    public boolean isMapped() {
        return this.subBlocks.get(0).isMapped();
    }

    @Override
    public boolean isLoaded() {
        return this.startAddress.getAddressSpace().isLoadedMemorySpace();
    }

    void checkValid() {
        if (this.invalid) {
            throw new ConcurrentModificationException();
        }
    }

    private void setPermissionBit(int permBitMask, boolean enable) {
        byte p = this.record.getByteValue(3);
        p = enable ? (byte)(p | permBitMask) : (byte)(p & ~permBitMask);
        this.record.setByteValue(3, p);
        try {
            this.adapter.updateBlockRecord(this.record);
        }
        catch (IOException e) {
            this.memMap.dbError(e);
        }
    }

    @Override
    public MemoryBlockType getType() {
        return this.subBlocks.get(0).getType();
    }

    @Override
    public boolean isOverlay() {
        return this.startAddress.getAddressSpace().isOverlaySpace();
    }

    public byte getByte(long offset) throws MemoryAccessException {
        SubMemoryBlock subBlock = this.getSubBlock(offset);
        try {
            return subBlock.getByte(offset);
        }
        catch (IOException e) {
            this.checkValid();
            this.memMap.dbError(e);
            return 0;
        }
    }

    public int getBytes(long offset, byte[] b, int off, int len) throws IndexOutOfBoundsException, MemoryAccessException {
        int totalCopied;
        if (off < 0 || off + len > b.length) {
            throw new IndexOutOfBoundsException();
        }
        if (offset < 0L || offset >= this.length) {
            throw new IndexOutOfBoundsException();
        }
        len = (int)Math.min((long)len, this.length - offset);
        try {
            SubMemoryBlock subBlock;
            for (totalCopied = 0; totalCopied < len; totalCopied += subBlock.getBytes(offset + (long)totalCopied, b, off + totalCopied, len - totalCopied)) {
                subBlock = this.getSubBlock(offset + (long)totalCopied);
            }
        }
        catch (IOException e) {
            this.checkValid();
            this.memMap.dbError(e);
        }
        return totalCopied;
    }

    protected long getBlockOffset(Address addr) throws MemoryAccessException {
        if (!addr.hasSameAddressSpace(this.startAddress)) {
            throw new MemoryAccessException("Address not contained in block: " + addr);
        }
        long offset = addr.subtract(this.startAddress);
        if (offset < 0L || offset >= this.length) {
            throw new MemoryAccessException("Address not contained in block: " + addr);
        }
        return offset;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void putByte(long offset, byte b) throws MemoryAccessException {
        SubMemoryBlock subBlock = this.getSubBlock(offset);
        this.memMap.lock.acquire();
        try {
            subBlock.putByte(offset, b);
        }
        catch (IOException e) {
            this.memMap.dbError(e);
        }
        finally {
            this.memMap.lock.release();
        }
    }

    private int putBytes(long offset, byte[] b, int off, int len) throws IndexOutOfBoundsException, MemoryAccessException {
        int totalCopied;
        if (off < 0 || off + len > b.length) {
            throw new IndexOutOfBoundsException();
        }
        if (offset < 0L || offset >= this.length) {
            throw new IndexOutOfBoundsException();
        }
        len = (int)Math.min((long)len, this.length - offset);
        try {
            SubMemoryBlock subBlock;
            for (totalCopied = 0; totalCopied < len; totalCopied += subBlock.putBytes(offset + (long)totalCopied, b, off + totalCopied, len - totalCopied)) {
                subBlock = this.getSubBlock(offset + (long)totalCopied);
            }
        }
        catch (IOException e) {
            this.checkValid();
            this.memMap.dbError(e);
        }
        return totalCopied;
    }

    private SubMemoryBlock getSubBlock(long offset) {
        SubMemoryBlock last = this.lastSubBlock;
        if (last != null && last.contains(offset)) {
            return last;
        }
        this.lastSubBlock = last = this.findBlock(0, this.subBlocks.size() - 1, offset);
        return last;
    }

    private SubMemoryBlock findBlock(int minIndex, int maxIndex, long offset) {
        if (minIndex > maxIndex) {
            throw new IllegalArgumentException("address or offset out of bounds");
        }
        int index = (maxIndex + minIndex) / 2;
        SubMemoryBlock block = this.subBlocks.get(index);
        if (block.contains(offset)) {
            return block;
        }
        long startingOffset = block.getStartingOffset();
        if (offset < startingOffset) {
            return this.findBlock(minIndex, index - 1, offset);
        }
        return this.findBlock(index + 1, maxIndex, offset);
    }

    public void invalidate() {
        this.invalid = true;
    }

    void delete() throws IOException {
        for (SubMemoryBlock subBlock : this.subBlocks) {
            subBlock.delete();
        }
        this.adapter.deleteMemoryBlock(this);
        this.invalidate();
    }

    void setStartAddress(Address newStartAddr) throws IOException, AddressOverflowException {
        this.startAddress = newStartAddr;
        AddressSet set = new AddressSet(this.startAddress, this.startAddress.addNoWrap(this.length - 1L));
        AddressMapDB addrMap = this.adapter.getMemoryMap().getAddressMap();
        addrMap.getKeyRanges(set, true);
        this.record.setLongValue(4, addrMap.getKey(newStartAddr, true));
        if (newStartAddr instanceof SegmentedAddress) {
            SegmentedAddress imageBase = (SegmentedAddress)this.memMap.getAddressMap().getImageBase();
            int baseSegment = imageBase.getSegment();
            int segment = ((SegmentedAddress)this.startAddress).getSegment();
            this.record.setIntValue(6, segment - baseSegment);
        }
        this.adapter.updateBlockRecord(this.record);
    }

    MemoryBlockDB split(Address addr) throws IOException {
        this.lastSubBlock = null;
        long offset = addr.subtract(this.startAddress);
        long newLength = this.length - offset;
        this.length = offset;
        this.record.setLongValue(5, this.length);
        this.adapter.updateBlockRecord(this.record);
        ArrayList<SubMemoryBlock> splitBlocks = new ArrayList<SubMemoryBlock>();
        int index = this.getIndexOfSubBlockToSplit(offset);
        SubMemoryBlock subMemoryBlock = this.subBlocks.get(index);
        if (subMemoryBlock.getStartingOffset() == offset) {
            List<SubMemoryBlock> subList = this.subBlocks.subList(index, this.subBlocks.size());
            splitBlocks.addAll(subList);
            subList.clear();
        } else {
            SubMemoryBlock split = subMemoryBlock.split(offset);
            splitBlocks.add(split);
            List<SubMemoryBlock> subList = this.subBlocks.subList(index + 1, this.subBlocks.size());
            splitBlocks.addAll(subList);
            subList.clear();
        }
        return this.adapter.createBlock(this.getName() + ".split", addr, newLength, this.getPermissions(), splitBlocks);
    }

    private int getIndexOfSubBlockToSplit(long offset) {
        for (int i = 0; i < this.subBlocks.size(); ++i) {
            if (!this.subBlocks.get(i).contains(offset)) continue;
            return i;
        }
        throw new IllegalArgumentException("offset " + offset + " not in this block");
    }

    void initializeBlock(byte initialValue) throws IOException {
        this.lastSubBlock = null;
        for (SubMemoryBlock subBlock : this.subBlocks) {
            subBlock.delete();
        }
        this.subBlocks.clear();
        int numFullBlocks = (int)(this.length / 0x40000000L);
        int lastSubBlockSize = (int)(this.length % 0x40000000L);
        long blockOffset = 0L;
        for (int i = 0; i < numFullBlocks; ++i) {
            this.createBufferSubBlock(initialValue, blockOffset, 0x40000000);
            blockOffset += 0x40000000L;
        }
        if (lastSubBlockSize > 0) {
            this.createBufferSubBlock(initialValue, blockOffset, lastSubBlockSize);
        }
    }

    private void createBufferSubBlock(byte initialValue, long blockOffset, int size) throws IOException {
        DBBuffer buffer = this.adapter.createBuffer(size, initialValue);
        DBRecord subBlockRecord = this.adapter.createSubBlockRecord(this.id, blockOffset, size, (byte)2, buffer.getId(), 0L);
        BufferSubMemoryBlock sub = new BufferSubMemoryBlock(this.adapter, subBlockRecord);
        this.subBlocks.add(sub);
    }

    void join(MemoryBlockDB memBlock2) throws IOException {
        this.lastSubBlock = null;
        this.length += memBlock2.length;
        this.record.setLongValue(5, this.length);
        int n = this.subBlocks.size();
        this.subBlocks.addAll(memBlock2.subBlocks);
        this.possiblyMergeSubBlocks(n - 1, n);
        this.sequenceSubBlocks();
        this.adapter.deleteMemoryBlock(memBlock2);
        this.adapter.updateBlockRecord(this.record);
    }

    private void sequenceSubBlocks() throws IOException {
        long startingOffset = 0L;
        for (SubMemoryBlock subBlock : this.subBlocks) {
            subBlock.setParentIdAndStartingOffset(this.id, startingOffset);
            startingOffset += subBlock.subBlockLength;
        }
    }

    private void possiblyMergeSubBlocks(int lastOld, int firstNew) throws IOException {
        SubMemoryBlock sub2;
        SubMemoryBlock sub1 = this.subBlocks.get(lastOld);
        if (sub1.join(sub2 = this.subBlocks.get(firstNew))) {
            this.subBlocks.remove(firstNew);
        }
    }

    void uninitializeBlock() throws IOException {
        this.lastSubBlock = null;
        for (SubMemoryBlock subBlock : this.subBlocks) {
            subBlock.delete();
        }
        this.subBlocks.clear();
        DBRecord subRecord = this.adapter.createSubBlockRecord(this.id, 0L, this.length, (byte)3, 0, 0L);
        this.subBlocks.add(new UninitializedSubMemoryBlock(this.adapter, subRecord));
    }

    DBBuffer getBuffer() {
        if (this.subBlocks.size() > 1) {
            throw new IllegalStateException("Old blocks to be upgraded should only have one sub block");
        }
        SubMemoryBlock subMemoryBlock = this.subBlocks.get(0);
        if (subMemoryBlock instanceof BufferSubMemoryBlock) {
            return ((BufferSubMemoryBlock)subMemoryBlock).buf;
        }
        throw new IllegalStateException("Old blocks to be upgraded not expected type");
    }

    @Override
    public List<MemoryBlockSourceInfo> getSourceInfos() {
        ArrayList<MemoryBlockSourceInfo> infos = new ArrayList<MemoryBlockSourceInfo>(this.subBlocks.size());
        for (SubMemoryBlock subBlock : this.subBlocks) {
            infos.add(subBlock.getSourceInfo(this));
        }
        return infos;
    }

    boolean uses(FileBytes fileBytes) {
        for (SubMemoryBlock subBlock : this.subBlocks) {
            if (!subBlock.uses(fileBytes)) continue;
            return true;
        }
        return false;
    }
}

