/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.database.map;

import ghidra.program.database.map.AddressMap;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressIterator;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressRangeImpl;
import ghidra.program.model.address.AddressRangeIterator;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.address.KeyRange;
import ghidra.util.datastruct.Range;
import ghidra.util.datastruct.SortedRangeList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class NormalizedAddressSet
implements AddressSetView {
    private AddressMap addrMap;
    private Map<Long, SortedRangeList> baseLists = new HashMap<Long, SortedRangeList>();
    private ArrayList<Long> bases = new ArrayList();
    private Comparator<Long> baseComparator = new Comparator<Long>(){

        @Override
        public int compare(Long base1, Long base2) {
            Address a1 = NormalizedAddressSet.this.addrMap.decodeAddress(base1);
            Address a2 = NormalizedAddressSet.this.addrMap.decodeAddress(base2);
            return a1.compareTo(a2);
        }
    };

    public NormalizedAddressSet(AddressMap addrMap) {
        this.addrMap = addrMap;
    }

    public void add(Address addr) {
        this.addRange(addr, addr);
    }

    public void add(AddressSetView set) {
        AddressRangeIterator it = set.getAddressRanges();
        while (it.hasNext()) {
            this.add((AddressRange)it.next());
        }
    }

    public void add(AddressRange range) {
        this.addRange(range.getMinAddress(), range.getMaxAddress());
    }

    public void addRange(Address startAddr, Address endAddr) {
        long end;
        long start = this.addrMap.getKey(startAddr, true);
        if ((start & 0xFFFFFFFF00000000L) == ((end = this.addrMap.getKey(endAddr, true)) & 0xFFFFFFFF00000000L) && start <= end) {
            this.addRange(start, end);
            return;
        }
        List<KeyRange> ranges = this.addrMap.getKeyRanges(startAddr, endAddr, true);
        for (KeyRange kr : ranges) {
            this.addRange(kr.minKey, kr.maxKey);
        }
    }

    public void clear() {
        this.baseLists = new HashMap<Long, SortedRangeList>();
        this.bases = new ArrayList();
    }

    private void addRange(long minKey, long maxKey) {
        long baseKey = minKey & 0xFFFFFFFF00000000L;
        SortedRangeList set = this.baseLists.get(baseKey);
        if (set == null) {
            set = new SortedRangeList();
            this.baseLists.put(baseKey, set);
            this.bases.add(baseKey);
            Collections.sort(this.bases, this.baseComparator);
        }
        set.addRange((int)minKey + Integer.MIN_VALUE, (int)maxKey + Integer.MIN_VALUE);
    }

    private SortedRangeList getRangeList(long key) {
        return this.baseLists.get(key & 0xFFFFFFFF00000000L);
    }

    public void delete(AddressSetView view) {
        List<KeyRange> list = this.addrMap.getKeyRanges(view, false, false);
        for (KeyRange kr : list) {
            this.deleteRange(kr.minKey, kr.maxKey);
        }
    }

    private void deleteRange(long minKey, long maxKey) {
        long baseKey = minKey & 0xFFFFFFFF00000000L;
        SortedRangeList set = this.baseLists.get(baseKey);
        if (set == null) {
            return;
        }
        set.removeRange((int)minKey + Integer.MIN_VALUE, (int)maxKey + Integer.MIN_VALUE);
        if (set.isEmpty()) {
            this.baseLists.remove(baseKey);
            this.bases.remove(baseKey);
        }
    }

    @Override
    public boolean contains(Address addr) {
        long key = this.addrMap.getKey(addr, false);
        SortedRangeList list = this.getRangeList(key);
        if (list != null) {
            return list.contains((int)key + Integer.MIN_VALUE);
        }
        return false;
    }

    @Override
    public boolean contains(Address startAddr, Address endAddr) {
        if (!startAddr.hasSameAddressSpace(endAddr)) {
            return this.contains(this.addrMap.getAddressFactory().getAddressSet(startAddr, endAddr));
        }
        List<KeyRange> ranges = this.addrMap.getKeyRanges(startAddr, endAddr, false);
        if (ranges.isEmpty() || !this.addrMap.decodeAddress(ranges.get((int)0).minKey).equals(startAddr) || !this.addrMap.decodeAddress(ranges.get((int)(ranges.size() - 1)).maxKey).equals(endAddr)) {
            return false;
        }
        for (KeyRange kr : ranges) {
            SortedRangeList list = this.getRangeList(kr.minKey);
            if (list.contains((int)kr.minKey + Integer.MIN_VALUE, (int)kr.maxKey + Integer.MIN_VALUE)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean contains(AddressSetView rangeSet) {
        AddressRangeIterator it = rangeSet.getAddressRanges();
        while (it.hasNext()) {
            AddressRange range = (AddressRange)it.next();
            if (this.contains(range.getMinAddress(), range.getMaxAddress())) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isEmpty() {
        return this.baseLists.size() == 0;
    }

    @Override
    public Address getMinAddress() {
        if (this.bases.size() == 0) {
            return null;
        }
        long minBase = this.bases.get(0);
        SortedRangeList list = this.baseLists.get(minBase);
        long min = minBase + ((long)(list.getMin() - Integer.MIN_VALUE) & 0xFFFFFFFFL);
        return this.addrMap.decodeAddress(min);
    }

    @Override
    public Address getMaxAddress() {
        if (this.bases.size() == 0) {
            return null;
        }
        long maxBase = this.bases.get(this.bases.size() - 1);
        SortedRangeList list = this.baseLists.get(maxBase);
        long max = maxBase + ((long)(list.getMax() - Integer.MIN_VALUE) & 0xFFFFFFFFL);
        return this.addrMap.decodeAddress(max);
    }

    @Override
    public int getNumAddressRanges() {
        int n = 0;
        for (long key : this.baseLists.keySet()) {
            SortedRangeList list = this.baseLists.get(key);
            n += list.getNumRanges();
        }
        return n;
    }

    @Override
    public AddressRangeIterator getAddressRanges() {
        return this.getAddressRanges(true);
    }

    @Override
    public Iterator<AddressRange> iterator() {
        return this.getAddressRanges();
    }

    @Override
    public AddressRangeIterator getAddressRanges(boolean forward) {
        return new MyAddressRangeIterator(forward);
    }

    @Override
    public long getNumAddresses() {
        long n = 0L;
        for (long key : this.baseLists.keySet()) {
            SortedRangeList list = this.baseLists.get(key);
            n += list.getNumValues();
        }
        return n;
    }

    @Override
    public AddressIterator getAddresses(boolean forward) {
        return new MyAddressIterator(forward, null);
    }

    @Override
    public AddressIterator getAddresses(Address start, boolean forward) {
        return new MyAddressIterator(forward, start);
    }

    @Override
    public boolean intersects(AddressSetView addrSet) {
        List<KeyRange> keyList = this.addrMap.getKeyRanges(addrSet, false, false);
        for (KeyRange kr : keyList) {
            if (!this.intersects(kr.minKey, kr.maxKey)) continue;
            return true;
        }
        return false;
    }

    private boolean intersects(long min, long max) {
        SortedRangeList srl = this.getRangeList(min);
        if (srl == null) {
            return false;
        }
        return srl.intersects((int)min + Integer.MIN_VALUE, (int)max + Integer.MIN_VALUE);
    }

    @Override
    public boolean intersects(Address start, Address end) {
        List<KeyRange> keyList = this.addrMap.getKeyRanges(start, end, false);
        for (KeyRange kr : keyList) {
            if (!this.intersects(kr.minKey, kr.maxKey)) continue;
            return true;
        }
        return false;
    }

    @Override
    public AddressSet intersect(AddressSetView view) {
        return new AddressSet(this).intersect(view);
    }

    @Override
    public AddressSet intersectRange(Address start, Address end) {
        return new AddressSet(this).intersectRange(start, end);
    }

    @Override
    public AddressSet union(AddressSetView addrSet) {
        return new AddressSet(this).union(addrSet);
    }

    @Override
    public AddressSet subtract(AddressSetView addrSet) {
        return new AddressSet(this).subtract(addrSet);
    }

    @Override
    public AddressSet xor(AddressSetView addrSet) {
        return new AddressSet(this).xor(addrSet);
    }

    @Override
    public boolean hasSameAddresses(AddressSetView view) {
        AddressRangeIterator it1 = this.getAddressRanges();
        AddressRangeIterator it2 = view.getAddressRanges();
        while (it1.hasNext() && it2.hasNext()) {
            AddressRange yourRange;
            AddressRange myRange = (AddressRange)it1.next();
            if (myRange.equals(yourRange = (AddressRange)it2.next())) continue;
            return false;
        }
        return !it1.hasNext() && !it2.hasNext();
    }

    public final String toString() {
        int size = this.getNumAddressRanges();
        if (size == 0) {
            return "[empty]\n";
        }
        StringBuffer str = new StringBuffer();
        for (AddressRange range : this) {
            str.append(range);
            str.append(" ");
        }
        return str.toString();
    }

    @Override
    public AddressRangeIterator getAddressRanges(Address start, boolean forward) {
        return new AddressSet(this).getAddressRanges(start, forward);
    }

    @Override
    public AddressRange getFirstRange() {
        return new AddressSet(this).getFirstRange();
    }

    @Override
    public AddressRange getLastRange() {
        return new AddressSet(this).getLastRange();
    }

    @Override
    public AddressRange getRangeContaining(Address address) {
        return new AddressSet(this).getRangeContaining(address);
    }

    @Override
    public Iterator<AddressRange> iterator(Address start, boolean forward) {
        return new AddressSet(this).iterator(start, forward);
    }

    @Override
    public Iterator<AddressRange> iterator(boolean forward) {
        return new AddressSet(this).iterator(forward);
    }

    @Override
    public Address findFirstAddressInCommon(AddressSetView set) {
        return new AddressSet(this).findFirstAddressInCommon(set);
    }

    class MyAddressRangeIterator
    implements AddressRangeIterator {
        private boolean forward;
        private Iterator<Long> baseIterator;
        private Iterator<Range> currIt;
        private long base;

        MyAddressRangeIterator(boolean forward) {
            this.forward = forward;
            ArrayList<Long> myBases = new ArrayList<Long>(NormalizedAddressSet.this.bases);
            if (!forward) {
                Collections.reverse(myBases);
            }
            this.baseIterator = myBases.iterator();
            if (this.baseIterator.hasNext()) {
                this.base = this.baseIterator.next();
                SortedRangeList srl = NormalizedAddressSet.this.getRangeList(this.base);
                this.currIt = srl.getRanges(forward);
            }
        }

        @Override
        public Iterator<AddressRange> iterator() {
            return this;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public AddressRange next() {
            if (this.hasNext()) {
                Range range = this.currIt.next();
                Address a1 = NormalizedAddressSet.this.addrMap.decodeAddress(this.base + ((long)(range.min - Integer.MIN_VALUE) & 0xFFFFFFFFL));
                Address a2 = NormalizedAddressSet.this.addrMap.decodeAddress(this.base + ((long)(range.max - Integer.MIN_VALUE) & 0xFFFFFFFFL));
                return new AddressRangeImpl(a1, a2);
            }
            return null;
        }

        @Override
        public boolean hasNext() {
            if (this.currIt == null) {
                return false;
            }
            if (this.currIt.hasNext()) {
                return true;
            }
            this.currIt = null;
            while (this.baseIterator.hasNext()) {
                this.base = this.baseIterator.next();
                SortedRangeList srl = NormalizedAddressSet.this.getRangeList(this.base);
                this.currIt = srl.getRanges(this.forward);
                if (!this.currIt.hasNext()) continue;
                return true;
            }
            return false;
        }
    }

    class MyAddressIterator
    implements AddressIterator {
        AddressRangeIterator it;
        Address nextAddr;
        Address endAddr;
        boolean forward;

        MyAddressIterator(boolean forward, Address start) {
            this.it = NormalizedAddressSet.this.getAddressRanges(forward);
            this.forward = forward;
            if (start != null) {
                this.init(start);
            }
        }

        void init(Address start) {
            while (this.it.hasNext()) {
                AddressRange range = (AddressRange)this.it.next();
                int comp = range.compareTo(start);
                if (comp == 0) {
                    this.nextAddr = start;
                    this.endAddr = this.forward ? range.getMaxAddress() : range.getMinAddress();
                    continue;
                }
                if (!(this.forward & comp > 0) && !(!this.forward & comp < 0)) continue;
                return;
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Address next() {
            if (this.hasNext()) {
                Address retAddr = this.nextAddr;
                this.nextAddr = this.forward ? (this.nextAddr.compareTo(this.endAddr) < 0 ? this.nextAddr.next() : null) : (this.nextAddr.compareTo(this.endAddr) > 0 ? this.nextAddr.previous() : null);
                return retAddr;
            }
            return null;
        }

        @Override
        public boolean hasNext() {
            if (this.nextAddr != null) {
                return true;
            }
            if (this.it.hasNext()) {
                AddressRange range = (AddressRange)this.it.next();
                if (this.forward) {
                    this.nextAddr = range.getMinAddress();
                    this.endAddr = range.getMaxAddress();
                } else {
                    this.nextAddr = range.getMaxAddress();
                    this.endAddr = range.getMinAddress();
                }
                return true;
            }
            return false;
        }

        @Override
        public Iterator<Address> iterator() {
            return this;
        }
    }
}

