/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.database.data;

import db.DBRecord;
import ghidra.docking.settings.Settings;
import ghidra.docking.settings.SettingsDefinition;
import ghidra.program.database.DBObjectCache;
import ghidra.program.database.data.DataTypeDB;
import ghidra.program.database.data.DataTypeManagerDB;
import ghidra.program.database.data.DataTypeUtilities;
import ghidra.program.database.data.PointerDBAdapter;
import ghidra.program.model.address.Address;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeDisplayOptions;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.MutabilitySettingsDefinition;
import ghidra.program.model.data.Pointer;
import ghidra.program.model.data.PointerDataType;
import ghidra.program.model.data.TypeDefSettingsDefinition;
import ghidra.program.model.mem.MemBuffer;
import ghidra.util.InvalidNameException;
import ghidra.util.UniversalID;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;

class PointerDB
extends DataTypeDB
implements Pointer {
    private static final SettingsDefinition[] POINTER_SETTINGS_DEFINITIONS = new SettingsDefinition[]{MutabilitySettingsDefinition.DEF};
    private PointerDBAdapter adapter;
    private String displayName;
    private ThreadLocal<Boolean> isEquivalentActive = ThreadLocal.withInitial(() -> Boolean.FALSE);

    public PointerDB(DataTypeManagerDB dataMgr, DBObjectCache<DataTypeDB> cache, PointerDBAdapter adapter, DBRecord record) {
        super(dataMgr, cache, record);
        this.adapter = adapter;
    }

    @Override
    protected long doGetCategoryID() {
        return this.record.getLongValue(1);
    }

    @Override
    protected String doGetName() {
        String lenStr;
        DataType dt = this.getDataType();
        byte storedLen = this.record.getByteValue(2);
        String string = lenStr = storedLen > 0 ? Integer.toString(storedLen * 8) : "";
        if (dt == null) {
            return "pointer" + lenStr;
        }
        return dt.getName() + " *" + lenStr;
    }

    @Override
    public String toString() {
        return this.getName();
    }

    @Override
    public DataType getDataType() {
        this.lock.acquire();
        try {
            this.checkIsValid();
            DataType dataType = this.dataMgr.getDataType(this.record.getLongValue(0));
            return dataType;
        }
        finally {
            this.lock.release();
        }
    }

    @Override
    public SettingsDefinition[] getSettingsDefinitions() {
        return POINTER_SETTINGS_DEFINITIONS;
    }

    @Override
    protected void refreshName() {
        super.refreshName();
        this.displayName = null;
    }

    @Override
    protected boolean refresh() {
        try {
            DBRecord rec = this.adapter.getRecord(this.key);
            if (rec != null) {
                this.record = rec;
                return super.refresh();
            }
        }
        catch (IOException e) {
            this.dataMgr.dbError(e);
        }
        return false;
    }

    @Override
    public final DataType clone(DataTypeManager dtm) {
        if (dtm == this.getDataTypeManager()) {
            return this;
        }
        return new PointerDataType(this.getDataType(), this.hasLanguageDependantLength() ? -1 : this.getLength(), dtm);
    }

    @Override
    public DataType copy(DataTypeManager dtm) {
        return this.clone(dtm);
    }

    @Override
    public String getDisplayName() {
        String localDisplayName = this.displayName;
        if (localDisplayName != null && !this.isInvalid()) {
            return localDisplayName;
        }
        this.lock.acquire();
        try {
            this.checkIsValid();
            if (this.displayName == null) {
                DataType dt = this.getDataType();
                if (dt == null) {
                    this.displayName = "pointer";
                    if (!this.hasLanguageDependantLength()) {
                        this.displayName = this.displayName + Integer.toString(this.getLength() * 8);
                    }
                } else {
                    this.displayName = dt.getDisplayName() + " *";
                }
            }
            String string = this.displayName;
            return string;
        }
        finally {
            this.lock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getMnemonic(Settings settings) {
        this.lock.acquire();
        try {
            this.checkIsValid();
            DataType dataType = this.getDataType();
            if (dataType == null || dataType == DataType.DEFAULT) {
                String string = "addr";
                return string;
            }
            String string = dataType.getMnemonic(settings) + " *";
            return string;
        }
        finally {
            this.lock.release();
        }
    }

    @Override
    public boolean hasLanguageDependantLength() {
        this.lock.acquire();
        try {
            this.checkIsValid();
            boolean bl = this.record.getByteValue(2) <= 0;
            return bl;
        }
        finally {
            this.lock.release();
        }
    }

    @Override
    public int getLength() {
        this.lock.acquire();
        try {
            this.checkIsValid();
            int len = this.record.getByteValue(2);
            if (len <= 0) {
                len = this.dataMgr.getDataOrganization().getPointerSize();
            }
            int n = len;
            return n;
        }
        finally {
            this.lock.release();
        }
    }

    @Override
    public int getAlignedLength() {
        return this.getLength();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getDescription() {
        this.lock.acquire();
        try {
            this.checkIsValid();
            StringBuffer sbuf = new StringBuffer();
            if (!this.hasLanguageDependantLength()) {
                sbuf.append(Integer.toString(this.getLength() * 8));
                sbuf.append("-bit ");
            }
            sbuf.append("pointer");
            DataType dt = this.getDataType();
            if (dt != null) {
                sbuf.append(" to ");
                if (dt instanceof Pointer) {
                    sbuf.append(this.getDataType().getDescription());
                } else {
                    sbuf.append(this.getDataType().getName());
                }
            }
            String string = sbuf.toString();
            return string;
        }
        finally {
            this.lock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getValue(MemBuffer buf, Settings settings, int length) {
        this.lock.acquire();
        try {
            this.checkIsValid();
            Address address = PointerDataType.getAddressValue(buf, this.getLength(), settings);
            return address;
        }
        catch (IllegalArgumentException exc) {
            Object var5_6 = null;
            return var5_6;
        }
        finally {
            this.lock.release();
        }
    }

    @Override
    public Class<?> getValueClass(Settings settings) {
        return Address.class;
    }

    @Override
    public TypeDefSettingsDefinition[] getTypeDefSettingsDefinitions() {
        return PointerDataType.dataType.getTypeDefSettingsDefinitions();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getRepresentation(MemBuffer buf, Settings settings, int length) {
        this.lock.acquire();
        try {
            this.checkIsValid();
            Address addr = (Address)this.getValue(buf, settings, length);
            if (addr == null) {
                String string = "NaP";
                return string;
            }
            String string = addr.toString();
            return string;
        }
        finally {
            this.lock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isEquivalent(DataType dt) {
        if (dt == null) {
            return false;
        }
        if (this == dt) {
            return true;
        }
        if (!(dt instanceof Pointer)) {
            return false;
        }
        Pointer p = (Pointer)dt;
        DataType otherDataType = p.getDataType();
        if (this.hasLanguageDependantLength() != p.hasLanguageDependantLength()) {
            return false;
        }
        if (!this.hasLanguageDependantLength() && this.getLength() != p.getLength()) {
            return false;
        }
        DataType referencedDataType = this.getDataType();
        if (referencedDataType == null) {
            return otherDataType == null;
        }
        if (otherDataType == null) {
            return false;
        }
        if (DataTypeUtilities.isSameDataType(referencedDataType, otherDataType)) {
            return true;
        }
        if (!DataTypeUtilities.equalsIgnoreConflict(this.getDataType().getPathName(), otherDataType.getPathName())) {
            return false;
        }
        if (this.isEquivalentActive.get().booleanValue()) {
            return true;
        }
        this.isEquivalentActive.set(true);
        try {
            boolean bl = this.getDataType().isEquivalent(otherDataType);
            return bl;
        }
        finally {
            this.isEquivalentActive.set(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dataTypeReplaced(DataType oldDt, DataType newDt) {
        if (newDt == this) {
            newDt = DataType.DEFAULT;
        }
        this.lock.acquire();
        try {
            String myOldName = this.getOldName();
            if (this.checkIsValid() && this.getDataType() == oldDt) {
                oldDt.removeParent(this);
                newDt.addParent(this);
                this.record.setLongValue(0, this.dataMgr.getResolvedID(newDt));
                this.refreshName();
                if (!oldDt.getName().equals(newDt.getName())) {
                    this.notifyNameChanged(myOldName);
                }
                try {
                    this.adapter.updateRecord(this.record);
                }
                catch (IOException e) {
                    this.dataMgr.dbError(e);
                }
            }
        }
        finally {
            this.lock.release();
        }
    }

    @Override
    public void dataTypeDeleted(DataType dt) {
        if (this.getDataType() == dt) {
            this.dataMgr.addDataTypeToDelete(this.key);
        }
    }

    @Override
    protected void doSetCategoryPathRecord(long categoryID) throws IOException {
        this.record.setLongValue(1, categoryID);
        this.adapter.updateRecord(this.record);
    }

    @Override
    protected void doSetNameRecord(String newName) throws InvalidNameException {
        throw new InvalidNameException("Can't set the name of an array!");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dataTypeNameChanged(DataType dt, String oldName) {
        this.lock.acquire();
        try {
            String myOldName = this.getOldName();
            if (this.checkIsValid() && dt == this.getDataType()) {
                this.refreshName();
                if (!this.getName().equals(myOldName)) {
                    this.notifyNameChanged(myOldName);
                }
            }
        }
        finally {
            this.lock.release();
        }
    }

    @Override
    public void setName(String name) throws InvalidNameException, DuplicateNameException {
    }

    @Override
    protected void updatePath(DataTypeDB dt) {
        if (dt == DataTypeUtilities.getBaseDataType(this)) {
            CategoryPath oldPath = this.getCategoryPath();
            CategoryPath currentPath = dt.getCategoryPath();
            if (!currentPath.equals(oldPath)) {
                try {
                    super.setCategoryPath(currentPath);
                }
                catch (DuplicateNameException duplicateNameException) {
                    // empty catch block
                }
            }
        }
    }

    @Override
    public void setCategoryPath(CategoryPath path) throws DuplicateNameException {
    }

    @Override
    public boolean dependsOn(DataType dt) {
        DataType myDt = this.getDataType();
        return myDt != null && (myDt == dt || myDt.dependsOn(dt));
    }

    @Override
    public Pointer newPointer(DataType dataType) {
        if (this.hasLanguageDependantLength()) {
            return new PointerDataType(dataType, this.dataMgr);
        }
        return new PointerDataType(dataType, this.getLength(), (DataTypeManager)this.dataMgr);
    }

    @Override
    public String getDefaultLabelPrefix() {
        return "PTR";
    }

    @Override
    public String getDefaultLabelPrefix(MemBuffer buf, Settings settings, int len, DataTypeDisplayOptions options) {
        return PointerDataType.getLabelString(buf, settings, this.getLength(), options);
    }

    @Override
    public long getLastChangeTime() {
        return 0L;
    }

    @Override
    public long getLastChangeTimeInSourceArchive() {
        return 0L;
    }

    @Override
    public UniversalID getUniversalID() {
        return null;
    }

    @Override
    protected void setUniversalID(UniversalID id) {
    }

    @Override
    protected UniversalID getSourceArchiveID() {
        return DataTypeManager.LOCAL_ARCHIVE_UNIVERSAL_ID;
    }

    @Override
    public void setLastChangeTime(long lastChangeTime) {
    }

    @Override
    public void setLastChangeTimeInSourceArchive(long lastChangeTimeInSourceArchive) {
    }

    @Override
    protected void setSourceArchiveID(UniversalID id) {
    }
}

