/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.database.data;

import ghidra.app.util.NamespaceUtils;
import ghidra.app.util.SymbolPathParser;
import ghidra.docking.settings.Settings;
import ghidra.program.model.data.Array;
import ghidra.program.model.data.BitFieldDataType;
import ghidra.program.model.data.BuiltIn;
import ghidra.program.model.data.BuiltInDataType;
import ghidra.program.model.data.Category;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.CharDataType;
import ghidra.program.model.data.Composite;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeComponent;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.DoubleDataType;
import ghidra.program.model.data.Enum;
import ghidra.program.model.data.FloatDataType;
import ghidra.program.model.data.FunctionDefinition;
import ghidra.program.model.data.IntegerDataType;
import ghidra.program.model.data.LongDataType;
import ghidra.program.model.data.LongDoubleDataType;
import ghidra.program.model.data.LongLongDataType;
import ghidra.program.model.data.MissingBuiltInDataType;
import ghidra.program.model.data.ParameterDefinition;
import ghidra.program.model.data.Pointer;
import ghidra.program.model.data.ProgramBasedDataTypeManager;
import ghidra.program.model.data.ShortDataType;
import ghidra.program.model.data.SourceArchive;
import ghidra.program.model.data.Structure;
import ghidra.program.model.data.TypeDef;
import ghidra.program.model.data.Union;
import ghidra.program.model.data.UnsignedCharDataType;
import ghidra.program.model.data.UnsignedIntegerDataType;
import ghidra.program.model.data.UnsignedLongDataType;
import ghidra.program.model.data.UnsignedLongLongDataType;
import ghidra.program.model.data.UnsignedShortDataType;
import ghidra.program.model.listing.GhidraClass;
import ghidra.program.model.listing.Library;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.Namespace;
import ghidra.util.UniversalID;
import ghidra.util.exception.AssertException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;

public class DataTypeUtilities {
    private static Map<String, DataType> cPrimitiveNameMap = new HashMap<String, DataType>();
    private static final Pattern DATATYPE_CONFLICT_PATTERN;
    private static final int NAMESPACE_PATH_INDEX = 0;
    private static final int PARENT_NAMESPACE_PATH_INDEX = 1;
    private static final Comparator<DataType> DATATYPE_CATEGORY_PATH_LENGTH_COMPARATOR;

    public static Collection<DataType> getContainedDataTypes(DataType rootDataType) {
        HashMap<String, DataType> dataTypeMap = new HashMap<String, DataType>();
        LinkedList<DataType> unprocessedDataTypes = new LinkedList<DataType>();
        dataTypeMap.put(rootDataType.getPathName(), rootDataType);
        unprocessedDataTypes.add(rootDataType);
        while (!unprocessedDataTypes.isEmpty()) {
            DataType dataType = (DataType)unprocessedDataTypes.remove();
            List<DataType> directContainedDatatypes = DataTypeUtilities.getDirectContainedDatatypes(dataType);
            for (DataType containedDataType : directContainedDatatypes) {
                String path = containedDataType.getPathName();
                if (dataTypeMap.containsKey(path)) continue;
                dataTypeMap.put(path, containedDataType);
                unprocessedDataTypes.add(containedDataType);
            }
        }
        return dataTypeMap.values();
    }

    private static List<DataType> getDirectContainedDatatypes(DataType dt) {
        ArrayList<DataType> list = new ArrayList<DataType>();
        if (dt instanceof Array) {
            Array array = (Array)dt;
            list.add(array.getDataType());
        } else if (dt instanceof Pointer) {
            Pointer ptr = (Pointer)dt;
            DataType ptrDt = ptr.getDataType();
            if (ptrDt != null) {
                list.add(ptrDt);
            }
        } else if (dt instanceof Composite) {
            Composite composite = (Composite)dt;
            int n = composite.getNumComponents();
            for (int i = 0; i < n; ++i) {
                DataTypeComponent component = composite.getComponent(i);
                list.add(component.getDataType());
            }
        } else if (dt instanceof TypeDef) {
            TypeDef typedef = (TypeDef)dt;
            list.add(typedef.getDataType());
        } else if (!(dt instanceof Enum)) {
            if (dt instanceof FunctionDefinition) {
                ParameterDefinition[] arguments;
                FunctionDefinition funDef = (FunctionDefinition)dt;
                list.add(funDef.getReturnType());
                for (ParameterDefinition parameter : arguments = funDef.getArguments()) {
                    list.add(parameter.getDataType());
                }
            } else if (!(dt instanceof BuiltInDataType)) {
                if (dt instanceof BitFieldDataType) {
                    BitFieldDataType bitFieldDt = (BitFieldDataType)dt;
                    list.add(bitFieldDt.getBaseDataType());
                } else if (!(dt instanceof MissingBuiltInDataType) && !dt.equals(DataType.DEFAULT)) {
                    throw new AssertException("Unknown data Type:" + dt.getDisplayName());
                }
            }
        }
        return list;
    }

    public static boolean isSecondPartOfFirst(DataType firstDataType, DataType secondDataType) {
        if (firstDataType instanceof Pointer || secondDataType instanceof Pointer) {
            return false;
        }
        if (firstDataType.equals(secondDataType)) {
            return true;
        }
        if (firstDataType instanceof Array) {
            DataType elementDataType = ((Array)firstDataType).getDataType();
            return DataTypeUtilities.isSecondPartOfFirst(elementDataType, secondDataType);
        }
        if (firstDataType instanceof TypeDef) {
            DataType innerDataType = ((TypeDef)firstDataType).getDataType();
            return DataTypeUtilities.isSecondPartOfFirst(innerDataType, secondDataType);
        }
        if (firstDataType instanceof Composite) {
            Composite compositeDataType = (Composite)firstDataType;
            for (DataTypeComponent dtc : compositeDataType.getDefinedComponents()) {
                DataType dataTypeToCheck = dtc.getDataType();
                if (!DataTypeUtilities.isSecondPartOfFirst(dataTypeToCheck, secondDataType)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isSameDataType(DataType dataType1, DataType dataType2) {
        UniversalID id1 = dataType1.getUniversalID();
        UniversalID id2 = dataType2.getUniversalID();
        if (id1 == null || id2 == null) {
            return false;
        }
        if (!id1.equals((Object)id2)) {
            return false;
        }
        SourceArchive sourceArchive1 = dataType1.getSourceArchive();
        SourceArchive sourceArchive2 = dataType2.getSourceArchive();
        if (sourceArchive1 == null || sourceArchive2 == null) {
            return false;
        }
        return sourceArchive1.getSourceArchiveID().equals((Object)sourceArchive2.getSourceArchiveID());
    }

    public static boolean isSameOrEquivalentDataType(DataType dataType1, DataType dataType2) {
        if (DataTypeUtilities.isSameDataType(dataType1, dataType2)) {
            return true;
        }
        return dataType1.isEquivalent(dataType2);
    }

    public static boolean isSameKindDataType(DataType dataType1, DataType dataType2) {
        while (true) {
            if (dataType1 == dataType2) {
                return true;
            }
            if (dataType1 instanceof TypeDef) {
                TypeDef td1 = (TypeDef)dataType1;
                dataType1 = td1.getBaseDataType();
            }
            if (dataType2 instanceof TypeDef) {
                TypeDef td2 = (TypeDef)dataType2;
                dataType2 = td2.getBaseDataType();
            }
            if (dataType1 instanceof Pointer) {
                Pointer p1 = (Pointer)dataType1;
                if (dataType2 instanceof Pointer) {
                    Pointer p2 = (Pointer)dataType2;
                    dataType1 = p1.getDataType();
                    dataType2 = p2.getDataType();
                    continue;
                }
            }
            if (!(dataType2 instanceof Array)) break;
            Array a1 = (Array)dataType2;
            if (!(dataType2 instanceof Array)) break;
            Array a2 = (Array)dataType2;
            dataType1 = a1.getDataType();
            dataType2 = a2.getDataType();
        }
        if (dataType1 instanceof Enum) {
            return dataType2 instanceof Enum;
        }
        if (dataType1 instanceof Structure) {
            return dataType2 instanceof Structure;
        }
        if (dataType1 instanceof Union) {
            return dataType2 instanceof Union;
        }
        if (dataType1 instanceof BuiltInDataType) {
            BuiltInDataType dt1 = (BuiltInDataType)dataType1;
            return DataTypeUtilities.isSameKindBuiltInDataType(dt1, dataType2);
        }
        return false;
    }

    private static boolean isSameKindBuiltInDataType(BuiltInDataType dataType1, DataType dataType2) {
        if (dataType1 instanceof BuiltIn) {
            Class<?> superClass;
            Class<?> baseClass = dataType1.getClass();
            while ((superClass = baseClass.getSuperclass()) != BuiltIn.class) {
                baseClass = superClass;
            }
            return baseClass.isAssignableFrom(dataType2.getClass());
        }
        return dataType1.getClass().equals(dataType2.getClass());
    }

    public static String getNameWithoutConflict(DataType dataType, boolean includeCategoryPath) {
        String name = includeCategoryPath ? dataType.getPathName() : dataType.getName();
        return DATATYPE_CONFLICT_PATTERN.matcher(name).replaceAll("");
    }

    public static boolean equalsIgnoreConflict(String name1, String name2) {
        name1 = DATATYPE_CONFLICT_PATTERN.matcher(name1).replaceAll("");
        name2 = DATATYPE_CONFLICT_PATTERN.matcher(name2).replaceAll("");
        return name1.equals(name2);
    }

    public static DataType getBaseDataType(DataType dt) {
        DataType baseDataType = dt;
        while (baseDataType instanceof Pointer || baseDataType instanceof Array) {
            if (baseDataType instanceof Pointer) {
                baseDataType = ((Pointer)baseDataType).getDataType();
                continue;
            }
            if (!(baseDataType instanceof Array)) continue;
            baseDataType = ((Array)baseDataType).getDataType();
        }
        return baseDataType;
    }

    public static DataType getArrayBaseDataType(Array arrayDt) {
        DataType dataType = arrayDt.getDataType();
        if (dataType instanceof Array) {
            return DataTypeUtilities.getArrayBaseDataType((Array)dataType);
        }
        return dataType;
    }

    private static int getArrayBaseElementLength(Array arrayDt) {
        DataType dataType = arrayDt.getDataType();
        if (dataType instanceof Array) {
            return DataTypeUtilities.getArrayBaseElementLength((Array)dataType);
        }
        return arrayDt.getElementLength();
    }

    private static String getArrayElementLengthForDynamic(Array arrayDt) {
        if (DataTypeUtilities.getArrayBaseDataType(arrayDt).getLength() <= 0) {
            return " {" + DataTypeUtilities.getArrayBaseElementLength(arrayDt) + "} ";
        }
        return "";
    }

    private static String getArrayDimensions(Array arrayDt) {
        String dimensionString = "[" + arrayDt.getNumElements() + "]";
        DataType dataType = arrayDt.getDataType();
        if (dataType instanceof Array) {
            dimensionString = dimensionString + DataTypeUtilities.getArrayDimensions((Array)dataType);
        }
        return dimensionString;
    }

    public static String getName(Array arrayDt, boolean showBaseSizeForDynamics) {
        StringBuilder buf = new StringBuilder();
        buf.append(DataTypeUtilities.getArrayBaseDataType(arrayDt).getName());
        if (showBaseSizeForDynamics) {
            buf.append(DataTypeUtilities.getArrayElementLengthForDynamic(arrayDt));
        }
        buf.append(DataTypeUtilities.getArrayDimensions(arrayDt));
        return buf.toString();
    }

    public static String getDisplayName(Array arrayDt, boolean showBaseSizeForDynamics) {
        StringBuilder buf = new StringBuilder();
        buf.append(DataTypeUtilities.getArrayBaseDataType(arrayDt).getDisplayName());
        if (showBaseSizeForDynamics) {
            buf.append(DataTypeUtilities.getArrayElementLengthForDynamic(arrayDt));
        }
        buf.append(DataTypeUtilities.getArrayDimensions(arrayDt));
        return buf.toString();
    }

    public static String getMnemonic(Array arrayDt, boolean showBaseSizeForDynamics, Settings settings) {
        StringBuilder buf = new StringBuilder();
        buf.append(DataTypeUtilities.getArrayBaseDataType(arrayDt).getMnemonic(settings));
        if (showBaseSizeForDynamics) {
            buf.append(DataTypeUtilities.getArrayElementLengthForDynamic(arrayDt));
        }
        buf.append(DataTypeUtilities.getArrayDimensions(arrayDt));
        return buf.toString();
    }

    public static CategoryPath getDataTypeCategoryPath(CategoryPath baseCategory, Namespace namespace) {
        ArrayList<String> categoryPathParts = new ArrayList<String>();
        for (Namespace ns : NamespaceUtils.getNamespaceParts(namespace)) {
            if (ns instanceof Library) break;
            categoryPathParts.add(ns.getName());
        }
        return categoryPathParts.isEmpty() ? baseCategory : new CategoryPath(baseCategory, categoryPathParts);
    }

    public static Structure findExistingClassStruct(DataTypeManager dataTypeManager, GhidraClass classNamespace) {
        Structure dt = DataTypeUtilities.findPreferredDataType(dataTypeManager, classNamespace, classNamespace.getName(), Structure.class, true);
        if (dt != null) {
            return dt;
        }
        String[] namespacePaths = DataTypeUtilities.getRelativeCategoryPaths(classNamespace);
        return DataTypeUtilities.findDataType(dataTypeManager, classNamespace.getName(), Structure.class, (CategoryPath categoryPath) -> DataTypeUtilities.getCategoryMatchType(categoryPath, namespacePaths, true));
    }

    public static <T extends DataType> T findDataType(DataTypeManager dataTypeManager, Namespace namespace, String dtName, Class<T> classConstraint) {
        T dt = DataTypeUtilities.findPreferredDataType(dataTypeManager, namespace, dtName, classConstraint, false);
        if (dt != null) {
            return dt;
        }
        String[] namespacePaths = DataTypeUtilities.getRelativeCategoryPaths(namespace);
        return DataTypeUtilities.findDataType(dataTypeManager, dtName, classConstraint, (CategoryPath categoryPath) -> DataTypeUtilities.getCategoryMatchType(categoryPath, namespacePaths, false));
    }

    public static <T extends DataType> T findNamespaceQualifiedDataType(DataTypeManager dataTypeManager, String dtNameWithNamespace, Class<T> classConstraint) {
        List<String> namespacePath;
        T dt;
        List<String> pathList = SymbolPathParser.parse(dtNameWithNamespace);
        int nameIndex = pathList.size() - 1;
        String dtName = pathList.get(nameIndex);
        CategoryPath rootPath = DataTypeUtilities.getPreferredRootNamespaceCategoryPath(dataTypeManager);
        if (rootPath != null && (dt = DataTypeUtilities.getAssignableDataType(dataTypeManager, rootPath, namespacePath = pathList.subList(0, nameIndex), dtName, classConstraint)) != null) {
            return dt;
        }
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < nameIndex; ++i) {
            buf.append("/");
            buf.append(pathList.get(i));
        }
        String namespacePath2 = buf.toString();
        return DataTypeUtilities.findDataType(dataTypeManager, dtName, classConstraint, (CategoryPath categoryPath) -> DataTypeUtilities.getCategoryMatchType(categoryPath, namespacePath2));
    }

    public static DataType getCPrimitiveDataType(String dataTypeName) {
        if (dataTypeName.contains(" ")) {
            dataTypeName = dataTypeName.trim().replaceAll("\\s+", " ");
        }
        dataTypeName = dataTypeName.toLowerCase();
        return cPrimitiveNameMap.get(dataTypeName);
    }

    private static String[] getRelativeCategoryPaths(Namespace namespace) {
        if (namespace == null || namespace.isGlobal() || namespace.isLibrary()) {
            return null;
        }
        String[] paths = new String[2];
        StringBuilder buf = new StringBuilder();
        for (String n : namespace.getParentNamespace().getPathList(true)) {
            buf.append("/");
            buf.append(CategoryPath.escapeString(n));
        }
        paths[1] = buf.toString();
        buf.append("/");
        buf.append(CategoryPath.escapeString(namespace.getName()));
        paths[0] = buf.toString();
        return paths;
    }

    private static CategoryMatchType getCategoryMatchType(CategoryPath categoryPath, String namespacePath) {
        if (namespacePath.length() == 0) {
            return categoryPath.isRoot() ? CategoryMatchType.PREFERRED : CategoryMatchType.SECONDARY;
        }
        String path = categoryPath.getPath();
        return path.endsWith(namespacePath) ? CategoryMatchType.PREFERRED : CategoryMatchType.NONE;
    }

    private static CategoryMatchType getCategoryMatchType(CategoryPath categoryPath, String[] namespacePaths, boolean parentNamespacePreferred) {
        if (namespacePaths == null) {
            return categoryPath.isRoot() ? CategoryMatchType.PREFERRED : CategoryMatchType.SECONDARY;
        }
        String path = categoryPath.getPath();
        if (parentNamespacePreferred && path.endsWith(namespacePaths[1])) {
            return CategoryMatchType.PREFERRED;
        }
        if (path.endsWith(namespacePaths[0])) {
            return parentNamespacePreferred ? CategoryMatchType.SECONDARY : CategoryMatchType.PREFERRED;
        }
        return CategoryMatchType.NONE;
    }

    private static CategoryPath getPreferredRootNamespaceCategoryPath(DataTypeManager dataTypeManager) {
        if (!(dataTypeManager instanceof ProgramBasedDataTypeManager)) {
            return null;
        }
        ProgramBasedDataTypeManager pdtm = (ProgramBasedDataTypeManager)dataTypeManager;
        Program p = pdtm.getProgram();
        return p.getPreferredRootNamespaceCategoryPath();
    }

    private static <T extends DataType> T getAssignableDataType(DataTypeManager dataTypeManager, CategoryPath rootPath, List<String> namespacePath, String dtName, Class<? extends DataType> classConstraint) {
        Category category = dataTypeManager.getCategory(rootPath);
        if (category == null) {
            return null;
        }
        if (namespacePath == null || namespacePath.isEmpty()) {
            return DataTypeUtilities.getAssignableDataType(category, dtName, classConstraint);
        }
        CategoryPath categoryPath = new CategoryPath(rootPath, namespacePath);
        category = dataTypeManager.getCategory(categoryPath);
        if (category == null) {
            return null;
        }
        return DataTypeUtilities.getAssignableDataType(category, dtName, classConstraint);
    }

    private static <T extends DataType> T getAssignableDataType(Category category, String dtName, Class<? extends DataType> classConstraint) {
        DataType dt = category.getDataType(dtName);
        if (dt != null && (classConstraint == null || classConstraint.isAssignableFrom(dt.getClass()))) {
            return (T)dt;
        }
        return null;
    }

    private static <T extends DataType> T findPreferredDataType(DataTypeManager dataTypeManager, Namespace namespace, String dtName, Class<T> classConstraint, boolean parentNamespacePreferred) {
        T dt;
        CategoryPath rootPath = DataTypeUtilities.getPreferredRootNamespaceCategoryPath(dataTypeManager);
        if (rootPath == null) {
            return null;
        }
        if (namespace == null || namespace.isGlobal() || namespace.isLibrary()) {
            return DataTypeUtilities.getAssignableDataType(dataTypeManager, rootPath, null, dtName, classConstraint);
        }
        if (parentNamespacePreferred && (dt = DataTypeUtilities.getAssignableDataType(dataTypeManager, rootPath, namespace.getParentNamespace().getPathList(true), dtName, classConstraint)) != null) {
            return dt;
        }
        return DataTypeUtilities.getAssignableDataType(dataTypeManager, rootPath, namespace.getPathList(true), dtName, classConstraint);
    }

    private static <T extends DataType> T findDataType(DataTypeManager dataTypeManager, String dtName, Class<T> classConstraint, NamespaceMatcher categoryMatcher) {
        ArrayList<DataType> list = new ArrayList<DataType>();
        dataTypeManager.findDataTypes(dtName, list);
        Collections.sort(list, DATATYPE_CATEGORY_PATH_LENGTH_COMPARATOR);
        if (!list.isEmpty()) {
            DataType secondaryMatch = null;
            for (DataType existingDT : list) {
                if (classConstraint != null && !classConstraint.isAssignableFrom(existingDT.getClass())) continue;
                CategoryMatchType matchType = categoryMatcher.getMatchType(existingDT.getCategoryPath());
                if (matchType == CategoryMatchType.PREFERRED) {
                    return (T)existingDT;
                }
                if (secondaryMatch != null || matchType != CategoryMatchType.SECONDARY) continue;
                secondaryMatch = existingDT;
            }
            return (T)secondaryMatch;
        }
        return null;
    }

    static {
        cPrimitiveNameMap.put("char", CharDataType.dataType);
        cPrimitiveNameMap.put("signed char", CharDataType.dataType);
        cPrimitiveNameMap.put("unsigned char", UnsignedCharDataType.dataType);
        cPrimitiveNameMap.put("short", ShortDataType.dataType);
        cPrimitiveNameMap.put("short int", ShortDataType.dataType);
        cPrimitiveNameMap.put("signed short", ShortDataType.dataType);
        cPrimitiveNameMap.put("signed short int", ShortDataType.dataType);
        cPrimitiveNameMap.put("unsigned short", UnsignedShortDataType.dataType);
        cPrimitiveNameMap.put("unsigned short int", UnsignedShortDataType.dataType);
        cPrimitiveNameMap.put("int", IntegerDataType.dataType);
        cPrimitiveNameMap.put("signed", IntegerDataType.dataType);
        cPrimitiveNameMap.put("signed int", IntegerDataType.dataType);
        cPrimitiveNameMap.put("unsigned", UnsignedIntegerDataType.dataType);
        cPrimitiveNameMap.put("unsigned int", UnsignedIntegerDataType.dataType);
        cPrimitiveNameMap.put("long", LongDataType.dataType);
        cPrimitiveNameMap.put("long int", LongDataType.dataType);
        cPrimitiveNameMap.put("signed long", LongDataType.dataType);
        cPrimitiveNameMap.put("signed long int", LongDataType.dataType);
        cPrimitiveNameMap.put("unsigned long", UnsignedLongDataType.dataType);
        cPrimitiveNameMap.put("long long", LongLongDataType.dataType);
        cPrimitiveNameMap.put("long long int", LongLongDataType.dataType);
        cPrimitiveNameMap.put("signed long long", LongLongDataType.dataType);
        cPrimitiveNameMap.put("signed long long int", LongLongDataType.dataType);
        cPrimitiveNameMap.put("unsigned long long", UnsignedLongLongDataType.dataType);
        cPrimitiveNameMap.put("unsigned long long int", UnsignedLongLongDataType.dataType);
        cPrimitiveNameMap.put("float", FloatDataType.dataType);
        cPrimitiveNameMap.put("double", DoubleDataType.dataType);
        cPrimitiveNameMap.put("long double", LongDoubleDataType.dataType);
        DATATYPE_CONFLICT_PATTERN = Pattern.compile(Pattern.quote(".conflict") + "_?[0-9]*");
        DATATYPE_CATEGORY_PATH_LENGTH_COMPARATOR = (dt1, dt2) -> {
            String catPath1 = dt1.getCategoryPath().getPath();
            String catPath2 = dt2.getCategoryPath().getPath();
            int cmp = catPath1.length() - catPath2.length();
            if (cmp == 0) {
                cmp = catPath1.compareTo(catPath2);
            }
            return cmp;
        };
    }

    private static interface NamespaceMatcher {
        public CategoryMatchType getMatchType(CategoryPath var1);
    }

    private static enum CategoryMatchType {
        NONE,
        SECONDARY,
        PREFERRED;

    }
}

