/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.processors.sleigh.expression;

import ghidra.app.plugin.processors.sleigh.ParserWalker;
import ghidra.app.plugin.processors.sleigh.SleighLanguage;
import ghidra.app.plugin.processors.sleigh.expression.AndExpression;
import ghidra.app.plugin.processors.sleigh.expression.ConstantValue;
import ghidra.app.plugin.processors.sleigh.expression.ContextField;
import ghidra.app.plugin.processors.sleigh.expression.DivExpression;
import ghidra.app.plugin.processors.sleigh.expression.EndInstructionValue;
import ghidra.app.plugin.processors.sleigh.expression.LeftShiftExpression;
import ghidra.app.plugin.processors.sleigh.expression.MinusExpression;
import ghidra.app.plugin.processors.sleigh.expression.MultExpression;
import ghidra.app.plugin.processors.sleigh.expression.Next2InstructionValue;
import ghidra.app.plugin.processors.sleigh.expression.NotExpression;
import ghidra.app.plugin.processors.sleigh.expression.OperandValue;
import ghidra.app.plugin.processors.sleigh.expression.OrExpression;
import ghidra.app.plugin.processors.sleigh.expression.PlusExpression;
import ghidra.app.plugin.processors.sleigh.expression.RightShiftExpression;
import ghidra.app.plugin.processors.sleigh.expression.StartInstructionValue;
import ghidra.app.plugin.processors.sleigh.expression.SubExpression;
import ghidra.app.plugin.processors.sleigh.expression.TokenField;
import ghidra.app.plugin.processors.sleigh.expression.XorExpression;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.xml.XmlElement;
import ghidra.xml.XmlPullParser;

public abstract class PatternExpression {
    public abstract long getValue(ParserWalker var1) throws MemoryAccessException;

    public abstract void restoreXml(XmlPullParser var1, SleighLanguage var2);

    public static PatternExpression restoreExpression(XmlPullParser parser, SleighLanguage lang) {
        PatternExpression res;
        XmlElement el = parser.peek();
        String nm = el.getName();
        if (nm.equals("tokenfield")) {
            res = new TokenField();
        } else if (nm.equals("contextfield")) {
            res = new ContextField();
        } else if (nm.equals("intb")) {
            res = new ConstantValue();
        } else if (nm.equals("operand_exp")) {
            res = new OperandValue();
        } else if (nm.equals("start_exp")) {
            res = new StartInstructionValue();
        } else if (nm.equals("end_exp")) {
            res = new EndInstructionValue();
        } else if (nm.equals("next2_exp")) {
            res = new Next2InstructionValue();
        } else if (nm.equals("plus_exp")) {
            res = new PlusExpression();
        } else if (nm.equals("sub_exp")) {
            res = new SubExpression();
        } else if (nm.equals("mult_exp")) {
            res = new MultExpression();
        } else if (nm.equals("lshift_exp")) {
            res = new LeftShiftExpression();
        } else if (nm.equals("rshift_exp")) {
            res = new RightShiftExpression();
        } else if (nm.equals("and_exp")) {
            res = new AndExpression();
        } else if (nm.equals("or_exp")) {
            res = new OrExpression();
        } else if (nm.equals("xor_exp")) {
            res = new XorExpression();
        } else if (nm.equals("div_exp")) {
            res = new DivExpression();
        } else if (nm.equals("minus_exp")) {
            res = new MinusExpression();
        } else if (nm.equals("not_exp")) {
            res = new NotExpression();
        } else {
            return null;
        }
        ((PatternExpression)res).restoreXml(parser, lang);
        return res;
    }

    public abstract String toString();
}

