/*
 * Decompiled with CFR 0.152.
 */
package ghidra.dbg.util;

import ghidra.async.AsyncFence;
import ghidra.dbg.attributes.TargetArrayDataType;
import ghidra.dbg.attributes.TargetBitfieldDataType;
import ghidra.dbg.attributes.TargetDataType;
import ghidra.dbg.attributes.TargetPointerDataType;
import ghidra.dbg.attributes.TargetPrimitiveDataType;
import ghidra.dbg.target.TargetDataTypeMember;
import ghidra.dbg.target.TargetNamedDataType;
import ghidra.dbg.util.PathUtils;
import ghidra.program.model.data.AbstractComplexDataType;
import ghidra.program.model.data.AbstractFloatDataType;
import ghidra.program.model.data.AbstractIntegerDataType;
import ghidra.program.model.data.ArrayDataType;
import ghidra.program.model.data.BitFieldDataType;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.CompositeDataTypeImpl;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeComponent;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.EnumDataType;
import ghidra.program.model.data.FunctionDefinitionDataType;
import ghidra.program.model.data.InvalidDataTypeException;
import ghidra.program.model.data.ParameterDefinition;
import ghidra.program.model.data.ParameterDefinitionImpl;
import ghidra.program.model.data.PointerDataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.program.model.data.TypedefDataType;
import ghidra.program.model.data.Undefined;
import ghidra.program.model.data.UnionDataType;
import ghidra.program.model.data.VoidDataType;
import ghidra.util.Msg;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.function.Function;
import java.util.stream.Collectors;

public class TargetDataTypeConverter {
    protected final DataTypeManager dtm;
    protected final Map<TargetDataType, TwoPhased<? extends DataType>> types = new HashMap<TargetDataType, TwoPhased<? extends DataType>>();
    protected boolean explainedOffsetDisagreement = false;

    public TargetDataTypeConverter() {
        this(null);
    }

    public TargetDataTypeConverter(DataTypeManager dtm) {
        this.dtm = dtm;
    }

    protected synchronized void explainOffsetDisagreement() {
        if (!this.explainedOffsetDisagreement) {
            this.explainedOffsetDisagreement = true;
            Msg.warn((Object)this, (Object)"Offset disagreement happens likely because the destination data type manager has a pointer size different than the source target.");
        }
    }

    public CompletableFuture<? extends DataType> convertTargetDataType(TargetDataType type) {
        return this.convertTwoPhased(type).depTwos();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected TwoPhased<? extends DataType> convertTwoPhased(TargetDataType type) {
        TwoPhased<? extends DataType> conv;
        Map<TargetDataType, TwoPhased<? extends DataType>> map = this.types;
        synchronized (map) {
            conv = this.types.get(type);
            if (conv != null) {
                return conv;
            }
            conv = this.doConvertTargetDataType(type);
            this.types.put(type, conv);
        }
        conv.start();
        return conv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<TargetDataType> getPendingOne() {
        Map<TargetDataType, TwoPhased<? extends DataType>> map = this.types;
        synchronized (map) {
            return this.types.entrySet().stream().filter(e -> !((TwoPhased)e.getValue()).one.isDone()).map(e -> (TargetDataType)e.getKey()).collect(Collectors.toSet());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<TargetDataType> getPendingTwo() {
        Map<TargetDataType, TwoPhased<? extends DataType>> map = this.types;
        synchronized (map) {
            return this.types.entrySet().stream().filter(e -> !((TwoPhased)e.getValue()).two.isDone()).map(e -> (TargetDataType)e.getKey()).collect(Collectors.toSet());
        }
    }

    protected TwoPhased<? extends DataType> doConvertTargetDataType(TargetDataType type) {
        if (type instanceof TargetNamedDataType) {
            TargetNamedDataType tNamed = (TargetNamedDataType)type;
            return this.convertTargetNamedDataType(tNamed);
        }
        if (type instanceof TargetArrayDataType) {
            TargetArrayDataType tArray = (TargetArrayDataType)type;
            return this.convertTargetArrayDataType(tArray);
        }
        if (type instanceof TargetBitfieldDataType) {
            TargetBitfieldDataType tBitfield = (TargetBitfieldDataType)type;
            return this.convertTargetBitfieldDataType(tBitfield);
        }
        if (type instanceof TargetPointerDataType) {
            TargetPointerDataType tPointer = (TargetPointerDataType)type;
            return this.convertTargetPointerDataType(tPointer);
        }
        if (type instanceof TargetPrimitiveDataType) {
            TargetPrimitiveDataType tPrimitive = (TargetPrimitiveDataType)type;
            return this.convertTargetPrimitiveDataType(tPrimitive);
        }
        throw new AssertionError((Object)("Do not know how to convert " + type));
    }

    protected TwoPhased<? extends DataType> convertTargetNamedDataType(TargetNamedDataType type) {
        String[] parts = type.getIndex().split("\\s+");
        String name = parts[parts.length - 1];
        switch (type.getTypeKind()) {
            case ENUM: {
                return this.convertTargetEnumDataType(name, type);
            }
            case FUNCTION: {
                return this.convertTargetFunctionDataType(name, type);
            }
            case STRUCT: {
                return this.convertTargetStructDataType(name, type);
            }
            case TYPEDEF: {
                return this.convertTargetTypedefDataType(name, type);
            }
            case UNION: {
                return this.convertTargetUnionDataType(name, type);
            }
        }
        throw new AssertionError((Object)("Do not know how to convert " + type));
    }

    protected TwoPhased<EnumDataType> convertTargetEnumDataType(final String name, final TargetNamedDataType tEnum) {
        return new TwoPhased<EnumDataType>(){
            final EnumDataType type;
            {
                this.type = new EnumDataType(CategoryPath.ROOT, name, tEnum.getTypedAttributeNowByName("_byte_length", Integer.class, 4).intValue(), TargetDataTypeConverter.this.dtm);
            }

            @Override
            protected void doStart() {
                this.completeOne(this.type);
                this.chainExc((CompletableFuture<?>)tEnum.getMembers().thenAccept(this::procMembers));
            }

            private void procMembers(Collection<? extends TargetDataTypeMember> members) {
                for (TargetDataTypeMember targetDataTypeMember : members) {
                    this.type.add(targetDataTypeMember.getMemberName(), (long)targetDataTypeMember.getPosition());
                }
                this.completeTwo();
            }
        };
    }

    protected TwoPhased<FunctionDefinitionDataType> convertTargetFunctionDataType(final String name, final TargetNamedDataType tFunction) {
        return new TwoPhased<FunctionDefinitionDataType>(){
            final Map<String, ParameterDefinitionImpl> args = new TreeMap<String, ParameterDefinitionImpl>(PathUtils.TargetObjectKeyComparator.ELEMENT);
            final FunctionDefinitionDataType type;
            {
                this.type = new FunctionDefinitionDataType(name, TargetDataTypeConverter.this.dtm);
            }

            @Override
            protected void doStart() {
                this.completeOne(this.type);
                this.chainExc((CompletableFuture<?>)tFunction.getMembers().thenAccept(this::procMembers));
            }

            private void procMembers(Collection<? extends TargetDataTypeMember> members) {
                AsyncFence fence = new AsyncFence();
                for (TargetDataTypeMember targetDataTypeMember : members) {
                    TwoPhased<? extends DataType> dep = TargetDataTypeConverter.this.convertTwoPhased(targetDataTypeMember.getDataType());
                    this.deps.add(dep);
                    fence.include((CompletableFuture)dep.two.thenAccept(t -> {
                        if ("return".equals(p.getIndex())) {
                            this.type.setReturnType(t);
                        } else {
                            this.args.put(p.getIndex(), new ParameterDefinitionImpl(p.getMemberName(), t, null));
                        }
                    }));
                }
                this.chainExc((CompletableFuture<?>)fence.ready().thenAccept(this::procArgs));
            }

            private void procArgs(Void __) {
                this.type.setArguments((ParameterDefinition[])this.args.values().toArray(new ParameterDefinitionImpl[this.args.size()]));
                this.completeTwo();
            }
        };
    }

    protected TwoPhased<StructureDataType> convertTargetStructDataType(String name, TargetNamedDataType tStruct) {
        return new TwoPhasedComposite(this, (CompositeDataTypeImpl)new StructureDataType(name, 0, this.dtm), tStruct);
    }

    protected TwoPhased<UnionDataType> convertTargetUnionDataType(String name, TargetNamedDataType tUnion) {
        return new TwoPhasedComposite(this, (CompositeDataTypeImpl)new UnionDataType(CategoryPath.ROOT, name, this.dtm), tUnion);
    }

    protected TwoPhased<TypedefDataType> convertTargetTypedefDataType(final String name, final TargetNamedDataType tTypedef) {
        return new TwoPhased<TypedefDataType>(){

            @Override
            protected void doStart() {
                this.chainExc((CompletableFuture<?>)tTypedef.getMembers().thenAccept(this::procMembers));
            }

            private void procMembers(Collection<? extends TargetDataTypeMember> members) {
                if (members.isEmpty()) {
                    Msg.warn((Object)this, (Object)"Typedef did not provide definition. Defaulting.");
                    this.procDef(DataType.DEFAULT);
                    this.procTwo(null);
                    return;
                }
                if (members.size() != 1) {
                    Msg.warn((Object)this, (Object)"Typedef provided multiple definitions. Taking first.");
                }
                TargetDataTypeMember d = members.iterator().next();
                TwoPhased<? extends DataType> dep = TargetDataTypeConverter.this.convertTwoPhased(d.getDataType());
                this.deps.add(dep);
                this.chainExc((CompletableFuture<?>)dep.one.thenAccept(this::procDef));
                this.chainExc((CompletableFuture<?>)dep.two.thenAccept(this::procTwo));
            }

            private void procDef(DataType cDef) {
                this.completeOne(new TypedefDataType(CategoryPath.ROOT, name, cDef, TargetDataTypeConverter.this.dtm));
            }

            private void procTwo(DataType __) {
                this.completeTwo();
            }
        };
    }

    protected TwoPhased<ArrayDataType> convertTargetArrayDataType(TargetArrayDataType tArray) {
        return this.convertTwoPhased(tArray.getElementType()).thenApply(cElem -> new ArrayDataType(cElem, tArray.getElementCount(), cElem.getLength(), this.dtm));
    }

    protected TwoPhased<ConvertedTargetBitfieldDataType> convertTargetBitfieldDataType(TargetBitfieldDataType tBitfield) {
        return this.convertTwoPhased(tBitfield.getFieldType()).thenApply(cField -> {
            try {
                return new ConvertedTargetBitfieldDataType((DataType)cField, tBitfield.getBitLength(), tBitfield.getLeastBitPosition());
            }
            catch (InvalidDataTypeException e) {
                throw new AssertionError((Object)e);
            }
        });
    }

    protected TwoPhased<PointerDataType> convertTargetPointerDataType(TargetPointerDataType tPointer) {
        TwoPhased<PointerDataType> cPointer = this.convertTwoPhased(tPointer.getReferentType()).thenApply(cRef -> new PointerDataType(cRef, this.dtm));
        cPointer.one.thenAccept(__ -> cPointer.completeTwo());
        return cPointer;
    }

    protected TwoPhased<DataType> convertTargetPrimitiveDataType(TargetPrimitiveDataType tPrimitive) {
        return TwoPhased.completedTwo(this.doConvertTargetPrimitiveDataType(tPrimitive));
    }

    protected DataType doConvertTargetPrimitiveDataType(TargetPrimitiveDataType tPrimitive) {
        switch (tPrimitive.getKind()) {
            case UNDEFINED: {
                return Undefined.getUndefinedDataType((int)tPrimitive.getLength());
            }
            case VOID: {
                if (tPrimitive.getLength() != 0) {
                    Msg.warn((Object)this, (Object)"Ignoring non-zero length for void data type");
                }
                return VoidDataType.dataType;
            }
            case UINT: {
                return AbstractIntegerDataType.getUnsignedDataType((int)tPrimitive.getLength(), (DataTypeManager)this.dtm);
            }
            case SINT: {
                return AbstractIntegerDataType.getSignedDataType((int)tPrimitive.getLength(), (DataTypeManager)this.dtm);
            }
            case FLOAT: {
                return AbstractFloatDataType.getFloatDataType((int)tPrimitive.getLength(), (DataTypeManager)this.dtm);
            }
            case COMPLEX: {
                return AbstractComplexDataType.getComplexDataType((int)tPrimitive.getLength(), (DataTypeManager)this.dtm);
            }
        }
        throw new IllegalArgumentException("Do not know how to convert " + tPrimitive);
    }

    protected static abstract class TwoPhased<T> {
        protected final CompletableFuture<T> one = new CompletableFuture();
        protected final CompletableFuture<T> two = new CompletableFuture();
        protected final Set<TwoPhased<?>> deps = new HashSet();
        protected boolean started = false;

        protected TwoPhased() {
        }

        public static <T> TwoPhased<T> completedTwo(final T val) {
            TwoPhased result = new TwoPhased<T>(){

                @Override
                protected void doStart() {
                    this.completeOne(val);
                    this.completeTwo();
                }
            };
            result.start();
            return result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void start() {
            TwoPhased twoPhased = this;
            synchronized (twoPhased) {
                if (this.started) {
                    return;
                }
                this.started = true;
            }
            this.doStart();
        }

        protected abstract void doStart();

        protected void chainExc(CompletableFuture<?> chain) {
            chain.exceptionally(ex -> {
                this.completeExceptionally((Throwable)ex);
                return null;
            });
        }

        protected void chainExc(TwoPhased<?> chain) {
            this.chainExc(chain.one);
            this.chainExc(chain.two);
        }

        public void completeOne(T val) {
            this.one.complete(val);
        }

        public void completeTwo() {
            if (!this.one.isDone()) {
                throw new IllegalStateException("Phase one hasn't completed");
            }
            try {
                this.two.complete(this.one.get());
            }
            catch (InterruptedException e) {
                throw new AssertionError((Object)e);
            }
            catch (ExecutionException e) {
                this.two.completeExceptionally(e.getCause());
            }
        }

        public void completeExceptionally(Throwable ex) {
            this.one.completeExceptionally(ex);
            this.two.completeExceptionally(ex);
        }

        public <U> TwoPhased<U> thenApply(final Function<? super T, ? extends U> func) {
            final TwoPhased tp = this;
            return new TwoPhased<U>(){

                @Override
                protected void doStart() {
                    this.deps.add(tp);
                    this.chainExc((CompletableFuture<?>)tp.one.thenAccept(t -> this.completeOne(func.apply(t))));
                    this.chainExc((CompletableFuture<?>)tp.two.thenAccept(__ -> this.completeTwo()));
                }
            };
        }

        private void collectDeps(Set<TwoPhased<?>> allDeps) {
            for (TwoPhased<?> d : this.deps) {
                if (!allDeps.add(d)) continue;
                d.collectDeps(allDeps);
            }
        }

        protected CompletableFuture<T> depTwos() {
            HashSet allDeps = new HashSet();
            this.collectDeps(allDeps);
            return CompletableFuture.allOf((CompletableFuture[])allDeps.stream().map(tp -> tp.two).toArray(CompletableFuture[]::new)).thenCompose(__ -> this.two);
        }
    }

    protected static class TwoPhasedComposite<T extends CompositeDataTypeImpl>
    extends TwoPhased<T> {
        protected final T type;
        protected final TargetNamedDataType tNamed;
        protected final Map<String, ConvertedMember> subs = new TreeMap<String, ConvertedMember>(PathUtils.TargetObjectKeyComparator.ELEMENT);
        final /* synthetic */ TargetDataTypeConverter this$0;

        public TwoPhasedComposite(T type, TargetNamedDataType tNamed) {
            this.this$0 = this$0;
            this.type = type;
            this.tNamed = tNamed;
        }

        @Override
        protected synchronized void doStart() {
            this.one.complete(this.type);
            try {
                this.chainExc((CompletableFuture<?>)this.tNamed.getMembers().thenAccept(this::procMembers));
            }
            catch (Throwable e) {
                this.completeExceptionally(e);
            }
        }

        private void procMembers(Collection<? extends TargetDataTypeMember> members) {
            AsyncFence fence = new AsyncFence();
            for (TargetDataTypeMember targetDataTypeMember : members) {
                TwoPhased<? extends DataType> dep = this.this$0.convertTwoPhased(targetDataTypeMember.getDataType());
                this.deps.add(dep);
                fence.include((CompletableFuture)dep.two.thenAccept(tField -> this.subs.put(f.getIndex(), new ConvertedMember(f, (DataType)tField))));
            }
            this.chainExc((CompletableFuture<?>)fence.ready().thenAccept(this::procSubs));
        }

        protected void procSubs(Void __) {
            for (Map.Entry<String, ConvertedMember> s : this.subs.entrySet()) {
                ConvertedMember conv = s.getValue();
                DataTypeComponent component = this.type.add(conv.type, -1, conv.member.getMemberName(), null);
                long fOff = conv.member.getOffset();
                int cOff = component.getOffset();
                if (fOff == -1L || fOff == (long)cOff) continue;
                Msg.warn((Object)this, (Object)("Offset disagreement during conversion of " + conv.member + ". " + fOff + " != " + cOff));
                this.this$0.explainOffsetDisagreement();
            }
            this.completeTwo();
        }
    }

    protected static class ConvertedTargetBitfieldDataType
    extends BitFieldDataType {
        protected ConvertedTargetBitfieldDataType(DataType baseDataType, int bitSize, int bitOffset) throws InvalidDataTypeException {
            super(baseDataType, bitSize, bitOffset);
        }
    }

    protected static class ConvertedMember {
        protected final TargetDataTypeMember member;
        protected final DataType type;

        public ConvertedMember(TargetDataTypeMember member, DataType type) {
            this.member = member;
            this.type = type;
        }
    }
}

